/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusContentProvider;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusEntryFilter;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusEntryLabelProvider;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.StatusContextViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.util.SWTUtil;
import org.eclipse.ltk.internal.ui.refactoring.util.ViewerPane;
import org.eclipse.ltk.ui.refactoring.IStatusContextViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class RefactoringStatusViewer
extends SashForm {
    private RefactoringStatus fStatus;
    private TableViewer fTableViewer;
    private PageBook fContextViewerContainer;
    private StatusContextViewerDescriptor fCurrentDescriptor;
    private IStatusContextViewer fCurrentContextViewer;
    private NullContextViewer fNullContextViewer;
    private RefactoringStatusEntryFilter fFilter = null;
    private NextProblem fNextProblem;
    private PreviousProblem fPreviousProblem;

    public RefactoringStatusViewer(Composite parent, int style) {
        super(parent, style | 0x200);
        this.createContents();
    }

    public void setFilter(RefactoringStatusEntryFilter filter) {
        this.fFilter = filter;
    }

    public void setStatus(RefactoringStatus status) {
        this.fStatus = status;
        if (this.fTableViewer.getInput() != this.fStatus) {
            RefactoringStatusEntry entry;
            this.fTableViewer.setInput((Object)this.fStatus);
            ISelection selection = this.fTableViewer.getSelection();
            if (selection.isEmpty() && (entry = this.getFirstEntry()) != null) {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)entry));
                this.showContextViewer(entry);
                this.fTableViewer.getControl().setFocus();
            }
            this.fNextProblem.update();
            this.fPreviousProblem.update();
        }
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        PixelConverter converter = new PixelConverter((Control)this);
        return new Point(converter.convertWidthInCharsToPixels(90), converter.convertHeightInCharsToPixels(25));
    }

    private void createContents() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        ViewerPane contextPane = new ViewerPane((Composite)this, 0x800800);
        contextPane.setText(RefactoringUIMessages.RefactoringStatusViewer_Found_problems);
        ToolBarManager tbm = contextPane.getToolBarManager();
        this.fNextProblem = new NextProblem();
        tbm.add((IAction)this.fNextProblem);
        this.fPreviousProblem = new PreviousProblem();
        tbm.add((IAction)this.fPreviousProblem);
        tbm.update(true);
        this.createTableViewer((Composite)contextPane);
        contextPane.setContent(this.fTableViewer.getControl());
        this.fContextViewerContainer = new PageBook((Composite)this, 0);
        this.fNullContextViewer = new NullContextViewer();
        this.fNullContextViewer.createControl((Composite)this.fContextViewerContainer);
        this.fContextViewerContainer.showPage(this.fNullContextViewer.getControl());
        this.fCurrentContextViewer = this.fNullContextViewer;
        this.fCurrentContextViewer = this.fNullContextViewer;
        this.fCurrentDescriptor = null;
        this.setWeights(new int[]{35, 65});
    }

    private void createTableViewer(Composite parent) {
        this.fTableViewer = new TableViewer(new Table(parent, 260));
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new RefactoringStatusEntryLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new RefactoringStatusContentProvider());
        this.fTableViewer.addSelectionChangedListener(event -> {
            this.entrySelected(event.getSelection());
            this.fNextProblem.update();
            this.fPreviousProblem.update();
        });
        this.fTableViewer.setComparator((ViewerComparator)new RefactoringStatusSorter());
        Table tableControl = this.fTableViewer.getTable();
        tableControl.setFont(JFaceResources.getDialogFont());
        GridData gd = new GridData(1808);
        tableControl.setLayoutData((Object)gd);
        SWTUtil.setAccessibilityText((Control)tableControl, RefactoringUIMessages.RefactoringStatusViewer_Found_problems);
    }

    /*
     * WARNING - void declaration
     */
    private void entrySelected(ISelection s) {
        void entry;
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        Object first = ((IStructuredSelection)s).getFirstElement();
        if (!(first instanceof RefactoringStatusEntry)) {
            return;
        }
        RefactoringStatusEntry refactoringStatusEntry = (RefactoringStatusEntry)first;
        this.showContextViewer((RefactoringStatusEntry)entry);
    }

    private void showContextViewer(RefactoringStatusEntry entry) {
        RefactoringStatusContext context = entry.getContext();
        if (context == null || this.fFilter != null && !this.fFilter.select(entry)) {
            this.showNullContextViewer();
        } else {
            try {
                StatusContextViewerDescriptor descriptor = StatusContextViewerDescriptor.get(context);
                if (this.fCurrentDescriptor != descriptor) {
                    IStatusContextViewer newViewer;
                    if (descriptor != null) {
                        newViewer = descriptor.createViewer();
                        newViewer.createControl((Composite)this.fContextViewerContainer);
                    } else {
                        newViewer = this.fNullContextViewer;
                    }
                    this.fCurrentDescriptor = descriptor;
                    newViewer.setInput(context);
                    if (this.fCurrentContextViewer != null && this.fCurrentContextViewer != this.fNullContextViewer) {
                        this.fCurrentContextViewer.getControl().dispose();
                    }
                    this.fCurrentContextViewer = newViewer;
                    this.fContextViewerContainer.showPage(this.fCurrentContextViewer.getControl());
                } else {
                    this.fCurrentContextViewer.setInput(context);
                }
            }
            catch (CoreException e) {
                this.showNullContextViewer();
                ExceptionHandler.handle(e, this.getShell(), RefactoringUIMessages.RefactoringStatusViewer_error_title, RefactoringUIMessages.RefactoringStatusViewer_error_message);
            }
        }
    }

    private void showNullContextViewer() {
        this.fCurrentContextViewer = this.fNullContextViewer;
        this.fCurrentDescriptor = null;
        this.fContextViewerContainer.showPage(this.fCurrentContextViewer.getControl());
    }

    private RefactoringStatusEntry getFirstEntry() {
        if (this.fStatus == null || !this.fStatus.hasEntries()) {
            return null;
        }
        return this.fStatus.getEntryAt(0);
    }

    private void revealElement(boolean next) {
        Object data;
        Table table = this.fTableViewer.getTable();
        int numberOfItems = table.getItemCount();
        if (numberOfItems == 0) {
            return;
        }
        int index = table.getSelectionIndex();
        int last = numberOfItems - 1;
        boolean doIt = true;
        if (index == -1) {
            index = 0;
        } else if (next && index < last) {
            ++index;
        } else if (!next && index > 0) {
            --index;
        } else {
            doIt = false;
        }
        if (doIt && (data = table.getItem(index).getData()) != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(data));
        }
    }

    private class NextProblem
    extends Action {
        public NextProblem() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setToolTipText(RefactoringUIMessages.ErrorWizardPage_next_Change);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.next_problem_action");
        }

        public void run() {
            RefactoringStatusViewer.this.revealElement(true);
        }

        public void update() {
            boolean enabled = false;
            if (RefactoringStatusViewer.this.fStatus != null && RefactoringStatusViewer.this.fStatus.hasEntries()) {
                RefactoringStatusEntry[] entries = RefactoringStatusViewer.this.fStatus.getEntries();
                int index = RefactoringStatusViewer.this.fTableViewer.getTable().getSelectionIndex();
                enabled = index == -1 || index < entries.length - 1;
            }
            this.setEnabled(enabled);
        }
    }

    private static class NullContextViewer
    implements IStatusContextViewer {
        private Label fLabel;

        @Override
        public void createControl(Composite parent) {
            this.fLabel = new Label(parent, 0x1800000);
            this.fLabel.setText(RefactoringUIMessages.ErrorWizardPage_no_context_information_available);
        }

        @Override
        public void setInput(RefactoringStatusContext input) {
        }

        @Override
        public Control getControl() {
            return this.fLabel;
        }
    }

    private class PreviousProblem
    extends Action {
        public PreviousProblem() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setToolTipText(RefactoringUIMessages.ErrorWizardPage_previous_Change);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.previous_problem_action");
        }

        public void run() {
            RefactoringStatusViewer.this.revealElement(false);
        }

        public void update() {
            boolean enabled = false;
            if (RefactoringStatusViewer.this.fStatus != null && RefactoringStatusViewer.this.fStatus.hasEntries()) {
                int index = RefactoringStatusViewer.this.fTableViewer.getTable().getSelectionIndex();
                enabled = index == -1 || index > 0;
            }
            this.setEnabled(enabled);
        }
    }

    private static class RefactoringStatusSorter
    extends ViewerComparator {
        private RefactoringStatusSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int r2;
            int r1 = ((RefactoringStatusEntry)e1).getSeverity();
            if (r1 < (r2 = ((RefactoringStatusEntry)e2).getSeverity())) {
                return 1;
            }
            if (r2 < r1) {
                return -1;
            }
            return 0;
        }
    }
}

