/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.css;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.css.CSSHandler;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.PublicationResourceChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Locale;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssInputStream;
import org.idpf.epubcheck.util.css.CssParser;
import org.idpf.epubcheck.util.css.CssSource;

public class CSSChecker
extends PublicationResourceChecker {
    private final Mode mode;
    private final String value;
    private int line;
    private final boolean isStyleAttribute;

    public CSSChecker(ValidationContext context) {
        this(context, Mode.FILE, null, -1, false);
    }

    public CSSChecker(ValidationContext context, String value, int line, boolean isStyleAttribute) {
        this(context, Mode.STRING, value, line, isStyleAttribute);
    }

    private CSSChecker(ValidationContext context, Mode mode, String value, int line, boolean isStyleAttribute) {
        super(context);
        this.mode = mode;
        this.value = value;
        this.line = line;
        this.isStyleAttribute = isStyleAttribute;
    }

    @Override
    protected boolean checkPublicationBeforeContent() {
        if (this.mode == Mode.FILE) {
            return super.checkPublicationBeforeContent();
        }
        return true;
    }

    @Override
    protected boolean checkContent() {
        CssSource source = null;
        try {
            CSSHandler handler = new CSSHandler(this.context, this.mode);
            if (this.mode == Mode.STRING && this.line > -1) {
                handler.setStartingLineNumber(this.line);
            }
            source = this.getCssSource();
            this.parseItem(source, handler);
            handler.setStartingLineNumber(-1);
            this.line = -1;
        }
        catch (Exception e) {
            this.report.message(MessageId.PKG_008, EPUBLocation.of(this.context), e.getMessage());
        }
        finally {
            if (source != null) {
                try {
                    CssInputStream iStream = source.getInputStream();
                    if (iStream != null) {
                        ((InputStream)iStream).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    CssSource getCssSource() throws IOException {
        CssSource source = null;
        if (this.mode == Mode.FILE) {
            String charset;
            source = new CssSource(this.context.path, this.context.resourceProvider.openStream(this.context.url));
            if (source.getInputStream().getBomCharset().isPresent()) {
                String charset2 = ((String)source.getInputStream().getBomCharset().get()).toLowerCase(Locale.ROOT);
                if (!charset2.equals("utf-8")) {
                    if (charset2.startsWith("utf-16")) {
                        this.report.message(MessageId.CSS_003, EPUBLocation.of(this.context), charset2);
                    } else {
                        this.report.message(MessageId.CSS_004, EPUBLocation.of(this.context), charset2);
                    }
                }
            } else if (source.getInputStream().getCssCharset().isPresent() && !(charset = ((String)source.getInputStream().getCssCharset().get()).toLowerCase(Locale.ROOT)).equals("utf-8")) {
                if (charset.startsWith("utf-16")) {
                    this.report.message(MessageId.CSS_003, EPUBLocation.of(this.context), charset);
                } else {
                    this.report.message(MessageId.CSS_004, EPUBLocation.of(this.context), charset);
                }
            }
        }
        return source;
    }

    void parseItem(CssSource source, CSSHandler handler) throws IOException, CssExceptions.CssException {
        if (!this.isStyleAttribute) {
            if (this.mode == Mode.FILE) {
                new CssParser(this.context.locale).parse(source, handler, handler);
            } else {
                new CssParser(this.context.locale).parse(new StringReader(this.value), this.context.path, handler, handler);
            }
        } else {
            new CssParser(this.context.locale).parseStyleAttribute(new StringReader(this.value), this.context.path, handler, handler);
        }
    }

    static enum Mode {
        FILE,
        STRING;

    }
}

