/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.mode.Controller;

class OutlineGeometry {
    private static final List<GeometryListener> LISTENERS = new ArrayList<GeometryListener>();
    private static OutlineGeometry INSTANCE;
    final int rowHeight;
    final int navButtonWidth;
    private final int indent;
    private final float itemFontSize;
    final ComponentOrientation outlineTextOrientation;

    static OutlineGeometry getInstance() {
        return INSTANCE;
    }

    float getItemFontSize() {
        return this.itemFontSize;
    }

    boolean isRightToLeft() {
        boolean applyRightToLeft = this.outlineTextOrientation.isHorizontal() && !this.outlineTextOrientation.isLeftToRight();
        return applyRightToLeft;
    }

    private static Quantity<LengthUnit> asLength(int rowHeight) {
        return new Quantity((double)rowHeight, (Enum)LengthUnit.px).in((Enum)LengthUnit.mm);
    }

    private static void updateGeometry(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals("outlineItemFontSize") || propertyName.equals("outlineItemIndentation") || propertyName.equals("showOutlineFoldingButtons") || propertyName.equals("outlineTextWritingDirection")) {
            OutlineGeometry.replaceInstance(OutlineGeometry.createFromConfiguration());
        }
    }

    static void registerListener(GeometryListener listener) {
        if (listener == null) {
            return;
        }
        LISTENERS.add(listener);
    }

    static void unregisterListener(GeometryListener listener) {
        if (listener == null) {
            return;
        }
        LISTENERS.remove(listener);
    }

    private static void replaceInstance(OutlineGeometry newInstance) {
        INSTANCE = newInstance;
        for (GeometryListener listener : LISTENERS) {
            listener.onGeometryChanged(INSTANCE);
        }
    }

    private static OutlineGeometry createFromConfiguration() {
        ResourceController resourceController = ResourceController.getResourceController();
        float configuredItemFontSize = UITools.FONT_SCALE_FACTOR * (float)resourceController.getDoubleProperty("outlineItemFontSize", 8.0);
        JButton sampleButton = new JButton("\u25bc");
        sampleButton.setMargin(new Insets(0, 0, 0, 0));
        sampleButton.setFont(sampleButton.getFont().deriveFont(configuredItemFontSize * 5.0f / 4.0f));
        sampleButton.setBorder(BorderFactory.createRaisedBevelBorder());
        Dimension preferredButtonSize = sampleButton.getPreferredSize();
        int configuredRowHeight = Math.round(preferredButtonSize.height);
        Quantity<LengthUnit> indentQuantity = resourceController.getLengthQuantityProperty("outlineItemIndentation");
        int configuredIndent = indentQuantity != null ? indentQuantity.toBaseUnitsRounded() : configuredRowHeight;
        int configuredNavigationButtonWidth = resourceController.getBooleanProperty("showOutlineFoldingButtons", true) ? Math.round(preferredButtonSize.width * 20 / 13) : 0;
        TextWritingDirection textWritingDirection = (TextWritingDirection)resourceController.getEnumProperty("outlineTextWritingDirection", TextWritingDirection.DEFAULT);
        ComponentOrientation componentOrientation = textWritingDirection == TextWritingDirection.RIGHT_TO_LEFT ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
        return new OutlineGeometry(configuredRowHeight, configuredNavigationButtonWidth, configuredIndent, configuredItemFontSize, componentOrientation);
    }

    private OutlineGeometry(int rowHeight, int navigationButtonWidth, int indent, float itemFontSize, ComponentOrientation componentOrientation) {
        this.rowHeight = rowHeight;
        this.navButtonWidth = navigationButtonWidth;
        this.indent = indent;
        this.itemFontSize = itemFontSize;
        this.outlineTextOrientation = componentOrientation;
    }

    int calculateNodeButtonX(boolean showNavigationButtons, int level) {
        if (!showNavigationButtons || this.navButtonWidth == 0) {
            return level * this.indent;
        }
        return level * this.indent + 2 * this.navButtonWidth;
    }

    int calculateNavigationButtonX(int rowIndent) {
        int baseX = rowIndent * this.indent;
        return baseX;
    }

    static {
        if (Controller.getCurrentController() != null) {
            INSTANCE = OutlineGeometry.createFromConfiguration();
            ResourceController resourceController = ResourceController.getResourceController();
            resourceController.setDefaultProperty("outlineItemIndentation", OutlineGeometry.asLength(OutlineGeometry.INSTANCE.rowHeight).toString());
            resourceController.addPropertyChangeListener(OutlineGeometry::updateGeometry);
        } else {
            INSTANCE = new OutlineGeometry(10, 10, 10, UITools.FONT_SCALE_FACTOR * 8.0f, ComponentOrientation.LEFT_TO_RIGHT);
        }
    }

    static interface GeometryListener {
        public void onGeometryChanged(OutlineGeometry var1);
    }
}

