/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import ghidra.app.cmd.label.DeleteLabelCmd;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

public class RemoveLabelAction
extends AbstractDecompilerAction {
    private static final String[] POPUP_PATH = new String[]{"Remove Label"};
    private static final KeyStroke KEYBINDING = KeyStroke.getKeyStroke(127, 0);

    public RemoveLabelAction() {
        super("Remove Label", KeyBindingType.SHARED);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRemoveLabel"));
        this.setPopupMenuData(new MenuData(POPUP_PATH, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(KEYBINDING));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (!(tokenAtCursor instanceof ClangLabelToken)) {
            return false;
        }
        Symbol symbol = this.getSymbol(context);
        return this.canRemoveSymbol(symbol);
    }

    private boolean canRemoveSymbol(Symbol s) {
        return s != null && s.getSource() != SourceType.DEFAULT && !s.isExternal();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Symbol s = this.getSymbol(context);
        DeleteLabelCmd cmd = new DeleteLabelCmd(s.getAddress(), s.getName(), s.getParentNamespace());
        PluginTool tool = context.getTool();
        if (!tool.execute((Command)cmd, (DomainObject)context.getProgram())) {
            tool.setStatusInfo(cmd.getStatusMsg());
        }
    }
}

