/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.sew;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.PointFlag;
import tim.prune.cmd.SewSegmentsCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.Describer;
import tim.prune.function.sew.NothingDoneException;
import tim.prune.function.sew.Segment;
import tim.prune.function.sew.SegmentChain;
import tim.prune.gui.ProgressDialog;
import tim.prune.gui.ProgressIndicator;

public class SewTrackSegmentsFunction
extends GenericFunction {
    private boolean _cancelled = false;

    public SewTrackSegmentsFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.sewsegments";
    }

    @Override
    public void begin() {
        new Thread(this::run).start();
    }

    public void run() {
        ProgressDialog progressDialog = new ProgressDialog(this._parentFrame, this.getNameKey(), null, () -> {
            boolean bl = this._cancelled = true;
        });
        progressDialog.show();
        Track track = this._app.getTrackInfo().getTrack();
        SewSegmentsCmd sewSegmentsCmd = null;
        try {
            sewSegmentsCmd = this.getSewSegmentsCommand(track, progressDialog);
            sewSegmentsCmd.setDescription(this.getName());
            sewSegmentsCmd.setConfirmText(I18nManager.getTextWithNumber("confirm.sewsegments", sewSegmentsCmd.getNumJoins()));
        }
        catch (NothingDoneException nothingDoneException) {
            Describer describer = new Describer("error.sewsegments.nothingdone.single", "error.sewsegments.nothingdone");
            this._app.showErrorMessageNoLookup(this.getNameKey(), describer.getDescriptionWithCount(nothingDoneException.numSegments));
        }
        progressDialog.close();
        if (sewSegmentsCmd != null) {
            this._app.execute(sewSegmentsCmd);
        }
    }

    SewSegmentsCmd getSewSegmentsCommand(Track track, ProgressIndicator progressIndicator) throws NothingDoneException {
        List<Segment> list = this.buildSegmentList(track);
        if (list.size() <= 1) {
            throw new NothingDoneException(list.size());
        }
        LinkedList<SegmentChain> linkedList = new LinkedList<SegmentChain>();
        int n = 0;
        progressIndicator.showProgress(1, list.size() + 1);
        for (Segment segment : list) {
            boolean bl = false;
            for (SegmentChain segmentChain : linkedList) {
                if (!segmentChain.append(segment)) continue;
                bl = true;
                break;
            }
            if (bl) {
                boolean bl2 = true;
                block2: while (bl2) {
                    bl2 = false;
                    for (SegmentChain segmentChain : linkedList) {
                        for (SegmentChain segmentChain2 : linkedList) {
                            if (segmentChain == segmentChain2) continue;
                            if (segmentChain.append(segmentChain2)) {
                                bl2 = true;
                                linkedList.remove(segmentChain2);
                            }
                            if (bl2) break;
                        }
                        if (bl2) continue block2;
                    }
                }
            } else {
                linkedList.add(new SegmentChain(track, segment));
            }
            progressIndicator.showProgress(++n + 1, list.size() + 1);
            if (this._cancelled) break;
        }
        if (this._cancelled) {
            return null;
        }
        if (linkedList.size() == list.size()) {
            throw new NothingDoneException(list.size());
        }
        List<Integer> list2 = this.findWaypointIndexes(track);
        for (SegmentChain segmentChain : linkedList) {
            list2.addAll(segmentChain.getPointIndexes());
        }
        return new SewSegmentsCmd(list2, this.getDiscardedPoints(list2, track.getNumPoints()), this.getSegmentFlags(linkedList, track));
    }

    private List<Segment> buildSegmentList(Track track) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        int n = track.getNumPoints();
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            DataPoint dataPoint = track.getPoint(n4);
            if (!dataPoint.isWaypoint()) {
                if (dataPoint.getSegmentStart()) {
                    if (n3 >= 0) {
                        arrayList.add(new Segment(n3, n2));
                    }
                    n3 = n4;
                }
                n2 = n4;
            }
            ++n4;
        }
        if (n3 >= 0 && n2 >= n3) {
            arrayList.add(new Segment(n3, n2));
        }
        return arrayList;
    }

    private List<Integer> findWaypointIndexes(Track track) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = track.getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = track.getPoint(n2);
            if (dataPoint.isWaypoint()) {
                arrayList.add(n2);
            }
            ++n2;
        }
        return arrayList;
    }

    private List<Integer> getDiscardedPoints(List<Integer> list, int n) {
        boolean[] blArray = new boolean[n];
        for (int n2 : list) {
            blArray[n2] = true;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 0;
        while (n3 < n) {
            if (!blArray[n3]) {
                arrayList.add(n3);
            }
            ++n3;
        }
        return arrayList;
    }

    private List<PointFlag> getSegmentFlags(List<SegmentChain> list, Track track) {
        ArrayList<PointFlag> arrayList = new ArrayList<PointFlag>();
        for (SegmentChain segmentChain : list) {
            boolean bl = true;
            for (int n : segmentChain.getPointIndexes()) {
                arrayList.add(new PointFlag(track.getPoint(n), bl));
                bl = false;
            }
        }
        return arrayList;
    }
}

