/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public abstract class AbstractBean {
    private transient PropertyChangeSupport pcs;
    private transient VetoableChangeSupport vcs;

    protected AbstractBean() {
        this.pcs = new PropertyChangeSupport(this);
        this.vcs = new VetoableChangeSupport(this);
    }

    protected AbstractBean(PropertyChangeSupport propertyChangeSupport, VetoableChangeSupport vetoableChangeSupport) {
        if (propertyChangeSupport == null) {
            throw new NullPointerException("PropertyChangeSupport must not be null");
        }
        if (vetoableChangeSupport == null) {
            throw new NullPointerException("VetoableChangeSupport must not be null");
        }
        this.pcs = propertyChangeSupport;
        this.vcs = vetoableChangeSupport;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.pcs.getPropertyChangeListeners(string);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    protected final void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pcs.firePropertyChange(propertyChangeEvent);
    }

    protected final void fireIndexedPropertyChange(String string, int n, Object object, Object object2) {
        this.pcs.fireIndexedPropertyChange(string, n, object, object2);
    }

    protected final boolean hasPropertyChangeListeners(String string) {
        return this.pcs.hasListeners(string);
    }

    protected final boolean hasVetoableChangeListeners(String string) {
        return this.vcs.hasListeners(string);
    }

    public final void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vcs.addVetoableChangeListener(vetoableChangeListener);
    }

    public final void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vcs.removeVetoableChangeListener(vetoableChangeListener);
    }

    public final VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vcs.getVetoableChangeListeners();
    }

    public final void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.vcs.addVetoableChangeListener(string, vetoableChangeListener);
    }

    public final void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.vcs.removeVetoableChangeListener(string, vetoableChangeListener);
    }

    public final VetoableChangeListener[] getVetoableChangeListeners(String string) {
        return this.vcs.getVetoableChangeListeners(string);
    }

    protected final void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vcs.fireVetoableChange(string, object, object2);
    }

    protected final void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        this.vcs.fireVetoableChange(propertyChangeEvent);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractBean abstractBean = (AbstractBean)super.clone();
        abstractBean.pcs = new PropertyChangeSupport(abstractBean);
        abstractBean.vcs = new VetoableChangeSupport(abstractBean);
        return abstractBean;
    }
}

