/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.RequestState;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;

public class TimedRequestState
extends RequestState {
    private final Timer timer;

    public TimedRequestState(LogContext logContext, String owner, long retryBackoffMs, long retryBackoffMaxMs, Timer timer) {
        super(logContext, owner, retryBackoffMs, retryBackoffMaxMs);
        this.timer = timer;
    }

    public TimedRequestState(LogContext logContext, String owner, long retryBackoffMs, int retryBackoffExpBase, long retryBackoffMaxMs, double jitter, Timer timer) {
        super(logContext, owner, retryBackoffMs, retryBackoffExpBase, retryBackoffMaxMs, jitter);
        this.timer = timer;
    }

    public boolean isExpired() {
        this.timer.update();
        return this.timer.isExpired();
    }

    public void resetTimeout(long timeoutMs) {
        this.timer.updateAndReset(timeoutMs);
    }

    public long remainingMs() {
        this.timer.update();
        return this.timer.remainingMs();
    }

    public static Timer deadlineTimer(Time time, long deadlineMs) {
        long diff = Math.max(0L, deadlineMs - time.milliseconds());
        return time.timer(diff);
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", remainingMs=" + this.remainingMs();
    }
}

