/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractNoOffsetLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class TopLimitHandler
extends AbstractNoOffsetLimitHandler {
    public static TopLimitHandler INSTANCE = new TopLimitHandler(true);

    public TopLimitHandler(boolean variableLimit) {
        super(variableLimit);
    }

    @Override
    protected String limitClause() {
        return " top ? ";
    }

    @Override
    protected String limitClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return " top " + parameterMarkerStrategy.createMarker(1, null) + " rows only";
    }

    @Override
    protected String insert(String limitClause, String sql) {
        return TopLimitHandler.insertAfterDistinct(limitClause, sql);
    }

    @Override
    public boolean bindLimitParametersFirst() {
        return true;
    }

    @Override
    public boolean processSqlMutatesState() {
        return false;
    }

    @Override
    public int getParameterPositionStart(Limit limit) {
        return TopLimitHandler.hasMaxRows(limit) && this.supportsVariableLimit() ? 2 : 1;
    }
}

