/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.AnnotationVisitor;
import org.eclipse.sisu.space.ClassFinder;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.DefaultClassFinder;
import org.eclipse.sisu.space.SpaceVisitor;
import org.eclipse.sisu.space.Streams;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

public final class SpaceScanner {
    private static final int ASM_FLAGS = 7;
    static final ClassFinder DEFAULT_FINDER = new DefaultClassFinder();
    private final ClassSpace space;
    private final ClassFinder finder;
    private final boolean isStrict;

    public SpaceScanner(ClassSpace space, ClassFinder finder, boolean isStrict) {
        this.space = space;
        this.finder = finder;
        this.isStrict = isStrict;
    }

    @Deprecated
    public SpaceScanner(ClassSpace space, ClassFinder finder) {
        this(space, finder, false);
    }

    public SpaceScanner(ClassSpace space, boolean isStrict) {
        this(space, DEFAULT_FINDER, isStrict);
    }

    @Deprecated
    public SpaceScanner(ClassSpace space) {
        this(space, DEFAULT_FINDER);
    }

    public void accept(SpaceVisitor visitor) {
        visitor.enterSpace(this.space);
        Enumeration<URL> result = this.finder.findClasses(this.space);
        while (result.hasMoreElements()) {
            URL url = result.nextElement();
            ClassVisitor cv = visitor.visitClass(url);
            if (null == cv) continue;
            SpaceScanner.accept(cv, url, this.isStrict);
        }
        visitor.leaveSpace();
    }

    @Deprecated
    public static void accept(ClassVisitor visitor, URL url) {
        SpaceScanner.accept(visitor, url, false);
    }

    public static void accept(ClassVisitor visitor, URL url, boolean isStrict) {
        if (null == url) {
            return;
        }
        try (InputStream in = Streams.open(url);){
            new ClassReader(in).accept(SpaceScanner.adapt(visitor), 7);
        }
        catch (IOException | RuntimeException e) {
            if (isStrict) {
                throw new IllegalStateException("Problem scanning " + url, e);
            }
            Logs.debug("Problem scanning: {}", url, e);
        }
    }

    public static String jvmDescriptor(Class<? extends Annotation> clazz) {
        return 'L' + clazz.getName().replace('.', '/') + ';';
    }

    private static org.objectweb.asm.ClassVisitor adapt(final ClassVisitor _cv) {
        return null == _cv ? null : new org.objectweb.asm.ClassVisitor(589824){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                _cv.enterClass(access, name, superName, interfaces);
            }

            public org.objectweb.asm.AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                final AnnotationVisitor _av = _cv.visitAnnotation(desc);
                return null == _av ? null : new org.objectweb.asm.AnnotationVisitor(589824){
                    {
                        super(arg0);
                        _av.enterAnnotation();
                    }

                    public void visit(String name, Object value) {
                        _av.visitElement(name, value instanceof Type ? ((Type)value).getClassName() : value);
                    }

                    public void visitEnd() {
                        _av.leaveAnnotation();
                    }
                };
            }

            public void visitEnd() {
                _cv.leaveClass();
            }
        };
    }
}

