/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.replay.OracleXADataSourceImpl;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class OracleXADataSourceConnectionFactoryAdapter
extends XADataSourceConnectionFactoryAdapter {
    static final String CLASS_NAME = OracleXADataSourceConnectionFactoryAdapter.class.getName();

    public OracleXADataSourceConnectionFactoryAdapter(XADataSource xaDataSource, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(xaDataSource, diagnosticsCollector);
        this.initializeUrlFromConnectionFactory();
    }

    public OracleXADataSourceConnectionFactoryAdapter(XADataSource xaDataSource) throws UniversalConnectionPoolException {
        this(xaDataSource, DiagnosticsCollectorImpl.getCommon());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRequestInfo;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "createConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            String instanceName = connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo ? ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName() : null;
            XAConnection xaConnection = null;
            try {
                if (!(this.m_xaDataSource instanceof OracleXADataSource) && !(this.m_xaDataSource instanceof OracleXADataSourceImpl)) {
                    this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection without specifying instance", null, null, new Object[0]);
                    xaConnection = (XAConnection)super.createConnection((ConnectionRetrievalInfo)connectionRequestInfo);
                } else {
                    OracleXAConnectionBuilderImpl builder = this.m_xaDataSource instanceof OracleXADataSource ? ((OracleXADataSource)this.m_xaDataSource).createXAConnectionBuilder() : ((OracleXADataSourceImpl)this.m_xaDataSource).createXAConnectionBuilder();
                    this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection to the instance {0}", null, null, instanceName);
                    JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
                    xaConnection = ((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)builder.user(jdbcCri.getUser())).password(jdbcCri.getPassword().toJDBCOpaqueString())).instanceName(instanceName)).serviceName(jdbcCri.getUserRequestedServiceName())).shardingKey(jdbcCri.getShardingKey())).superShardingKey(jdbcCri.getSuperShardingKey())).sslContext(jdbcCri.getSSLContext())).readOnlyInstanceAllowed(jdbcCri.isReadOnlyInstanceAllowed().booleanValue())).build();
                    this.postCreate(xaConnection, instanceName);
                }
                if (null != xaConnection) {
                    this.onSuccessfulConnectionCreation(xaConnection);
                }
            }
            catch (Throwable e) {
                this.onFailedConnectionCreation(e);
                this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
                if (null != xaConnection) {
                    this.closeConnection(xaConnection);
                }
                UCPErrorHandler.throwUniversalConnectionPoolException(261, e);
            }
            XAConnection xAConnection = xaConnection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "createConnection", "returning {0}", null, null, xAConnection);
            return xAConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "createConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private void postCreate(XAConnection xaConnection, String instanceName) {
        if (null != xaConnection) {
            String val = null;
            try {
                val = ((OracleConnection)xaConnection.getConnection()).getServerSessionInfo().getProperty("INSTANCE_NAME");
            }
            catch (Throwable e) {
                this.trace(Level.FINEST, CLASS_NAME, "createConnection", "unable to get named instance connection information", null, null, new Object[0]);
            }
            if (val != null) {
                if (instanceName != null && !"".equals(instanceName) && !Util.equalsNormalized(instanceName, val)) {
                    this.trace(Level.FINEST, CLASS_NAME, "createConnection", "wrong named instance connection created", null, null, new Object[0]);
                }
            } else {
                this.trace(Level.FINEST, CLASS_NAME, "createConnection", "unable to verify named instance connection creation", null, null, new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public UniversalPooledConnection createPooledConnection(Object object, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRequestInfo;
            void connection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "createPooledConnection", "entering args ({0}, {1})", null, null, object, connectionRetrievalInfo);
            JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
            OracleUniversalPooledConnection oracleUniversalPooledConnection = new OracleUniversalPooledConnection(jdbccp, (Object)connection, (ConnectionRetrievalInfo)connectionRequestInfo, jdbccp.isFailoverEnabled());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "createPooledConnection", "returning {0}", null, null, oracleUniversalPooledConnection);
            return oracleUniversalPooledConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "createPooledConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void initializeUrlFromConnectionFactory() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "initializeUrlFromConnectionFactory", "entering args ()", null, null, new Object[0]);
            Class<?> dsClass = this.m_xaDataSource.getClass();
            Class<?> cls = null;
            try {
                cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
                Method m = cls.getMethod("getURL", new Class[0]);
                this.m_url = (String)m.invoke((Object)this.m_xaDataSource, new Object[0]);
                this.trace(Level.FINEST, CLASS_NAME, "initializeUrlFromConnectionFactory", "succeeded", null, null, new Object[0]);
            }
            catch (Exception exc) {
                this.trace(Level.WARNING, CLASS_NAME, "initializeUrlFromConnectionFactory", "", null, exc, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "initializeUrlFromConnectionFactory", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "initializeUrlFromConnectionFactory", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setUrl(String string) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "setUrl", "entering args ({0})", null, null, string);
            Class<?> dsClass = this.m_xaDataSource.getClass();
            Class<?> cls = null;
            try {
                void url;
                cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
                Method m = cls.getMethod("setURL", String.class);
                m.invoke((Object)this.m_xaDataSource, url);
            }
            catch (Exception exc) {
                this.trace(Level.WARNING, CLASS_NAME, "setUrl", "", null, exc, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "setUrl", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter", "setUrl", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }
}

