/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import org.apache.poi.ooxml.util.POIXMLUnits;
import org.apache.poi.sl.usermodel.TabStop;
import org.apache.poi.util.Units;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStop;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextTabAlignType;

public class XSLFTabStop
implements TabStop {
    final CTTextTabStop tabStop;

    XSLFTabStop(CTTextTabStop tabStop) {
        this.tabStop = tabStop;
    }

    public int getPosition() {
        return (int)POIXMLUnits.parseLength(this.tabStop.xgetPos());
    }

    public void setPosition(int position) {
        this.tabStop.setPos((Object)position);
    }

    public double getPositionInPoints() {
        return Units.toPoints((long)this.getPosition());
    }

    public void setPositionInPoints(double points) {
        this.setPosition(Units.toEMU((double)points));
    }

    public TabStop.TabStopType getType() {
        return TabStop.TabStopType.fromOoxmlId((int)this.tabStop.getAlgn().intValue());
    }

    public void setType(TabStop.TabStopType tabStopType) {
        this.tabStop.setAlgn(STTextTabAlignType.Enum.forInt((int)tabStopType.ooxmlId));
    }
}

