/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.util.Collections;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.carrot2.attrs.AttrComposite;
import org.carrot2.attrs.AttrObjectArray;
import org.carrot2.language.DefaultDictionaryImpl;
import org.carrot2.language.LabelFilter;
import org.carrot2.language.LabelFilterDictionary;
import org.carrot2.language.LanguageComponents;
import org.carrot2.language.StopwordFilter;
import org.carrot2.language.StopwordFilterDictionary;

public class EphemeralDictionaries
extends AttrComposite {
    public AttrObjectArray<StopwordFilterDictionary> wordFilters;
    public AttrObjectArray<LabelFilterDictionary> labelFilters;

    public EphemeralDictionaries() {
        this.wordFilters = this.attributes.register("wordFilters", ((AttrObjectArray.Builder)AttrObjectArray.builder(StopwordFilterDictionary.class, DefaultDictionaryImpl::new).label("Word filtering dictionaries.")).defaultValue(Collections.emptyList()));
        this.labelFilters = this.attributes.register("labelFilters", ((AttrObjectArray.Builder)AttrObjectArray.builder(LabelFilterDictionary.class, DefaultDictionaryImpl::new).label("Cluster label filtering dictionaries.")).defaultValue(Collections.emptyList()));
    }

    public LanguageComponents override(LanguageComponents languageComponents) {
        Object labelFilterAttrs;
        Object wordFilterAttrs = this.wordFilters.get();
        if (wordFilterAttrs != null && !wordFilterAttrs.isEmpty()) {
            StopwordFilter dictFilter = wordFilterAttrs.stream().map(StopwordFilterDictionary::compileStopwordFilter).reduce(StopwordFilter::and).get();
            languageComponents = languageComponents.override(StopwordFilter.class, previous -> () -> EphemeralDictionaries.lambda$override$0((Supplier)previous, dictFilter));
        }
        if ((labelFilterAttrs = this.labelFilters.get()) != null && !labelFilterAttrs.isEmpty()) {
            LabelFilter dictFilter = labelFilterAttrs.stream().map(LabelFilterDictionary::compileLabelFilter).reduce(LabelFilter::and).get();
            languageComponents = languageComponents.override(LabelFilter.class, previous -> () -> EphemeralDictionaries.lambda$override$2((Supplier)previous, dictFilter));
        }
        return languageComponents;
    }

    private static /* synthetic */ LabelFilter lambda$override$2(Supplier previous, LabelFilter dictFilter) {
        LabelFilter previousFilter = (LabelFilter)previous.get();
        if (previousFilter != null) {
            return previousFilter.and((Predicate)dictFilter);
        }
        return dictFilter;
    }

    private static /* synthetic */ StopwordFilter lambda$override$0(Supplier previous, StopwordFilter dictFilter) {
        StopwordFilter previousFilter = (StopwordFilter)previous.get();
        if (previousFilter != null) {
            return previousFilter.and((Predicate)dictFilter);
        }
        return dictFilter;
    }
}

