/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.solr.api.ClusterPluginsSource;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.ContainerPluginsApi;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZkClusterPluginsSource
implements ClusterPluginsSource {
    private final Supplier<SolrZkClient> zkClientSupplier;
    private final ContainerPluginsApi api;

    public ZkClusterPluginsSource(CoreContainer coreContainer) {
        this.zkClientSupplier = coreContainer.zkClientSupplier;
        this.api = new ContainerPluginsApi(coreContainer, this);
    }

    @Override
    public ContainerPluginsApi.Read getReadApi() {
        return this.api.readAPI;
    }

    @Override
    public ContainerPluginsApi.Edit getEditApi() {
        return this.api.editAPI;
    }

    @Override
    public Map<String, Object> plugins() throws IOException {
        SolrZkClient zkClient = this.zkClientSupplier.get();
        try {
            Map clusterPropsJson = (Map)Utils.fromJSON((byte[])zkClient.getData("/clusterprops.json", null, new Stat(), true));
            return Map.copyOf((Map)clusterPropsJson.computeIfAbsent("plugin", o -> new LinkedHashMap()));
        }
        catch (KeeperException.NoNodeException e) {
            return new LinkedHashMap<String, Object>();
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading cluster property", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @Override
    public void persistPlugins(Function<Map<String, Object>, Map<String, Object>> modifier) throws IOException {
        try {
            this.zkClientSupplier.get().atomicUpdate("/clusterprops.json", bytes -> {
                Map rawJson = bytes == null ? new LinkedHashMap() : (Map)Utils.fromJSON((byte[])bytes);
                Map pluginsModified = (Map)modifier.apply((Map)rawJson.computeIfAbsent("plugin", o -> new LinkedHashMap()));
                if (pluginsModified == null) {
                    return null;
                }
                rawJson.put("plugin", pluginsModified);
                return Utils.toJSON(rawJson);
            });
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading cluster property", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }
}

