/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrDocumentFetcher;
import org.apache.solr.search.SolrIndexSearcher;

public abstract class ResultContext {
    private SolrDocumentFetcher docFetcher;
    public static final ThreadLocal<Predicate<String>> READASBYTES = new ThreadLocal();

    public abstract DocList getDocList();

    public abstract ReturnFields getReturnFields();

    public abstract SolrIndexSearcher getSearcher();

    public SolrDocumentFetcher getDocFetcher() {
        if (this.docFetcher == null) {
            this.docFetcher = this.getSearcher().getDocFetcher();
            return this.docFetcher;
        }
        return this.docFetcher;
    }

    public abstract Query getQuery();

    public abstract SolrQueryRequest getRequest();

    public boolean wantsScores() {
        return this.getReturnFields() != null && this.getReturnFields().wantsScore() && this.getDocList() != null && this.getDocList().hasScores();
    }

    public Iterator<SolrDocument> getProcessedDocuments() {
        return new DocsStreamer(this);
    }
}

