/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;

public final class UriUtil {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern PATTERN_EXCLAMATION_MARK = Pattern.compile("!/");
    private static final Pattern PATTERN_CARET = Pattern.compile("\\^/");
    private static final Pattern PATTERN_ASTERISK = Pattern.compile("\\*/");
    private static final Pattern PATTERN_CUSTOM;
    private static final String REPLACE_CUSTOM;
    private static final String WAR_SEPARATOR;

    private UriUtil() {
    }

    private static boolean isSchemeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.';
    }

    public static boolean hasScheme(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (UriUtil.isSchemeChar(c)) continue;
            return false;
        }
        return false;
    }

    public static URL buildJarUrl(File file) throws MalformedURLException {
        return UriUtil.buildJarUrl(file, null);
    }

    public static URL buildJarUrl(File file, String string) throws MalformedURLException {
        return UriUtil.buildJarUrl(file.toURI().toString(), string);
    }

    public static URL buildJarUrl(String string) throws MalformedURLException {
        return UriUtil.buildJarUrl(string, null);
    }

    public static URL buildJarUrl(String string, String string2) throws MalformedURLException {
        String string3 = UriUtil.makeSafeForJarUrl(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append("!/");
        if (string2 != null) {
            stringBuilder.append(UriUtil.makeSafeForJarUrl(string2));
        }
        return new URL("jar", null, -1, stringBuilder.toString());
    }

    public static URL buildJarSafeUrl(File file) throws MalformedURLException {
        String string = UriUtil.makeSafeForJarUrl(file.toURI().toString());
        return new URL(string);
    }

    private static String makeSafeForJarUrl(String string) {
        String string2 = PATTERN_EXCLAMATION_MARK.matcher(string).replaceAll("%21/");
        string2 = PATTERN_CARET.matcher(string2).replaceAll("%5e/");
        string2 = PATTERN_ASTERISK.matcher(string2).replaceAll("%2a/");
        if (PATTERN_CUSTOM != null) {
            string2 = PATTERN_CUSTOM.matcher(string2).replaceAll(REPLACE_CUSTOM);
        }
        return string2;
    }

    public static URL warToJar(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        if (string.contains("*/")) {
            string = string.replaceFirst("\\*/", "!/");
        } else if (string.contains("^/")) {
            string = string.replaceFirst("\\^/", "!/");
        } else if (PATTERN_CUSTOM != null) {
            string = string.replaceFirst(PATTERN_CUSTOM.pattern(), "!/");
        }
        return new URL("jar", uRL.getHost(), uRL.getPort(), string);
    }

    public static String getWarSeparator() {
        return WAR_SEPARATOR;
    }

    public static boolean isAbsoluteURI(String string) {
        int n;
        if (string.startsWith("file:/")) {
            return true;
        }
        for (n = 0; n < string.length() && UriUtil.isSchemeChar(string.charAt(n)); ++n) {
        }
        if (n == 0) {
            return false;
        }
        return n + 2 < string.length() && string.charAt(n++) == ':' && string.charAt(n++) == '/' && string.charAt(n) == '/';
    }

    public static URI resolve(URI uRI, String string) throws MalformedURLException, URISyntaxException {
        if (uRI.getScheme().equals("jar")) {
            URI uRI2 = new URI(uRI.getSchemeSpecificPart());
            URI uRI3 = uRI2.resolve(string);
            return new URI("jar:" + uRI3.toString());
        }
        return uRI.resolve(string);
    }

    static {
        String string = System.getProperty("org.apache.tomcat.util.buf.UriUtil.WAR_SEPARATOR");
        if (string == null) {
            WAR_SEPARATOR = "*/";
            PATTERN_CUSTOM = null;
            REPLACE_CUSTOM = null;
        } else {
            byte[] byArray;
            WAR_SEPARATOR = string + "/";
            PATTERN_CUSTOM = Pattern.compile(Pattern.quote(WAR_SEPARATOR));
            StringBuilder stringBuilder = new StringBuilder(string.length() * 3);
            for (byte by : byArray = string.getBytes()) {
                stringBuilder.append('%');
                int n = by & 0xF;
                int n2 = (by & 0xF0) >> 4;
                stringBuilder.append(HEX[n2]);
                stringBuilder.append(HEX[n]);
            }
            REPLACE_CUSTOM = stringBuilder.toString();
        }
    }
}

