/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.catalina.tribes.util.ExecutorFactory;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class McastServiceImpl {
    private static final Log log = LogFactory.getLog(McastService.class);
    protected static final int MAX_PACKET_SIZE = 65535;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.membership");
    protected volatile boolean doRunSender = false;
    protected volatile boolean doRunReceiver = false;
    protected volatile int startLevel = 0;
    protected MulticastSocket socket;
    protected final MemberImpl member;
    protected final InetAddress address;
    protected final int port;
    protected final long timeToExpiration;
    protected final long sendFrequency;
    protected DatagramPacket sendPacket;
    protected DatagramPacket receivePacket;
    protected Membership membership;
    protected final MembershipListener service;
    protected final MessageListener msgservice;
    protected ReceiverThread receiver;
    protected SenderThread sender;
    protected final int mcastTTL;
    protected int mcastSoTimeout = -1;
    protected final InetAddress mcastBindAddress;
    protected int recoveryCounter = 10;
    protected long recoverySleepTime = 5000L;
    protected boolean recoveryEnabled = true;
    protected final ExecutorService executor = ExecutorFactory.newThreadPool(0, 2, 2L, TimeUnit.SECONDS);
    protected final boolean localLoopbackDisabled;
    private Channel channel;
    protected final Object expiredMutex = new Object();
    private final Object sendLock = new Object();

    public McastServiceImpl(MemberImpl memberImpl, long l, long l2, int n, InetAddress inetAddress, InetAddress inetAddress2, int n2, int n3, MembershipListener membershipListener, MessageListener messageListener, boolean bl) throws IOException {
        this.member = memberImpl;
        this.address = inetAddress2;
        this.port = n;
        this.mcastSoTimeout = n3;
        this.mcastTTL = n2;
        this.mcastBindAddress = inetAddress;
        this.timeToExpiration = l2;
        this.service = membershipListener;
        this.msgservice = messageListener;
        this.sendFrequency = l;
        this.localLoopbackDisabled = bl;
        this.init();
    }

    public void init() throws IOException {
        this.setupSocket();
        this.sendPacket = new DatagramPacket(new byte[65535], 65535);
        this.sendPacket.setAddress(this.address);
        this.sendPacket.setPort(this.port);
        this.receivePacket = new DatagramPacket(new byte[65535], 65535);
        this.receivePacket.setAddress(this.address);
        this.receivePacket.setPort(this.port);
        this.member.setCommand(new byte[0]);
        if (this.membership == null) {
            this.membership = new Membership(this.member);
        }
    }

    protected void setupSocket() throws IOException {
        if (this.mcastBindAddress != null) {
            try {
                log.info((Object)sm.getString("mcastServiceImpl.bind", this.address, Integer.toString(this.port)));
                this.socket = new MulticastSocket(new InetSocketAddress(this.address, this.port));
            }
            catch (BindException bindException) {
                log.info((Object)sm.getString("mcastServiceImpl.bind.failed"));
                this.socket = new MulticastSocket(this.port);
            }
        } else {
            this.socket = new MulticastSocket(this.port);
        }
        this.socket.setLoopbackMode(this.localLoopbackDisabled);
        if (this.mcastBindAddress != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("mcastServiceImpl.setInterface", this.mcastBindAddress));
            }
            this.socket.setInterface(this.mcastBindAddress);
        }
        if (this.mcastSoTimeout <= 0) {
            this.mcastSoTimeout = (int)this.sendFrequency;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("mcastServiceImpl.setSoTimeout", Integer.toString(this.mcastSoTimeout)));
        }
        this.socket.setSoTimeout(this.mcastSoTimeout);
        if (this.mcastTTL >= 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("mcastServiceImpl.setTTL", Integer.toString(this.mcastTTL)));
            }
            this.socket.setTimeToLive(this.mcastTTL);
        }
    }

    public synchronized void start(int n) throws IOException {
        boolean bl = false;
        if ((n & 4) == 4) {
            if (this.receiver != null) {
                throw new IllegalStateException(sm.getString("mcastServiceImpl.receive.running"));
            }
            try {
                if (this.sender == null) {
                    this.socket.joinGroup(this.address);
                }
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("mcastServiceImpl.unable.join"));
                throw iOException;
            }
            this.doRunReceiver = true;
            this.receiver = new ReceiverThread();
            this.receiver.setDaemon(true);
            this.receiver.start();
            bl = true;
        }
        if ((n & 8) == 8) {
            if (this.sender != null) {
                throw new IllegalStateException(sm.getString("mcastServiceImpl.send.running"));
            }
            if (this.receiver == null) {
                this.socket.joinGroup(this.address);
            }
            this.send(false);
            this.doRunSender = true;
            this.sender = new SenderThread(this.sendFrequency);
            this.sender.setDaemon(true);
            this.sender.start();
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException(sm.getString("mcastServiceImpl.invalid.startLevel"));
        }
        this.waitForMembers(n);
        this.startLevel |= n;
    }

    private void waitForMembers(int n) {
        long l = this.sendFrequency * 2L;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("mcastServiceImpl.waitForMembers.start", Long.toString(l), Integer.toString(n)));
        }
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("mcastServiceImpl.waitForMembers.done", Integer.toString(n)));
        }
    }

    public synchronized boolean stop(int n) throws IOException {
        boolean bl = false;
        if ((n & 4) == 4) {
            bl = true;
            this.doRunReceiver = false;
            if (this.receiver != null) {
                this.receiver.interrupt();
            }
            this.receiver = null;
        }
        if ((n & 8) == 8) {
            bl = true;
            this.doRunSender = false;
            if (this.sender != null) {
                this.sender.interrupt();
            }
            this.sender = null;
        }
        if (!bl) {
            throw new IllegalArgumentException(sm.getString("mcastServiceImpl.invalid.stopLevel"));
        }
        this.startLevel &= ~n;
        if (this.startLevel == 0) {
            this.member.setCommand(Member.SHUTDOWN_PAYLOAD);
            this.send(false);
            try {
                this.socket.leaveGroup(this.address);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.member.setServiceStartTime(-1L);
        }
        return this.startLevel == 0;
    }

    public void receive() throws IOException {
        boolean bl = true;
        try {
            this.socket.receive(this.receivePacket);
            if (this.receivePacket.getLength() > 65535) {
                log.error((Object)sm.getString("mcastServiceImpl.packet.tooLong", Integer.toString(this.receivePacket.getLength())));
            } else {
                byte[] byArray = new byte[this.receivePacket.getLength()];
                System.arraycopy(this.receivePacket.getData(), this.receivePacket.getOffset(), byArray, 0, byArray.length);
                if (XByteBuffer.firstIndexOf(byArray, 0, MemberImpl.TRIBES_MBR_BEGIN) == 0) {
                    this.memberDataReceived(byArray);
                } else {
                    this.memberBroadcastsReceived(byArray);
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        if (bl) {
            this.checkExpired();
        }
    }

    private void memberDataReceived(byte[] byArray) {
        final Member member = MemberImpl.getMember(byArray);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mcast receive ping from member " + member));
        }
        Runnable runnable = null;
        final Thread thread = Thread.currentThread();
        if (Arrays.equals(member.getCommand(), Member.SHUTDOWN_PAYLOAD)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mcastServiceImpl.memberShutdown", member));
            }
            this.membership.removeMember(member);
            runnable = new Runnable(){

                @Override
                public void run() {
                    String string = thread.getName();
                    try {
                        thread.setName("Membership-MemberDisappeared.");
                        McastServiceImpl.this.service.memberDisappeared(member);
                    }
                    finally {
                        thread.setName(string);
                    }
                }
            };
        } else if (this.membership.memberAlive(member)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mcastServiceImpl.memberAdd", member));
            }
            runnable = new Runnable(){

                @Override
                public void run() {
                    String string = thread.getName();
                    try {
                        thread.setName("Membership-MemberAdded.");
                        McastServiceImpl.this.service.memberAdded(member);
                    }
                    finally {
                        thread.setName(string);
                    }
                }
            };
        }
        if (runnable != null) {
            this.executor.execute(runnable);
        }
    }

    private void memberBroadcastsReceived(byte[] byArray) {
        XByteBuffer xByteBuffer;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Mcast received broadcasts.");
        }
        if ((xByteBuffer = new XByteBuffer(byArray, true)).countPackages(true) > 0) {
            int n = xByteBuffer.countPackages();
            final ChannelData[] channelDataArray = new ChannelData[n];
            for (int i = 0; i < n; ++i) {
                try {
                    channelDataArray[i] = xByteBuffer.extractPackage(true);
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    log.debug((Object)sm.getString("mcastServiceImpl.messageError"), (Throwable)illegalStateException);
                }
            }
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread thread = Thread.currentThread();
                    String string = thread.getName();
                    try {
                        thread.setName("Membership-MemberAdded.");
                        for (ChannelData channelData : channelDataArray) {
                            try {
                                if (channelData == null || McastServiceImpl.this.member.equals(channelData.getAddress())) continue;
                                McastServiceImpl.this.msgservice.messageReceived(channelData);
                            }
                            catch (Throwable throwable) {
                                if (throwable instanceof ThreadDeath) {
                                    throw (ThreadDeath)throwable;
                                }
                                if (throwable instanceof VirtualMachineError) {
                                    throw (VirtualMachineError)throwable;
                                }
                                log.error((Object)sm.getString("mcastServiceImpl.unableReceive.broadcastMessage"), throwable);
                            }
                        }
                    }
                    finally {
                        thread.setName(string);
                    }
                }
            };
            this.executor.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkExpired() {
        Object object = this.expiredMutex;
        synchronized (object) {
            Member[] memberArray;
            for (final Member member : memberArray = this.membership.expire(this.timeToExpiration)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("mcastServiceImpl.memberExpire", member));
                }
                try {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Thread thread = Thread.currentThread();
                            String string = thread.getName();
                            try {
                                thread.setName("Membership-MemberExpired.");
                                McastServiceImpl.this.service.memberDisappeared(member);
                            }
                            finally {
                                thread.setName(string);
                            }
                        }
                    };
                    this.executor.execute(runnable);
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("mcastServiceImpl.memberDisappeared.failed"), (Throwable)exception);
                }
            }
        }
    }

    public void send(boolean bl) throws IOException {
        this.send(bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(boolean bl, DatagramPacket datagramPacket) throws IOException {
        Object object;
        boolean bl2 = bl = bl && datagramPacket == null;
        if (datagramPacket == null) {
            this.member.inc();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Mcast send ping from member " + this.member));
            }
            object = this.member.getData();
            datagramPacket = new DatagramPacket((byte[])object, ((byte[])object).length);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Sending message broadcast " + datagramPacket.getLength() + " bytes from " + this.member));
        }
        datagramPacket.setAddress(this.address);
        datagramPacket.setPort(this.port);
        Object object2 = this.sendLock;
        object = object2;
        synchronized (object2) {
            this.socket.send(datagramPacket);
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            if (bl) {
                this.checkExpired();
            }
            return;
        }
    }

    public long getServiceStartTime() {
        return this.member != null ? this.member.getServiceStartTime() : -1L;
    }

    public int getRecoveryCounter() {
        return this.recoveryCounter;
    }

    public boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    public long getRecoverySleepTime() {
        return this.recoverySleepTime;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setRecoveryCounter(int n) {
        this.recoveryCounter = n;
    }

    public void setRecoveryEnabled(boolean bl) {
        this.recoveryEnabled = bl;
    }

    public void setRecoverySleepTime(long l) {
        this.recoverySleepTime = l;
    }

    protected static class RecoveryThread
    extends Thread {
        private static final AtomicBoolean running = new AtomicBoolean(false);
        final McastServiceImpl parent;

        public static synchronized void recover(McastServiceImpl mcastServiceImpl) {
            if (!mcastServiceImpl.isRecoveryEnabled()) {
                return;
            }
            if (!running.compareAndSet(false, true)) {
                return;
            }
            RecoveryThread recoveryThread = new RecoveryThread(mcastServiceImpl);
            String string = "";
            if (mcastServiceImpl.channel.getName() != null) {
                string = "[" + mcastServiceImpl.channel.getName() + "]";
            }
            recoveryThread.setName("Tribes-MembershipRecovery" + string);
            recoveryThread.setDaemon(true);
            recoveryThread.start();
        }

        public RecoveryThread(McastServiceImpl mcastServiceImpl) {
            this.parent = mcastServiceImpl;
        }

        public boolean stopService() {
            try {
                this.parent.stop(12);
                return true;
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("mcastServiceImpl.recovery.stopFailed"), (Throwable)exception);
                return false;
            }
        }

        public boolean startService() {
            try {
                this.parent.init();
                this.parent.start(12);
                return true;
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("mcastServiceImpl.recovery.startFailed"), (Throwable)exception);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            int n = 0;
            try {
                while (!bl) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)sm.getString("mcastServiceImpl.recovery"));
                    }
                    if (this.stopService() & this.startService()) {
                        bl = true;
                        if (log.isInfoEnabled()) {
                            log.info((Object)sm.getString("mcastServiceImpl.recovery.successful"));
                        }
                    }
                    try {
                        if (bl) continue;
                        if (log.isInfoEnabled()) {
                            log.info((Object)sm.getString("mcastServiceImpl.recovery.failed", Integer.toString(++n), Long.toString(this.parent.recoverySleepTime)));
                        }
                        RecoveryThread.sleep(this.parent.recoverySleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            finally {
                running.set(false);
            }
        }
    }

    public class SenderThread
    extends Thread {
        final long time;
        int errorCounter = 0;

        public SenderThread(long l) {
            this.time = l;
            String string = "";
            if (McastServiceImpl.this.channel.getName() != null) {
                string = "[" + McastServiceImpl.this.channel.getName() + "]";
            }
            this.setName("Tribes-MembershipSender" + string);
        }

        @Override
        public void run() {
            while (McastServiceImpl.this.doRunSender) {
                block7: {
                    try {
                        McastServiceImpl.this.send(true);
                        this.errorCounter = 0;
                    }
                    catch (Exception exception) {
                        if (this.errorCounter == 0) {
                            log.warn((Object)sm.getString("mcastServiceImpl.send.failed"), (Throwable)exception);
                        } else {
                            log.debug((Object)sm.getString("mcastServiceImpl.send.failed"), (Throwable)exception);
                        }
                        if (++this.errorCounter < McastServiceImpl.this.recoveryCounter) break block7;
                        this.errorCounter = 0;
                        RecoveryThread.recover(McastServiceImpl.this);
                    }
                }
                try {
                    SenderThread.sleep(this.time);
                }
                catch (Exception exception) {}
            }
        }
    }

    public class ReceiverThread
    extends Thread {
        int errorCounter = 0;

        public ReceiverThread() {
            String string = "";
            if (McastServiceImpl.this.channel.getName() != null) {
                string = "[" + McastServiceImpl.this.channel.getName() + "]";
            }
            this.setName("Tribes-MembershipReceiver" + string);
        }

        @Override
        public void run() {
            while (McastServiceImpl.this.doRunReceiver) {
                try {
                    McastServiceImpl.this.receive();
                    this.errorCounter = 0;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("mcastServiceImpl.invalidMemberPackage"), (Throwable)arrayIndexOutOfBoundsException);
                }
                catch (Exception exception) {
                    if (this.errorCounter == 0 && McastServiceImpl.this.doRunReceiver) {
                        log.warn((Object)sm.getString("mcastServiceImpl.error.receiving"), (Throwable)exception);
                    } else if (log.isDebugEnabled()) {
                        if (McastServiceImpl.this.doRunReceiver) {
                            log.debug((Object)sm.getString("mcastServiceImpl.error.receiving"), (Throwable)exception);
                        } else {
                            log.warn((Object)sm.getString("mcastServiceImpl.error.receivingNoSleep"), (Throwable)exception);
                        }
                    }
                    if (!McastServiceImpl.this.doRunReceiver) continue;
                    try {
                        ReceiverThread.sleep(500L);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    if (++this.errorCounter < McastServiceImpl.this.recoveryCounter) continue;
                    this.errorCounter = 0;
                    RecoveryThread.recover(McastServiceImpl.this);
                }
            }
        }
    }
}

