/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.shaped.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.HighlightPainter;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.BackgroundPainterColorProvider;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.shaped.ShapedUtil;
import net.infonode.gui.shaped.border.AbstractShapedBorder;
import net.infonode.gui.shaped.panel.ShapedPanel;

public abstract class AbstractPolygonBorder
extends AbstractShapedBorder {
    private static final long serialVersionUID = 1L;
    private static final Insets HIGHLIGHT_INSETS = new Insets(1, 1, 0, 0);
    private ColorProvider lineColor;
    private ColorProvider highlightColor = new FixedColorProvider(new Color(255, 255, 255));
    private ColorProvider middleColor;
    private ColorProvider shadowColor;

    protected AbstractPolygonBorder(ColorProvider lineColor) {
        this(lineColor, FixedColorProvider.WHITE);
    }

    protected AbstractPolygonBorder(ColorProvider lineColor, ColorProvider highlightColor) {
        this(lineColor, highlightColor, BackgroundPainterColorProvider.INSTANCE, null);
    }

    protected AbstractPolygonBorder(ColorProvider lineColor, ColorProvider highlightColor, ColorProvider middleColor, ColorProvider shadowColor) {
        this.lineColor = lineColor;
        this.highlightColor = highlightColor;
        this.middleColor = middleColor;
        this.shadowColor = shadowColor;
    }

    @Override
    public Shape getShape(Component c, int x, int y, int width, int height) {
        int w = ShapedUtil.getWidth(c, width, height);
        int h = ShapedUtil.getHeight(c, width, height);
        Polygon polygon = this.getPolygon(c, x, y, w, h);
        return polygon;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Shape clip = g.getClip();
        g.clipRect(x, y, width, height);
        try {
            int w = ShapedUtil.getWidth(c, width, height);
            height = ShapedUtil.getHeight(c, width, height);
            width = w;
            Polygon polygon = this.getPolygon(c, x, y, width, height);
            Graphics2D g2 = (Graphics2D)g;
            if (this.highlightColor != null) {
                this.paintHighlight(c, g2, polygon, width, height);
            }
            if (this.lineColor != null) {
                g.setColor(this.lineColor.getColor());
                this.paintPolygon(c, g2, polygon, width, height);
            }
        }
        finally {
            g.setClip(clip);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets insets = this.getShapedBorderInsets(c);
        insets = ShapedUtil.transformInsets(c, insets);
        return this.highlightColor != null ? InsetsUtil.add(this.getShapedBorderHighlightInsets(c), insets) : insets;
    }

    protected Insets getShapedBorderInsets(Component c) {
        return new Insets(0, 0, 0, 0);
    }

    protected Insets getShapedBorderHighlightInsets(Component c) {
        return HIGHLIGHT_INSETS;
    }

    protected Polygon createPolygon(Component c, int width, int height) {
        return new Polygon();
    }

    protected void paintPolygon(Component c, Graphics2D g, Polygon polygon, int width, int height) {
        int i = 0;
        while (i < polygon.npoints) {
            if (this.lineIsDrawn(i, polygon)) {
                int ni = (i + 1) % polygon.npoints;
                GraphicsUtil.drawOptimizedLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[ni], polygon.ypoints[ni]);
            }
            ++i;
        }
    }

    protected void paintHighlight(Component c, Graphics2D g, Polygon polygon, int width, int height) {
        Color c1 = this.highlightColor == null ? null : this.highlightColor.getColor(c);
        Color c2 = this.middleColor.getColor(c);
        Color c3 = this.shadowColor == null ? null : this.shadowColor.getColor(c);
        boolean clockWise = this.isPointsClockwise(c);
        int i = 0;
        while (i < polygon.npoints) {
            int ni = (i + 1) % polygon.npoints;
            if (this.lineIsDrawn(i, polygon)) {
                HighlightPainter.drawLine(g, polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[ni], polygon.ypoints[ni], clockWise, true, c1, c2, c3);
            }
            ++i;
        }
    }

    protected boolean lineIsDrawn(int index, Polygon polygon) {
        return true;
    }

    protected boolean isHighlightable(int deltaX, int deltaY) {
        return deltaX > deltaY;
    }

    protected boolean isPointsClockwise(Component c) {
        if (c instanceof ShapedPanel) {
            return !(((ShapedPanel)c).isHorizontalFlip() ^ ((ShapedPanel)c).isVerticalFlip());
        }
        return true;
    }

    protected int getHighlightOffsetX(int deltaX, int deltaY) {
        return deltaY - deltaX > 0 ? (deltaX + deltaY > 0 ? -1 : 0) : (deltaX + deltaY > 0 ? 0 : 1);
    }

    protected int getHighlightOffsetY(int deltaX, int deltaY) {
        return deltaY - deltaX > 0 ? (deltaX + deltaY > 0 ? 0 : -1) : (deltaX + deltaY > 0 ? 1 : 0);
    }

    protected void setPoint(Polygon polygon, int x, int y) {
        polygon.xpoints[polygon.npoints] = x;
        polygon.ypoints[polygon.npoints] = y;
        ++polygon.npoints;
    }

    private Polygon getPolygon(Component c, int x, int y, int width, int height) {
        Polygon polygon = this.createPolygon(c, width, height);
        this.flipPolygon(c, polygon, width, height);
        this.rotatePolygon(c, polygon, width, height);
        this.fixGraphicsOffset(c, polygon, x, y);
        return polygon;
    }

    private void flipPolygon(Component c, Polygon polygon, int width, int height) {
        if (c instanceof ShapedPanel) {
            int i;
            if (((ShapedPanel)c).isHorizontalFlip()) {
                i = 0;
                while (i < polygon.npoints) {
                    polygon.xpoints[i] = Math.abs(width - polygon.xpoints[i]) - 1;
                    ++i;
                }
            }
            if (((ShapedPanel)c).isVerticalFlip()) {
                i = 0;
                while (i < polygon.npoints) {
                    polygon.ypoints[i] = Math.abs(height - polygon.ypoints[i]) - 1;
                    ++i;
                }
            }
        }
    }

    private void rotatePolygon(Component c, Polygon polygon, int width, int height) {
        ShapedUtil.rotate(polygon, ShapedUtil.getDirection(c), width, height);
    }

    private void fixGraphicsOffset(Component c, Polygon polygon, int x, int y) {
        int i = 0;
        while (i < polygon.npoints) {
            int n = i;
            polygon.xpoints[n] = polygon.xpoints[n] + x;
            int n2 = i++;
            polygon.ypoints[n2] = polygon.ypoints[n2] + y;
        }
    }
}

