/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor.scanning;

import jakarta.ws.rs.RuntimeType;
import java.util.List;
import org.jboss.jandex.ClassInfo;

public class ScannedSerializer {
    private final ClassInfo classInfo;
    private final String className;
    private final String handledClassName;
    private final List<String> mediaTypeStrings;
    private final RuntimeType runtimeType;
    private final boolean builtin;
    private final Integer priority;

    public ScannedSerializer(ClassInfo classInfo, String handledClassName, List<String> mediaTypeStrings) {
        this(classInfo, handledClassName, mediaTypeStrings, null, true, 5000);
    }

    public ScannedSerializer(String className, String handledClassName, List<String> mediaTypeStrings) {
        this(null, className, handledClassName, mediaTypeStrings, null, true, 5000);
    }

    public ScannedSerializer(ClassInfo classInfo, String handledClassName, List<String> mediaTypeStrings, RuntimeType runtimeType, boolean builtin, Integer priority) {
        this(classInfo, classInfo.name().toString(), handledClassName, mediaTypeStrings, runtimeType, builtin, priority);
    }

    private ScannedSerializer(ClassInfo classInfo, String className, String handledClassName, List<String> mediaTypeStrings, RuntimeType runtimeType, boolean builtin, Integer priority) {
        this.classInfo = classInfo;
        this.className = className;
        this.handledClassName = handledClassName;
        this.mediaTypeStrings = mediaTypeStrings;
        this.runtimeType = runtimeType;
        this.builtin = builtin;
        this.priority = priority;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getClassName() {
        return this.className;
    }

    public String getHandledClassName() {
        return this.handledClassName;
    }

    public List<String> getMediaTypeStrings() {
        return this.mediaTypeStrings;
    }

    public RuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public Integer getPriority() {
        return this.priority;
    }
}

