/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servicelocator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.exception.ServiceNotFoundException;
import liquibase.logging.Logger;
import liquibase.servicelocator.ServiceLocator;
import liquibase.util.SystemUtil;

public class StandardServiceLocator
implements ServiceLocator {
    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public <T> List<T> findInstances(Class<T> interfaceType) throws ServiceNotFoundException {
        ArrayList<T> allInstances = new ArrayList<T>();
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        Iterator<T> services = ServiceLoader.load(interfaceType, Scope.getCurrentScope().getClassLoader(true)).iterator();
        while (services.hasNext()) {
            try {
                T service = services.next();
                log.fine("Loaded " + interfaceType.getName() + " instance " + service.getClass().getName());
                allInstances.add(service);
            }
            catch (Throwable e) {
                new ServiceLoadExceptionHandler().handleException(e);
            }
        }
        return Collections.unmodifiableList(allInstances);
    }

    static class ServiceLoadExceptionHandler {
        ServiceLoadExceptionHandler() {
        }

        void handleException(Throwable e) {
            Level level = Level.INFO;
            if (e instanceof UnsupportedClassVersionError && !SystemUtil.isAtLeastJava11() && e.getMessage().contains("BigQuery")) {
                level = Level.FINE;
            }
            Scope.getCurrentScope().getLog(this.getClass()).log(level, "Cannot load service: " + e.getMessage(), e);
        }
    }
}

