/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.fips;

import java.security.Key;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.KeyUnwrapperUsingSecureRandom;
import org.bouncycastle.crypto.KeyWrapperUsingSecureRandom;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;

public class FIPSRsaKeyEncryptionJWEAlgorithmProvider
implements JWEAlgorithmProvider {
    private final FipsRSA.WrapParameters wrapParameters;

    public FIPSRsaKeyEncryptionJWEAlgorithmProvider(FipsRSA.WrapParameters wrapParameters) {
        this.wrapParameters = wrapParameters;
    }

    public byte[] decodeCek(byte[] encodedCek, Key privateKey, JWEHeader header, JWEEncryptionProvider encryptionProvider) throws Exception {
        AsymmetricRSAPrivateKey rsaPrivateKey = new AsymmetricRSAPrivateKey((Algorithm)FipsRSA.ALGORITHM, privateKey.getEncoded());
        FipsRSA.KeyWrapOperatorFactory wrapFact = new FipsRSA.KeyWrapOperatorFactory();
        KeyUnwrapperUsingSecureRandom unwrapper = wrapFact.createKeyUnwrapper((AsymmetricRSAKey)rsaPrivateKey, this.wrapParameters).withSecureRandom(SecureRandom.getInstance("DEFAULT"));
        return unwrapper.unwrap(encodedCek, 0, encodedCek.length);
    }

    public byte[] encodeCek(JWEEncryptionProvider encryptionProvider, JWEKeyStorage keyStorage, Key publicKey, JWEHeader.JWEHeaderBuilder headerBuilder) throws Exception {
        AsymmetricRSAPublicKey rsaPubKey = new AsymmetricRSAPublicKey((Algorithm)FipsRSA.ALGORITHM, publicKey.getEncoded());
        byte[] inputKeyBytes = keyStorage.getCekBytes();
        FipsRSA.KeyWrapOperatorFactory wrapFact = new FipsRSA.KeyWrapOperatorFactory();
        KeyWrapperUsingSecureRandom wrapper = wrapFact.createKeyWrapper((AsymmetricRSAKey)rsaPubKey, this.wrapParameters).withSecureRandom(SecureRandom.getInstance("DEFAULT"));
        return wrapper.wrap(inputKeyBytes, 0, inputKeyBytes.length);
    }
}

