Exception handler overwriting was once a very popular technique to exploit stack buffer overflows, but isn't so common anymore in newer programs because most likely they're compiled with SafeSEH. At one point, even with SafeSEH enabled, it was still possible to abuse an exception handler by heap spraying, but of course, memory protections didn't stop there. DEP/FASLR eventually came to the rescue, so that pretty much ended the glory days of SEH exploits. You can probably still find vulnerable applications not compiled with SafeSEH, but chances are the app is outdated, no longer maintained, or it is more of a learning experiment for the developer. Oh, and there's probably an exploit for that already. Nonetheless, exploiting a stack buffer overflow with exception handling is still fun, so if you do come across it, here's how it's supposed to be written with Metasploit's ```Seh``` mixin.

### Requirements

To be able to use the SEH mixin, some exploitable requirements must be met:

* The vulnerable program does not have SafeSEH in place.
* No DEP (Data Execution Prevention). The mixin uses a short jump to be able to execute the payload, which means the memory must be executable. DEP, as the name implies, prevents that.

### Usage

First, make sure you include the ```Seh``` mixin under the scope of your module's ```Metasploit3``` class:

```ruby
include Msf::Exploit::Seh
```

Next, you need to set up a ```Ret``` address for the SE handler. This address should be placed in your module's metadata, specifically under ```Targets```. In Metasploit, each target is actually an array of two elements. The first element is just the name of the target (and there is currently no strict naming style), the second element is actually a hash that contains information specific to that target, such as the target address. Here's an example of setting up a ```Ret``` address:

```ruby
'Targets'        =>
  [
    [ 'Windows XP', {'Ret' => 0x75022ac4 } ] # p/p/r in ws2help.dll
  ]
```

As you can see, it's also a good habit to document what the ```Ret``` address does, and which DLL it points to.

```Ret``` is actually kind of a special key, because it can be retrieved by using ```target.ret``` in the module. In our next examples, you will see ```target.ret``` being used instead of coding the target address raw.

If you need a tool to find a POP/POP/RET for the ```Ret``` address, you can use Metasploit's ```msfbinscan``` utility, which is located under the tools directory.

OK now, let's move on to the methods. There are two methods provided by the ```Seh``` mixin:

* ```generate_seh_payload``` - Generates a fake SEH record with the payload attached right after. Here's an example:

```ruby
buffer = ''
buffer << "A" * 1024 # 1024 bytes of padding
buffer << generate_seh_payload(target.ret) # SE record overwritten after 1024 bytes
```

The actual layout of ```buffer``` should look like this in memory:

```
[ 1024 bytes of 'A' ][ A short jump ][ target.ret ][ Payload ]
```

* ```generate_seh_record``` - Generates a fake SEH record without the payload, in case you prefer to place the payload somewhere else. Code example:

```ruby
buffer = ''
buffer << "A" * 1024 # 1024 bytes of padding
buffer << generate_seh_payload(target.ret)
buffer << "B" * 1024 # More padding
```

The memory layout should like this:

```
[ 1024 bytes of 'A' ][ A short jump ][ target.ret ][ Padding ]
```

### References

- <https://www.corelan.be/index.php/2009/07/25/writing-buffer-overflow-exploits-a-quick-and-basic-tutorial-part-3-seh/>
- <https://github.com/rapid7/metasploit-framework/blob/master/lib/rex/exploitation/seh.rb>
- <https://github.com/rapid7/metasploit-framework/blob/master/lib/msf/core/exploit/seh.rb>
