/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.time.Instant;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class ResponseCacheConformance
implements HttpResponseInterceptor {
    public static final ResponseCacheConformance INSTANCE = new ResponseCacheConformance();
    private static final String[] DISALLOWED_ENTITY_HEADERS = new String[]{"Content-Encoding", "Content-Language", "Content-Length", "Content-MD5", "Content-Range", "Content-Type"};

    ResponseCacheConformance() {
    }

    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        if (response.getCode() == 304) {
            for (String headerName : DISALLOWED_ENTITY_HEADERS) {
                response.removeHeaders(headerName);
            }
        }
        if (!response.containsHeader("Date")) {
            response.addHeader((Header)new BasicHeader("Date", (Object)Instant.now()));
        }
    }
}

