/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.weakassociations;

import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import schemacrawler.ermodel.weakassociations.WeakAssociationsUtility;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;

final class IdMatcher
implements Predicate<ColumnReference> {
    private static final Logger LOGGER = Logger.getLogger(IdMatcher.class.getName());

    IdMatcher() {
    }

    @Override
    public boolean test(ColumnReference proposedWeakAssociation) {
        boolean matches;
        if (proposedWeakAssociation == null) {
            return false;
        }
        Column fkColumn = proposedWeakAssociation.getForeignKeyColumn();
        Column pkColumn = proposedWeakAssociation.getPrimaryKeyColumn();
        String pkColumnName = WeakAssociationsUtility.normalizeColumnName(pkColumn);
        String fkColumnName = WeakAssociationsUtility.normalizeColumnName(fkColumn);
        String fkBaseName = WeakAssociationsUtility.removeId(fkColumn);
        String pkBaseName = WeakAssociationsUtility.removeId(pkColumn);
        boolean fkIsPartOfPk = fkColumn.isPartOfPrimaryKey();
        Matcher pkMatcher1 = WeakAssociationsUtility.ID_PATTERN.matcher(pkColumnName);
        boolean pkColNameHasId = pkMatcher1.find();
        boolean pkColNameIsJustId = pkColNameHasId && pkMatcher1.start() == 0;
        boolean isPossiblySubentity = pkColNameHasId && fkColumnName.equalsIgnoreCase(pkColumnName) && fkIsPartOfPk;
        boolean bl = matches = pkColNameHasId && (fkBaseName.equals(pkBaseName) || pkColNameIsJustId) && !isPossiblySubentity;
        if (matches && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Weak association rule matched: IdMatcher for proposed association {0}", proposedWeakAssociation);
        }
        return matches;
    }
}

