/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.argument;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.argument.ReadIndexedArgumentNodeGen;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.profiles.ValueProfile;

public abstract class ReadIndexedArgumentNode
extends ReadArgumentNode {
    private final int index;
    private final ValueProfile profile = ValueProfile.createClassProfile();

    ReadIndexedArgumentNode(int index) {
        this.index = index;
    }

    public static ReadIndexedArgumentNode create(int idx) {
        return ReadIndexedArgumentNodeGen.create(idx);
    }

    @Specialization(rewriteOn={InvalidAssumptionException.class})
    Object readArg(VirtualFrame frame) throws InvalidAssumptionException {
        Object argumentAt = PArguments.getArgument((Frame)frame, this.index);
        if (argumentAt == null) {
            throw new InvalidAssumptionException();
        }
        return this.profile.profile(argumentAt);
    }

    @Specialization(replaces={"readArg"})
    Object readArgOffBounds(VirtualFrame frame) {
        Object argumentAt = PArguments.getArgument((Frame)frame, this.index);
        if (argumentAt == null) {
            return PNone.NO_VALUE;
        }
        return this.profile.profile(argumentAt);
    }

    public int getIndex() {
        return this.index;
    }
}

