/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hdfs.store;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.lucene.store.OutputStreamIndexOutput;

public class HdfsFileWriter
extends OutputStreamIndexOutput {
    public static final String HDFS_SYNC_BLOCK = "solr.hdfs.sync.block";
    public static final int BUFFER_SIZE = 16384;

    public HdfsFileWriter(FileSystem fileSystem, Path path, String name) throws IOException {
        super("fileSystem=" + String.valueOf(fileSystem) + " path=" + String.valueOf(path), name, HdfsFileWriter.getOutputStream(fileSystem, path), 16384);
    }

    private static final OutputStream getOutputStream(FileSystem fileSystem, Path path) throws IOException {
        Configuration conf = fileSystem.getConf();
        FsServerDefaults fsDefaults = fileSystem.getServerDefaults(path);
        short replication = fileSystem.getDefaultReplication(path);
        EnumSet<CreateFlag> flags = EnumSet.of(CreateFlag.CREATE);
        if (Boolean.getBoolean(HDFS_SYNC_BLOCK)) {
            flags.add(CreateFlag.SYNC_BLOCK);
        }
        return fileSystem.create(path, FsPermission.getDefault().applyUMask(FsPermission.getUMask((Configuration)conf)), flags, fsDefaults.getFileBufferSize(), replication, fsDefaults.getBlockSize(), null);
    }
}

