/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.tagext.TagInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.SmapInput;
import org.apache.jasper.compiler.SmapStratum;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.runtime.InstanceManagerFactory;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.util.FastRemovalDequeue;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.Jar;

public class JspServletWrapper {
    private static final Map<String, Long> ALWAYS_OUTDATED_DEPENDENCIES = new HashMap<String, Long>();
    private final Log log = LogFactory.getLog(JspServletWrapper.class);
    private volatile Servlet theServlet;
    private final String jspUri;
    private volatile Class<?> tagHandlerClass;
    private final JspCompilationContext ctxt;
    private long available = 0L;
    private final ServletConfig config;
    private final Options options;
    private volatile boolean mustCompile = true;
    private volatile boolean reload = true;
    private final boolean isTagFile;
    private int tripCount;
    private JasperException compileException;
    private volatile long servletClassLastModifiedTime;
    private long lastModificationTest = 0L;
    private long lastUsageTime = System.currentTimeMillis();
    private FastRemovalDequeue.Entry unloadHandle;
    private final boolean unloadAllowed;
    private final boolean unloadByCount;
    private final boolean unloadByIdle;

    public JspServletWrapper(ServletConfig servletConfig, Options options, String string, JspRuntimeContext jspRuntimeContext) {
        this.isTagFile = false;
        this.config = servletConfig;
        this.options = options;
        this.jspUri = string;
        this.unloadByCount = options.getMaxLoadedJsps() > 0;
        this.unloadByIdle = options.getJspIdleTimeout() > 0;
        this.unloadAllowed = this.unloadByCount || this.unloadByIdle;
        this.ctxt = new JspCompilationContext(string, options, servletConfig.getServletContext(), this, jspRuntimeContext);
    }

    public JspServletWrapper(ServletContext servletContext, Options options, String string, TagInfo tagInfo, JspRuntimeContext jspRuntimeContext, Jar jar) {
        this.isTagFile = true;
        this.config = null;
        this.options = options;
        this.jspUri = string;
        this.tripCount = 0;
        this.unloadByCount = options.getMaxLoadedJsps() > 0;
        this.unloadByIdle = options.getJspIdleTimeout() > 0;
        this.unloadAllowed = this.unloadByCount || this.unloadByIdle;
        this.ctxt = new JspCompilationContext(this.jspUri, tagInfo, options, servletContext, this, jspRuntimeContext, jar);
    }

    public JspCompilationContext getJspEngineContext() {
        return this.ctxt;
    }

    public void setReload(boolean bl) {
        this.reload = bl;
    }

    public boolean getReload() {
        return this.reload;
    }

    private boolean getReloadInternal() {
        return this.reload && !this.ctxt.getRuntimeContext().isCompileCheckInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getServlet() throws ServletException {
        if (this.getReloadInternal() || this.theServlet == null) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.getReloadInternal() || this.theServlet == null) {
                    Servlet servlet;
                    this.destroy();
                    try {
                        InstanceManager instanceManager = InstanceManagerFactory.getInstanceManager(this.config);
                        servlet = (Servlet)instanceManager.newInstance(this.ctxt.getFQCN(), this.ctxt.getJspLoader());
                    }
                    catch (Exception exception) {
                        Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(exception);
                        ExceptionUtils.handleThrowable(throwable);
                        throw new JasperException(throwable);
                    }
                    servlet.init(this.config);
                    if (this.theServlet != null) {
                        this.ctxt.getRuntimeContext().incrementJspReloadCount();
                    }
                    this.theServlet = servlet;
                    this.reload = false;
                }
            }
        }
        return this.theServlet;
    }

    public ServletContext getServletContext() {
        return this.ctxt.getServletContext();
    }

    public void setCompilationException(JasperException jasperException) {
        this.compileException = jasperException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServletClassLastModifiedTime(long l) {
        if (this.servletClassLastModifiedTime < l) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.servletClassLastModifiedTime < l) {
                    this.servletClassLastModifiedTime = l;
                    this.reload = true;
                    this.ctxt.clearJspLoader();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadTagFile() throws JasperException {
        block14: {
            try {
                JspServletWrapper jspServletWrapper;
                if (this.ctxt.isRemoved()) {
                    throw new FileNotFoundException(this.jspUri);
                }
                if (this.options.getDevelopment() || this.mustCompile) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        if (this.options.getDevelopment() || this.mustCompile) {
                            this.ctxt.compile();
                            this.mustCompile = false;
                        }
                    }
                } else if (this.compileException != null) {
                    throw this.compileException;
                }
                if (!this.getReloadInternal() && this.tagHandlerClass != null) break block14;
                jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    if (this.getReloadInternal() || this.tagHandlerClass == null) {
                        this.tagHandlerClass = this.ctxt.load();
                        this.reload = false;
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JasperException(fileNotFoundException);
            }
        }
        return this.tagHandlerClass;
    }

    public Class<?> loadTagFilePrototype() throws JasperException {
        this.ctxt.setPrototypeMode(true);
        try {
            Class<?> clazz = this.loadTagFile();
            return clazz;
        }
        finally {
            this.ctxt.setPrototypeMode(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getDependants() {
        try {
            Object object;
            if (this.isTagFile) {
                if (this.reload) {
                    JspServletWrapper jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        if (this.reload) {
                            this.tagHandlerClass = this.ctxt.load();
                            this.reload = false;
                        }
                    }
                }
                object = this.tagHandlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                object = this.getServlet();
            }
            if (object instanceof JspSourceDependent) {
                return ((JspSourceDependent)object).getDependants();
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            return ALWAYS_OUTDATED_DEPENDENCIES;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
        }
        return null;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public int incTripCount() {
        return this.tripCount++;
    }

    public int decTripCount() {
        return this.tripCount--;
    }

    public String getJspUri() {
        return this.jspUri;
    }

    public FastRemovalDequeue.Entry getUnloadHandle() {
        return this.unloadHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws ServletException, IOException, FileNotFoundException {
        block41: {
            Servlet servlet;
            JspServletWrapper jspServletWrapper;
            try {
                if (this.ctxt.isRemoved()) {
                    throw new FileNotFoundException(this.jspUri);
                }
                if (this.available > 0L && this.available < Long.MAX_VALUE) {
                    if (this.available > System.currentTimeMillis()) {
                        httpServletResponse.setDateHeader("Retry-After", this.available);
                        httpServletResponse.sendError(503, Localizer.getMessage("jsp.error.unavailable"));
                        return;
                    }
                    this.available = 0L;
                }
                if (this.options.getDevelopment() || this.mustCompile) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        if (this.options.getDevelopment() || this.mustCompile) {
                            this.ctxt.compile();
                            this.mustCompile = false;
                        }
                    }
                } else if (this.compileException != null) {
                    throw this.compileException;
                }
                servlet = this.getServlet();
                if (bl) {
                    return;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException | IllegalStateException | ServletException throwable) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException((Exception)throwable);
                }
                throw throwable;
            }
            catch (Exception exception) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(exception);
                }
                throw new JasperException(exception);
            }
            try {
                if (this.unloadAllowed) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        if (this.unloadByCount) {
                            if (this.unloadHandle == null) {
                                this.unloadHandle = this.ctxt.getRuntimeContext().push(this);
                            } else if (this.lastUsageTime < this.ctxt.getRuntimeContext().getLastJspQueueUpdate()) {
                                this.ctxt.getRuntimeContext().makeYoungest(this.unloadHandle);
                                this.lastUsageTime = System.currentTimeMillis();
                            }
                        } else if (this.lastUsageTime < this.ctxt.getRuntimeContext().getLastJspQueueUpdate()) {
                            this.lastUsageTime = System.currentTimeMillis();
                        }
                    }
                }
                if (servlet instanceof SingleThreadModel) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        servlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                        break block41;
                    }
                }
                servlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (UnavailableException unavailableException) {
                String string = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
                if (string != null) {
                    throw unavailableException;
                }
                int n = unavailableException.getUnavailableSeconds();
                if (n <= 0) {
                    n = 60;
                }
                this.available = System.currentTimeMillis() + (long)n * 1000L;
                httpServletResponse.sendError(503, unavailableException.getMessage());
            }
            catch (IllegalStateException | ServletException throwable) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException((Exception)throwable);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                if (this.options.getDevelopment()) {
                    throw new IOException(this.handleJspException(iOException).getMessage(), iOException);
                }
                throw iOException;
            }
            catch (Exception exception) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(exception);
                }
                throw new JasperException(exception);
            }
        }
    }

    public void destroy() {
        if (this.theServlet != null) {
            try {
                this.theServlet.destroy();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                this.log.error((Object)Localizer.getMessage("jsp.error.servlet.destroy.failed"), throwable);
            }
            InstanceManager instanceManager = InstanceManagerFactory.getInstanceManager(this.config);
            try {
                instanceManager.destroyInstance((Object)this.theServlet);
            }
            catch (Exception exception) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(exception);
                ExceptionUtils.handleThrowable(throwable);
                this.log.error((Object)Localizer.getMessage("jsp.error.file.not.found", exception.getMessage()), throwable);
            }
        }
    }

    public long getLastModificationTest() {
        return this.lastModificationTest;
    }

    public void setLastModificationTest(long l) {
        this.lastModificationTest = l;
    }

    public long getLastUsageTime() {
        return this.lastUsageTime;
    }

    /*
     * WARNING - void declaration
     */
    protected JasperException handleJspException(Exception exception) {
        try {
            void var6_10;
            Throwable throwable = exception;
            if (exception instanceof ServletException) {
                throwable = ((ServletException)((Object)exception)).getRootCause();
            }
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            StackTraceElement stackTraceElement = null;
            String string = this.ctxt.getBasePackageName();
            for (StackTraceElement stackTraceElement2 : stackTraceElementArray) {
                if (!stackTraceElement2.getClassName().startsWith(string)) continue;
                stackTraceElement = stackTraceElement2;
                break;
            }
            Object var6_8 = null;
            if (stackTraceElement != null) {
                SmapStratum smapStratum = this.ctxt.getCompiler().getSmap(stackTraceElement.getClassName());
            }
            if (var6_10 == null) {
                return new JasperException(exception);
            }
            int n = stackTraceElement.getLineNumber();
            SmapInput smapInput = var6_10.getInputLineNumber(n);
            if (smapInput.getLineNumber() < 1) {
                throw new JasperException(exception);
            }
            JavacErrorDetail javacErrorDetail = new JavacErrorDetail(stackTraceElement.getMethodName(), n, smapInput.getFileName(), smapInput.getLineNumber(), null, this.ctxt);
            if (this.options.getDisplaySourceFragment()) {
                return new JasperException(Localizer.getMessage("jsp.exception", javacErrorDetail.getJspFileName(), "" + smapInput.getLineNumber()) + System.lineSeparator() + System.lineSeparator() + javacErrorDetail.getJspExtract() + System.lineSeparator() + System.lineSeparator() + "Stacktrace:", exception);
            }
            return new JasperException(Localizer.getMessage("jsp.exception", javacErrorDetail.getJspFileName(), "" + smapInput.getLineNumber()), exception);
        }
        catch (Exception exception2) {
            if (exception instanceof JasperException) {
                return (JasperException)((Object)exception);
            }
            return new JasperException(exception);
        }
    }

    static {
        ALWAYS_OUTDATED_DEPENDENCIES.put("/WEB-INF/web.xml", -1L);
    }
}

