{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetText: String;
    procedure SetText(const Value: String);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdString: TSFString;
    { Internal wrapper for property @link(Text). This wrapper API may change, we advise to access simpler @link(Text) instead. }
    public property FdString: TSFString read FFdString;
    {  }
    property Text: String read GetText write SetText;

{$endif read_interface}

{$ifdef read_implementation}

{ TInfoNode_1 ----------------------------------------------- }

function TInfoNode_1.GetText: String;
begin
  Result := FdString.Value;
end;

procedure TInfoNode_1.SetText(const Value: String);
begin
  FdString.Send(Value);
end;

class function TInfoNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TInfoNode_1.ClassX3DType: String;
begin
  Result := 'Info';
end;

procedure TInfoNode_1.CreateNode;
begin
  inherited;

  FFdString := TSFString.Create(Self, True, 'string', '<Undefined info>');
   FdString.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdString);
end;

{$endif read_implementation}
