#pragma once
#include <string>
#include <atomic>
#include <unistd.h>
#include <string.h>
#include "Erroring.h"
#include "utils.h"
#include "PipeIPC.h"

enum IPCCommand
{
	IPC_ERROR = 0,
	IPC_UNSUPPORTED,
	IPC_STOP,
	IPC_RESERVED = 10,
	IPC_GET_MODE,
	IPC_GET_MODES,
	IPC_GET_SIZE,
	IPC_GET_INFORMATION,
	IPC_FILE_DELETE,
	IPC_DIRECTORY_DELETE,
	IPC_RENAME,
	IPC_SET_TIMES,
	IPC_SET_MODE,
	IPC_SYMLINK_CREATE,
	IPC_SYMLINK_QUERY,
	IPC_DIRECTORY_CREATE,
	IPC_DIRECTORY_ENUM,
	IPC_FILE_GET,
	IPC_FILE_PUT,
	IPC_EXECUTE_COMMAND,
};

typedef PipeIPCEndpoint<IPCCommand> IPCEndpoint;

enum IPCProtocolInitStatus
{
	IPC_PI_OK = 0,
	IPC_PI_SERVER_IDENTITY_CHANGED,
	IPC_PI_AUTHORIZATION_FAILED,
	IPC_PI_PROTOCOL_ERROR,
	IPC_PI_GENERIC_ERROR
};

#define IPC_VERSION_MAGIC  0xbabe0001
