//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// VulnerabilityAssessmentBaselinesServer is a fake server for instances of the armsql.VulnerabilityAssessmentBaselinesClient type.
type VulnerabilityAssessmentBaselinesServer struct {
	// CreateOrUpdate is the fake for method VulnerabilityAssessmentBaselinesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, baselineName armsql.BaselineName, parameters armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput, options *armsql.VulnerabilityAssessmentBaselinesClientCreateOrUpdateOptions) (resp azfake.Responder[armsql.VulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)
}

// NewVulnerabilityAssessmentBaselinesServerTransport creates a new instance of VulnerabilityAssessmentBaselinesServerTransport with the provided implementation.
// The returned VulnerabilityAssessmentBaselinesServerTransport instance is connected to an instance of armsql.VulnerabilityAssessmentBaselinesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVulnerabilityAssessmentBaselinesServerTransport(srv *VulnerabilityAssessmentBaselinesServer) *VulnerabilityAssessmentBaselinesServerTransport {
	return &VulnerabilityAssessmentBaselinesServerTransport{srv: srv}
}

// VulnerabilityAssessmentBaselinesServerTransport connects instances of armsql.VulnerabilityAssessmentBaselinesClient to instances of VulnerabilityAssessmentBaselinesServer.
// Don't use this type directly, use NewVulnerabilityAssessmentBaselinesServerTransport instead.
type VulnerabilityAssessmentBaselinesServerTransport struct {
	srv *VulnerabilityAssessmentBaselinesServer
}

// Do implements the policy.Transporter interface for VulnerabilityAssessmentBaselinesServerTransport.
func (v *VulnerabilityAssessmentBaselinesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VulnerabilityAssessmentBaselinesClient.CreateOrUpdate":
		resp, err = v.dispatchCreateOrUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VulnerabilityAssessmentBaselinesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsql.BaselineName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.BaselineName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, baselineNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseSQLVulnerabilityAssessmentBaselineSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
