/*
 *		Copyright (C) 2013-2015, 2019 by the Konclude Developer Team.
 *
 *		This file is part of the reasoning system Konclude.
 *		For details and support, see <http://konclude.com/>.
 *
 *		Konclude is free software: you can redistribute it and/or modify
 *		it under the terms of version 3 of the GNU Lesser General Public
 *		License (LGPLv3) as published by the Free Software Foundation.
 *
 *		Konclude is distributed in the hope that it will be useful,
 *		but WITHOUT ANY WARRANTY; without even the implied warranty of
 *		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *		GNU (Lesser) General Public License for more details.
 *
 *		You should have received a copy of the GNU (Lesser) General Public
 *		License along with Konclude. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef KONCLUDE_REASONER_REALIZER_CONTOLOGYREALIZINGDYNAMICREQUIRMENTPROCESSINGSTATISTICS_H
#define KONCLUDE_REASONER_REALIZER_CONTOLOGYREALIZINGDYNAMICREQUIRMENTPROCESSINGSTATISTICS_H

// Libraries includes


// Namespace includes
#include "RealizerSettings.h"

// Other includes
#include "Utilities/UtilitiesSettings.h"


// Logger includes
#include "Logger/CLogger.h"


namespace Konclude {

	using namespace Utilities;

	namespace Reasoner {

		namespace Realizer {


			/*! 
			 *
			 *		\class		COntologyRealizingDynamicRequirmentProcessingStatistics
			 *		\author		Andreas Steigmiller
			 *		\version	0.1
			 *		\brief		TODO
			 *
			 */
			class COntologyRealizingDynamicRequirmentProcessingStatistics {
				// public methods
				public:
					//! Constructor
					COntologyRealizingDynamicRequirmentProcessingStatistics();

					COntologyRealizingDynamicRequirmentProcessingStatistics* incIteratorRoleInstancesInitializationCount(cint64 incCount = 1);
					cint64 getIteratorRoleInstancesInitializationCount();

					COntologyRealizingDynamicRequirmentProcessingStatistics* incIteratorRoleInstancesRealizationCount(cint64 incCount = 1);
					cint64 getIteratorRoleInstancesRealizationCount();

					COntologyRealizingDynamicRequirmentProcessingStatistics* incIteratorConceptInstancesRealizationCount(cint64 incCount = 1);
					cint64 getIteratorConceptInstancesRealizationCount();

					COntologyRealizingDynamicRequirmentProcessingStatistics* incIteratorPreparationStartingCount(cint64 incCount = 1);
					cint64 getIteratorPreparationStartingCount();

					COntologyRealizingDynamicRequirmentProcessingStatistics* incIteratorPreparationFinsihingCount(cint64 incCount = 1);
					cint64 getIteratorPreparationFinsihingCount();

					COntologyRealizingDynamicRequirmentProcessingStatistics* incmIteratorScheduledIndividualRealizationCount(cint64 incCount = 1);
					cint64 getmIteratorScheduledIndividualRealizationCount();


				// protected methods
				protected:

				// protected variables
				protected:
					cint64 mIteratorRoleInstancesInitializationCount;
					cint64 mIteratorRoleInstancesRealizationCount;
					cint64 mIteratorConceptInstancesRealizationCount;
					cint64 mIteratorPreparationStartingCount;
					cint64 mIteratorPreparationFinsihingCount;
					cint64 mIteratorScheduledIndividualRealizationCount;

				// private methods
				private:

				// private variables
				private:

			};

		}; // end namespace Realizer

	}; // end namespace Reasoner

}; // end namespace Konclude

#endif // KONCLUDE_REASONER_REALIZER_CONTOLOGYREALIZINGDYNAMICREQUIRMENTPROCESSINGSTATISTICS_H
