// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2009 Konrad Twardowski

#pragma once

#include "../kshutdown.h"

class LockAction final: public Action {
public:
	virtual void initContainerWidget() override { }
	virtual bool onAction() override;
	#ifdef QT_DBUS_LIB
	static QDBusInterface *getQDBusInterface();
	#endif // QT_DBUS_LIB
	static LockAction *self() {
		if (!m_instance)
			m_instance = new LockAction();

		return m_instance;
	}
private:
	Q_DISABLE_COPY(LockAction)
	inline static LockAction *m_instance = nullptr;
	#ifdef QT_DBUS_LIB
	inline static QDBusInterface *m_qdbusInterface = nullptr;
	#endif // QT_DBUS_LIB
	explicit LockAction();
};
