/* $Id: Affil.cpp 272611 2011-04-08 18:57:08Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'biblio.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/biblio/Affil.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CAffil::~CAffil(void)
{
}


// Corresponds to the C Toolkit's internal MakeAffilStr
bool CAffil::GetLabelV1(string* label, TLabelFlags) const
{
    switch (Which()) {
    case e_not_set:
        return false;

    case e_Str:
        *label += GetStr();
        return HasText(GetStr());

    case e_Std:
    {
        string sep;
#define ADD_AFFIL_FIELD(X) \
        if (GetStd().CanGet##X()  &&  HasText(GetStd().Get##X())) { \
            *label += sep + GetStd().Get##X(); \
            sep = ", "; \
        }
        ADD_AFFIL_FIELD(Affil)
        ADD_AFFIL_FIELD(Div)
        ADD_AFFIL_FIELD(Street)
        ADD_AFFIL_FIELD(City)
        ADD_AFFIL_FIELD(Sub)
        ADD_AFFIL_FIELD(Country)
#undef ADD_AFFIL_FIELD
        return !sep.empty();
    }
    }
    return false;
}


// Corresponds to the C Toolkit's exported GetFlatFileAffilString (aka GetAffil)
bool CAffil::GetLabelV2(string* label, TLabelFlags) const
{
    switch (Which()) {
    case e_not_set:
        return false;

    case e_Str:
        *label += NStr::Replace(GetStr(), "\"", "'");
        return HasText(GetStr());

    case e_Std:
    {
        string sep;
#define ADD_AFFIL_FIELD(X) \
        if (GetStd().CanGet##X()  &&  HasText(GetStd().Get##X())) { \
            *label += sep + NStr::Replace(GetStd().Get##X(), "\"", "'"); \
            sep = ", "; \
        }
        ADD_AFFIL_FIELD(Div)
        ADD_AFFIL_FIELD(Affil)
        ADD_AFFIL_FIELD(Street)
        ADD_AFFIL_FIELD(City)
        ADD_AFFIL_FIELD(Sub)
        if (GetStd().CanGetPostal_code()
            &&  HasText(GetStd().GetPostal_code())) {
            *label += ' ' + NStr::Replace(GetStd().GetPostal_code(), "\"", "'");
        }
        ADD_AFFIL_FIELD(Country)
#undef ADD_AFFIL_FIELD
        return !sep.empty()  ||  GetStd().CanGetPostal_code();
    }
    }    
    return false;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 65, chars: 1877, CRC32: e9efa3dc */
