// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TecplotPluginInfo.C
// ****************************************************************************

#include <TecplotPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Tecplot,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Tecplot,General)

// ****************************************************************************
//  Method: TecplotGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TecplotGeneralPluginInfo::GetName() const
{
    return "Tecplot";
}

// ****************************************************************************
//  Method: TecplotGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TecplotGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: TecplotGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TecplotGeneralPluginInfo::GetID() const
{
    return "Tecplot_1.0";
}
// ****************************************************************************
//  Method: TecplotGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
TecplotGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: TecplotGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
TecplotGeneralPluginInfo::HasWriter() const
{
    return true;
}
// ****************************************************************************
//  Method:  TecplotGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Tecplot database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
TecplotGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.tp");
    defaultPatterns.push_back("*.plt");
    defaultPatterns.push_back("*.tec");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  TecplotGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Tecplot database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
TecplotGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  TecplotGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Tecplot plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
TecplotGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
