/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.blr;

import weka.classifiers.bayes.BayesianLogisticRegression;
import weka.classifiers.bayes.blr.Prior;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class GaussianPriorImpl
extends Prior {
    private static final long serialVersionUID = -2995684220141159223L;

    public double update(int j, Instances instances, double beta, double hyperparameter, double[] r, double deltaV) {
        double numerator = 0.0;
        double denominator = 0.0;
        double value = 0.0;
        this.m_Instances = instances;
        this.Beta = beta;
        this.Hyperparameter = hyperparameter;
        this.Delta = deltaV;
        this.R = r;
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            Instance instance = this.m_Instances.instance(i);
            if (instance.value(j) == 0.0) continue;
            numerator += instance.value(j) * BayesianLogisticRegression.classSgn(instance.classValue()) * (0.0 - 1.0 / (1.0 + Math.exp(this.R[i])));
            denominator += instance.value(j) * instance.value(j) * BayesianLogisticRegression.bigF(this.R[i], this.Delta * Math.abs(instance.value(j)));
        }
        value = (numerator += 2.0 * this.Beta / this.Hyperparameter) / (denominator += 2.0 / this.Hyperparameter);
        return 0.0 - value;
    }

    public void computeLoglikelihood(double[] betas, Instances instances) {
        super.computelogLikelihood(betas, instances);
    }

    public void computePenalty(double[] betas, double[] hyperparameters) {
        this.penalty = 0.0;
        for (int j = 0; j < betas.length; ++j) {
            this.penalty += Math.log(Math.sqrt(hyperparameters[j])) + Math.log(Math.PI * 2) / 2.0 + betas[j] * betas[j] / (2.0 * hyperparameters[j]);
        }
        this.penalty = 0.0 - this.penalty;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

