% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiR.R
\name{tidy.epi.2by2}
\alias{tidy.epi.2by2}
\alias{epiR_tidiers}
\title{Tidy a(n) epi.2by2 object}
\usage{
\method{tidy}{epi.2by2}(x, parameters = c("moa", "stat"), ...)
}
\arguments{
\item{x}{A \code{epi.2by2} object produced by a call to \code{\link[epiR:epi.2by2]{epiR::epi.2by2()}}}

\item{parameters}{Return measures of association (\code{moa}) or test statistics (\code{stat}),
default is \code{moa} (measures of association)}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
The tibble has a column for each of the measures of association
or tests contained in \code{massoc} or \code{massoc.detail} when \code{\link[epiR:epi.2by2]{epiR::epi.2by2()}} is called.
}
\examples{
\dontshow{if (rlang::is_installed("epiR")) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(epiR)

# generate data
dat <- matrix(c(13, 2163, 5, 3349), nrow = 2, byrow = TRUE)

rownames(dat) <- c("DF+", "DF-")
colnames(dat) <- c("FUS+", "FUS-")

# fit model
fit <- epi.2by2(
  dat = as.table(dat), method = "cross.sectional",
  conf.level = 0.95, units = 100, outcome = "as.columns"
)

# summarize model fit with tidiers
tidy(fit, parameters = "moa")
tidy(fit, parameters = "stat")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[epiR:epi.2by2]{epiR::epi.2by2()}}
}
\concept{epiR tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{df}{Degrees of freedom used by this term in the model.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{term}{The name of the regression term.}
  \item{estimate}{Estimated measure of association}

}
