% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_CI.R
\name{add_edge_length}
\alias{add_edge_length}
\title{Assign and compute edge lengths from a sample of trees}
\usage{
add_edge_length(tree, trees, fun = function(x) median(na.omit(x)),
  rooted = TRUE)
}
\arguments{
\item{tree}{tree where edge lengths are assigned to.}

\item{trees}{an object of class multiPhylo, where the average for the edges
is computed from.}

\item{fun}{a function to compute the average (default is median).}

\item{rooted}{rooted logical, if FALSE edge lengths is a function of the
observed splits, if TRUE edge lengths are estimated from height for the
observed clades.}
}
\description{
This command can infer some average edge lengths and assign
them from a (bootstrap/MCMC) sample.
}
\examples{
data("Laurasiatherian")
set.seed(123)
bs <- bootstrap.phyDat(Laurasiatherian,
                FUN=function(x)upgma(dist.ml(x)), bs=100)
tree_compat <- allCompat(bs, rooted=TRUE) |>
              add_edge_length(bs)
plot(tree_compat)
add_boxplot(tree_compat, bs)
}
\seealso{
\code{\link{node.depth.edgelength}}, \code{\link{consensus}},
\code{\link{maxCladeCred}}
}
\author{
Klaus Schliep
}
\keyword{aplot}
