% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projpred-package.R
\name{internal-global-options}
\alias{internal-global-options}
\title{Internal global options}
\description{
The following global options are for internal use:
\itemize{
\item \code{projpred.mssg_ndraws}, \code{projpred.mssg_cut_search}, \code{projpred.mssg_time},
\code{projpred.warn_wobs_ppd}, \code{projpred.warn_additive_experimental},
\code{projpred.warn_allrandom_dis}, \code{projpred.warn_instable_projections},
\code{projpred.warn_cvrefbuilder_NULL}, \code{projpred.warn_kfold_refits}: A single
logical value indicating whether to throw certain messages or warnings
(depending on the midfix \code{mssg} or \code{warn}, respectively). For the exact
meaning of these global options, see their occurrences in the codebase. With
the exception of \code{projpred.warn_allrandom_dis}, these global options are
currently used in the unit tests to deactivate these messages and warnings.
Global option \code{projpred.warn_instable_projections} is also used (invisibly)
in the latent vignette to suppress the corresponding warnings while
illustrating the underlying issue (instable projections).
\item \code{projpred.additional_checks}: A single logical value indicating whether to
run some additional checks that are not necessary to be run when users call
the corresponding \pkg{projpred} functions. Currently, these checks are
activated during the unit tests.
\item \code{projpred.glm_fitter}: A character string naming the function to be used as
the submodel fitter for non-multilevel, non-additive projections. Currently,
this is an experimental feature and allowed values are
\code{"fit_glm_ridge_callback"} (the default) and \code{"fit_glm_callback"}.
\item \code{projpred.gaussian_not_as_generalized}: A single logical value indicating
whether to treat the \code{\link[=gaussian]{gaussian()}} family not as a family for a \emph{generalized
linear} model (i.e., for which \code{\link[=glm]{glm()}} would typically be used as a model
fitting function outside of \pkg{projpred}), but as the family for an
explicit \emph{linear} model (i.e., for which \code{\link[=lm]{lm()}} would typically be used as a
model fitting function outside of \pkg{projpred}). This also holds for models
with multilevel terms (because \pkg{lme4} offers both \code{\link[lme4:glmer]{lme4::glmer()}} and
\code{\link[lme4:lmer]{lme4::lmer()}}). Currently, this is an experimental feature.
\item \code{projpred.PQL}: A single logical value indicating whether to use
\code{\link[MASS:glmmPQL]{MASS::glmmPQL()}} as the submodel fitter for multilevel (non-additive)
projections (see GitHub issue
\href{https://github.com/stan-dev/projpred/issues/207}{#207} and GitHub pull
request \href{https://github.com/stan-dev/projpred/pull/353}{#353}). Currently,
this is an experimental feature.
}
}
\keyword{internal}
