% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{client_save}
\alias{client_save}
\alias{client_list}
\title{Save an authentication mechanism for use in a future session}
\usage{
client_save(client)

client_list()
}
\arguments{
\item{client}{A client \code{\link[=rtweet_client]{rtweet_client()}}.}
}
\value{
Invisible the path where the client is saved.
}
\description{
Use \code{client_save()} with \code{\link[=client_as]{client_as()}} to avoid repeatedly entering app
credentials, making it easier to share auth between projects.
Use \code{client_list()} to list all saved credentials.
}
\details{
The tokens are saved on the clients folder in \code{tools::R_user_dir("rtweet", "config")}.
}
\examples{
\dontrun{
# save app client for use in other sessions
client <- rtweet_client()
client_save(client)

# later, in a different session...
client_as("my-app")
# Show all authentications stored
client_list()
}
}
\seealso{
\code{\link[=auth_sitrep]{auth_sitrep()}} to help finding and managing authentications.

Other client: 
\code{\link{client_as}()},
\code{\link{client_get}()},
\code{\link{client_has_default}()}
}
\concept{client}
