# Announce: Rakudo compiler, Release #142 (2020.12)

On behalf of the Rakudo development team, I’m very happy to announce the
December 2020 release of Rakudo #142. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.12:

  + Removals:
    + Deprecated method candidates (`subbuf(Any:U)` on `Buf`, `chdir(Str(), :$!test)` on `IO::Path`)
     and `indir(IO() $path, &what, :$test!)` subroutine candidate that were
     throwing an exception instead of a deprecation warning for a long time
     were removed from CORE [9040318c]
  + Additions:
    + Add new method `deterministic` to `Iterator` role [87fc041f][b83b1b34][b63c0e02][c37a88e8][96285afb]
    + Introduce `%*SUB-MAIN-OPTS<coerce-allomorphs-to>` setting [bd5eba4b][49eecd68]
    + Add a new candidate to `spurt` routine and method.
     It does not have an argument taking content to write,
     making it similar to the `touch` utility [f2ea0a65]
    + Add `:emit-timed` to `Supply.batch` method [492651ea]
    + Make `is DEPRECATED` trait introspectable on `Routine` instances [0d1c8a8e]
  + Changes:
    + Improve output of `Attribute` documentation when rendered with `Pod::To::Text` [a0a8a515]
    + Increase sensitivity of `Supply.batch(:seconds)` x 1000 [aecfc9b3]
    + The `cas` subroutine now accepts `Mu` as both its target and values [998cae57]
    + Defined `List` instances no longer return `True` when calling `ACCEPT`
      with an undefined `List` (i.e. `List ~~ ()` returns False now) [9fd79f9e]
    + Mark the base native `array` class as `Positional` [d1d2546e]
  + Efficiency:
    + Implement metamodel transparency of nominalizables and fix handling of
      definite parameters, gaining back some performance loss introduced with
      the new coercion protocol in previous release
      [d37906d0][ed16d6c1][b5465b17][e4816198]
    + Fix a shaped array performance problem [f27e212b]
    + Make execution of some kinds of `when` faster [c080e594][0006475a][b3a25580]
    + Make `cas` subroutine ~10% faster [484f870c]
    + Make `@a[*-1]` candidates about 60% faster [2d5d3bf4]
    + Optimize some array operators [4ac0f737]
    + Make array access `[$i]` with `$i` being a native int about 2x as fast [7c0956b8]
    + Improve the performance of signature binding [b1f59a2f]
    + Speed up various aspects of native 1-dim shaped arrays and
      native arrays in general
      [42fceb08][2c5b5457][3def3ced][705e6e62][a76e2b6e][60fa48ec]
      [6792cc42][bd944e7c][2274aa85][392d8be2][1c43c46e]
  + Fixes:
    + Fix number of issues with REPL execution. e.g. it "forgetting" previous
      multi sub declarations, calling `WHAT` on native type
      [7c0a81f5][eae309a4][e46a1da2][f2851b90][e8ab5272][0d6278f3]
      [6f7718ce][be455078]
    + Fix roles not being auto-punned for `postcifcumfix:<( )>`, by
      implementing an invocation protocol for roles [79d2aeab]
      [5a22a7c5][77a7bd27][17223fc4][4009f401][538ad1b7][9f98595c]
    + Fix concurrency issue in compilations with heredocs [147bae3b]
    + Fix subsets of coercions [af43ef62]
    + Fix an issue with `splitdir` method of `IO::Spec::Unix`
      leading to action at a distance bugs [3d463419][f154244c]
    + Fix argument of a coercion type not having a workable default value
      [44cc88b5][856dfb2d]
    + Fix error reporting for slurpy named parameters with type constraints [e1f09cfa]
    + Fix behavior of postcircumfix `[ ]` called with Iterable on
      native array [4304e250]
    + Disallow calling  of postcircumfix `[ ]` with type objects [6c7044ec]
    + Fix a bug in set symmetric difference logic [7b6de5c5]
    + Make `Num` coercer demand definite invocant [a75b3fa8]
    + Add missing handling of adverbs `:kv`, `:p`, `:k`, `:v` for
      1-dim shaped native arrays, also support many adverbs at once
      (e.g. `:exists:(kv|p)` [0f4970da][02e48d81]
    + Give stub packages created by package_at_key a proper longname [aab4f55a]
    + Fix `raku` method called on `CompUnit::Repository::Distribution` instance [7d0813c3]
    + Fix proper reporting of the `X::Parameter::RW` exception message [17320542]
    + Fix `RAKUDO_MODULE_DEBUG` output when the message contains meta characters [b58510ff]
    + The `Test` module now correctly handles `RAKU_TEST_TIMES` environment variable,
      previously called `PERL6_TEST_TIMES` [d84ed4e9]
  + Internal:
    + Remove deprecated functionality to core epilogue [7406f8c6]
    + Introduce `Rakudo::Iterator.TailWith` [f6c7ddb2][9dbb52f9]
    + Add `sink-all` method to a number of PredictiveIterators [cf0f2f2e]
    + Make `Iterator.sink-all` default to using `skip-one` [f0ebdd09]
    + Add `raku` method to `Rakudo::Internals::IterationSet` for easier debugging [0d301fab]
    + Remove all easily removable `nqp::stmts` from Rakudo code [f2f2cf82]
    + Another round of nqp::if -> ternaries [aba90b01]
    + Fix unwanted references to other compilations by CompilerServices [d0de7664]
    + Type IO::Socket::INET family/type/protocol values [534cc543]
    + Add missing debug type names for easier debugging [a68b8ab4]
    + Move "is test-assertion" to candidates [15ec4fe6]
    + Adapt filenames in binary release scripts [3748884d]
    + Various cleanup and micro-optimization changes [1801a5aa]
      [eabdee48][45246aef][6852f40d][dce6804c][c663cc33][1712f03b]
      [b525c4df][6ee47f03][912381b7][2ce5260e][80f92836][161325e0]
      [65f24a8d][c02c9cdb][46e9468f][82d31e0d][137d49b0][53ad24af]
      [1331ffdd][c4c4ba98]


The following people contributed to this release:

Elizabeth Mattijsen, Nicholas Clark, Stoned Elipot, Vadim Belman,
Stefan Seifert, Jonathan Worthington, Will "Coke" Coleda,
Christian Bartolomäus, Peter du Marchie van Voorthuysen, Alexander Kiryuhin,
Daniel Green, Moray Jones, Daniel Mita, Dominique Dumont, Patrick Böker,
Stéphane Payrard, Jan Krňávek, JustThisGuyAZ, Leon Timmermans, Tim Gates,
Tom Browder, stoned

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2021 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#143), is tentatively scheduled for 2021-01-23.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
