//! Autogenerated: 'src/ExtractionOCaml/unsaturated_solinas' --lang Rust --inline p521 32 '(auto)' '2^521 - 1' carry_mul carry_square carry add sub opp selectznz to_bytes from_bytes relax
//! curve description: p521
//! machine_wordsize = 32 (from "32")
//! requested operations: carry_mul, carry_square, carry, add, sub, opp, selectznz, to_bytes, from_bytes, relax
//! n = 19 (from "(auto)")
//! s-c = 2^521 - [(1, 1)] (from "2^521 - 1")
//! tight_bounds_multiplier = 1 (from "")
//!
//! Computed values:
//!   carry_chain = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1]
//!   eval z = z[0] + (z[1] << 28) + (z[2] << 55) + (z[3] << 83) + (z[4] << 110) + (z[5] << 138) + (z[6] << 165) + (z[7] << 192) + (z[8] << 220) + (z[9] << 247) + (z[10] << 0x113) + (z[11] << 0x12e) + (z[12] << 0x14a) + (z[13] << 0x165) + (z[14] << 0x180) + (z[15] << 0x19c) + (z[16] << 0x1b7) + (z[17] << 0x1d3) + (z[18] << 0x1ee)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8) + (z[56] << 0x1c0) + (z[57] << 0x1c8) + (z[58] << 0x1d0) + (z[59] << 0x1d8) + (z[60] << 0x1e0) + (z[61] << 0x1e8) + (z[62] << 0x1f0) + (z[63] << 0x1f8) + (z[64] << 2^9) + (z[65] << 0x208)
//!   balance = [0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0x1ffffffe, 0xffffffe, 0xffffffe]

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

/** fiat_p521_u1 represents values of 1 bits, stored in one byte. */
pub type fiat_p521_u1 = u8;
/** fiat_p521_i1 represents values of 1 bits, stored in one byte. */
pub type fiat_p521_i1 = i8;
/** fiat_p521_u2 represents values of 2 bits, stored in one byte. */
pub type fiat_p521_u2 = u8;
/** fiat_p521_i2 represents values of 2 bits, stored in one byte. */
pub type fiat_p521_i2 = i8;

/** The type fiat_p521_loose_field_element is a field element with loose bounds. */
/** Bounds: [[0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x30000000], [0x0 ~> 0x18000000], [0x0 ~> 0x18000000]] */
#[derive(Clone, Copy)]
pub struct fiat_p521_loose_field_element(pub [u32; 19]);

impl core::ops::Index<usize> for fiat_p521_loose_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p521_loose_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

/** The type fiat_p521_tight_field_element is a field element with tight bounds. */
/** Bounds: [[0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x10000000], [0x0 ~> 0x8000000], [0x0 ~> 0x8000000]] */
#[derive(Clone, Copy)]
pub struct fiat_p521_tight_field_element(pub [u32; 19]);

impl core::ops::Index<usize> for fiat_p521_tight_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p521_tight_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}


/// The function fiat_p521_addcarryx_u28 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^28
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^28⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xfffffff]
///   arg3: [0x0 ~> 0xfffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xfffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p521_addcarryx_u28(out1: &mut u32, out2: &mut fiat_p521_u1, arg1: fiat_p521_u1, arg2: u32, arg3: u32) {
  let x1: u32 = (((arg1 as u32) + arg2) + arg3);
  let x2: u32 = (x1 & 0xfffffff);
  let x3: fiat_p521_u1 = ((x1 >> 28) as fiat_p521_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p521_subborrowx_u28 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^28
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^28⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xfffffff]
///   arg3: [0x0 ~> 0xfffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xfffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p521_subborrowx_u28(out1: &mut u32, out2: &mut fiat_p521_u1, arg1: fiat_p521_u1, arg2: u32, arg3: u32) {
  let x1: i32 = ((((((arg2 as i64) - (arg1 as i64)) as i32) as i64) - (arg3 as i64)) as i32);
  let x2: fiat_p521_i1 = ((x1 >> 28) as fiat_p521_i1);
  let x3: u32 = (((x1 as i64) & (0xfffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p521_i2) - (x2 as fiat_p521_i2)) as fiat_p521_u1);
}

/// The function fiat_p521_addcarryx_u27 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^27
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^27⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x7ffffff]
///   arg3: [0x0 ~> 0x7ffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x7ffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p521_addcarryx_u27(out1: &mut u32, out2: &mut fiat_p521_u1, arg1: fiat_p521_u1, arg2: u32, arg3: u32) {
  let x1: u32 = (((arg1 as u32) + arg2) + arg3);
  let x2: u32 = (x1 & 0x7ffffff);
  let x3: fiat_p521_u1 = ((x1 >> 27) as fiat_p521_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p521_subborrowx_u27 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^27
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^27⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x7ffffff]
///   arg3: [0x0 ~> 0x7ffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x7ffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p521_subborrowx_u27(out1: &mut u32, out2: &mut fiat_p521_u1, arg1: fiat_p521_u1, arg2: u32, arg3: u32) {
  let x1: i32 = ((((((arg2 as i64) - (arg1 as i64)) as i32) as i64) - (arg3 as i64)) as i32);
  let x2: fiat_p521_i1 = ((x1 >> 27) as fiat_p521_i1);
  let x3: u32 = (((x1 as i64) & (0x7ffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p521_i2) - (x2 as fiat_p521_i2)) as fiat_p521_u1);
}

/// The function fiat_p521_cmovznz_u32 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p521_cmovznz_u32(out1: &mut u32, arg1: fiat_p521_u1, arg2: u32, arg3: u32) {
  let x1: fiat_p521_u1 = (!(!arg1));
  let x2: u32 = ((((((0x0 as fiat_p521_i2) - (x1 as fiat_p521_i2)) as fiat_p521_i1) as i64) & (0xffffffff as i64)) as u32);
  let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_p521_carry_mul multiplies two field elements and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg2) mod m
///
#[inline]
pub fn fiat_p521_carry_mul(out1: &mut fiat_p521_tight_field_element, arg1: &fiat_p521_loose_field_element, arg2: &fiat_p521_loose_field_element) {
  let x1: u64 = (((arg1[18]) as u64) * ((arg2[18]) as u64));
  let x2: u64 = (((arg1[18]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x3: u64 = (((arg1[18]) as u64) * ((arg2[16]) as u64));
  let x4: u64 = (((arg1[18]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x5: u64 = (((arg1[18]) as u64) * ((arg2[14]) as u64));
  let x6: u64 = (((arg1[18]) as u64) * ((arg2[13]) as u64));
  let x7: u64 = (((arg1[18]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x8: u64 = (((arg1[18]) as u64) * ((arg2[11]) as u64));
  let x9: u64 = (((arg1[18]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x10: u64 = (((arg1[18]) as u64) * ((arg2[9]) as u64));
  let x11: u64 = (((arg1[18]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x12: u64 = (((arg1[18]) as u64) * ((arg2[7]) as u64));
  let x13: u64 = (((arg1[18]) as u64) * ((arg2[6]) as u64));
  let x14: u64 = (((arg1[18]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x15: u64 = (((arg1[18]) as u64) * ((arg2[4]) as u64));
  let x16: u64 = (((arg1[18]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x17: u64 = (((arg1[18]) as u64) * ((arg2[2]) as u64));
  let x18: u64 = (((arg1[18]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x19: u64 = (((arg1[17]) as u64) * (((arg2[18]) * 0x2) as u64));
  let x20: u64 = (((arg1[17]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x21: u64 = (((arg1[17]) as u64) * (((arg2[16]) * 0x2) as u64));
  let x22: u64 = (((arg1[17]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x23: u64 = (((arg1[17]) as u64) * ((arg2[14]) as u64));
  let x24: u64 = (((arg1[17]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x25: u64 = (((arg1[17]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x26: u64 = (((arg1[17]) as u64) * (((arg2[11]) * 0x2) as u64));
  let x27: u64 = (((arg1[17]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x28: u64 = (((arg1[17]) as u64) * (((arg2[9]) * 0x2) as u64));
  let x29: u64 = (((arg1[17]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x30: u64 = (((arg1[17]) as u64) * ((arg2[7]) as u64));
  let x31: u64 = (((arg1[17]) as u64) * (((arg2[6]) * 0x2) as u64));
  let x32: u64 = (((arg1[17]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x33: u64 = (((arg1[17]) as u64) * (((arg2[4]) * 0x2) as u64));
  let x34: u64 = (((arg1[17]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x35: u64 = (((arg1[17]) as u64) * (((arg2[2]) * 0x2) as u64));
  let x36: u64 = (((arg1[16]) as u64) * ((arg2[18]) as u64));
  let x37: u64 = (((arg1[16]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x38: u64 = (((arg1[16]) as u64) * ((arg2[16]) as u64));
  let x39: u64 = (((arg1[16]) as u64) * ((arg2[15]) as u64));
  let x40: u64 = (((arg1[16]) as u64) * ((arg2[14]) as u64));
  let x41: u64 = (((arg1[16]) as u64) * ((arg2[13]) as u64));
  let x42: u64 = (((arg1[16]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x43: u64 = (((arg1[16]) as u64) * ((arg2[11]) as u64));
  let x44: u64 = (((arg1[16]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x45: u64 = (((arg1[16]) as u64) * ((arg2[9]) as u64));
  let x46: u64 = (((arg1[16]) as u64) * ((arg2[8]) as u64));
  let x47: u64 = (((arg1[16]) as u64) * ((arg2[7]) as u64));
  let x48: u64 = (((arg1[16]) as u64) * ((arg2[6]) as u64));
  let x49: u64 = (((arg1[16]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x50: u64 = (((arg1[16]) as u64) * ((arg2[4]) as u64));
  let x51: u64 = (((arg1[16]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x52: u64 = (((arg1[15]) as u64) * (((arg2[18]) * 0x2) as u64));
  let x53: u64 = (((arg1[15]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x54: u64 = (((arg1[15]) as u64) * ((arg2[16]) as u64));
  let x55: u64 = (((arg1[15]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x56: u64 = (((arg1[15]) as u64) * ((arg2[14]) as u64));
  let x57: u64 = (((arg1[15]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x58: u64 = (((arg1[15]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x59: u64 = (((arg1[15]) as u64) * (((arg2[11]) * 0x2) as u64));
  let x60: u64 = (((arg1[15]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x61: u64 = (((arg1[15]) as u64) * ((arg2[9]) as u64));
  let x62: u64 = (((arg1[15]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x63: u64 = (((arg1[15]) as u64) * ((arg2[7]) as u64));
  let x64: u64 = (((arg1[15]) as u64) * (((arg2[6]) * 0x2) as u64));
  let x65: u64 = (((arg1[15]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x66: u64 = (((arg1[15]) as u64) * (((arg2[4]) * 0x2) as u64));
  let x67: u64 = (((arg1[14]) as u64) * ((arg2[18]) as u64));
  let x68: u64 = (((arg1[14]) as u64) * ((arg2[17]) as u64));
  let x69: u64 = (((arg1[14]) as u64) * ((arg2[16]) as u64));
  let x70: u64 = (((arg1[14]) as u64) * ((arg2[15]) as u64));
  let x71: u64 = (((arg1[14]) as u64) * ((arg2[14]) as u64));
  let x72: u64 = (((arg1[14]) as u64) * ((arg2[13]) as u64));
  let x73: u64 = (((arg1[14]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x74: u64 = (((arg1[14]) as u64) * ((arg2[11]) as u64));
  let x75: u64 = (((arg1[14]) as u64) * ((arg2[10]) as u64));
  let x76: u64 = (((arg1[14]) as u64) * ((arg2[9]) as u64));
  let x77: u64 = (((arg1[14]) as u64) * ((arg2[8]) as u64));
  let x78: u64 = (((arg1[14]) as u64) * ((arg2[7]) as u64));
  let x79: u64 = (((arg1[14]) as u64) * ((arg2[6]) as u64));
  let x80: u64 = (((arg1[14]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x81: u64 = (((arg1[13]) as u64) * ((arg2[18]) as u64));
  let x82: u64 = (((arg1[13]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x83: u64 = (((arg1[13]) as u64) * ((arg2[16]) as u64));
  let x84: u64 = (((arg1[13]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x85: u64 = (((arg1[13]) as u64) * ((arg2[14]) as u64));
  let x86: u64 = (((arg1[13]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x87: u64 = (((arg1[13]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x88: u64 = (((arg1[13]) as u64) * ((arg2[11]) as u64));
  let x89: u64 = (((arg1[13]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x90: u64 = (((arg1[13]) as u64) * ((arg2[9]) as u64));
  let x91: u64 = (((arg1[13]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x92: u64 = (((arg1[13]) as u64) * ((arg2[7]) as u64));
  let x93: u64 = (((arg1[13]) as u64) * (((arg2[6]) * 0x2) as u64));
  let x94: u64 = (((arg1[12]) as u64) * (((arg2[18]) * 0x2) as u64));
  let x95: u64 = (((arg1[12]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x96: u64 = (((arg1[12]) as u64) * (((arg2[16]) * 0x2) as u64));
  let x97: u64 = (((arg1[12]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x98: u64 = (((arg1[12]) as u64) * (((arg2[14]) * 0x2) as u64));
  let x99: u64 = (((arg1[12]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x100: u64 = (((arg1[12]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x101: u64 = (((arg1[12]) as u64) * (((arg2[11]) * 0x2) as u64));
  let x102: u64 = (((arg1[12]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x103: u64 = (((arg1[12]) as u64) * (((arg2[9]) * 0x2) as u64));
  let x104: u64 = (((arg1[12]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x105: u64 = (((arg1[12]) as u64) * (((arg2[7]) * 0x2) as u64));
  let x106: u64 = (((arg1[11]) as u64) * ((arg2[18]) as u64));
  let x107: u64 = (((arg1[11]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x108: u64 = (((arg1[11]) as u64) * ((arg2[16]) as u64));
  let x109: u64 = (((arg1[11]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x110: u64 = (((arg1[11]) as u64) * ((arg2[14]) as u64));
  let x111: u64 = (((arg1[11]) as u64) * ((arg2[13]) as u64));
  let x112: u64 = (((arg1[11]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x113: u64 = (((arg1[11]) as u64) * ((arg2[11]) as u64));
  let x114: u64 = (((arg1[11]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x115: u64 = (((arg1[11]) as u64) * ((arg2[9]) as u64));
  let x116: u64 = (((arg1[11]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x117: u64 = (((arg1[10]) as u64) * (((arg2[18]) * 0x2) as u64));
  let x118: u64 = (((arg1[10]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x119: u64 = (((arg1[10]) as u64) * (((arg2[16]) * 0x2) as u64));
  let x120: u64 = (((arg1[10]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x121: u64 = (((arg1[10]) as u64) * ((arg2[14]) as u64));
  let x122: u64 = (((arg1[10]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x123: u64 = (((arg1[10]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x124: u64 = (((arg1[10]) as u64) * (((arg2[11]) * 0x2) as u64));
  let x125: u64 = (((arg1[10]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x126: u64 = (((arg1[10]) as u64) * (((arg2[9]) * 0x2) as u64));
  let x127: u64 = (((arg1[9]) as u64) * ((arg2[18]) as u64));
  let x128: u64 = (((arg1[9]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x129: u64 = (((arg1[9]) as u64) * ((arg2[16]) as u64));
  let x130: u64 = (((arg1[9]) as u64) * ((arg2[15]) as u64));
  let x131: u64 = (((arg1[9]) as u64) * ((arg2[14]) as u64));
  let x132: u64 = (((arg1[9]) as u64) * ((arg2[13]) as u64));
  let x133: u64 = (((arg1[9]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x134: u64 = (((arg1[9]) as u64) * ((arg2[11]) as u64));
  let x135: u64 = (((arg1[9]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x136: u64 = (((arg1[8]) as u64) * (((arg2[18]) * 0x2) as u64));
  let x137: u64 = (((arg1[8]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x138: u64 = (((arg1[8]) as u64) * ((arg2[16]) as u64));
  let x139: u64 = (((arg1[8]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x140: u64 = (((arg1[8]) as u64) * ((arg2[14]) as u64));
  let x141: u64 = (((arg1[8]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x142: u64 = (((arg1[8]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x143: u64 = (((arg1[8]) as u64) * (((arg2[11]) * 0x2) as u64));
  let x144: u64 = (((arg1[7]) as u64) * ((arg2[18]) as u64));
  let x145: u64 = (((arg1[7]) as u64) * ((arg2[17]) as u64));
  let x146: u64 = (((arg1[7]) as u64) * ((arg2[16]) as u64));
  let x147: u64 = (((arg1[7]) as u64) * ((arg2[15]) as u64));
  let x148: u64 = (((arg1[7]) as u64) * ((arg2[14]) as u64));
  let x149: u64 = (((arg1[7]) as u64) * ((arg2[13]) as u64));
  let x150: u64 = (((arg1[7]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x151: u64 = (((arg1[6]) as u64) * ((arg2[18]) as u64));
  let x152: u64 = (((arg1[6]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x153: u64 = (((arg1[6]) as u64) * ((arg2[16]) as u64));
  let x154: u64 = (((arg1[6]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x155: u64 = (((arg1[6]) as u64) * ((arg2[14]) as u64));
  let x156: u64 = (((arg1[6]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x157: u64 = (((arg1[5]) as u64) * (((arg2[18]) * 0x2) as u64));
  let x158: u64 = (((arg1[5]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x159: u64 = (((arg1[5]) as u64) * (((arg2[16]) * 0x2) as u64));
  let x160: u64 = (((arg1[5]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x161: u64 = (((arg1[5]) as u64) * (((arg2[14]) * 0x2) as u64));
  let x162: u64 = (((arg1[4]) as u64) * ((arg2[18]) as u64));
  let x163: u64 = (((arg1[4]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x164: u64 = (((arg1[4]) as u64) * ((arg2[16]) as u64));
  let x165: u64 = (((arg1[4]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x166: u64 = (((arg1[3]) as u64) * (((arg2[18]) * 0x2) as u64));
  let x167: u64 = (((arg1[3]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x168: u64 = (((arg1[3]) as u64) * (((arg2[16]) * 0x2) as u64));
  let x169: u64 = (((arg1[2]) as u64) * ((arg2[18]) as u64));
  let x170: u64 = (((arg1[2]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x171: u64 = (((arg1[1]) as u64) * (((arg2[18]) * 0x2) as u64));
  let x172: u64 = (((arg1[18]) as u64) * ((arg2[0]) as u64));
  let x173: u64 = (((arg1[17]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x174: u64 = (((arg1[17]) as u64) * ((arg2[0]) as u64));
  let x175: u64 = (((arg1[16]) as u64) * ((arg2[2]) as u64));
  let x176: u64 = (((arg1[16]) as u64) * ((arg2[1]) as u64));
  let x177: u64 = (((arg1[16]) as u64) * ((arg2[0]) as u64));
  let x178: u64 = (((arg1[15]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x179: u64 = (((arg1[15]) as u64) * ((arg2[2]) as u64));
  let x180: u64 = (((arg1[15]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x181: u64 = (((arg1[15]) as u64) * ((arg2[0]) as u64));
  let x182: u64 = (((arg1[14]) as u64) * ((arg2[4]) as u64));
  let x183: u64 = (((arg1[14]) as u64) * ((arg2[3]) as u64));
  let x184: u64 = (((arg1[14]) as u64) * ((arg2[2]) as u64));
  let x185: u64 = (((arg1[14]) as u64) * ((arg2[1]) as u64));
  let x186: u64 = (((arg1[14]) as u64) * ((arg2[0]) as u64));
  let x187: u64 = (((arg1[13]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x188: u64 = (((arg1[13]) as u64) * ((arg2[4]) as u64));
  let x189: u64 = (((arg1[13]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x190: u64 = (((arg1[13]) as u64) * ((arg2[2]) as u64));
  let x191: u64 = (((arg1[13]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x192: u64 = (((arg1[13]) as u64) * ((arg2[0]) as u64));
  let x193: u64 = (((arg1[12]) as u64) * (((arg2[6]) * 0x2) as u64));
  let x194: u64 = (((arg1[12]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x195: u64 = (((arg1[12]) as u64) * (((arg2[4]) * 0x2) as u64));
  let x196: u64 = (((arg1[12]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x197: u64 = (((arg1[12]) as u64) * (((arg2[2]) * 0x2) as u64));
  let x198: u64 = (((arg1[12]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x199: u64 = (((arg1[12]) as u64) * ((arg2[0]) as u64));
  let x200: u64 = (((arg1[11]) as u64) * ((arg2[7]) as u64));
  let x201: u64 = (((arg1[11]) as u64) * ((arg2[6]) as u64));
  let x202: u64 = (((arg1[11]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x203: u64 = (((arg1[11]) as u64) * ((arg2[4]) as u64));
  let x204: u64 = (((arg1[11]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x205: u64 = (((arg1[11]) as u64) * ((arg2[2]) as u64));
  let x206: u64 = (((arg1[11]) as u64) * ((arg2[1]) as u64));
  let x207: u64 = (((arg1[11]) as u64) * ((arg2[0]) as u64));
  let x208: u64 = (((arg1[10]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x209: u64 = (((arg1[10]) as u64) * ((arg2[7]) as u64));
  let x210: u64 = (((arg1[10]) as u64) * (((arg2[6]) * 0x2) as u64));
  let x211: u64 = (((arg1[10]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x212: u64 = (((arg1[10]) as u64) * (((arg2[4]) * 0x2) as u64));
  let x213: u64 = (((arg1[10]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x214: u64 = (((arg1[10]) as u64) * ((arg2[2]) as u64));
  let x215: u64 = (((arg1[10]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x216: u64 = (((arg1[10]) as u64) * ((arg2[0]) as u64));
  let x217: u64 = (((arg1[9]) as u64) * ((arg2[9]) as u64));
  let x218: u64 = (((arg1[9]) as u64) * ((arg2[8]) as u64));
  let x219: u64 = (((arg1[9]) as u64) * ((arg2[7]) as u64));
  let x220: u64 = (((arg1[9]) as u64) * ((arg2[6]) as u64));
  let x221: u64 = (((arg1[9]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x222: u64 = (((arg1[9]) as u64) * ((arg2[4]) as u64));
  let x223: u64 = (((arg1[9]) as u64) * ((arg2[3]) as u64));
  let x224: u64 = (((arg1[9]) as u64) * ((arg2[2]) as u64));
  let x225: u64 = (((arg1[9]) as u64) * ((arg2[1]) as u64));
  let x226: u64 = (((arg1[9]) as u64) * ((arg2[0]) as u64));
  let x227: u64 = (((arg1[8]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x228: u64 = (((arg1[8]) as u64) * ((arg2[9]) as u64));
  let x229: u64 = (((arg1[8]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x230: u64 = (((arg1[8]) as u64) * ((arg2[7]) as u64));
  let x231: u64 = (((arg1[8]) as u64) * (((arg2[6]) * 0x2) as u64));
  let x232: u64 = (((arg1[8]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x233: u64 = (((arg1[8]) as u64) * ((arg2[4]) as u64));
  let x234: u64 = (((arg1[8]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x235: u64 = (((arg1[8]) as u64) * ((arg2[2]) as u64));
  let x236: u64 = (((arg1[8]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x237: u64 = (((arg1[8]) as u64) * ((arg2[0]) as u64));
  let x238: u64 = (((arg1[7]) as u64) * ((arg2[11]) as u64));
  let x239: u64 = (((arg1[7]) as u64) * ((arg2[10]) as u64));
  let x240: u64 = (((arg1[7]) as u64) * ((arg2[9]) as u64));
  let x241: u64 = (((arg1[7]) as u64) * ((arg2[8]) as u64));
  let x242: u64 = (((arg1[7]) as u64) * ((arg2[7]) as u64));
  let x243: u64 = (((arg1[7]) as u64) * ((arg2[6]) as u64));
  let x244: u64 = (((arg1[7]) as u64) * ((arg2[5]) as u64));
  let x245: u64 = (((arg1[7]) as u64) * ((arg2[4]) as u64));
  let x246: u64 = (((arg1[7]) as u64) * ((arg2[3]) as u64));
  let x247: u64 = (((arg1[7]) as u64) * ((arg2[2]) as u64));
  let x248: u64 = (((arg1[7]) as u64) * ((arg2[1]) as u64));
  let x249: u64 = (((arg1[7]) as u64) * ((arg2[0]) as u64));
  let x250: u64 = (((arg1[6]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x251: u64 = (((arg1[6]) as u64) * ((arg2[11]) as u64));
  let x252: u64 = (((arg1[6]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x253: u64 = (((arg1[6]) as u64) * ((arg2[9]) as u64));
  let x254: u64 = (((arg1[6]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x255: u64 = (((arg1[6]) as u64) * ((arg2[7]) as u64));
  let x256: u64 = (((arg1[6]) as u64) * ((arg2[6]) as u64));
  let x257: u64 = (((arg1[6]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x258: u64 = (((arg1[6]) as u64) * ((arg2[4]) as u64));
  let x259: u64 = (((arg1[6]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x260: u64 = (((arg1[6]) as u64) * ((arg2[2]) as u64));
  let x261: u64 = (((arg1[6]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x262: u64 = (((arg1[6]) as u64) * ((arg2[0]) as u64));
  let x263: u64 = (((arg1[5]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x264: u64 = (((arg1[5]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x265: u64 = (((arg1[5]) as u64) * (((arg2[11]) * 0x2) as u64));
  let x266: u64 = (((arg1[5]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x267: u64 = (((arg1[5]) as u64) * (((arg2[9]) * 0x2) as u64));
  let x268: u64 = (((arg1[5]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x269: u64 = (((arg1[5]) as u64) * ((arg2[7]) as u64));
  let x270: u64 = (((arg1[5]) as u64) * (((arg2[6]) * 0x2) as u64));
  let x271: u64 = (((arg1[5]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x272: u64 = (((arg1[5]) as u64) * (((arg2[4]) * 0x2) as u64));
  let x273: u64 = (((arg1[5]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x274: u64 = (((arg1[5]) as u64) * (((arg2[2]) * 0x2) as u64));
  let x275: u64 = (((arg1[5]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x276: u64 = (((arg1[5]) as u64) * ((arg2[0]) as u64));
  let x277: u64 = (((arg1[4]) as u64) * ((arg2[14]) as u64));
  let x278: u64 = (((arg1[4]) as u64) * ((arg2[13]) as u64));
  let x279: u64 = (((arg1[4]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x280: u64 = (((arg1[4]) as u64) * ((arg2[11]) as u64));
  let x281: u64 = (((arg1[4]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x282: u64 = (((arg1[4]) as u64) * ((arg2[9]) as u64));
  let x283: u64 = (((arg1[4]) as u64) * ((arg2[8]) as u64));
  let x284: u64 = (((arg1[4]) as u64) * ((arg2[7]) as u64));
  let x285: u64 = (((arg1[4]) as u64) * ((arg2[6]) as u64));
  let x286: u64 = (((arg1[4]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x287: u64 = (((arg1[4]) as u64) * ((arg2[4]) as u64));
  let x288: u64 = (((arg1[4]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x289: u64 = (((arg1[4]) as u64) * ((arg2[2]) as u64));
  let x290: u64 = (((arg1[4]) as u64) * ((arg2[1]) as u64));
  let x291: u64 = (((arg1[4]) as u64) * ((arg2[0]) as u64));
  let x292: u64 = (((arg1[3]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x293: u64 = (((arg1[3]) as u64) * ((arg2[14]) as u64));
  let x294: u64 = (((arg1[3]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x295: u64 = (((arg1[3]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x296: u64 = (((arg1[3]) as u64) * (((arg2[11]) * 0x2) as u64));
  let x297: u64 = (((arg1[3]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x298: u64 = (((arg1[3]) as u64) * ((arg2[9]) as u64));
  let x299: u64 = (((arg1[3]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x300: u64 = (((arg1[3]) as u64) * ((arg2[7]) as u64));
  let x301: u64 = (((arg1[3]) as u64) * (((arg2[6]) * 0x2) as u64));
  let x302: u64 = (((arg1[3]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x303: u64 = (((arg1[3]) as u64) * (((arg2[4]) * 0x2) as u64));
  let x304: u64 = (((arg1[3]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x305: u64 = (((arg1[3]) as u64) * ((arg2[2]) as u64));
  let x306: u64 = (((arg1[3]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x307: u64 = (((arg1[3]) as u64) * ((arg2[0]) as u64));
  let x308: u64 = (((arg1[2]) as u64) * ((arg2[16]) as u64));
  let x309: u64 = (((arg1[2]) as u64) * ((arg2[15]) as u64));
  let x310: u64 = (((arg1[2]) as u64) * ((arg2[14]) as u64));
  let x311: u64 = (((arg1[2]) as u64) * ((arg2[13]) as u64));
  let x312: u64 = (((arg1[2]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x313: u64 = (((arg1[2]) as u64) * ((arg2[11]) as u64));
  let x314: u64 = (((arg1[2]) as u64) * ((arg2[10]) as u64));
  let x315: u64 = (((arg1[2]) as u64) * ((arg2[9]) as u64));
  let x316: u64 = (((arg1[2]) as u64) * ((arg2[8]) as u64));
  let x317: u64 = (((arg1[2]) as u64) * ((arg2[7]) as u64));
  let x318: u64 = (((arg1[2]) as u64) * ((arg2[6]) as u64));
  let x319: u64 = (((arg1[2]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x320: u64 = (((arg1[2]) as u64) * ((arg2[4]) as u64));
  let x321: u64 = (((arg1[2]) as u64) * ((arg2[3]) as u64));
  let x322: u64 = (((arg1[2]) as u64) * ((arg2[2]) as u64));
  let x323: u64 = (((arg1[2]) as u64) * ((arg2[1]) as u64));
  let x324: u64 = (((arg1[2]) as u64) * ((arg2[0]) as u64));
  let x325: u64 = (((arg1[1]) as u64) * (((arg2[17]) * 0x2) as u64));
  let x326: u64 = (((arg1[1]) as u64) * ((arg2[16]) as u64));
  let x327: u64 = (((arg1[1]) as u64) * (((arg2[15]) * 0x2) as u64));
  let x328: u64 = (((arg1[1]) as u64) * ((arg2[14]) as u64));
  let x329: u64 = (((arg1[1]) as u64) * (((arg2[13]) * 0x2) as u64));
  let x330: u64 = (((arg1[1]) as u64) * (((arg2[12]) * 0x2) as u64));
  let x331: u64 = (((arg1[1]) as u64) * ((arg2[11]) as u64));
  let x332: u64 = (((arg1[1]) as u64) * (((arg2[10]) * 0x2) as u64));
  let x333: u64 = (((arg1[1]) as u64) * ((arg2[9]) as u64));
  let x334: u64 = (((arg1[1]) as u64) * (((arg2[8]) * 0x2) as u64));
  let x335: u64 = (((arg1[1]) as u64) * ((arg2[7]) as u64));
  let x336: u64 = (((arg1[1]) as u64) * (((arg2[6]) * 0x2) as u64));
  let x337: u64 = (((arg1[1]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x338: u64 = (((arg1[1]) as u64) * ((arg2[4]) as u64));
  let x339: u64 = (((arg1[1]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x340: u64 = (((arg1[1]) as u64) * ((arg2[2]) as u64));
  let x341: u64 = (((arg1[1]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x342: u64 = (((arg1[1]) as u64) * ((arg2[0]) as u64));
  let x343: u64 = (((arg1[0]) as u64) * ((arg2[18]) as u64));
  let x344: u64 = (((arg1[0]) as u64) * ((arg2[17]) as u64));
  let x345: u64 = (((arg1[0]) as u64) * ((arg2[16]) as u64));
  let x346: u64 = (((arg1[0]) as u64) * ((arg2[15]) as u64));
  let x347: u64 = (((arg1[0]) as u64) * ((arg2[14]) as u64));
  let x348: u64 = (((arg1[0]) as u64) * ((arg2[13]) as u64));
  let x349: u64 = (((arg1[0]) as u64) * ((arg2[12]) as u64));
  let x350: u64 = (((arg1[0]) as u64) * ((arg2[11]) as u64));
  let x351: u64 = (((arg1[0]) as u64) * ((arg2[10]) as u64));
  let x352: u64 = (((arg1[0]) as u64) * ((arg2[9]) as u64));
  let x353: u64 = (((arg1[0]) as u64) * ((arg2[8]) as u64));
  let x354: u64 = (((arg1[0]) as u64) * ((arg2[7]) as u64));
  let x355: u64 = (((arg1[0]) as u64) * ((arg2[6]) as u64));
  let x356: u64 = (((arg1[0]) as u64) * ((arg2[5]) as u64));
  let x357: u64 = (((arg1[0]) as u64) * ((arg2[4]) as u64));
  let x358: u64 = (((arg1[0]) as u64) * ((arg2[3]) as u64));
  let x359: u64 = (((arg1[0]) as u64) * ((arg2[2]) as u64));
  let x360: u64 = (((arg1[0]) as u64) * ((arg2[1]) as u64));
  let x361: u64 = (((arg1[0]) as u64) * ((arg2[0]) as u64));
  let x362: u64 = (x361 + (x171 + (x170 + (x168 + (x165 + (x161 + (x156 + (x150 + (x143 + (x135 + (x126 + (x116 + (x105 + (x93 + (x80 + (x66 + (x51 + (x35 + x18))))))))))))))))));
  let x363: u64 = (x362 >> 28);
  let x364: u32 = ((x362 & (0xfffffff as u64)) as u32);
  let x365: u64 = (x343 + (x325 + (x308 + (x292 + (x277 + (x263 + (x250 + (x238 + (x227 + (x217 + (x208 + (x200 + (x193 + (x187 + (x182 + (x178 + (x175 + (x173 + x172))))))))))))))))));
  let x366: u64 = (x344 + (x326 + (x309 + (x293 + (x278 + (x264 + (x251 + (x239 + (x228 + (x218 + (x209 + (x201 + (x194 + (x188 + (x183 + (x179 + (x176 + (x174 + x1))))))))))))))))));
  let x367: u64 = (x345 + (x327 + (x310 + (x294 + (x279 + (x265 + (x252 + (x240 + (x229 + (x219 + (x210 + (x202 + (x195 + (x189 + (x184 + (x180 + (x177 + (x19 + x2))))))))))))))))));
  let x368: u64 = (x346 + (x328 + (x311 + (x295 + (x280 + (x266 + (x253 + (x241 + (x230 + (x220 + (x211 + (x203 + (x196 + (x190 + (x185 + (x181 + (x36 + (x20 + x3))))))))))))))))));
  let x369: u64 = (x347 + (x329 + (x312 + (x296 + (x281 + (x267 + (x254 + (x242 + (x231 + (x221 + (x212 + (x204 + (x197 + (x191 + (x186 + (x52 + (x37 + (x21 + x4))))))))))))))))));
  let x370: u64 = (x348 + (x330 + (x313 + (x297 + (x282 + (x268 + (x255 + (x243 + (x232 + (x222 + (x213 + (x205 + (x198 + (x192 + (x67 + (x53 + (x38 + (x22 + x5))))))))))))))))));
  let x371: u64 = (x349 + (x331 + (x314 + (x298 + (x283 + (x269 + (x256 + (x244 + (x233 + (x223 + (x214 + (x206 + (x199 + (x81 + (x68 + (x54 + (x39 + (x23 + x6))))))))))))))))));
  let x372: u64 = (x350 + (x332 + (x315 + (x299 + (x284 + (x270 + (x257 + (x245 + (x234 + (x224 + (x215 + (x207 + (x94 + (x82 + (x69 + (x55 + (x40 + (x24 + x7))))))))))))))))));
  let x373: u64 = (x351 + (x333 + (x316 + (x300 + (x285 + (x271 + (x258 + (x246 + (x235 + (x225 + (x216 + (x106 + (x95 + (x83 + (x70 + (x56 + (x41 + (x25 + x8))))))))))))))))));
  let x374: u64 = (x352 + (x334 + (x317 + (x301 + (x286 + (x272 + (x259 + (x247 + (x236 + (x226 + (x117 + (x107 + (x96 + (x84 + (x71 + (x57 + (x42 + (x26 + x9))))))))))))))))));
  let x375: u64 = (x353 + (x335 + (x318 + (x302 + (x287 + (x273 + (x260 + (x248 + (x237 + (x127 + (x118 + (x108 + (x97 + (x85 + (x72 + (x58 + (x43 + (x27 + x10))))))))))))))))));
  let x376: u64 = (x354 + (x336 + (x319 + (x303 + (x288 + (x274 + (x261 + (x249 + (x136 + (x128 + (x119 + (x109 + (x98 + (x86 + (x73 + (x59 + (x44 + (x28 + x11))))))))))))))))));
  let x377: u64 = (x355 + (x337 + (x320 + (x304 + (x289 + (x275 + (x262 + (x144 + (x137 + (x129 + (x120 + (x110 + (x99 + (x87 + (x74 + (x60 + (x45 + (x29 + x12))))))))))))))))));
  let x378: u64 = (x356 + (x338 + (x321 + (x305 + (x290 + (x276 + (x151 + (x145 + (x138 + (x130 + (x121 + (x111 + (x100 + (x88 + (x75 + (x61 + (x46 + (x30 + x13))))))))))))))))));
  let x379: u64 = (x357 + (x339 + (x322 + (x306 + (x291 + (x157 + (x152 + (x146 + (x139 + (x131 + (x122 + (x112 + (x101 + (x89 + (x76 + (x62 + (x47 + (x31 + x14))))))))))))))))));
  let x380: u64 = (x358 + (x340 + (x323 + (x307 + (x162 + (x158 + (x153 + (x147 + (x140 + (x132 + (x123 + (x113 + (x102 + (x90 + (x77 + (x63 + (x48 + (x32 + x15))))))))))))))))));
  let x381: u64 = (x359 + (x341 + (x324 + (x166 + (x163 + (x159 + (x154 + (x148 + (x141 + (x133 + (x124 + (x114 + (x103 + (x91 + (x78 + (x64 + (x49 + (x33 + x16))))))))))))))))));
  let x382: u64 = (x360 + (x342 + (x169 + (x167 + (x164 + (x160 + (x155 + (x149 + (x142 + (x134 + (x125 + (x115 + (x104 + (x92 + (x79 + (x65 + (x50 + (x34 + x17))))))))))))))))));
  let x383: u64 = (x363 + x382);
  let x384: u64 = (x383 >> 27);
  let x385: u32 = ((x383 & (0x7ffffff as u64)) as u32);
  let x386: u64 = (x384 + x381);
  let x387: u64 = (x386 >> 28);
  let x388: u32 = ((x386 & (0xfffffff as u64)) as u32);
  let x389: u64 = (x387 + x380);
  let x390: u64 = (x389 >> 27);
  let x391: u32 = ((x389 & (0x7ffffff as u64)) as u32);
  let x392: u64 = (x390 + x379);
  let x393: u64 = (x392 >> 28);
  let x394: u32 = ((x392 & (0xfffffff as u64)) as u32);
  let x395: u64 = (x393 + x378);
  let x396: u64 = (x395 >> 27);
  let x397: u32 = ((x395 & (0x7ffffff as u64)) as u32);
  let x398: u64 = (x396 + x377);
  let x399: u64 = (x398 >> 27);
  let x400: u32 = ((x398 & (0x7ffffff as u64)) as u32);
  let x401: u64 = (x399 + x376);
  let x402: u64 = (x401 >> 28);
  let x403: u32 = ((x401 & (0xfffffff as u64)) as u32);
  let x404: u64 = (x402 + x375);
  let x405: u64 = (x404 >> 27);
  let x406: u32 = ((x404 & (0x7ffffff as u64)) as u32);
  let x407: u64 = (x405 + x374);
  let x408: u64 = (x407 >> 28);
  let x409: u32 = ((x407 & (0xfffffff as u64)) as u32);
  let x410: u64 = (x408 + x373);
  let x411: u64 = (x410 >> 27);
  let x412: u32 = ((x410 & (0x7ffffff as u64)) as u32);
  let x413: u64 = (x411 + x372);
  let x414: u64 = (x413 >> 28);
  let x415: u32 = ((x413 & (0xfffffff as u64)) as u32);
  let x416: u64 = (x414 + x371);
  let x417: u64 = (x416 >> 27);
  let x418: u32 = ((x416 & (0x7ffffff as u64)) as u32);
  let x419: u64 = (x417 + x370);
  let x420: u64 = (x419 >> 27);
  let x421: u32 = ((x419 & (0x7ffffff as u64)) as u32);
  let x422: u64 = (x420 + x369);
  let x423: u64 = (x422 >> 28);
  let x424: u32 = ((x422 & (0xfffffff as u64)) as u32);
  let x425: u64 = (x423 + x368);
  let x426: u64 = (x425 >> 27);
  let x427: u32 = ((x425 & (0x7ffffff as u64)) as u32);
  let x428: u64 = (x426 + x367);
  let x429: u64 = (x428 >> 28);
  let x430: u32 = ((x428 & (0xfffffff as u64)) as u32);
  let x431: u64 = (x429 + x366);
  let x432: u64 = (x431 >> 27);
  let x433: u32 = ((x431 & (0x7ffffff as u64)) as u32);
  let x434: u64 = (x432 + x365);
  let x435: u64 = (x434 >> 27);
  let x436: u32 = ((x434 & (0x7ffffff as u64)) as u32);
  let x437: u64 = ((x364 as u64) + x435);
  let x438: u32 = ((x437 >> 28) as u32);
  let x439: u32 = ((x437 & (0xfffffff as u64)) as u32);
  let x440: u32 = (x438 + x385);
  let x441: fiat_p521_u1 = ((x440 >> 27) as fiat_p521_u1);
  let x442: u32 = (x440 & 0x7ffffff);
  let x443: u32 = ((x441 as u32) + x388);
  out1[0] = x439;
  out1[1] = x442;
  out1[2] = x443;
  out1[3] = x391;
  out1[4] = x394;
  out1[5] = x397;
  out1[6] = x400;
  out1[7] = x403;
  out1[8] = x406;
  out1[9] = x409;
  out1[10] = x412;
  out1[11] = x415;
  out1[12] = x418;
  out1[13] = x421;
  out1[14] = x424;
  out1[15] = x427;
  out1[16] = x430;
  out1[17] = x433;
  out1[18] = x436;
}

/// The function fiat_p521_carry_square squares a field element and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg1) mod m
///
#[inline]
pub fn fiat_p521_carry_square(out1: &mut fiat_p521_tight_field_element, arg1: &fiat_p521_loose_field_element) {
  let x1: u32 = (arg1[18]);
  let x2: u32 = (x1 * 0x2);
  let x3: u32 = ((arg1[18]) * 0x2);
  let x4: u32 = (arg1[17]);
  let x5: u32 = (x4 * 0x2);
  let x6: u32 = ((arg1[17]) * 0x2);
  let x7: u32 = (arg1[16]);
  let x8: u32 = (x7 * 0x2);
  let x9: u32 = ((arg1[16]) * 0x2);
  let x10: u32 = (arg1[15]);
  let x11: u32 = (x10 * 0x2);
  let x12: u32 = ((arg1[15]) * 0x2);
  let x13: u32 = (arg1[14]);
  let x14: u32 = (x13 * 0x2);
  let x15: u32 = ((arg1[14]) * 0x2);
  let x16: u32 = (arg1[13]);
  let x17: u32 = (x16 * 0x2);
  let x18: u32 = ((arg1[13]) * 0x2);
  let x19: u32 = (arg1[12]);
  let x20: u32 = (x19 * 0x2);
  let x21: u32 = ((arg1[12]) * 0x2);
  let x22: u32 = (arg1[11]);
  let x23: u32 = (x22 * 0x2);
  let x24: u32 = ((arg1[11]) * 0x2);
  let x25: u32 = (arg1[10]);
  let x26: u32 = (x25 * 0x2);
  let x27: u32 = ((arg1[10]) * 0x2);
  let x28: u32 = ((arg1[9]) * 0x2);
  let x29: u32 = ((arg1[8]) * 0x2);
  let x30: u32 = ((arg1[7]) * 0x2);
  let x31: u32 = ((arg1[6]) * 0x2);
  let x32: u32 = ((arg1[5]) * 0x2);
  let x33: u32 = ((arg1[4]) * 0x2);
  let x34: u32 = ((arg1[3]) * 0x2);
  let x35: u32 = ((arg1[2]) * 0x2);
  let x36: u32 = ((arg1[1]) * 0x2);
  let x37: u64 = (((arg1[18]) as u64) * (x1 as u64));
  let x38: u64 = (((arg1[17]) as u64) * ((x2 * 0x2) as u64));
  let x39: u64 = (((arg1[17]) as u64) * ((x4 * 0x2) as u64));
  let x40: u64 = (((arg1[16]) as u64) * (x2 as u64));
  let x41: u64 = (((arg1[16]) as u64) * ((x5 * 0x2) as u64));
  let x42: u64 = (((arg1[16]) as u64) * (x7 as u64));
  let x43: u64 = (((arg1[15]) as u64) * ((x2 * 0x2) as u64));
  let x44: u64 = (((arg1[15]) as u64) * ((x5 * 0x2) as u64));
  let x45: u64 = (((arg1[15]) as u64) * (x8 as u64));
  let x46: u64 = (((arg1[15]) as u64) * ((x10 * 0x2) as u64));
  let x47: u64 = (((arg1[14]) as u64) * (x2 as u64));
  let x48: u64 = (((arg1[14]) as u64) * (x5 as u64));
  let x49: u64 = (((arg1[14]) as u64) * (x8 as u64));
  let x50: u64 = (((arg1[14]) as u64) * (x11 as u64));
  let x51: u64 = (((arg1[14]) as u64) * (x13 as u64));
  let x52: u64 = (((arg1[13]) as u64) * (x2 as u64));
  let x53: u64 = (((arg1[13]) as u64) * ((x5 * 0x2) as u64));
  let x54: u64 = (((arg1[13]) as u64) * (x8 as u64));
  let x55: u64 = (((arg1[13]) as u64) * ((x11 * 0x2) as u64));
  let x56: u64 = (((arg1[13]) as u64) * (x14 as u64));
  let x57: u64 = (((arg1[13]) as u64) * ((x16 * 0x2) as u64));
  let x58: u64 = (((arg1[12]) as u64) * ((x2 * 0x2) as u64));
  let x59: u64 = (((arg1[12]) as u64) * ((x5 * 0x2) as u64));
  let x60: u64 = (((arg1[12]) as u64) * ((x8 * 0x2) as u64));
  let x61: u64 = (((arg1[12]) as u64) * ((x11 * 0x2) as u64));
  let x62: u64 = (((arg1[12]) as u64) * ((x14 * 0x2) as u64));
  let x63: u64 = (((arg1[12]) as u64) * ((x17 * 0x2) as u64));
  let x64: u64 = (((arg1[12]) as u64) * ((x19 * 0x2) as u64));
  let x65: u64 = (((arg1[11]) as u64) * (x2 as u64));
  let x66: u64 = (((arg1[11]) as u64) * ((x5 * 0x2) as u64));
  let x67: u64 = (((arg1[11]) as u64) * (x8 as u64));
  let x68: u64 = (((arg1[11]) as u64) * ((x11 * 0x2) as u64));
  let x69: u64 = (((arg1[11]) as u64) * (x14 as u64));
  let x70: u64 = (((arg1[11]) as u64) * (x17 as u64));
  let x71: u64 = (((arg1[11]) as u64) * ((x20 * 0x2) as u64));
  let x72: u64 = (((arg1[11]) as u64) * (x22 as u64));
  let x73: u64 = (((arg1[10]) as u64) * ((x2 * 0x2) as u64));
  let x74: u64 = (((arg1[10]) as u64) * ((x5 * 0x2) as u64));
  let x75: u64 = (((arg1[10]) as u64) * ((x8 * 0x2) as u64));
  let x76: u64 = (((arg1[10]) as u64) * ((x11 * 0x2) as u64));
  let x77: u64 = (((arg1[10]) as u64) * (x14 as u64));
  let x78: u64 = (((arg1[10]) as u64) * ((x17 * 0x2) as u64));
  let x79: u64 = (((arg1[10]) as u64) * ((x20 * 0x2) as u64));
  let x80: u64 = (((arg1[10]) as u64) * ((x23 * 0x2) as u64));
  let x81: u64 = (((arg1[10]) as u64) * ((x25 * 0x2) as u64));
  let x82: u64 = (((arg1[9]) as u64) * (x2 as u64));
  let x83: u64 = (((arg1[9]) as u64) * ((x5 * 0x2) as u64));
  let x84: u64 = (((arg1[9]) as u64) * (x8 as u64));
  let x85: u64 = (((arg1[9]) as u64) * (x11 as u64));
  let x86: u64 = (((arg1[9]) as u64) * (x14 as u64));
  let x87: u64 = (((arg1[9]) as u64) * (x17 as u64));
  let x88: u64 = (((arg1[9]) as u64) * ((x20 * 0x2) as u64));
  let x89: u64 = (((arg1[9]) as u64) * (x23 as u64));
  let x90: u64 = (((arg1[9]) as u64) * ((x26 * 0x2) as u64));
  let x91: u64 = (((arg1[9]) as u64) * ((arg1[9]) as u64));
  let x92: u64 = (((arg1[8]) as u64) * ((x2 * 0x2) as u64));
  let x93: u64 = (((arg1[8]) as u64) * ((x5 * 0x2) as u64));
  let x94: u64 = (((arg1[8]) as u64) * (x8 as u64));
  let x95: u64 = (((arg1[8]) as u64) * ((x11 * 0x2) as u64));
  let x96: u64 = (((arg1[8]) as u64) * (x14 as u64));
  let x97: u64 = (((arg1[8]) as u64) * ((x17 * 0x2) as u64));
  let x98: u64 = (((arg1[8]) as u64) * ((x20 * 0x2) as u64));
  let x99: u64 = (((arg1[8]) as u64) * ((x23 * 0x2) as u64));
  let x100: u64 = (((arg1[8]) as u64) * ((x27 * 0x2) as u64));
  let x101: u64 = (((arg1[8]) as u64) * (x28 as u64));
  let x102: u64 = (((arg1[8]) as u64) * (((arg1[8]) * 0x2) as u64));
  let x103: u64 = (((arg1[7]) as u64) * (x2 as u64));
  let x104: u64 = (((arg1[7]) as u64) * (x5 as u64));
  let x105: u64 = (((arg1[7]) as u64) * (x8 as u64));
  let x106: u64 = (((arg1[7]) as u64) * (x11 as u64));
  let x107: u64 = (((arg1[7]) as u64) * (x14 as u64));
  let x108: u64 = (((arg1[7]) as u64) * (x17 as u64));
  let x109: u64 = (((arg1[7]) as u64) * ((x20 * 0x2) as u64));
  let x110: u64 = (((arg1[7]) as u64) * (x24 as u64));
  let x111: u64 = (((arg1[7]) as u64) * (x27 as u64));
  let x112: u64 = (((arg1[7]) as u64) * (x28 as u64));
  let x113: u64 = (((arg1[7]) as u64) * (x29 as u64));
  let x114: u64 = (((arg1[7]) as u64) * ((arg1[7]) as u64));
  let x115: u64 = (((arg1[6]) as u64) * (x2 as u64));
  let x116: u64 = (((arg1[6]) as u64) * ((x5 * 0x2) as u64));
  let x117: u64 = (((arg1[6]) as u64) * (x8 as u64));
  let x118: u64 = (((arg1[6]) as u64) * ((x11 * 0x2) as u64));
  let x119: u64 = (((arg1[6]) as u64) * (x14 as u64));
  let x120: u64 = (((arg1[6]) as u64) * ((x17 * 0x2) as u64));
  let x121: u64 = (((arg1[6]) as u64) * ((x21 * 0x2) as u64));
  let x122: u64 = (((arg1[6]) as u64) * (x24 as u64));
  let x123: u64 = (((arg1[6]) as u64) * ((x27 * 0x2) as u64));
  let x124: u64 = (((arg1[6]) as u64) * (x28 as u64));
  let x125: u64 = (((arg1[6]) as u64) * ((x29 * 0x2) as u64));
  let x126: u64 = (((arg1[6]) as u64) * (x30 as u64));
  let x127: u64 = (((arg1[6]) as u64) * ((arg1[6]) as u64));
  let x128: u64 = (((arg1[5]) as u64) * ((x2 * 0x2) as u64));
  let x129: u64 = (((arg1[5]) as u64) * ((x5 * 0x2) as u64));
  let x130: u64 = (((arg1[5]) as u64) * ((x8 * 0x2) as u64));
  let x131: u64 = (((arg1[5]) as u64) * ((x11 * 0x2) as u64));
  let x132: u64 = (((arg1[5]) as u64) * ((x14 * 0x2) as u64));
  let x133: u64 = (((arg1[5]) as u64) * ((x18 * 0x2) as u64));
  let x134: u64 = (((arg1[5]) as u64) * ((x21 * 0x2) as u64));
  let x135: u64 = (((arg1[5]) as u64) * ((x24 * 0x2) as u64));
  let x136: u64 = (((arg1[5]) as u64) * ((x27 * 0x2) as u64));
  let x137: u64 = (((arg1[5]) as u64) * ((x28 * 0x2) as u64));
  let x138: u64 = (((arg1[5]) as u64) * ((x29 * 0x2) as u64));
  let x139: u64 = (((arg1[5]) as u64) * (x30 as u64));
  let x140: u64 = (((arg1[5]) as u64) * ((x31 * 0x2) as u64));
  let x141: u64 = (((arg1[5]) as u64) * (((arg1[5]) * 0x2) as u64));
  let x142: u64 = (((arg1[4]) as u64) * (x2 as u64));
  let x143: u64 = (((arg1[4]) as u64) * ((x5 * 0x2) as u64));
  let x144: u64 = (((arg1[4]) as u64) * (x8 as u64));
  let x145: u64 = (((arg1[4]) as u64) * ((x11 * 0x2) as u64));
  let x146: u64 = (((arg1[4]) as u64) * (x15 as u64));
  let x147: u64 = (((arg1[4]) as u64) * (x18 as u64));
  let x148: u64 = (((arg1[4]) as u64) * ((x21 * 0x2) as u64));
  let x149: u64 = (((arg1[4]) as u64) * (x24 as u64));
  let x150: u64 = (((arg1[4]) as u64) * ((x27 * 0x2) as u64));
  let x151: u64 = (((arg1[4]) as u64) * (x28 as u64));
  let x152: u64 = (((arg1[4]) as u64) * (x29 as u64));
  let x153: u64 = (((arg1[4]) as u64) * (x30 as u64));
  let x154: u64 = (((arg1[4]) as u64) * (x31 as u64));
  let x155: u64 = (((arg1[4]) as u64) * ((x32 * 0x2) as u64));
  let x156: u64 = (((arg1[4]) as u64) * ((arg1[4]) as u64));
  let x157: u64 = (((arg1[3]) as u64) * ((x2 * 0x2) as u64));
  let x158: u64 = (((arg1[3]) as u64) * ((x5 * 0x2) as u64));
  let x159: u64 = (((arg1[3]) as u64) * ((x8 * 0x2) as u64));
  let x160: u64 = (((arg1[3]) as u64) * ((x12 * 0x2) as u64));
  let x161: u64 = (((arg1[3]) as u64) * (x15 as u64));
  let x162: u64 = (((arg1[3]) as u64) * ((x18 * 0x2) as u64));
  let x163: u64 = (((arg1[3]) as u64) * ((x21 * 0x2) as u64));
  let x164: u64 = (((arg1[3]) as u64) * ((x24 * 0x2) as u64));
  let x165: u64 = (((arg1[3]) as u64) * ((x27 * 0x2) as u64));
  let x166: u64 = (((arg1[3]) as u64) * (x28 as u64));
  let x167: u64 = (((arg1[3]) as u64) * ((x29 * 0x2) as u64));
  let x168: u64 = (((arg1[3]) as u64) * (x30 as u64));
  let x169: u64 = (((arg1[3]) as u64) * ((x31 * 0x2) as u64));
  let x170: u64 = (((arg1[3]) as u64) * ((x32 * 0x2) as u64));
  let x171: u64 = (((arg1[3]) as u64) * ((x33 * 0x2) as u64));
  let x172: u64 = (((arg1[3]) as u64) * (((arg1[3]) * 0x2) as u64));
  let x173: u64 = (((arg1[2]) as u64) * (x2 as u64));
  let x174: u64 = (((arg1[2]) as u64) * ((x5 * 0x2) as u64));
  let x175: u64 = (((arg1[2]) as u64) * (x9 as u64));
  let x176: u64 = (((arg1[2]) as u64) * (x12 as u64));
  let x177: u64 = (((arg1[2]) as u64) * (x15 as u64));
  let x178: u64 = (((arg1[2]) as u64) * (x18 as u64));
  let x179: u64 = (((arg1[2]) as u64) * ((x21 * 0x2) as u64));
  let x180: u64 = (((arg1[2]) as u64) * (x24 as u64));
  let x181: u64 = (((arg1[2]) as u64) * (x27 as u64));
  let x182: u64 = (((arg1[2]) as u64) * (x28 as u64));
  let x183: u64 = (((arg1[2]) as u64) * (x29 as u64));
  let x184: u64 = (((arg1[2]) as u64) * (x30 as u64));
  let x185: u64 = (((arg1[2]) as u64) * (x31 as u64));
  let x186: u64 = (((arg1[2]) as u64) * ((x32 * 0x2) as u64));
  let x187: u64 = (((arg1[2]) as u64) * (x33 as u64));
  let x188: u64 = (((arg1[2]) as u64) * (x34 as u64));
  let x189: u64 = (((arg1[2]) as u64) * ((arg1[2]) as u64));
  let x190: u64 = (((arg1[1]) as u64) * ((x2 * 0x2) as u64));
  let x191: u64 = (((arg1[1]) as u64) * ((x6 * 0x2) as u64));
  let x192: u64 = (((arg1[1]) as u64) * (x9 as u64));
  let x193: u64 = (((arg1[1]) as u64) * ((x12 * 0x2) as u64));
  let x194: u64 = (((arg1[1]) as u64) * (x15 as u64));
  let x195: u64 = (((arg1[1]) as u64) * ((x18 * 0x2) as u64));
  let x196: u64 = (((arg1[1]) as u64) * ((x21 * 0x2) as u64));
  let x197: u64 = (((arg1[1]) as u64) * (x24 as u64));
  let x198: u64 = (((arg1[1]) as u64) * ((x27 * 0x2) as u64));
  let x199: u64 = (((arg1[1]) as u64) * (x28 as u64));
  let x200: u64 = (((arg1[1]) as u64) * ((x29 * 0x2) as u64));
  let x201: u64 = (((arg1[1]) as u64) * (x30 as u64));
  let x202: u64 = (((arg1[1]) as u64) * ((x31 * 0x2) as u64));
  let x203: u64 = (((arg1[1]) as u64) * ((x32 * 0x2) as u64));
  let x204: u64 = (((arg1[1]) as u64) * (x33 as u64));
  let x205: u64 = (((arg1[1]) as u64) * ((x34 * 0x2) as u64));
  let x206: u64 = (((arg1[1]) as u64) * (x35 as u64));
  let x207: u64 = (((arg1[1]) as u64) * (((arg1[1]) * 0x2) as u64));
  let x208: u64 = (((arg1[0]) as u64) * (x3 as u64));
  let x209: u64 = (((arg1[0]) as u64) * (x6 as u64));
  let x210: u64 = (((arg1[0]) as u64) * (x9 as u64));
  let x211: u64 = (((arg1[0]) as u64) * (x12 as u64));
  let x212: u64 = (((arg1[0]) as u64) * (x15 as u64));
  let x213: u64 = (((arg1[0]) as u64) * (x18 as u64));
  let x214: u64 = (((arg1[0]) as u64) * (x21 as u64));
  let x215: u64 = (((arg1[0]) as u64) * (x24 as u64));
  let x216: u64 = (((arg1[0]) as u64) * (x27 as u64));
  let x217: u64 = (((arg1[0]) as u64) * (x28 as u64));
  let x218: u64 = (((arg1[0]) as u64) * (x29 as u64));
  let x219: u64 = (((arg1[0]) as u64) * (x30 as u64));
  let x220: u64 = (((arg1[0]) as u64) * (x31 as u64));
  let x221: u64 = (((arg1[0]) as u64) * (x32 as u64));
  let x222: u64 = (((arg1[0]) as u64) * (x33 as u64));
  let x223: u64 = (((arg1[0]) as u64) * (x34 as u64));
  let x224: u64 = (((arg1[0]) as u64) * (x35 as u64));
  let x225: u64 = (((arg1[0]) as u64) * (x36 as u64));
  let x226: u64 = (((arg1[0]) as u64) * ((arg1[0]) as u64));
  let x227: u64 = (x226 + (x190 + (x174 + (x159 + (x145 + (x132 + (x120 + (x109 + (x99 + x90)))))))));
  let x228: u64 = (x227 >> 28);
  let x229: u32 = ((x227 & (0xfffffff as u64)) as u32);
  let x230: u64 = (x208 + (x191 + (x175 + (x160 + (x146 + (x133 + (x121 + (x110 + (x100 + x91)))))))));
  let x231: u64 = (x209 + (x192 + (x176 + (x161 + (x147 + (x134 + (x122 + (x111 + (x101 + x37)))))))));
  let x232: u64 = (x210 + (x193 + (x177 + (x162 + (x148 + (x135 + (x123 + (x112 + (x102 + x38)))))))));
  let x233: u64 = (x211 + (x194 + (x178 + (x163 + (x149 + (x136 + (x124 + (x113 + (x40 + x39)))))))));
  let x234: u64 = (x212 + (x195 + (x179 + (x164 + (x150 + (x137 + (x125 + (x114 + (x43 + x41)))))))));
  let x235: u64 = (x213 + (x196 + (x180 + (x165 + (x151 + (x138 + (x126 + (x47 + (x44 + x42)))))))));
  let x236: u64 = (x214 + (x197 + (x181 + (x166 + (x152 + (x139 + (x127 + (x52 + (x48 + x45)))))))));
  let x237: u64 = (x215 + (x198 + (x182 + (x167 + (x153 + (x140 + (x58 + (x53 + (x49 + x46)))))))));
  let x238: u64 = (x216 + (x199 + (x183 + (x168 + (x154 + (x141 + (x65 + (x59 + (x54 + x50)))))))));
  let x239: u64 = (x217 + (x200 + (x184 + (x169 + (x155 + (x73 + (x66 + (x60 + (x55 + x51)))))))));
  let x240: u64 = (x218 + (x201 + (x185 + (x170 + (x156 + (x82 + (x74 + (x67 + (x61 + x56)))))))));
  let x241: u64 = (x219 + (x202 + (x186 + (x171 + (x92 + (x83 + (x75 + (x68 + (x62 + x57)))))))));
  let x242: u64 = (x220 + (x203 + (x187 + (x172 + (x103 + (x93 + (x84 + (x76 + (x69 + x63)))))))));
  let x243: u64 = (x221 + (x204 + (x188 + (x115 + (x104 + (x94 + (x85 + (x77 + (x70 + x64)))))))));
  let x244: u64 = (x222 + (x205 + (x189 + (x128 + (x116 + (x105 + (x95 + (x86 + (x78 + x71)))))))));
  let x245: u64 = (x223 + (x206 + (x142 + (x129 + (x117 + (x106 + (x96 + (x87 + (x79 + x72)))))))));
  let x246: u64 = (x224 + (x207 + (x157 + (x143 + (x130 + (x118 + (x107 + (x97 + (x88 + x80)))))))));
  let x247: u64 = (x225 + (x173 + (x158 + (x144 + (x131 + (x119 + (x108 + (x98 + (x89 + x81)))))))));
  let x248: u64 = (x228 + x247);
  let x249: u64 = (x248 >> 27);
  let x250: u32 = ((x248 & (0x7ffffff as u64)) as u32);
  let x251: u64 = (x249 + x246);
  let x252: u64 = (x251 >> 28);
  let x253: u32 = ((x251 & (0xfffffff as u64)) as u32);
  let x254: u64 = (x252 + x245);
  let x255: u64 = (x254 >> 27);
  let x256: u32 = ((x254 & (0x7ffffff as u64)) as u32);
  let x257: u64 = (x255 + x244);
  let x258: u64 = (x257 >> 28);
  let x259: u32 = ((x257 & (0xfffffff as u64)) as u32);
  let x260: u64 = (x258 + x243);
  let x261: u64 = (x260 >> 27);
  let x262: u32 = ((x260 & (0x7ffffff as u64)) as u32);
  let x263: u64 = (x261 + x242);
  let x264: u64 = (x263 >> 27);
  let x265: u32 = ((x263 & (0x7ffffff as u64)) as u32);
  let x266: u64 = (x264 + x241);
  let x267: u64 = (x266 >> 28);
  let x268: u32 = ((x266 & (0xfffffff as u64)) as u32);
  let x269: u64 = (x267 + x240);
  let x270: u64 = (x269 >> 27);
  let x271: u32 = ((x269 & (0x7ffffff as u64)) as u32);
  let x272: u64 = (x270 + x239);
  let x273: u64 = (x272 >> 28);
  let x274: u32 = ((x272 & (0xfffffff as u64)) as u32);
  let x275: u64 = (x273 + x238);
  let x276: u64 = (x275 >> 27);
  let x277: u32 = ((x275 & (0x7ffffff as u64)) as u32);
  let x278: u64 = (x276 + x237);
  let x279: u64 = (x278 >> 28);
  let x280: u32 = ((x278 & (0xfffffff as u64)) as u32);
  let x281: u64 = (x279 + x236);
  let x282: u64 = (x281 >> 27);
  let x283: u32 = ((x281 & (0x7ffffff as u64)) as u32);
  let x284: u64 = (x282 + x235);
  let x285: u64 = (x284 >> 27);
  let x286: u32 = ((x284 & (0x7ffffff as u64)) as u32);
  let x287: u64 = (x285 + x234);
  let x288: u64 = (x287 >> 28);
  let x289: u32 = ((x287 & (0xfffffff as u64)) as u32);
  let x290: u64 = (x288 + x233);
  let x291: u64 = (x290 >> 27);
  let x292: u32 = ((x290 & (0x7ffffff as u64)) as u32);
  let x293: u64 = (x291 + x232);
  let x294: u64 = (x293 >> 28);
  let x295: u32 = ((x293 & (0xfffffff as u64)) as u32);
  let x296: u64 = (x294 + x231);
  let x297: u64 = (x296 >> 27);
  let x298: u32 = ((x296 & (0x7ffffff as u64)) as u32);
  let x299: u64 = (x297 + x230);
  let x300: u64 = (x299 >> 27);
  let x301: u32 = ((x299 & (0x7ffffff as u64)) as u32);
  let x302: u64 = ((x229 as u64) + x300);
  let x303: u32 = ((x302 >> 28) as u32);
  let x304: u32 = ((x302 & (0xfffffff as u64)) as u32);
  let x305: u32 = (x303 + x250);
  let x306: fiat_p521_u1 = ((x305 >> 27) as fiat_p521_u1);
  let x307: u32 = (x305 & 0x7ffffff);
  let x308: u32 = ((x306 as u32) + x253);
  out1[0] = x304;
  out1[1] = x307;
  out1[2] = x308;
  out1[3] = x256;
  out1[4] = x259;
  out1[5] = x262;
  out1[6] = x265;
  out1[7] = x268;
  out1[8] = x271;
  out1[9] = x274;
  out1[10] = x277;
  out1[11] = x280;
  out1[12] = x283;
  out1[13] = x286;
  out1[14] = x289;
  out1[15] = x292;
  out1[16] = x295;
  out1[17] = x298;
  out1[18] = x301;
}

/// The function fiat_p521_carry reduces a field element.
///
/// Postconditions:
///   eval out1 mod m = eval arg1 mod m
///
#[inline]
pub fn fiat_p521_carry(out1: &mut fiat_p521_tight_field_element, arg1: &fiat_p521_loose_field_element) {
  let x1: u32 = (arg1[0]);
  let x2: u32 = ((x1 >> 28) + (arg1[1]));
  let x3: u32 = ((x2 >> 27) + (arg1[2]));
  let x4: u32 = ((x3 >> 28) + (arg1[3]));
  let x5: u32 = ((x4 >> 27) + (arg1[4]));
  let x6: u32 = ((x5 >> 28) + (arg1[5]));
  let x7: u32 = ((x6 >> 27) + (arg1[6]));
  let x8: u32 = ((x7 >> 27) + (arg1[7]));
  let x9: u32 = ((x8 >> 28) + (arg1[8]));
  let x10: u32 = ((x9 >> 27) + (arg1[9]));
  let x11: u32 = ((x10 >> 28) + (arg1[10]));
  let x12: u32 = ((x11 >> 27) + (arg1[11]));
  let x13: u32 = ((x12 >> 28) + (arg1[12]));
  let x14: u32 = ((x13 >> 27) + (arg1[13]));
  let x15: u32 = ((x14 >> 27) + (arg1[14]));
  let x16: u32 = ((x15 >> 28) + (arg1[15]));
  let x17: u32 = ((x16 >> 27) + (arg1[16]));
  let x18: u32 = ((x17 >> 28) + (arg1[17]));
  let x19: u32 = ((x18 >> 27) + (arg1[18]));
  let x20: u32 = ((x1 & 0xfffffff) + (x19 >> 27));
  let x21: u32 = ((((x20 >> 28) as fiat_p521_u1) as u32) + (x2 & 0x7ffffff));
  let x22: u32 = (x20 & 0xfffffff);
  let x23: u32 = (x21 & 0x7ffffff);
  let x24: u32 = ((((x21 >> 27) as fiat_p521_u1) as u32) + (x3 & 0xfffffff));
  let x25: u32 = (x4 & 0x7ffffff);
  let x26: u32 = (x5 & 0xfffffff);
  let x27: u32 = (x6 & 0x7ffffff);
  let x28: u32 = (x7 & 0x7ffffff);
  let x29: u32 = (x8 & 0xfffffff);
  let x30: u32 = (x9 & 0x7ffffff);
  let x31: u32 = (x10 & 0xfffffff);
  let x32: u32 = (x11 & 0x7ffffff);
  let x33: u32 = (x12 & 0xfffffff);
  let x34: u32 = (x13 & 0x7ffffff);
  let x35: u32 = (x14 & 0x7ffffff);
  let x36: u32 = (x15 & 0xfffffff);
  let x37: u32 = (x16 & 0x7ffffff);
  let x38: u32 = (x17 & 0xfffffff);
  let x39: u32 = (x18 & 0x7ffffff);
  let x40: u32 = (x19 & 0x7ffffff);
  out1[0] = x22;
  out1[1] = x23;
  out1[2] = x24;
  out1[3] = x25;
  out1[4] = x26;
  out1[5] = x27;
  out1[6] = x28;
  out1[7] = x29;
  out1[8] = x30;
  out1[9] = x31;
  out1[10] = x32;
  out1[11] = x33;
  out1[12] = x34;
  out1[13] = x35;
  out1[14] = x36;
  out1[15] = x37;
  out1[16] = x38;
  out1[17] = x39;
  out1[18] = x40;
}

/// The function fiat_p521_add adds two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 + eval arg2) mod m
///
#[inline]
pub fn fiat_p521_add(out1: &mut fiat_p521_loose_field_element, arg1: &fiat_p521_tight_field_element, arg2: &fiat_p521_tight_field_element) {
  let x1: u32 = ((arg1[0]) + (arg2[0]));
  let x2: u32 = ((arg1[1]) + (arg2[1]));
  let x3: u32 = ((arg1[2]) + (arg2[2]));
  let x4: u32 = ((arg1[3]) + (arg2[3]));
  let x5: u32 = ((arg1[4]) + (arg2[4]));
  let x6: u32 = ((arg1[5]) + (arg2[5]));
  let x7: u32 = ((arg1[6]) + (arg2[6]));
  let x8: u32 = ((arg1[7]) + (arg2[7]));
  let x9: u32 = ((arg1[8]) + (arg2[8]));
  let x10: u32 = ((arg1[9]) + (arg2[9]));
  let x11: u32 = ((arg1[10]) + (arg2[10]));
  let x12: u32 = ((arg1[11]) + (arg2[11]));
  let x13: u32 = ((arg1[12]) + (arg2[12]));
  let x14: u32 = ((arg1[13]) + (arg2[13]));
  let x15: u32 = ((arg1[14]) + (arg2[14]));
  let x16: u32 = ((arg1[15]) + (arg2[15]));
  let x17: u32 = ((arg1[16]) + (arg2[16]));
  let x18: u32 = ((arg1[17]) + (arg2[17]));
  let x19: u32 = ((arg1[18]) + (arg2[18]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
  out1[16] = x17;
  out1[17] = x18;
  out1[18] = x19;
}

/// The function fiat_p521_sub subtracts two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 - eval arg2) mod m
///
#[inline]
pub fn fiat_p521_sub(out1: &mut fiat_p521_loose_field_element, arg1: &fiat_p521_tight_field_element, arg2: &fiat_p521_tight_field_element) {
  let x1: u32 = ((0x1ffffffe + (arg1[0])) - (arg2[0]));
  let x2: u32 = ((0xffffffe + (arg1[1])) - (arg2[1]));
  let x3: u32 = ((0x1ffffffe + (arg1[2])) - (arg2[2]));
  let x4: u32 = ((0xffffffe + (arg1[3])) - (arg2[3]));
  let x5: u32 = ((0x1ffffffe + (arg1[4])) - (arg2[4]));
  let x6: u32 = ((0xffffffe + (arg1[5])) - (arg2[5]));
  let x7: u32 = ((0xffffffe + (arg1[6])) - (arg2[6]));
  let x8: u32 = ((0x1ffffffe + (arg1[7])) - (arg2[7]));
  let x9: u32 = ((0xffffffe + (arg1[8])) - (arg2[8]));
  let x10: u32 = ((0x1ffffffe + (arg1[9])) - (arg2[9]));
  let x11: u32 = ((0xffffffe + (arg1[10])) - (arg2[10]));
  let x12: u32 = ((0x1ffffffe + (arg1[11])) - (arg2[11]));
  let x13: u32 = ((0xffffffe + (arg1[12])) - (arg2[12]));
  let x14: u32 = ((0xffffffe + (arg1[13])) - (arg2[13]));
  let x15: u32 = ((0x1ffffffe + (arg1[14])) - (arg2[14]));
  let x16: u32 = ((0xffffffe + (arg1[15])) - (arg2[15]));
  let x17: u32 = ((0x1ffffffe + (arg1[16])) - (arg2[16]));
  let x18: u32 = ((0xffffffe + (arg1[17])) - (arg2[17]));
  let x19: u32 = ((0xffffffe + (arg1[18])) - (arg2[18]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
  out1[16] = x17;
  out1[17] = x18;
  out1[18] = x19;
}

/// The function fiat_p521_opp negates a field element.
///
/// Postconditions:
///   eval out1 mod m = -eval arg1 mod m
///
#[inline]
pub fn fiat_p521_opp(out1: &mut fiat_p521_loose_field_element, arg1: &fiat_p521_tight_field_element) {
  let x1: u32 = (0x1ffffffe - (arg1[0]));
  let x2: u32 = (0xffffffe - (arg1[1]));
  let x3: u32 = (0x1ffffffe - (arg1[2]));
  let x4: u32 = (0xffffffe - (arg1[3]));
  let x5: u32 = (0x1ffffffe - (arg1[4]));
  let x6: u32 = (0xffffffe - (arg1[5]));
  let x7: u32 = (0xffffffe - (arg1[6]));
  let x8: u32 = (0x1ffffffe - (arg1[7]));
  let x9: u32 = (0xffffffe - (arg1[8]));
  let x10: u32 = (0x1ffffffe - (arg1[9]));
  let x11: u32 = (0xffffffe - (arg1[10]));
  let x12: u32 = (0x1ffffffe - (arg1[11]));
  let x13: u32 = (0xffffffe - (arg1[12]));
  let x14: u32 = (0xffffffe - (arg1[13]));
  let x15: u32 = (0x1ffffffe - (arg1[14]));
  let x16: u32 = (0xffffffe - (arg1[15]));
  let x17: u32 = (0x1ffffffe - (arg1[16]));
  let x18: u32 = (0xffffffe - (arg1[17]));
  let x19: u32 = (0xffffffe - (arg1[18]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
  out1[16] = x17;
  out1[17] = x18;
  out1[18] = x19;
}

/// The function fiat_p521_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p521_selectznz(out1: &mut [u32; 19], arg1: fiat_p521_u1, arg2: &[u32; 19], arg3: &[u32; 19]) {
  let mut x1: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x8, arg1, (arg2[7]), (arg3[7]));
  let mut x9: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x9, arg1, (arg2[8]), (arg3[8]));
  let mut x10: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x10, arg1, (arg2[9]), (arg3[9]));
  let mut x11: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x11, arg1, (arg2[10]), (arg3[10]));
  let mut x12: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x12, arg1, (arg2[11]), (arg3[11]));
  let mut x13: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x13, arg1, (arg2[12]), (arg3[12]));
  let mut x14: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x14, arg1, (arg2[13]), (arg3[13]));
  let mut x15: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x15, arg1, (arg2[14]), (arg3[14]));
  let mut x16: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x16, arg1, (arg2[15]), (arg3[15]));
  let mut x17: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x17, arg1, (arg2[16]), (arg3[16]));
  let mut x18: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x18, arg1, (arg2[17]), (arg3[17]));
  let mut x19: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x19, arg1, (arg2[18]), (arg3[18]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
  out1[16] = x17;
  out1[17] = x18;
  out1[18] = x19;
}

/// The function fiat_p521_to_bytes serializes a field element to bytes in little-endian order.
///
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..65]
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
#[inline]
pub fn fiat_p521_to_bytes(out1: &mut [u8; 66], arg1: &fiat_p521_tight_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u28(&mut x1, &mut x2, 0x0, (arg1[0]), 0xfffffff);
  let mut x3: u32 = 0;
  let mut x4: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x3, &mut x4, x2, (arg1[1]), 0x7ffffff);
  let mut x5: u32 = 0;
  let mut x6: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u28(&mut x5, &mut x6, x4, (arg1[2]), 0xfffffff);
  let mut x7: u32 = 0;
  let mut x8: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x7, &mut x8, x6, (arg1[3]), 0x7ffffff);
  let mut x9: u32 = 0;
  let mut x10: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u28(&mut x9, &mut x10, x8, (arg1[4]), 0xfffffff);
  let mut x11: u32 = 0;
  let mut x12: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x11, &mut x12, x10, (arg1[5]), 0x7ffffff);
  let mut x13: u32 = 0;
  let mut x14: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x13, &mut x14, x12, (arg1[6]), 0x7ffffff);
  let mut x15: u32 = 0;
  let mut x16: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u28(&mut x15, &mut x16, x14, (arg1[7]), 0xfffffff);
  let mut x17: u32 = 0;
  let mut x18: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x17, &mut x18, x16, (arg1[8]), 0x7ffffff);
  let mut x19: u32 = 0;
  let mut x20: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u28(&mut x19, &mut x20, x18, (arg1[9]), 0xfffffff);
  let mut x21: u32 = 0;
  let mut x22: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x21, &mut x22, x20, (arg1[10]), 0x7ffffff);
  let mut x23: u32 = 0;
  let mut x24: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u28(&mut x23, &mut x24, x22, (arg1[11]), 0xfffffff);
  let mut x25: u32 = 0;
  let mut x26: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x25, &mut x26, x24, (arg1[12]), 0x7ffffff);
  let mut x27: u32 = 0;
  let mut x28: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x27, &mut x28, x26, (arg1[13]), 0x7ffffff);
  let mut x29: u32 = 0;
  let mut x30: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u28(&mut x29, &mut x30, x28, (arg1[14]), 0xfffffff);
  let mut x31: u32 = 0;
  let mut x32: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x31, &mut x32, x30, (arg1[15]), 0x7ffffff);
  let mut x33: u32 = 0;
  let mut x34: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u28(&mut x33, &mut x34, x32, (arg1[16]), 0xfffffff);
  let mut x35: u32 = 0;
  let mut x36: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x35, &mut x36, x34, (arg1[17]), 0x7ffffff);
  let mut x37: u32 = 0;
  let mut x38: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u27(&mut x37, &mut x38, x36, (arg1[18]), 0x7ffffff);
  let mut x39: u32 = 0;
  fiat_p521_cmovznz_u32(&mut x39, x38, (0x0 as u32), 0xffffffff);
  let mut x40: u32 = 0;
  let mut x41: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u28(&mut x40, &mut x41, 0x0, x1, (x39 & 0xfffffff));
  let mut x42: u32 = 0;
  let mut x43: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x42, &mut x43, x41, x3, (x39 & 0x7ffffff));
  let mut x44: u32 = 0;
  let mut x45: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u28(&mut x44, &mut x45, x43, x5, (x39 & 0xfffffff));
  let mut x46: u32 = 0;
  let mut x47: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x46, &mut x47, x45, x7, (x39 & 0x7ffffff));
  let mut x48: u32 = 0;
  let mut x49: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u28(&mut x48, &mut x49, x47, x9, (x39 & 0xfffffff));
  let mut x50: u32 = 0;
  let mut x51: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x50, &mut x51, x49, x11, (x39 & 0x7ffffff));
  let mut x52: u32 = 0;
  let mut x53: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x52, &mut x53, x51, x13, (x39 & 0x7ffffff));
  let mut x54: u32 = 0;
  let mut x55: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u28(&mut x54, &mut x55, x53, x15, (x39 & 0xfffffff));
  let mut x56: u32 = 0;
  let mut x57: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x56, &mut x57, x55, x17, (x39 & 0x7ffffff));
  let mut x58: u32 = 0;
  let mut x59: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u28(&mut x58, &mut x59, x57, x19, (x39 & 0xfffffff));
  let mut x60: u32 = 0;
  let mut x61: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x60, &mut x61, x59, x21, (x39 & 0x7ffffff));
  let mut x62: u32 = 0;
  let mut x63: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u28(&mut x62, &mut x63, x61, x23, (x39 & 0xfffffff));
  let mut x64: u32 = 0;
  let mut x65: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x64, &mut x65, x63, x25, (x39 & 0x7ffffff));
  let mut x66: u32 = 0;
  let mut x67: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x66, &mut x67, x65, x27, (x39 & 0x7ffffff));
  let mut x68: u32 = 0;
  let mut x69: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u28(&mut x68, &mut x69, x67, x29, (x39 & 0xfffffff));
  let mut x70: u32 = 0;
  let mut x71: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x70, &mut x71, x69, x31, (x39 & 0x7ffffff));
  let mut x72: u32 = 0;
  let mut x73: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u28(&mut x72, &mut x73, x71, x33, (x39 & 0xfffffff));
  let mut x74: u32 = 0;
  let mut x75: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x74, &mut x75, x73, x35, (x39 & 0x7ffffff));
  let mut x76: u32 = 0;
  let mut x77: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u27(&mut x76, &mut x77, x75, x37, (x39 & 0x7ffffff));
  let x78: u64 = ((x76 as u64) << 6);
  let x79: u32 = (x74 << 3);
  let x80: u64 = ((x72 as u64) << 7);
  let x81: u32 = (x70 << 4);
  let x82: u32 = (x66 << 5);
  let x83: u32 = (x64 << 2);
  let x84: u64 = ((x62 as u64) << 6);
  let x85: u32 = (x60 << 3);
  let x86: u64 = ((x58 as u64) << 7);
  let x87: u32 = (x56 << 4);
  let x88: u32 = (x52 << 5);
  let x89: u32 = (x50 << 2);
  let x90: u64 = ((x48 as u64) << 6);
  let x91: u32 = (x46 << 3);
  let x92: u64 = ((x44 as u64) << 7);
  let x93: u32 = (x42 << 4);
  let x94: u8 = ((x40 & (0xff as u32)) as u8);
  let x95: u32 = (x40 >> 8);
  let x96: u8 = ((x95 & (0xff as u32)) as u8);
  let x97: u32 = (x95 >> 8);
  let x98: u8 = ((x97 & (0xff as u32)) as u8);
  let x99: u8 = ((x97 >> 8) as u8);
  let x100: u32 = (x93 + (x99 as u32));
  let x101: u8 = ((x100 & (0xff as u32)) as u8);
  let x102: u32 = (x100 >> 8);
  let x103: u8 = ((x102 & (0xff as u32)) as u8);
  let x104: u32 = (x102 >> 8);
  let x105: u8 = ((x104 & (0xff as u32)) as u8);
  let x106: u8 = ((x104 >> 8) as u8);
  let x107: u64 = (x92 + (x106 as u64));
  let x108: u8 = ((x107 & (0xff as u64)) as u8);
  let x109: u32 = ((x107 >> 8) as u32);
  let x110: u8 = ((x109 & (0xff as u32)) as u8);
  let x111: u32 = (x109 >> 8);
  let x112: u8 = ((x111 & (0xff as u32)) as u8);
  let x113: u32 = (x111 >> 8);
  let x114: u8 = ((x113 & (0xff as u32)) as u8);
  let x115: u8 = ((x113 >> 8) as u8);
  let x116: u32 = (x91 + (x115 as u32));
  let x117: u8 = ((x116 & (0xff as u32)) as u8);
  let x118: u32 = (x116 >> 8);
  let x119: u8 = ((x118 & (0xff as u32)) as u8);
  let x120: u32 = (x118 >> 8);
  let x121: u8 = ((x120 & (0xff as u32)) as u8);
  let x122: u8 = ((x120 >> 8) as u8);
  let x123: u64 = (x90 + (x122 as u64));
  let x124: u8 = ((x123 & (0xff as u64)) as u8);
  let x125: u32 = ((x123 >> 8) as u32);
  let x126: u8 = ((x125 & (0xff as u32)) as u8);
  let x127: u32 = (x125 >> 8);
  let x128: u8 = ((x127 & (0xff as u32)) as u8);
  let x129: u32 = (x127 >> 8);
  let x130: u8 = ((x129 & (0xff as u32)) as u8);
  let x131: u8 = ((x129 >> 8) as u8);
  let x132: u32 = (x89 + (x131 as u32));
  let x133: u8 = ((x132 & (0xff as u32)) as u8);
  let x134: u32 = (x132 >> 8);
  let x135: u8 = ((x134 & (0xff as u32)) as u8);
  let x136: u32 = (x134 >> 8);
  let x137: u8 = ((x136 & (0xff as u32)) as u8);
  let x138: u8 = ((x136 >> 8) as u8);
  let x139: u32 = (x88 + (x138 as u32));
  let x140: u8 = ((x139 & (0xff as u32)) as u8);
  let x141: u32 = (x139 >> 8);
  let x142: u8 = ((x141 & (0xff as u32)) as u8);
  let x143: u32 = (x141 >> 8);
  let x144: u8 = ((x143 & (0xff as u32)) as u8);
  let x145: u8 = ((x143 >> 8) as u8);
  let x146: u8 = ((x54 & (0xff as u32)) as u8);
  let x147: u32 = (x54 >> 8);
  let x148: u8 = ((x147 & (0xff as u32)) as u8);
  let x149: u32 = (x147 >> 8);
  let x150: u8 = ((x149 & (0xff as u32)) as u8);
  let x151: u8 = ((x149 >> 8) as u8);
  let x152: u32 = (x87 + (x151 as u32));
  let x153: u8 = ((x152 & (0xff as u32)) as u8);
  let x154: u32 = (x152 >> 8);
  let x155: u8 = ((x154 & (0xff as u32)) as u8);
  let x156: u32 = (x154 >> 8);
  let x157: u8 = ((x156 & (0xff as u32)) as u8);
  let x158: u8 = ((x156 >> 8) as u8);
  let x159: u64 = (x86 + (x158 as u64));
  let x160: u8 = ((x159 & (0xff as u64)) as u8);
  let x161: u32 = ((x159 >> 8) as u32);
  let x162: u8 = ((x161 & (0xff as u32)) as u8);
  let x163: u32 = (x161 >> 8);
  let x164: u8 = ((x163 & (0xff as u32)) as u8);
  let x165: u32 = (x163 >> 8);
  let x166: u8 = ((x165 & (0xff as u32)) as u8);
  let x167: u8 = ((x165 >> 8) as u8);
  let x168: u32 = (x85 + (x167 as u32));
  let x169: u8 = ((x168 & (0xff as u32)) as u8);
  let x170: u32 = (x168 >> 8);
  let x171: u8 = ((x170 & (0xff as u32)) as u8);
  let x172: u32 = (x170 >> 8);
  let x173: u8 = ((x172 & (0xff as u32)) as u8);
  let x174: u8 = ((x172 >> 8) as u8);
  let x175: u64 = (x84 + (x174 as u64));
  let x176: u8 = ((x175 & (0xff as u64)) as u8);
  let x177: u32 = ((x175 >> 8) as u32);
  let x178: u8 = ((x177 & (0xff as u32)) as u8);
  let x179: u32 = (x177 >> 8);
  let x180: u8 = ((x179 & (0xff as u32)) as u8);
  let x181: u32 = (x179 >> 8);
  let x182: u8 = ((x181 & (0xff as u32)) as u8);
  let x183: u8 = ((x181 >> 8) as u8);
  let x184: u32 = (x83 + (x183 as u32));
  let x185: u8 = ((x184 & (0xff as u32)) as u8);
  let x186: u32 = (x184 >> 8);
  let x187: u8 = ((x186 & (0xff as u32)) as u8);
  let x188: u32 = (x186 >> 8);
  let x189: u8 = ((x188 & (0xff as u32)) as u8);
  let x190: u8 = ((x188 >> 8) as u8);
  let x191: u32 = (x82 + (x190 as u32));
  let x192: u8 = ((x191 & (0xff as u32)) as u8);
  let x193: u32 = (x191 >> 8);
  let x194: u8 = ((x193 & (0xff as u32)) as u8);
  let x195: u32 = (x193 >> 8);
  let x196: u8 = ((x195 & (0xff as u32)) as u8);
  let x197: u8 = ((x195 >> 8) as u8);
  let x198: u8 = ((x68 & (0xff as u32)) as u8);
  let x199: u32 = (x68 >> 8);
  let x200: u8 = ((x199 & (0xff as u32)) as u8);
  let x201: u32 = (x199 >> 8);
  let x202: u8 = ((x201 & (0xff as u32)) as u8);
  let x203: u8 = ((x201 >> 8) as u8);
  let x204: u32 = (x81 + (x203 as u32));
  let x205: u8 = ((x204 & (0xff as u32)) as u8);
  let x206: u32 = (x204 >> 8);
  let x207: u8 = ((x206 & (0xff as u32)) as u8);
  let x208: u32 = (x206 >> 8);
  let x209: u8 = ((x208 & (0xff as u32)) as u8);
  let x210: u8 = ((x208 >> 8) as u8);
  let x211: u64 = (x80 + (x210 as u64));
  let x212: u8 = ((x211 & (0xff as u64)) as u8);
  let x213: u32 = ((x211 >> 8) as u32);
  let x214: u8 = ((x213 & (0xff as u32)) as u8);
  let x215: u32 = (x213 >> 8);
  let x216: u8 = ((x215 & (0xff as u32)) as u8);
  let x217: u32 = (x215 >> 8);
  let x218: u8 = ((x217 & (0xff as u32)) as u8);
  let x219: u8 = ((x217 >> 8) as u8);
  let x220: u32 = (x79 + (x219 as u32));
  let x221: u8 = ((x220 & (0xff as u32)) as u8);
  let x222: u32 = (x220 >> 8);
  let x223: u8 = ((x222 & (0xff as u32)) as u8);
  let x224: u32 = (x222 >> 8);
  let x225: u8 = ((x224 & (0xff as u32)) as u8);
  let x226: u8 = ((x224 >> 8) as u8);
  let x227: u64 = (x78 + (x226 as u64));
  let x228: u8 = ((x227 & (0xff as u64)) as u8);
  let x229: u32 = ((x227 >> 8) as u32);
  let x230: u8 = ((x229 & (0xff as u32)) as u8);
  let x231: u32 = (x229 >> 8);
  let x232: u8 = ((x231 & (0xff as u32)) as u8);
  let x233: u32 = (x231 >> 8);
  let x234: u8 = ((x233 & (0xff as u32)) as u8);
  let x235: fiat_p521_u1 = ((x233 >> 8) as fiat_p521_u1);
  out1[0] = x94;
  out1[1] = x96;
  out1[2] = x98;
  out1[3] = x101;
  out1[4] = x103;
  out1[5] = x105;
  out1[6] = x108;
  out1[7] = x110;
  out1[8] = x112;
  out1[9] = x114;
  out1[10] = x117;
  out1[11] = x119;
  out1[12] = x121;
  out1[13] = x124;
  out1[14] = x126;
  out1[15] = x128;
  out1[16] = x130;
  out1[17] = x133;
  out1[18] = x135;
  out1[19] = x137;
  out1[20] = x140;
  out1[21] = x142;
  out1[22] = x144;
  out1[23] = x145;
  out1[24] = x146;
  out1[25] = x148;
  out1[26] = x150;
  out1[27] = x153;
  out1[28] = x155;
  out1[29] = x157;
  out1[30] = x160;
  out1[31] = x162;
  out1[32] = x164;
  out1[33] = x166;
  out1[34] = x169;
  out1[35] = x171;
  out1[36] = x173;
  out1[37] = x176;
  out1[38] = x178;
  out1[39] = x180;
  out1[40] = x182;
  out1[41] = x185;
  out1[42] = x187;
  out1[43] = x189;
  out1[44] = x192;
  out1[45] = x194;
  out1[46] = x196;
  out1[47] = x197;
  out1[48] = x198;
  out1[49] = x200;
  out1[50] = x202;
  out1[51] = x205;
  out1[52] = x207;
  out1[53] = x209;
  out1[54] = x212;
  out1[55] = x214;
  out1[56] = x216;
  out1[57] = x218;
  out1[58] = x221;
  out1[59] = x223;
  out1[60] = x225;
  out1[61] = x228;
  out1[62] = x230;
  out1[63] = x232;
  out1[64] = x234;
  out1[65] = (x235 as u8);
}

/// The function fiat_p521_from_bytes deserializes a field element from bytes in little-endian order.
///
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
#[inline]
pub fn fiat_p521_from_bytes(out1: &mut fiat_p521_tight_field_element, arg1: &[u8; 66]) {
  let x1: u32 = ((((arg1[65]) as fiat_p521_u1) as u32) << 26);
  let x2: u32 = (((arg1[64]) as u32) << 18);
  let x3: u32 = (((arg1[63]) as u32) << 10);
  let x4: u32 = (((arg1[62]) as u32) << 2);
  let x5: u32 = (((arg1[61]) as u32) << 21);
  let x6: u32 = (((arg1[60]) as u32) << 13);
  let x7: u32 = (((arg1[59]) as u32) << 5);
  let x8: u64 = (((arg1[58]) as u64) << 25);
  let x9: u32 = (((arg1[57]) as u32) << 17);
  let x10: u32 = (((arg1[56]) as u32) << 9);
  let x11: u32 = (((arg1[55]) as u32) * (0x2 as u32));
  let x12: u32 = (((arg1[54]) as u32) << 20);
  let x13: u32 = (((arg1[53]) as u32) << 12);
  let x14: u32 = (((arg1[52]) as u32) << 4);
  let x15: u32 = (((arg1[51]) as u32) << 24);
  let x16: u32 = (((arg1[50]) as u32) << 16);
  let x17: u32 = (((arg1[49]) as u32) << 8);
  let x18: u8 = (arg1[48]);
  let x19: u32 = (((arg1[47]) as u32) << 19);
  let x20: u32 = (((arg1[46]) as u32) << 11);
  let x21: u32 = (((arg1[45]) as u32) << 3);
  let x22: u32 = (((arg1[44]) as u32) << 22);
  let x23: u32 = (((arg1[43]) as u32) << 14);
  let x24: u32 = (((arg1[42]) as u32) << 6);
  let x25: u64 = (((arg1[41]) as u64) << 26);
  let x26: u32 = (((arg1[40]) as u32) << 18);
  let x27: u32 = (((arg1[39]) as u32) << 10);
  let x28: u32 = (((arg1[38]) as u32) << 2);
  let x29: u32 = (((arg1[37]) as u32) << 21);
  let x30: u32 = (((arg1[36]) as u32) << 13);
  let x31: u32 = (((arg1[35]) as u32) << 5);
  let x32: u64 = (((arg1[34]) as u64) << 25);
  let x33: u32 = (((arg1[33]) as u32) << 17);
  let x34: u32 = (((arg1[32]) as u32) << 9);
  let x35: u32 = (((arg1[31]) as u32) * (0x2 as u32));
  let x36: u32 = (((arg1[30]) as u32) << 20);
  let x37: u32 = (((arg1[29]) as u32) << 12);
  let x38: u32 = (((arg1[28]) as u32) << 4);
  let x39: u32 = (((arg1[27]) as u32) << 24);
  let x40: u32 = (((arg1[26]) as u32) << 16);
  let x41: u32 = (((arg1[25]) as u32) << 8);
  let x42: u8 = (arg1[24]);
  let x43: u32 = (((arg1[23]) as u32) << 19);
  let x44: u32 = (((arg1[22]) as u32) << 11);
  let x45: u32 = (((arg1[21]) as u32) << 3);
  let x46: u32 = (((arg1[20]) as u32) << 22);
  let x47: u32 = (((arg1[19]) as u32) << 14);
  let x48: u32 = (((arg1[18]) as u32) << 6);
  let x49: u64 = (((arg1[17]) as u64) << 26);
  let x50: u32 = (((arg1[16]) as u32) << 18);
  let x51: u32 = (((arg1[15]) as u32) << 10);
  let x52: u32 = (((arg1[14]) as u32) << 2);
  let x53: u32 = (((arg1[13]) as u32) << 21);
  let x54: u32 = (((arg1[12]) as u32) << 13);
  let x55: u32 = (((arg1[11]) as u32) << 5);
  let x56: u64 = (((arg1[10]) as u64) << 25);
  let x57: u32 = (((arg1[9]) as u32) << 17);
  let x58: u32 = (((arg1[8]) as u32) << 9);
  let x59: u32 = (((arg1[7]) as u32) * (0x2 as u32));
  let x60: u32 = (((arg1[6]) as u32) << 20);
  let x61: u32 = (((arg1[5]) as u32) << 12);
  let x62: u32 = (((arg1[4]) as u32) << 4);
  let x63: u32 = (((arg1[3]) as u32) << 24);
  let x64: u32 = (((arg1[2]) as u32) << 16);
  let x65: u32 = (((arg1[1]) as u32) << 8);
  let x66: u8 = (arg1[0]);
  let x67: u32 = (x65 + (x66 as u32));
  let x68: u32 = (x64 + x67);
  let x69: u32 = (x63 + x68);
  let x70: u32 = (x69 & 0xfffffff);
  let x71: u8 = ((x69 >> 28) as u8);
  let x72: u32 = (x62 + (x71 as u32));
  let x73: u32 = (x61 + x72);
  let x74: u32 = (x60 + x73);
  let x75: u32 = (x74 & 0x7ffffff);
  let x76: fiat_p521_u1 = ((x74 >> 27) as fiat_p521_u1);
  let x77: u32 = (x59 + (x76 as u32));
  let x78: u32 = (x58 + x77);
  let x79: u32 = (x57 + x78);
  let x80: u64 = (x56 + (x79 as u64));
  let x81: u32 = ((x80 & (0xfffffff as u64)) as u32);
  let x82: u8 = ((x80 >> 28) as u8);
  let x83: u32 = (x55 + (x82 as u32));
  let x84: u32 = (x54 + x83);
  let x85: u32 = (x53 + x84);
  let x86: u32 = (x85 & 0x7ffffff);
  let x87: u8 = ((x85 >> 27) as u8);
  let x88: u32 = (x52 + (x87 as u32));
  let x89: u32 = (x51 + x88);
  let x90: u32 = (x50 + x89);
  let x91: u64 = (x49 + (x90 as u64));
  let x92: u32 = ((x91 & (0xfffffff as u64)) as u32);
  let x93: u8 = ((x91 >> 28) as u8);
  let x94: u32 = (x48 + (x93 as u32));
  let x95: u32 = (x47 + x94);
  let x96: u32 = (x46 + x95);
  let x97: u32 = (x96 & 0x7ffffff);
  let x98: u8 = ((x96 >> 27) as u8);
  let x99: u32 = (x45 + (x98 as u32));
  let x100: u32 = (x44 + x99);
  let x101: u32 = (x43 + x100);
  let x102: u32 = (x41 + (x42 as u32));
  let x103: u32 = (x40 + x102);
  let x104: u32 = (x39 + x103);
  let x105: u32 = (x104 & 0xfffffff);
  let x106: u8 = ((x104 >> 28) as u8);
  let x107: u32 = (x38 + (x106 as u32));
  let x108: u32 = (x37 + x107);
  let x109: u32 = (x36 + x108);
  let x110: u32 = (x109 & 0x7ffffff);
  let x111: fiat_p521_u1 = ((x109 >> 27) as fiat_p521_u1);
  let x112: u32 = (x35 + (x111 as u32));
  let x113: u32 = (x34 + x112);
  let x114: u32 = (x33 + x113);
  let x115: u64 = (x32 + (x114 as u64));
  let x116: u32 = ((x115 & (0xfffffff as u64)) as u32);
  let x117: u8 = ((x115 >> 28) as u8);
  let x118: u32 = (x31 + (x117 as u32));
  let x119: u32 = (x30 + x118);
  let x120: u32 = (x29 + x119);
  let x121: u32 = (x120 & 0x7ffffff);
  let x122: u8 = ((x120 >> 27) as u8);
  let x123: u32 = (x28 + (x122 as u32));
  let x124: u32 = (x27 + x123);
  let x125: u32 = (x26 + x124);
  let x126: u64 = (x25 + (x125 as u64));
  let x127: u32 = ((x126 & (0xfffffff as u64)) as u32);
  let x128: u8 = ((x126 >> 28) as u8);
  let x129: u32 = (x24 + (x128 as u32));
  let x130: u32 = (x23 + x129);
  let x131: u32 = (x22 + x130);
  let x132: u32 = (x131 & 0x7ffffff);
  let x133: u8 = ((x131 >> 27) as u8);
  let x134: u32 = (x21 + (x133 as u32));
  let x135: u32 = (x20 + x134);
  let x136: u32 = (x19 + x135);
  let x137: u32 = (x17 + (x18 as u32));
  let x138: u32 = (x16 + x137);
  let x139: u32 = (x15 + x138);
  let x140: u32 = (x139 & 0xfffffff);
  let x141: u8 = ((x139 >> 28) as u8);
  let x142: u32 = (x14 + (x141 as u32));
  let x143: u32 = (x13 + x142);
  let x144: u32 = (x12 + x143);
  let x145: u32 = (x144 & 0x7ffffff);
  let x146: fiat_p521_u1 = ((x144 >> 27) as fiat_p521_u1);
  let x147: u32 = (x11 + (x146 as u32));
  let x148: u32 = (x10 + x147);
  let x149: u32 = (x9 + x148);
  let x150: u64 = (x8 + (x149 as u64));
  let x151: u32 = ((x150 & (0xfffffff as u64)) as u32);
  let x152: u8 = ((x150 >> 28) as u8);
  let x153: u32 = (x7 + (x152 as u32));
  let x154: u32 = (x6 + x153);
  let x155: u32 = (x5 + x154);
  let x156: u32 = (x155 & 0x7ffffff);
  let x157: u8 = ((x155 >> 27) as u8);
  let x158: u32 = (x4 + (x157 as u32));
  let x159: u32 = (x3 + x158);
  let x160: u32 = (x2 + x159);
  let x161: u32 = (x1 + x160);
  out1[0] = x70;
  out1[1] = x75;
  out1[2] = x81;
  out1[3] = x86;
  out1[4] = x92;
  out1[5] = x97;
  out1[6] = x101;
  out1[7] = x105;
  out1[8] = x110;
  out1[9] = x116;
  out1[10] = x121;
  out1[11] = x127;
  out1[12] = x132;
  out1[13] = x136;
  out1[14] = x140;
  out1[15] = x145;
  out1[16] = x151;
  out1[17] = x156;
  out1[18] = x161;
}

/// The function fiat_p521_relax is the identity function converting from tight field elements to loose field elements.
///
/// Postconditions:
///   out1 = arg1
///
#[inline]
pub fn fiat_p521_relax(out1: &mut fiat_p521_loose_field_element, arg1: &fiat_p521_tight_field_element) {
  let x1: u32 = (arg1[0]);
  let x2: u32 = (arg1[1]);
  let x3: u32 = (arg1[2]);
  let x4: u32 = (arg1[3]);
  let x5: u32 = (arg1[4]);
  let x6: u32 = (arg1[5]);
  let x7: u32 = (arg1[6]);
  let x8: u32 = (arg1[7]);
  let x9: u32 = (arg1[8]);
  let x10: u32 = (arg1[9]);
  let x11: u32 = (arg1[10]);
  let x12: u32 = (arg1[11]);
  let x13: u32 = (arg1[12]);
  let x14: u32 = (arg1[13]);
  let x15: u32 = (arg1[14]);
  let x16: u32 = (arg1[15]);
  let x17: u32 = (arg1[16]);
  let x18: u32 = (arg1[17]);
  let x19: u32 = (arg1[18]);
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
  out1[12] = x13;
  out1[13] = x14;
  out1[14] = x15;
  out1[15] = x16;
  out1[16] = x17;
  out1[17] = x18;
  out1[18] = x19;
}
