/*
 * Perform both rotation and reframing of all the image of the stream
 * This file is part of ufo-serge filter set.
 * Copyright (C) 2021 Serge Cohen
 *
 * This file is part of Ufo.
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Serge Cohen <serge.cohen@ipanema-remote.fr>
 */

#ifndef __UFO_ROTATE_REFRAME_TASK_H
#define __UFO_ROTATE_REFRAME_TASK_H

#include <ufo/ufo.h>

G_BEGIN_DECLS

#define UFO_TYPE_ROTATE_REFRAME_TASK             (ufo_rotate_reframe_task_get_type())
#define UFO_ROTATE_REFRAME_TASK(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj), UFO_TYPE_ROTATE_REFRAME_TASK, UfoRotateReframeTask))
#define UFO_IS_ROTATE_REFRAME_TASK(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj), UFO_TYPE_ROTATE_REFRAME_TASK))
#define UFO_ROTATE_REFRAME_TASK_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass), UFO_TYPE_ROTATE_REFRAME_TASK, UfoRotateReframeTaskClass))
#define UFO_IS_ROTATE_REFRAME_TASK_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE((klass), UFO_TYPE_ROTATE_REFRAME_TASK))
#define UFO_ROTATE_REFRAME_TASK_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS((obj), UFO_TYPE_ROTATE_REFRAME_TASK, UfoRotateReframeTaskClass))

typedef struct _UfoRotateReframeTask           UfoRotateReframeTask;
typedef struct _UfoRotateReframeTaskClass      UfoRotateReframeTaskClass;
typedef struct _UfoRotateReframeTaskPrivate    UfoRotateReframeTaskPrivate;

struct _UfoRotateReframeTask {
  UfoTaskNode parent_instance;

  UfoRotateReframeTaskPrivate *priv;
};

struct _UfoRotateReframeTaskClass {
  UfoTaskNodeClass parent_class;
};

UfoNode  *ufo_rotate_reframe_task_new       (void);
GType     ufo_rotate_reframe_task_get_type  (void);

G_END_DECLS

#endif
