/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;

public class CascadingDataEntryWriter
implements DataEntryWriter {
    private DataEntryWriter dataEntryWriter1;
    private DataEntryWriter dataEntryWriter2;

    public CascadingDataEntryWriter(DataEntryWriter dataEntryWriter, DataEntryWriter dataEntryWriter2) {
        this.dataEntryWriter1 = dataEntryWriter;
        this.dataEntryWriter2 = dataEntryWriter2;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter1.createDirectory(dataEntry) || this.dataEntryWriter2.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter1.sameOutputStream(dataEntry, dataEntry2) || this.dataEntryWriter2.sameOutputStream(dataEntry, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        OutputStream outputStream = this.dataEntryWriter1.createOutputStream(dataEntry);
        return outputStream != null ? outputStream : this.dataEntryWriter2.createOutputStream(dataEntry);
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter1.close();
        this.dataEntryWriter2.close();
        this.dataEntryWriter1 = null;
        this.dataEntryWriter2 = null;
    }

    @Override
    public void println(PrintWriter printWriter, String string) {
        printWriter.println(string + "CascadingDataEntryWriter");
        this.dataEntryWriter1.println(printWriter, string + "  ");
        this.dataEntryWriter2.println(printWriter, string + "  ");
    }
}

