; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -infer-address-spaces -instsimplify %s | FileCheck %s

define amdgpu_kernel void @is_local_true(i8 addrspace(3)* %lptr) {
; CHECK-LABEL: @is_local_true(
; CHECK-NEXT:    store i32 1, i32 addrspace(1)* undef
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast i8 addrspace(3)* %lptr to i8*
  %is.shared = call i1 @llvm.amdgcn.is.shared(i8* %cast)
  %ext = zext i1 %is.shared to i32
  store i32 %ext, i32 addrspace(1)* undef
  ret void
}

define amdgpu_kernel void @is_local_false(i8 addrspace(1)* %gptr) {
; CHECK-LABEL: @is_local_false(
; CHECK-NEXT:    store i32 0, i32 addrspace(1)* undef
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast i8 addrspace(1)* %gptr to i8*
  %is.shared = call i1 @llvm.amdgcn.is.shared(i8* %cast)
  %ext = zext i1 %is.shared to i32
  store i32 %ext, i32 addrspace(1)* undef
  ret void
}

define void @is_private_true(i8 addrspace(5)* %lptr) {
; CHECK-LABEL: @is_private_true(
; CHECK-NEXT:    store i32 1, i32 addrspace(1)* undef
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast i8 addrspace(5)* %lptr to i8*
  %is.private = call i1 @llvm.amdgcn.is.private(i8* %cast)
  %ext = zext i1 %is.private to i32
  store i32 %ext, i32 addrspace(1)* undef
  ret void
}

define void @is_private_false(i8 addrspace(1)* %gptr) {
; CHECK-LABEL: @is_private_false(
; CHECK-NEXT:    store i32 0, i32 addrspace(1)* undef
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast i8 addrspace(1)* %gptr to i8*
  %is.private = call i1 @llvm.amdgcn.is.private(i8* %cast)
  %ext = zext i1 %is.private to i32
  store i32 %ext, i32 addrspace(1)* undef
  ret void
}

declare i1 @llvm.amdgcn.is.shared(i8* nocapture) #0
declare i1 @llvm.amdgcn.is.private(i8* nocapture) #0

attributes #0 = { nounwind readnone speculatable }
