// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// Test host codegen.
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK2
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK4
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - -DOMP5 | FileCheck %s --check-prefix=CHECK5
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s -DOMP5
// RUN: %clang_cc1 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -DOMP5 | FileCheck %s --check-prefix=CHECK6
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - -DOMP5| FileCheck %s --check-prefix=CHECK7
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s -DOMP5
// RUN: %clang_cc1 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -DOMP5 | FileCheck %s --check-prefix=CHECK8

// RUN: %clang_cc1 -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK9
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK10
// RUN: %clang_cc1 -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK11
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK12
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - -DOMP5 | FileCheck %s --check-prefix=CHECK13
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s -DOMP5
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -DOMP5 | FileCheck %s --check-prefix=CHECK14
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - -DOMP5 | FileCheck %s --check-prefix=CHECK15
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s -DOMP5
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -DOMP5 | FileCheck %s --check-prefix=CHECK16

// Test target codegen - host bc file has to be created first. (no significant differences with host version of target region)
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=CHECK17
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK18
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK19
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK20
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc -DOMP5
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - -DOMP5 | FileCheck %s --check-prefix=CHECK21
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s -DOMP5
// RUN: %clang_cc1 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - -DOMP5 | FileCheck %s --check-prefix=CHECK22
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc -DOMP5
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - -DOMP5 | FileCheck %s --check-prefix=CHECK23
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s -DOMP5
// RUN: %clang_cc1 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - -DOMP5 | FileCheck %s --check-prefix=CHECK24

// RUN: %clang_cc1 -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=CHECK25
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK26
// RUN: %clang_cc1 -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK27
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK28
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc -DOMP5
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - -DOMP5 | FileCheck %s --check-prefix=CHECK29
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s -DOMP5
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - -DOMP5 | FileCheck %s --check-prefix=CHECK30
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc -DOMP5
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - -DOMP5 | FileCheck %s --check-prefix=CHECK31
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s -DOMP5
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - -DOMP5 | FileCheck %s --check-prefix=CHECK32

// expected-no-diagnostics
#ifndef HEADER
#define HEADER


void without_schedule_clause(float *a, float *b, float *c, float *d) {
  #pragma omp target
  #pragma omp teams
#ifdef OMP5
  #pragma omp distribute simd simdlen(8) aligned(a) if(true)
#else
  #pragma omp distribute simd simdlen(8) aligned(a)
#endif // OMP5
  for (int i = 33; i < 32000000; i += 7) {
    a[i] = b[i] * c[i] * d[i];
  }
}

// ... loop body ...


void static_not_chunked(float *a, float *b, float *c, float *d) {
  #pragma omp target
  #pragma omp teams
#ifdef OMP5
  #pragma omp distribute simd dist_schedule(static) safelen(32) if(simd: true) nontemporal(a, b)
#else
  #pragma omp distribute simd dist_schedule(static) safelen(32)
#endif // OMP5
  for (int i = 32000000; i > 33; i += -7) {
        a[i] = b[i] * c[i] * d[i];
  }
}

// ... loop body ...



void static_chunked(float *a, float *b, float *c, float *d) {
  #pragma omp target
  #pragma omp teams
#pragma omp distribute simd dist_schedule(static, 5)
  for (unsigned i = 131071; i <= 2147483647; i += 127) {
    a[i] = b[i] * c[i] * d[i];
  }
}

// ... loop body ...

void test_precond() {
  char a = 0; char i;
  #pragma omp target
  #pragma omp teams
#ifdef OMP5
  #pragma omp distribute simd linear(i) if(a) nontemporal(i)
#else
  #pragma omp distribute simd linear(i)
#endif // OMP5
  for(i = a; i < 10; ++i);
}

// a is passed as a parameter to the outlined functions
// ..many loads of %0..

// no templates for now, as these require special handling in target regions and/or declare target


template <typename T>
T ftemplate() {
  short aa = 0;

#pragma omp target
#pragma omp teams
#pragma omp distribute simd dist_schedule(static, aa)
  for (int i = 0; i < 100; i++) {
  }
  return T();
}

int fint(void) { return ftemplate<int>(); }

#endif

// CHECK1-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK1-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK1-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK1-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK1-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK1-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK1-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK1-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK1-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK1-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK1-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK1-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK1-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 4571424)
// CHECK1-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK1-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3:[0-9]+]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK1-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK1-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK1-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK1-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK1-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK1-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i64 16) ]
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK1-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP17]] to i64
// CHECK1-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 [[IDXPROM2]]
// CHECK1-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[MUL4:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK1-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP20]] to i64
// CHECK1-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP19]], i64 [[IDXPROM5]]
// CHECK1-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX6]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP21]]
// CHECK1-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP23]] to i64
// CHECK1-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP22]], i64 [[IDXPROM8]]
// CHECK1-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK1-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK1-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK1-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK1-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK1-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK1-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK1-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK1-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK1-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK1-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK1-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK1-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK1-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK1-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 4571424)
// CHECK1-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK1-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK1-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK1-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK1-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK1-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK1-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK1-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK1-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP16]] to i64
// CHECK1-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP15]], i64 [[IDXPROM2]]
// CHECK1-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK1-NEXT:    [[MUL4:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK1-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK1-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// CHECK1-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP18]], i64 [[IDXPROM5]]
// CHECK1-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX6]], align 4
// CHECK1-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP20]]
// CHECK1-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK1-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP22]] to i64
// CHECK1-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP21]], i64 [[IDXPROM8]]
// CHECK1-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK1-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK1-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK1-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK1-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK1-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK1-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK1-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK1-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK1-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK1-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK1-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK1-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK1-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 16908289)
// CHECK1-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK1-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK1-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK1-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK1-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK1-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..4 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK1-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK1:       omp.dispatch.cond:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK1:       omp.dispatch.body:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK1-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !17
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP15]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !17
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[IDXPROM3:%.*]] = zext i32 [[TMP18]] to i64
// CHECK1-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP17]], i64 [[IDXPROM3]]
// CHECK1-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[MUL5:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK1-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !17
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[IDXPROM6:%.*]] = zext i32 [[TMP21]] to i64
// CHECK1-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP20]], i64 [[IDXPROM6]]
// CHECK1-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX7]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[MUL8:%.*]] = fmul float [[MUL5]], [[TMP22]]
// CHECK1-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !17
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[IDXPROM9:%.*]] = zext i32 [[TMP24]] to i64
// CHECK1-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP23]], i64 [[IDXPROM9]]
// CHECK1-NEXT:    store float [[MUL8]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    [[ADD11:%.*]] = add i32 [[TMP25]], 1
// CHECK1-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP18:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK1:       omp.dispatch.inc:
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD12:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK1-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD13:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK1-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK1:       omp.dispatch.end:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK1-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK1-NEXT:    [[TMP0:%.*]] = load i8, i8* [[I]], align 1
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i8*
// CHECK1-NEXT:    store i8 [[TMP0]], i8* [[CONV]], align 1
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i8, i8* [[A]], align 1
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_CASTED]] to i8*
// CHECK1-NEXT:    store i8 [[TMP2]], i8* [[CONV1]], align 1
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP16:%.*]] = load i8, i8* [[A]], align 1
// CHECK1-NEXT:    store i8 [[TMP16]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    [[CONV3:%.*]] = sext i8 [[TMP17]] to i32
// CHECK1-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV3]]
// CHECK1-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK1-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK1-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK1-NEXT:    [[TMP19:%.*]] = zext i32 [[ADD6]] to i64
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP19]])
// CHECK1-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115.region_id, i32 2, i8** [[TMP14]], i8** [[TMP15]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK1-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115(i64 [[TMP1]], i64 [[TMP3]]) #[[ATTR3]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK1-SAME: (i64 [[I:%.*]], i64 [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i8*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_ADDR]] to i8*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 8
// CHECK1-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK1-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK1-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK1-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK1-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK1-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK1-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !20
// CHECK1-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK1-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !20
// CHECK1-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP16]] to i32
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK1-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK1-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK1-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !20
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK1-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK1-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP21:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK1-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP23]] to i32
// CHECK1-NEXT:    [[TMP24:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP24]] to i32
// CHECK1-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK1-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK1-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK1-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK1-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK1-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK1-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK1-NEXT:    store i8 [[CONV21]], i8* [[TMP0]], align 1
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[CALL:%.*]] = call signext i32 @_Z9ftemplateIiET_v()
// CHECK1-NEXT:    ret i32 [[CALL]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK1-SAME: () #[[ATTR0]] comdat {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK1-NEXT:    [[TMP0:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP0]], i16* [[CONV]], align 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 100)
// CHECK1-NEXT:    [[TMP9:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135.region_id, i32 1, i8** [[TMP7]], i8** [[TMP8]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.11, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK1-NEXT:    br i1 [[TMP10]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135(i64 [[TMP1]]) #[[ATTR3]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK1-SAME: (i64 [[AA:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK1:       omp.dispatch.cond:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK1-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK1:       omp.dispatch.body:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !23
// CHECK1-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !23
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK1-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP24:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK1:       omp.dispatch.inc:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK1-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK1-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK1:       omp.dispatch.end:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK1-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK2-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK2-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK2-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK2-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK2-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK2-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK2-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK2-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK2-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK2-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK2-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK2-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK2-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK2-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK2-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK2-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK2-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 4571424)
// CHECK2-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK2-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK2-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK2:       omp_offload.failed:
// CHECK2-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3:[0-9]+]]
// CHECK2-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK2:       omp_offload.cont:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK2-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK2-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK2-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK2-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK2-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK2-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK2-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK2-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i64 16) ]
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK2-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM]]
// CHECK2-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP17]] to i64
// CHECK2-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 [[IDXPROM2]]
// CHECK2-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[MUL4:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK2-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP20]] to i64
// CHECK2-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP19]], i64 [[IDXPROM5]]
// CHECK2-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX6]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP21]]
// CHECK2-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP23]] to i64
// CHECK2-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP22]], i64 [[IDXPROM8]]
// CHECK2-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK2-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK2-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK2-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK2-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK2-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK2-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK2-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK2-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK2-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK2-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK2-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK2-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK2-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK2-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK2-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK2-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK2-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK2-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK2-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 4571424)
// CHECK2-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK2-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK2-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK2:       omp_offload.failed:
// CHECK2-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK2-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK2:       omp_offload.cont:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK2-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK2-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK2-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK2-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK2-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK2-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK2-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK2-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK2-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK2-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDXPROM]]
// CHECK2-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK2-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK2-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP16]] to i64
// CHECK2-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP15]], i64 [[IDXPROM2]]
// CHECK2-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK2-NEXT:    [[MUL4:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK2-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK2-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// CHECK2-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP18]], i64 [[IDXPROM5]]
// CHECK2-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX6]], align 4
// CHECK2-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP20]]
// CHECK2-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK2-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP22]] to i64
// CHECK2-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP21]], i64 [[IDXPROM8]]
// CHECK2-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK2-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK2-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK2-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK2-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK2-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK2-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK2-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK2-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK2-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK2-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK2-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK2-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK2-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK2-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK2-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK2-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK2-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK2-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 16908289)
// CHECK2-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK2-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK2-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK2:       omp_offload.failed:
// CHECK2-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK2-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK2:       omp_offload.cont:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK2-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK2-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK2-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK2-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK2-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..4 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK2-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK2-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK2-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK2-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK2:       omp.dispatch.cond:
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK2-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK2:       omp.dispatch.body:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK2-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK2-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !17
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP15]] to i64
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM]]
// CHECK2-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !17
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[IDXPROM3:%.*]] = zext i32 [[TMP18]] to i64
// CHECK2-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP17]], i64 [[IDXPROM3]]
// CHECK2-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[MUL5:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK2-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !17
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[IDXPROM6:%.*]] = zext i32 [[TMP21]] to i64
// CHECK2-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP20]], i64 [[IDXPROM6]]
// CHECK2-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX7]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[MUL8:%.*]] = fmul float [[MUL5]], [[TMP22]]
// CHECK2-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !17
// CHECK2-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[IDXPROM9:%.*]] = zext i32 [[TMP24]] to i64
// CHECK2-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP23]], i64 [[IDXPROM9]]
// CHECK2-NEXT:    store float [[MUL8]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    [[ADD11:%.*]] = add i32 [[TMP25]], 1
// CHECK2-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP18:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK2:       omp.dispatch.inc:
// CHECK2-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    [[ADD12:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK2-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    [[ADD13:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK2-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK2:       omp.dispatch.end:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK2-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK2-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK2-SAME: () #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK2-NEXT:    [[TMP0:%.*]] = load i8, i8* [[I]], align 1
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i8*
// CHECK2-NEXT:    store i8 [[TMP0]], i8* [[CONV]], align 1
// CHECK2-NEXT:    [[TMP1:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i8, i8* [[A]], align 1
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_CASTED]] to i8*
// CHECK2-NEXT:    store i8 [[TMP2]], i8* [[CONV1]], align 1
// CHECK2-NEXT:    [[TMP3:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK2-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK2-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK2-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK2-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK2-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK2-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP16:%.*]] = load i8, i8* [[A]], align 1
// CHECK2-NEXT:    store i8 [[TMP16]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    [[CONV3:%.*]] = sext i8 [[TMP17]] to i32
// CHECK2-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV3]]
// CHECK2-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK2-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK2-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK2-NEXT:    [[TMP19:%.*]] = zext i32 [[ADD6]] to i64
// CHECK2-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP19]])
// CHECK2-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115.region_id, i32 2, i8** [[TMP14]], i8** [[TMP15]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK2-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK2-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK2:       omp_offload.failed:
// CHECK2-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115(i64 [[TMP1]], i64 [[TMP3]]) #[[ATTR3]]
// CHECK2-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK2:       omp_offload.cont:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK2-SAME: (i64 [[I:%.*]], i64 [[A:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i8*
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_ADDR]] to i8*
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 8
// CHECK2-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK2-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK2-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK2-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK2-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK2-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK2-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK2-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK2:       omp.precond.then:
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK2-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !20
// CHECK2-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK2-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP16:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !20
// CHECK2-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP16]] to i32
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK2-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK2-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK2-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !20
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK2-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK2-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP21:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK2-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    [[TMP23:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP23]] to i32
// CHECK2-NEXT:    [[TMP24:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP24]] to i32
// CHECK2-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK2-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK2-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK2-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK2-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK2-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK2-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK2-NEXT:    store i8 [[CONV21]], i8* [[TMP0]], align 1
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK2:       omp.precond.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK2-SAME: () #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[CALL:%.*]] = call signext i32 @_Z9ftemplateIiET_v()
// CHECK2-NEXT:    ret i32 [[CALL]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK2-SAME: () #[[ATTR0]] comdat {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK2-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK2-NEXT:    [[TMP0:%.*]] = load i16, i16* [[AA]], align 2
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK2-NEXT:    store i16 [[TMP0]], i16* [[CONV]], align 2
// CHECK2-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to i64*
// CHECK2-NEXT:    store i64 [[TMP1]], i64* [[TMP3]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK2-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK2-NEXT:    store i8* null, i8** [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 100)
// CHECK2-NEXT:    [[TMP9:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135.region_id, i32 1, i8** [[TMP7]], i8** [[TMP8]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.11, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK2-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK2-NEXT:    br i1 [[TMP10]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK2:       omp_offload.failed:
// CHECK2-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135(i64 [[TMP1]]) #[[ATTR3]]
// CHECK2-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK2:       omp_offload.cont:
// CHECK2-NEXT:    ret i32 0
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK2-SAME: (i64 [[AA:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 8
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK2-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK2-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK2:       omp.dispatch.cond:
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK2-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK2:       omp.dispatch.body:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !23
// CHECK2-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK2-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !23
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK2-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK2-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP24:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK2:       omp.dispatch.inc:
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK2-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK2-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK2:       omp.dispatch.end:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK2-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK2-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK2-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK3-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK3-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK3-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK3-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK3-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK3-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK3-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK3-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK3-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK3-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK3-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK3-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 4571424)
// CHECK3-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK3-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3:[0-9]+]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK3-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK3-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK3-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK3-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK3-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK3-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i32 16) ]
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK3-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP16]], i32 [[TMP17]]
// CHECK3-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[MUL3:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK3-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP19]], i32 [[TMP20]]
// CHECK3-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP21]]
// CHECK3-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP22]], i32 [[TMP23]]
// CHECK3-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK3-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK3-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK3-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK3-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK3-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK3-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK3-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK3-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK3-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK3-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK3-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK3-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK3-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK3-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 4571424)
// CHECK3-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK3-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK3-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK3-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK3-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK3-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK3-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK3-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i32 [[TMP13]]
// CHECK3-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK3-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP15]], i32 [[TMP16]]
// CHECK3-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK3-NEXT:    [[MUL3:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK3-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK3-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP18]], i32 [[TMP19]]
// CHECK3-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX4]], align 4
// CHECK3-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP20]]
// CHECK3-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK3-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP21]], i32 [[TMP22]]
// CHECK3-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK3-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK3-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK3-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK3-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK3-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK3-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK3-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK3-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK3-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK3-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK3-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK3-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK3-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 16908289)
// CHECK3-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK3-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK3-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK3-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK3-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK3-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..4 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK3-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK3:       omp.dispatch.cond:
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK3:       omp.dispatch.body:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK3-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK3-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK3-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP17]], i32 [[TMP18]]
// CHECK3-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[MUL4:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK3-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP20]], i32 [[TMP21]]
// CHECK3-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[MUL6:%.*]] = fmul float [[MUL4]], [[TMP22]]
// CHECK3-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP23]], i32 [[TMP24]]
// CHECK3-NEXT:    store float [[MUL6]], float* [[ARRAYIDX7]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    [[ADD8:%.*]] = add i32 [[TMP25]], 1
// CHECK3-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK3:       omp.dispatch.inc:
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD9:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK3-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD10:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK3-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK3:       omp.dispatch.end:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK3-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK3-SAME: () #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK3-NEXT:    [[TMP0:%.*]] = load i8, i8* [[I]], align 1
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_CASTED]] to i8*
// CHECK3-NEXT:    store i8 [[TMP0]], i8* [[CONV]], align 1
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i8, i8* [[A]], align 1
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_CASTED]] to i8*
// CHECK3-NEXT:    store i8 [[TMP2]], i8* [[CONV1]], align 1
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP16:%.*]] = load i8, i8* [[A]], align 1
// CHECK3-NEXT:    store i8 [[TMP16]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    [[CONV3:%.*]] = sext i8 [[TMP17]] to i32
// CHECK3-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV3]]
// CHECK3-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK3-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK3-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK3-NEXT:    [[TMP19:%.*]] = zext i32 [[ADD6]] to i64
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP19]])
// CHECK3-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115.region_id, i32 2, i8** [[TMP14]], i8** [[TMP15]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK3-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115(i32 [[TMP1]], i32 [[TMP3]]) #[[ATTR3]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK3-SAME: (i32 [[I:%.*]], i32 [[A:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_ADDR]] to i8*
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_ADDR]] to i8*
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 4
// CHECK3-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK3-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK3-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK3-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK3-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK3-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK3-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK3-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !21
// CHECK3-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK3-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP16:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !21
// CHECK3-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP16]] to i32
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK3-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK3-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK3-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !21
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK3-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK3-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK3-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    [[TMP23:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP23]] to i32
// CHECK3-NEXT:    [[TMP24:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP24]] to i32
// CHECK3-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK3-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK3-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK3-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK3-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK3-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK3-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK3-NEXT:    store i8 [[CONV21]], i8* [[TMP0]], align 1
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK3-SAME: () #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[CALL:%.*]] = call i32 @_Z9ftemplateIiET_v()
// CHECK3-NEXT:    ret i32 [[CALL]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK3-SAME: () #[[ATTR0]] comdat {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK3-NEXT:    [[TMP0:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP0]], i16* [[CONV]], align 2
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP6]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 100)
// CHECK3-NEXT:    [[TMP9:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135.region_id, i32 1, i8** [[TMP7]], i8** [[TMP8]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.11, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK3-NEXT:    br i1 [[TMP10]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135(i32 [[TMP1]]) #[[ATTR3]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK3-SAME: (i32 [[AA:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK3:       omp.dispatch.cond:
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK3:       omp.dispatch.body:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !24
// CHECK3-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK3-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !24
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK3-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK3:       omp.dispatch.inc:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK3-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK3-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK3:       omp.dispatch.end:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK3-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK4-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK4-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK4-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK4-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK4-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK4-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK4-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK4-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK4-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK4-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK4-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK4-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK4-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK4-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK4-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK4-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 4571424)
// CHECK4-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK4-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK4-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK4:       omp_offload.failed:
// CHECK4-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3:[0-9]+]]
// CHECK4-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK4:       omp_offload.cont:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK4-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK4-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK4-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK4-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK4-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK4-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK4-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK4-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i32 16) ]
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK4-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK4-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK4-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP16]], i32 [[TMP17]]
// CHECK4-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[MUL3:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK4-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP19]], i32 [[TMP20]]
// CHECK4-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP21]]
// CHECK4-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP22]], i32 [[TMP23]]
// CHECK4-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK4-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK4-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK4-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK4-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK4-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK4-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK4-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK4-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK4-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK4-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK4-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK4-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK4-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK4-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK4-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK4-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK4-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK4-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK4-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 4571424)
// CHECK4-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK4-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK4-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK4:       omp_offload.failed:
// CHECK4-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK4-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK4:       omp_offload.cont:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK4-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK4-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK4-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK4-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK4-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK4-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK4-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK4-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK4-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK4-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK4-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK4-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i32 [[TMP13]]
// CHECK4-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK4-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK4-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP15]], i32 [[TMP16]]
// CHECK4-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK4-NEXT:    [[MUL3:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK4-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK4-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP18]], i32 [[TMP19]]
// CHECK4-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX4]], align 4
// CHECK4-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP20]]
// CHECK4-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK4-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP21]], i32 [[TMP22]]
// CHECK4-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK4-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK4-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK4-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK4-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK4-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK4-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK4-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK4-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK4-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK4-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK4-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK4-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK4-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK4-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK4-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK4-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK4-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK4-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 16908289)
// CHECK4-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK4-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK4-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK4:       omp_offload.failed:
// CHECK4-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK4-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK4:       omp_offload.cont:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK4-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK4-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK4-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK4-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK4-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..4 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK4-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK4-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK4-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK4-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK4:       omp.dispatch.cond:
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK4-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK4-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK4:       omp.dispatch.body:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK4-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK4-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK4-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP17]], i32 [[TMP18]]
// CHECK4-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[MUL4:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK4-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP20]], i32 [[TMP21]]
// CHECK4-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[MUL6:%.*]] = fmul float [[MUL4]], [[TMP22]]
// CHECK4-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP23]], i32 [[TMP24]]
// CHECK4-NEXT:    store float [[MUL6]], float* [[ARRAYIDX7]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    [[ADD8:%.*]] = add i32 [[TMP25]], 1
// CHECK4-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK4:       omp.dispatch.inc:
// CHECK4-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    [[ADD9:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK4-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    [[ADD10:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK4-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK4:       omp.dispatch.end:
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK4-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK4-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK4-SAME: () #[[ATTR0]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK4-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK4-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK4-NEXT:    [[TMP0:%.*]] = load i8, i8* [[I]], align 1
// CHECK4-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_CASTED]] to i8*
// CHECK4-NEXT:    store i8 [[TMP0]], i8* [[CONV]], align 1
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i8, i8* [[A]], align 1
// CHECK4-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_CASTED]] to i8*
// CHECK4-NEXT:    store i8 [[TMP2]], i8* [[CONV1]], align 1
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK4-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK4-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK4-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK4-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK4-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK4-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP16:%.*]] = load i8, i8* [[A]], align 1
// CHECK4-NEXT:    store i8 [[TMP16]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK4-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK4-NEXT:    [[CONV3:%.*]] = sext i8 [[TMP17]] to i32
// CHECK4-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV3]]
// CHECK4-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK4-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK4-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK4-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK4-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK4-NEXT:    [[TMP19:%.*]] = zext i32 [[ADD6]] to i64
// CHECK4-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP19]])
// CHECK4-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115.region_id, i32 2, i8** [[TMP14]], i8** [[TMP15]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK4-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK4-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK4:       omp_offload.failed:
// CHECK4-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115(i32 [[TMP1]], i32 [[TMP3]]) #[[ATTR3]]
// CHECK4-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK4:       omp_offload.cont:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK4-SAME: (i32 [[I:%.*]], i32 [[A:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK4-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_ADDR]] to i8*
// CHECK4-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_ADDR]] to i8*
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 4
// CHECK4-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK4-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK4-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK4-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK4-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK4-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK4-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK4-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK4-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK4-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK4-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK4-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK4-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK4-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK4:       omp.precond.then:
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK4-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !21
// CHECK4-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK4-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP16:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !21
// CHECK4-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP16]] to i32
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK4-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK4-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK4-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !21
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK4-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK4-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK4-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    [[TMP23:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK4-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP23]] to i32
// CHECK4-NEXT:    [[TMP24:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK4-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP24]] to i32
// CHECK4-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK4-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK4-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK4-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK4-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK4-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK4-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK4-NEXT:    store i8 [[CONV21]], i8* [[TMP0]], align 1
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK4:       omp.precond.end:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK4-SAME: () #[[ATTR0]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[CALL:%.*]] = call i32 @_Z9ftemplateIiET_v()
// CHECK4-NEXT:    ret i32 [[CALL]]
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK4-SAME: () #[[ATTR0]] comdat {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK4-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK4-NEXT:    [[TMP0:%.*]] = load i16, i16* [[AA]], align 2
// CHECK4-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK4-NEXT:    store i16 [[TMP0]], i16* [[CONV]], align 2
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to i32*
// CHECK4-NEXT:    store i32 [[TMP1]], i32* [[TMP3]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK4-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK4-NEXT:    store i8* null, i8** [[TMP6]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 100)
// CHECK4-NEXT:    [[TMP9:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135.region_id, i32 1, i8** [[TMP7]], i8** [[TMP8]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.11, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK4-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK4-NEXT:    br i1 [[TMP10]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK4:       omp_offload.failed:
// CHECK4-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135(i32 [[TMP1]]) #[[ATTR3]]
// CHECK4-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK4:       omp_offload.cont:
// CHECK4-NEXT:    ret i32 0
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK4-SAME: (i32 [[AA:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK4-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK4-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK4-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK4:       omp.dispatch.cond:
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK4-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK4-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK4:       omp.dispatch.body:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !24
// CHECK4-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK4-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !24
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK4-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK4-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK4:       omp.dispatch.inc:
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK4-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK4-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK4:       omp.dispatch.end:
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK4-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK4-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK4-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK5-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK5-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK5-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK5-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK5-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK5-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK5-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK5-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK5-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK5-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK5-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK5-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK5-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK5-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK5-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK5-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK5-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK5-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK5-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 4571424)
// CHECK5-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK5-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3:[0-9]+]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK5-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK5-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK5-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK5-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK5-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK5-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK5-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK5-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK5-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i64 16) ]
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK5-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !8
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM]]
// CHECK5-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !8
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP17]] to i64
// CHECK5-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 [[IDXPROM2]]
// CHECK5-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[MUL4:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK5-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !8
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP20]] to i64
// CHECK5-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP19]], i64 [[IDXPROM5]]
// CHECK5-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX6]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP21]]
// CHECK5-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !8
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP23]] to i64
// CHECK5-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP22]], i64 [[IDXPROM8]]
// CHECK5-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK5-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK5-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK5-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK5-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK5-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK5-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK5-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK5-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK5-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK5-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK5-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK5-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK5-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK5-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK5-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK5-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK5-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK5-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK5-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK5-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK5-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK5-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 4571424)
// CHECK5-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK5-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK5-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK5-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK5-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK5-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK5-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK5-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK5-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK5-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK5-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK5-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK5-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK5-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 8, !nontemporal !15
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK5-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDXPROM]]
// CHECK5-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK5-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 8
// CHECK5-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK5-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP16]] to i64
// CHECK5-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP15]], i64 [[IDXPROM2]]
// CHECK5-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK5-NEXT:    [[MUL4:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK5-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK5-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// CHECK5-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP18]], i64 [[IDXPROM5]]
// CHECK5-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX6]], align 4
// CHECK5-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP20]]
// CHECK5-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 8, !nontemporal !15
// CHECK5-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK5-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP22]] to i64
// CHECK5-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP21]], i64 [[IDXPROM8]]
// CHECK5-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK5-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK5-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK5-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK5-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK5-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK5-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK5-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK5-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK5-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK5-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK5-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK5-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK5-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK5-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK5-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK5-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK5-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK5-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK5-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK5-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 16908289)
// CHECK5-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK5-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK5-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK5-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK5-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK5-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..4 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK5-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK5-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK5-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK5-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK5-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK5:       omp.dispatch.cond:
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK5-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK5:       omp.dispatch.body:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK5-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK5-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !18
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP15]] to i64
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM]]
// CHECK5-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !18
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[IDXPROM3:%.*]] = zext i32 [[TMP18]] to i64
// CHECK5-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP17]], i64 [[IDXPROM3]]
// CHECK5-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[MUL5:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK5-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !18
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[IDXPROM6:%.*]] = zext i32 [[TMP21]] to i64
// CHECK5-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP20]], i64 [[IDXPROM6]]
// CHECK5-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX7]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[MUL8:%.*]] = fmul float [[MUL5]], [[TMP22]]
// CHECK5-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !18
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[IDXPROM9:%.*]] = zext i32 [[TMP24]] to i64
// CHECK5-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP23]], i64 [[IDXPROM9]]
// CHECK5-NEXT:    store float [[MUL8]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    [[ADD11:%.*]] = add i32 [[TMP25]], 1
// CHECK5-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK5:       omp.dispatch.inc:
// CHECK5-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    [[ADD12:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK5-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    [[ADD13:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK5-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK5:       omp.dispatch.end:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK5-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK5-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK5-SAME: () #[[ATTR0]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK5-NEXT:    [[TMP0:%.*]] = load i8, i8* [[I]], align 1
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i8*
// CHECK5-NEXT:    store i8 [[TMP0]], i8* [[CONV]], align 1
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i8, i8* [[A]], align 1
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_CASTED]] to i8*
// CHECK5-NEXT:    store i8 [[TMP2]], i8* [[CONV1]], align 1
// CHECK5-NEXT:    [[TMP3:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK5-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK5-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK5-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP16:%.*]] = load i8, i8* [[A]], align 1
// CHECK5-NEXT:    store i8 [[TMP16]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[CONV3:%.*]] = sext i8 [[TMP17]] to i32
// CHECK5-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV3]]
// CHECK5-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK5-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK5-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK5-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK5-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK5-NEXT:    [[TMP19:%.*]] = zext i32 [[ADD6]] to i64
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP19]])
// CHECK5-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115.region_id, i32 2, i8** [[TMP14]], i8** [[TMP15]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK5-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115(i64 [[TMP1]], i64 [[TMP3]]) #[[ATTR3]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK5-SAME: (i64 [[I:%.*]], i64 [[A:%.*]]) #[[ATTR1]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i8*
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_ADDR]] to i8*
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK5-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR1]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 8
// CHECK5-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK5-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK5-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK5-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK5-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK5-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK5-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK5-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK5-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK5-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK5:       omp.precond.then:
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK5-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK5-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK5-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP14:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK5-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP14]], 0
// CHECK5-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK5-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !21
// CHECK5-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK5-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !21
// CHECK5-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP17]] to i32
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK5-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK5-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK5-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !15, !llvm.access.group !21
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK5-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK5-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK5:       omp_if.else:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK5:       omp.inner.for.cond13:
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK5-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK5:       omp.inner.for.body15:
// CHECK5-NEXT:    [[TMP22:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP22]] to i32
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP23]], 1
// CHECK5-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK5-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK5-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK5:       omp.body.continue20:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK5:       omp.inner.for.inc21:
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK5-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP24:![0-9]+]]
// CHECK5:       omp.inner.for.end23:
// CHECK5-NEXT:    br label [[OMP_IF_END]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK5-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK5-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    [[TMP29:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP29]] to i32
// CHECK5-NEXT:    [[TMP30:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP30]] to i32
// CHECK5-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK5-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK5-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK5-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK5-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK5-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK5-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK5-NEXT:    store i8 [[CONV32]], i8* [[TMP0]], align 1
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK5:       omp.precond.end:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK5-SAME: () #[[ATTR0]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[CALL:%.*]] = call signext i32 @_Z9ftemplateIiET_v()
// CHECK5-NEXT:    ret i32 [[CALL]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK5-SAME: () #[[ATTR0]] comdat {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK5-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK5-NEXT:    [[TMP0:%.*]] = load i16, i16* [[AA]], align 2
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK5-NEXT:    store i16 [[TMP0]], i16* [[CONV]], align 2
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to i64*
// CHECK5-NEXT:    store i64 [[TMP1]], i64* [[TMP3]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK5-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP6]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 100)
// CHECK5-NEXT:    [[TMP9:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135.region_id, i32 1, i8** [[TMP7]], i8** [[TMP8]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.11, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK5-NEXT:    br i1 [[TMP10]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135(i64 [[TMP1]]) #[[ATTR3]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    ret i32 0
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK5-SAME: (i64 [[AA:%.*]]) #[[ATTR1]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK5-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR1]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 8
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK5-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK5-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK5:       omp.dispatch.cond:
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK5-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK5:       omp.dispatch.body:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !26
// CHECK5-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK5-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !26
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK5-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK5-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP27:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK5:       omp.dispatch.inc:
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK5-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK5-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK5:       omp.dispatch.end:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK5-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK5-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK5-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK6-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK6-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK6-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK6-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK6-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK6-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK6-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK6-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK6-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK6-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK6-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK6-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK6-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK6-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK6-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK6-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK6-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK6-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK6-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK6-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK6-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK6-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK6-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK6-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK6-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK6-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK6-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 4571424)
// CHECK6-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK6-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK6-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK6:       omp_offload.failed:
// CHECK6-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3:[0-9]+]]
// CHECK6-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK6:       omp_offload.cont:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK6-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK6-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK6-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK6-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK6-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK6-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK6-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK6-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK6-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK6-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK6-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i64 16) ]
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK6-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK6:       cond.true:
// CHECK6-NEXT:    br label [[COND_END:%.*]]
// CHECK6:       cond.false:
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    br label [[COND_END]]
// CHECK6:       cond.end:
// CHECK6-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK6-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK6-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !8
// CHECK6-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK6-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM]]
// CHECK6-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !8
// CHECK6-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP17]] to i64
// CHECK6-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 [[IDXPROM2]]
// CHECK6-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[MUL4:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK6-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !8
// CHECK6-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP20]] to i64
// CHECK6-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP19]], i64 [[IDXPROM5]]
// CHECK6-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX6]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP21]]
// CHECK6-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !8
// CHECK6-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP23]] to i64
// CHECK6-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP22]], i64 [[IDXPROM8]]
// CHECK6-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK6-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK6:       omp.loop.exit:
// CHECK6-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK6-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK6-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK6:       .omp.final.then:
// CHECK6-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK6:       .omp.final.done:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK6-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK6-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK6-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK6-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK6-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK6-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK6-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK6-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK6-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK6-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK6-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK6-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK6-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK6-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK6-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK6-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK6-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK6-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK6-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK6-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK6-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK6-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK6-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK6-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK6-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK6-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK6-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 4571424)
// CHECK6-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK6-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK6-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK6:       omp_offload.failed:
// CHECK6-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK6-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK6:       omp_offload.cont:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK6-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK6-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK6-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK6-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK6-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK6-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK6-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK6-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK6-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK6-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK6-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK6:       cond.true:
// CHECK6-NEXT:    br label [[COND_END:%.*]]
// CHECK6:       cond.false:
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    br label [[COND_END]]
// CHECK6:       cond.end:
// CHECK6-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK6-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK6-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK6-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK6-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK6-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 8, !nontemporal !15
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK6-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK6-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDXPROM]]
// CHECK6-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK6-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 8
// CHECK6-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK6-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP16]] to i64
// CHECK6-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP15]], i64 [[IDXPROM2]]
// CHECK6-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK6-NEXT:    [[MUL4:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK6-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 8
// CHECK6-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK6-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// CHECK6-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP18]], i64 [[IDXPROM5]]
// CHECK6-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX6]], align 4
// CHECK6-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP20]]
// CHECK6-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 8, !nontemporal !15
// CHECK6-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK6-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP22]] to i64
// CHECK6-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP21]], i64 [[IDXPROM8]]
// CHECK6-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK6:       omp.loop.exit:
// CHECK6-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK6-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK6-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK6:       .omp.final.then:
// CHECK6-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK6:       .omp.final.done:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK6-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK6-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK6-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK6-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK6-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK6-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 8
// CHECK6-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK6-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK6-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK6-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 8
// CHECK6-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK6-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 8
// CHECK6-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK6-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK6-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK6-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 8
// CHECK6-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK6-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 8
// CHECK6-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK6-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK6-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK6-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 8
// CHECK6-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK6-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 8
// CHECK6-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK6-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK6-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 16908289)
// CHECK6-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK6-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK6-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK6:       omp_offload.failed:
// CHECK6-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK6-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK6:       omp_offload.cont:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK6-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK6-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK6-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK6-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK6-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK6-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..4 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK6-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR1]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK6-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK6-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK6-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK6-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK6-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK6:       omp.dispatch.cond:
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK6-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK6:       cond.true:
// CHECK6-NEXT:    br label [[COND_END:%.*]]
// CHECK6:       cond.false:
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    br label [[COND_END]]
// CHECK6:       cond.end:
// CHECK6-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK6-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK6-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK6:       omp.dispatch.body:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK6-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK6-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !18
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP15]] to i64
// CHECK6-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM]]
// CHECK6-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !18
// CHECK6-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[IDXPROM3:%.*]] = zext i32 [[TMP18]] to i64
// CHECK6-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP17]], i64 [[IDXPROM3]]
// CHECK6-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[MUL5:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK6-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !18
// CHECK6-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[IDXPROM6:%.*]] = zext i32 [[TMP21]] to i64
// CHECK6-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP20]], i64 [[IDXPROM6]]
// CHECK6-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX7]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[MUL8:%.*]] = fmul float [[MUL5]], [[TMP22]]
// CHECK6-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !18
// CHECK6-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[IDXPROM9:%.*]] = zext i32 [[TMP24]] to i64
// CHECK6-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP23]], i64 [[IDXPROM9]]
// CHECK6-NEXT:    store float [[MUL8]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    [[ADD11:%.*]] = add i32 [[TMP25]], 1
// CHECK6-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK6:       omp.dispatch.inc:
// CHECK6-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    [[ADD12:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK6-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    [[ADD13:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK6-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK6:       omp.dispatch.end:
// CHECK6-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK6-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK6-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK6:       .omp.final.then:
// CHECK6-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK6:       .omp.final.done:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK6-SAME: () #[[ATTR0]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK6-NEXT:    [[TMP0:%.*]] = load i8, i8* [[I]], align 1
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_CASTED]] to i8*
// CHECK6-NEXT:    store i8 [[TMP0]], i8* [[CONV]], align 1
// CHECK6-NEXT:    [[TMP1:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load i8, i8* [[A]], align 1
// CHECK6-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_CASTED]] to i8*
// CHECK6-NEXT:    store i8 [[TMP2]], i8* [[CONV1]], align 1
// CHECK6-NEXT:    [[TMP3:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK6-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK6-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK6-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK6-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK6-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK6-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK6-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK6-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK6-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK6-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK6-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP16:%.*]] = load i8, i8* [[A]], align 1
// CHECK6-NEXT:    store i8 [[TMP16]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    [[CONV3:%.*]] = sext i8 [[TMP17]] to i32
// CHECK6-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV3]]
// CHECK6-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK6-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK6-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK6-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK6-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK6-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK6-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK6-NEXT:    [[TMP19:%.*]] = zext i32 [[ADD6]] to i64
// CHECK6-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP19]])
// CHECK6-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115.region_id, i32 2, i8** [[TMP14]], i8** [[TMP15]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK6-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK6-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK6:       omp_offload.failed:
// CHECK6-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115(i64 [[TMP1]], i64 [[TMP3]]) #[[ATTR3]]
// CHECK6-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK6:       omp_offload.cont:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK6-SAME: (i64 [[I:%.*]], i64 [[A:%.*]]) #[[ATTR1]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i8*
// CHECK6-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_ADDR]] to i8*
// CHECK6-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK6-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR1]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 8
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK6-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 8
// CHECK6-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK6-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK6-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK6-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK6-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK6-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK6-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK6-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK6-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK6-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK6-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK6-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK6:       omp.precond.then:
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK6-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK6-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK6-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK6:       cond.true:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK6-NEXT:    br label [[COND_END:%.*]]
// CHECK6:       cond.false:
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    br label [[COND_END]]
// CHECK6:       cond.end:
// CHECK6-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK6-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[TMP14:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK6-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP14]], 0
// CHECK6-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK6:       omp_if.then:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK6-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !21
// CHECK6-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK6-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !21
// CHECK6-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP17]] to i32
// CHECK6-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK6-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK6-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK6-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !15, !llvm.access.group !21
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK6-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK6-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK6:       omp_if.else:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK6:       omp.inner.for.cond13:
// CHECK6-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK6-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK6:       omp.inner.for.body15:
// CHECK6-NEXT:    [[TMP22:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP22]] to i32
// CHECK6-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP23]], 1
// CHECK6-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK6-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK6-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK6:       omp.body.continue20:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK6:       omp.inner.for.inc21:
// CHECK6-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK6-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP24:![0-9]+]]
// CHECK6:       omp.inner.for.end23:
// CHECK6-NEXT:    br label [[OMP_IF_END]]
// CHECK6:       omp_if.end:
// CHECK6-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK6:       omp.loop.exit:
// CHECK6-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK6-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK6-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK6:       .omp.final.then:
// CHECK6-NEXT:    [[TMP29:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP29]] to i32
// CHECK6-NEXT:    [[TMP30:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP30]] to i32
// CHECK6-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK6-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK6-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK6-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK6-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK6-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK6-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK6-NEXT:    store i8 [[CONV32]], i8* [[TMP0]], align 1
// CHECK6-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK6:       .omp.final.done:
// CHECK6-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK6:       omp.precond.end:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK6-SAME: () #[[ATTR0]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[CALL:%.*]] = call signext i32 @_Z9ftemplateIiET_v()
// CHECK6-NEXT:    ret i32 [[CALL]]
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK6-SAME: () #[[ATTR0]] comdat {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK6-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK6-NEXT:    [[TMP0:%.*]] = load i16, i16* [[AA]], align 2
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK6-NEXT:    store i16 [[TMP0]], i16* [[CONV]], align 2
// CHECK6-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to i64*
// CHECK6-NEXT:    store i64 [[TMP1]], i64* [[TMP3]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK6-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK6-NEXT:    store i8* null, i8** [[TMP6]], align 8
// CHECK6-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 100)
// CHECK6-NEXT:    [[TMP9:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135.region_id, i32 1, i8** [[TMP7]], i8** [[TMP8]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.11, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK6-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK6-NEXT:    br i1 [[TMP10]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK6:       omp_offload.failed:
// CHECK6-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135(i64 [[TMP1]]) #[[ATTR3]]
// CHECK6-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK6:       omp_offload.cont:
// CHECK6-NEXT:    ret i32 0
//
//
// CHECK6-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK6-SAME: (i64 [[AA:%.*]]) #[[ATTR1]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK6-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK6-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR1]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK6-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 8
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK6-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK6-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK6-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK6:       omp.dispatch.cond:
// CHECK6-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK6-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK6:       cond.true:
// CHECK6-NEXT:    br label [[COND_END:%.*]]
// CHECK6:       cond.false:
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    br label [[COND_END]]
// CHECK6:       cond.end:
// CHECK6-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK6-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK6-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK6:       omp.dispatch.body:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !26
// CHECK6-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK6-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !26
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK6-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK6-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP27:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK6:       omp.dispatch.inc:
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK6-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK6-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK6:       omp.dispatch.end:
// CHECK6-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK6-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK6-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK6:       .omp.final.then:
// CHECK6-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK6:       .omp.final.done:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK6-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK6-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK7-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK7-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK7-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK7-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK7-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK7-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK7-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK7-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK7-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK7-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK7-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK7-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK7-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK7-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK7-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK7-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK7-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK7-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 4571424)
// CHECK7-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK7-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3:[0-9]+]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK7-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK7-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK7-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK7-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK7-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK7-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK7-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK7-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK7-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i32 16) ]
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK7-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK7-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP16]], i32 [[TMP17]]
// CHECK7-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[MUL3:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK7-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP19]], i32 [[TMP20]]
// CHECK7-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP21]]
// CHECK7-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP22]], i32 [[TMP23]]
// CHECK7-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK7-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK7-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK7-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK7-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK7-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK7-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK7-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK7-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK7-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK7-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK7-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK7-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK7-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK7-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK7-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK7-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK7-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK7-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK7-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK7-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK7-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 4571424)
// CHECK7-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK7-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK7-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK7-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK7-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK7-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK7-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK7-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK7-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK7-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK7-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK7-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK7-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 4, !nontemporal !16
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i32 [[TMP13]]
// CHECK7-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK7-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK7-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP15]], i32 [[TMP16]]
// CHECK7-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK7-NEXT:    [[MUL3:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK7-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK7-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP18]], i32 [[TMP19]]
// CHECK7-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX4]], align 4
// CHECK7-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP20]]
// CHECK7-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 4, !nontemporal !16
// CHECK7-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK7-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP21]], i32 [[TMP22]]
// CHECK7-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK7-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK7-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK7-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK7-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK7-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK7-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK7-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK7-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK7-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK7-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK7-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK7-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK7-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK7-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK7-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK7-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK7-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK7-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK7-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 16908289)
// CHECK7-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK7-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK7-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK7-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK7-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK7-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..4 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK7-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK7-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK7-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK7-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK7-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK7:       omp.dispatch.cond:
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK7-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK7:       omp.dispatch.body:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK7-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK7-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK7-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP17]], i32 [[TMP18]]
// CHECK7-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[MUL4:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK7-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP20]], i32 [[TMP21]]
// CHECK7-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[MUL6:%.*]] = fmul float [[MUL4]], [[TMP22]]
// CHECK7-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP23]], i32 [[TMP24]]
// CHECK7-NEXT:    store float [[MUL6]], float* [[ARRAYIDX7]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    [[ADD8:%.*]] = add i32 [[TMP25]], 1
// CHECK7-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK7:       omp.dispatch.inc:
// CHECK7-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    [[ADD9:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK7-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    [[ADD10:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK7-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK7:       omp.dispatch.end:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK7-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK7-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK7-SAME: () #[[ATTR0]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK7-NEXT:    [[TMP0:%.*]] = load i8, i8* [[I]], align 1
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_CASTED]] to i8*
// CHECK7-NEXT:    store i8 [[TMP0]], i8* [[CONV]], align 1
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i8, i8* [[A]], align 1
// CHECK7-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_CASTED]] to i8*
// CHECK7-NEXT:    store i8 [[TMP2]], i8* [[CONV1]], align 1
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK7-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK7-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP16:%.*]] = load i8, i8* [[A]], align 1
// CHECK7-NEXT:    store i8 [[TMP16]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[CONV3:%.*]] = sext i8 [[TMP17]] to i32
// CHECK7-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV3]]
// CHECK7-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK7-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK7-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK7-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK7-NEXT:    [[TMP19:%.*]] = zext i32 [[ADD6]] to i64
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP19]])
// CHECK7-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115.region_id, i32 2, i8** [[TMP14]], i8** [[TMP15]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK7-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115(i32 [[TMP1]], i32 [[TMP3]]) #[[ATTR3]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK7-SAME: (i32 [[I:%.*]], i32 [[A:%.*]]) #[[ATTR1]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_ADDR]] to i8*
// CHECK7-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_ADDR]] to i8*
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK7-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR1]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 4
// CHECK7-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK7-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK7-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK7-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK7-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK7-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK7-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK7-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK7-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK7-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK7:       omp.precond.then:
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK7-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK7-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK7-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK7-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP14]], 0
// CHECK7-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK7:       omp_if.then:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK7-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK7-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !22
// CHECK7-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP17]] to i32
// CHECK7-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK7-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK7-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK7-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !16, !llvm.access.group !22
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK7-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK7-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK7:       omp_if.else:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK7:       omp.inner.for.cond13:
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK7-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK7:       omp.inner.for.body15:
// CHECK7-NEXT:    [[TMP22:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP22]] to i32
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP23]], 1
// CHECK7-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK7-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK7-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK7:       omp.body.continue20:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK7:       omp.inner.for.inc21:
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK7-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK7:       omp.inner.for.end23:
// CHECK7-NEXT:    br label [[OMP_IF_END]]
// CHECK7:       omp_if.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK7-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK7-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    [[TMP29:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP29]] to i32
// CHECK7-NEXT:    [[TMP30:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP30]] to i32
// CHECK7-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK7-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK7-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK7-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK7-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK7-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK7-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK7-NEXT:    store i8 [[CONV32]], i8* [[TMP0]], align 1
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK7:       omp.precond.end:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK7-SAME: () #[[ATTR0]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[CALL:%.*]] = call i32 @_Z9ftemplateIiET_v()
// CHECK7-NEXT:    ret i32 [[CALL]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK7-SAME: () #[[ATTR0]] comdat {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK7-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK7-NEXT:    [[TMP0:%.*]] = load i16, i16* [[AA]], align 2
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK7-NEXT:    store i16 [[TMP0]], i16* [[CONV]], align 2
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP3]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP6]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 100)
// CHECK7-NEXT:    [[TMP9:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135.region_id, i32 1, i8** [[TMP7]], i8** [[TMP8]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.11, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK7-NEXT:    br i1 [[TMP10]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135(i32 [[TMP1]]) #[[ATTR3]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    ret i32 0
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK7-SAME: (i32 [[AA:%.*]]) #[[ATTR1]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK7-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR1]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK7-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK7-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK7:       omp.dispatch.cond:
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK7-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK7:       omp.dispatch.body:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !27
// CHECK7-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK7-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !27
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK7-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK7-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK7:       omp.dispatch.inc:
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK7-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK7-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK7:       omp.dispatch.end:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK7-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK7-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK7-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK8-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK8-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK8-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK8-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK8-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK8-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK8-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK8-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK8-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK8-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK8-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK8-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK8-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK8-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK8-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK8-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK8-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK8-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK8-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK8-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK8-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK8-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK8-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK8-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 4571424)
// CHECK8-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK8-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK8-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK8:       omp_offload.failed:
// CHECK8-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3:[0-9]+]]
// CHECK8-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK8:       omp_offload.cont:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK8-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK8-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK8-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK8-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK8-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK8-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK8-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK8-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK8-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK8-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK8-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i32 16) ]
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK8-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK8-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP16]], i32 [[TMP17]]
// CHECK8-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[MUL3:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK8-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP19]], i32 [[TMP20]]
// CHECK8-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP21]]
// CHECK8-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP22]], i32 [[TMP23]]
// CHECK8-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK8-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK8-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK8-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK8-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK8-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK8-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK8-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK8-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK8-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK8-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK8-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK8-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK8-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK8-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK8-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK8-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK8-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK8-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK8-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK8-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK8-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK8-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK8-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK8-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK8-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK8-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK8-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 4571424)
// CHECK8-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK8-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK8-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK8:       omp_offload.failed:
// CHECK8-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK8-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK8:       omp_offload.cont:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK8-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK8-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK8-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK8-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK8-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK8-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK8-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK8-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK8-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK8-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK8-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK8-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK8-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK8-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 4, !nontemporal !16
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i32 [[TMP13]]
// CHECK8-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK8-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 4
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK8-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP15]], i32 [[TMP16]]
// CHECK8-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK8-NEXT:    [[MUL3:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK8-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 4
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK8-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP18]], i32 [[TMP19]]
// CHECK8-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX4]], align 4
// CHECK8-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP20]]
// CHECK8-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 4, !nontemporal !16
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK8-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP21]], i32 [[TMP22]]
// CHECK8-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK8-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK8-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK8-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK8-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK8-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK8-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to float**
// CHECK8-NEXT:    store float* [[TMP0]], float** [[TMP5]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to float**
// CHECK8-NEXT:    store float* [[TMP0]], float** [[TMP7]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK8-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK8-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to float**
// CHECK8-NEXT:    store float* [[TMP1]], float** [[TMP10]], align 4
// CHECK8-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to float**
// CHECK8-NEXT:    store float* [[TMP1]], float** [[TMP12]], align 4
// CHECK8-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK8-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to float**
// CHECK8-NEXT:    store float* [[TMP2]], float** [[TMP15]], align 4
// CHECK8-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to float**
// CHECK8-NEXT:    store float* [[TMP2]], float** [[TMP17]], align 4
// CHECK8-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK8-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK8-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to float**
// CHECK8-NEXT:    store float* [[TMP3]], float** [[TMP20]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to float**
// CHECK8-NEXT:    store float* [[TMP3]], float** [[TMP22]], align 4
// CHECK8-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK8-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK8-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 16908289)
// CHECK8-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103.region_id, i32 4, i8** [[TMP24]], i8** [[TMP25]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK8-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK8-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK8:       omp_offload.failed:
// CHECK8-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103(float* [[TMP0]], float* [[TMP1]], float* [[TMP2]], float* [[TMP3]]) #[[ATTR3]]
// CHECK8-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK8:       omp_offload.cont:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK8-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR1]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK8-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK8-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK8-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK8-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK8-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..4 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK8-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR1]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK8-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK8-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK8-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK8-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK8-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK8:       omp.dispatch.cond:
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK8-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK8:       omp.dispatch.body:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK8-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK8-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK8-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP17]], i32 [[TMP18]]
// CHECK8-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[MUL4:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK8-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP20]], i32 [[TMP21]]
// CHECK8-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[MUL6:%.*]] = fmul float [[MUL4]], [[TMP22]]
// CHECK8-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP23]], i32 [[TMP24]]
// CHECK8-NEXT:    store float [[MUL6]], float* [[ARRAYIDX7]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    [[ADD8:%.*]] = add i32 [[TMP25]], 1
// CHECK8-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK8:       omp.dispatch.inc:
// CHECK8-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    [[ADD9:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK8-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    [[ADD10:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK8-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK8:       omp.dispatch.end:
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK8-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK8-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK8-SAME: () #[[ATTR0]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x i8*], align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK8-NEXT:    [[TMP0:%.*]] = load i8, i8* [[I]], align 1
// CHECK8-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_CASTED]] to i8*
// CHECK8-NEXT:    store i8 [[TMP0]], i8* [[CONV]], align 1
// CHECK8-NEXT:    [[TMP1:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load i8, i8* [[A]], align 1
// CHECK8-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_CASTED]] to i8*
// CHECK8-NEXT:    store i8 [[TMP2]], i8* [[CONV1]], align 1
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK8-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK8-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK8-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK8-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK8-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK8-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK8-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP16:%.*]] = load i8, i8* [[A]], align 1
// CHECK8-NEXT:    store i8 [[TMP16]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    [[CONV3:%.*]] = sext i8 [[TMP17]] to i32
// CHECK8-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV3]]
// CHECK8-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK8-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK8-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK8-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK8-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK8-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK8-NEXT:    [[TMP19:%.*]] = zext i32 [[ADD6]] to i64
// CHECK8-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP19]])
// CHECK8-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115.region_id, i32 2, i8** [[TMP14]], i8** [[TMP15]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK8-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK8-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK8:       omp_offload.failed:
// CHECK8-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115(i32 [[TMP1]], i32 [[TMP3]]) #[[ATTR3]]
// CHECK8-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK8:       omp_offload.cont:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK8-SAME: (i32 [[I:%.*]], i32 [[A:%.*]]) #[[ATTR1]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK8-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_ADDR]] to i8*
// CHECK8-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_ADDR]] to i8*
// CHECK8-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK8-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR1]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 4
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK8-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 4
// CHECK8-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK8-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK8-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK8-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK8-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK8-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK8-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK8-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK8-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK8-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK8:       omp.precond.then:
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK8-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK8-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK8-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK8-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP14]], 0
// CHECK8-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK8:       omp_if.then:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK8-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK8-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !22
// CHECK8-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP17]] to i32
// CHECK8-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK8-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK8-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK8-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !16, !llvm.access.group !22
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK8-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK8-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK8:       omp_if.else:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK8:       omp.inner.for.cond13:
// CHECK8-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK8-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK8:       omp.inner.for.body15:
// CHECK8-NEXT:    [[TMP22:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP22]] to i32
// CHECK8-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP23]], 1
// CHECK8-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK8-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK8-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK8:       omp.body.continue20:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK8:       omp.inner.for.inc21:
// CHECK8-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK8-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK8:       omp.inner.for.end23:
// CHECK8-NEXT:    br label [[OMP_IF_END]]
// CHECK8:       omp_if.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK8-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK8-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    [[TMP29:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP29]] to i32
// CHECK8-NEXT:    [[TMP30:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP30]] to i32
// CHECK8-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK8-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK8-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK8-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK8-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK8-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK8-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK8-NEXT:    store i8 [[CONV32]], i8* [[TMP0]], align 1
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK8:       omp.precond.end:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK8-SAME: () #[[ATTR0]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[CALL:%.*]] = call i32 @_Z9ftemplateIiET_v()
// CHECK8-NEXT:    ret i32 [[CALL]]
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK8-SAME: () #[[ATTR0]] comdat {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK8-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x i8*], align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK8-NEXT:    [[TMP0:%.*]] = load i16, i16* [[AA]], align 2
// CHECK8-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK8-NEXT:    store i16 [[TMP0]], i16* [[CONV]], align 2
// CHECK8-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP3:%.*]] = bitcast i8** [[TMP2]] to i32*
// CHECK8-NEXT:    store i32 [[TMP1]], i32* [[TMP3]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK8-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK8-NEXT:    store i8* null, i8** [[TMP6]], align 4
// CHECK8-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 100)
// CHECK8-NEXT:    [[TMP9:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135.region_id, i32 1, i8** [[TMP7]], i8** [[TMP8]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.11, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK8-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK8-NEXT:    br i1 [[TMP10]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK8:       omp_offload.failed:
// CHECK8-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135(i32 [[TMP1]]) #[[ATTR3]]
// CHECK8-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK8:       omp_offload.cont:
// CHECK8-NEXT:    ret i32 0
//
//
// CHECK8-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK8-SAME: (i32 [[AA:%.*]]) #[[ATTR1]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK8-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK8-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK8-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR1]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK8-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK8-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK8-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK8-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK8:       omp.dispatch.cond:
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK8-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK8:       omp.dispatch.body:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !27
// CHECK8-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK8-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !27
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK8-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK8-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK8:       omp.dispatch.inc:
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK8-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK8-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK8:       omp.dispatch.end:
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK8-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK8-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK8-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK9-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK9-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK9-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK9-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK9-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP1]], i64 16) ]
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 7
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[TMP5:%.*]] = load float*, float** [[B_ADDR]], align 8, !llvm.access.group !2
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP6]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP5]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP7:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[TMP8:%.*]] = load float*, float** [[C_ADDR]], align 8, !llvm.access.group !2
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[TMP9]] to i64
// CHECK9-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP8]], i64 [[IDXPROM1]]
// CHECK9-NEXT:    [[TMP10:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[MUL3:%.*]] = fmul float [[TMP7]], [[TMP10]]
// CHECK9-NEXT:    [[TMP11:%.*]] = load float*, float** [[D_ADDR]], align 8, !llvm.access.group !2
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP12]] to i64
// CHECK9-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP11]], i64 [[IDXPROM4]]
// CHECK9-NEXT:    [[TMP13:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP13]]
// CHECK9-NEXT:    [[TMP14:%.*]] = load float*, float** [[A_ADDR]], align 8, !llvm.access.group !2
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP15]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK9-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK9-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK9-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK9-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK9-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 7
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK9-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP5]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK9-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[TMP8]] to i64
// CHECK9-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP7]], i64 [[IDXPROM1]]
// CHECK9-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK9-NEXT:    [[MUL3:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK9-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK9-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP11]] to i64
// CHECK9-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP10]], i64 [[IDXPROM4]]
// CHECK9-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX5]], align 4
// CHECK9-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP12]]
// CHECK9-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP14]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK9-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK9-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK9-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK9-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[CMP:%.*]] = icmp ule i32 [[TMP1]], [[TMP2]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[MUL:%.*]] = mul i32 [[TMP3]], 127
// CHECK9-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 8, !llvm.access.group !9
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP5]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 8, !llvm.access.group !9
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[IDXPROM1:%.*]] = zext i32 [[TMP8]] to i64
// CHECK9-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP7]], i64 [[IDXPROM1]]
// CHECK9-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[MUL3:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK9-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 8, !llvm.access.group !9
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[IDXPROM4:%.*]] = zext i32 [[TMP11]] to i64
// CHECK9-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP10]], i64 [[IDXPROM4]]
// CHECK9-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP12]]
// CHECK9-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 8, !llvm.access.group !9
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = zext i32 [[TMP14]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[ADD9:%.*]] = add i32 [[TMP15]], 1
// CHECK9-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK9-SAME: () #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    [[I7:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK9-NEXT:    [[TMP0:%.*]] = load i8, i8* [[A]], align 1
// CHECK9-NEXT:    store i8 [[TMP0]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK9-NEXT:    [[TMP1:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK9-NEXT:    [[CONV:%.*]] = sext i8 [[TMP1]] to i32
// CHECK9-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK9-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK9-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK9-NEXT:    store i8 [[TMP3]], i8* [[I4]], align 1
// CHECK9-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK9-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP4]] to i32
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK9-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK9:       simd.if.then:
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i8, i8* [[I]], align 1
// CHECK9-NEXT:    store i8 [[TMP6]], i8* [[DOTLINEAR_START]], align 1
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK9-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP9:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !12
// CHECK9-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP9]] to i32
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK9-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK9-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK9-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !12
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK9-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK9-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP12]] to i32
// CHECK9-NEXT:    [[TMP13:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK9-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP13]] to i32
// CHECK9-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK9-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK9-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK9-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK9-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK9-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK9-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK9-NEXT:    store i8 [[CONV21]], i8* [[I]], align 1
// CHECK9-NEXT:    br label [[SIMD_IF_END]]
// CHECK9:       simd.if.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK9-SAME: () #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[CALL:%.*]] = call signext i32 @_Z9ftemplateIiET_v()
// CHECK9-NEXT:    ret i32 [[CALL]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK9-SAME: () #[[ATTR0]] comdat {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK9-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK9-NEXT:    ret i32 0
//
//
// CHECK10-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK10-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK10-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK10-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK10-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK10-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP1]], i64 16) ]
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK10-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 7
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK10-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[TMP5:%.*]] = load float*, float** [[B_ADDR]], align 8, !llvm.access.group !2
// CHECK10-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP6]] to i64
// CHECK10-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP5]], i64 [[IDXPROM]]
// CHECK10-NEXT:    [[TMP7:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[TMP8:%.*]] = load float*, float** [[C_ADDR]], align 8, !llvm.access.group !2
// CHECK10-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[TMP9]] to i64
// CHECK10-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP8]], i64 [[IDXPROM1]]
// CHECK10-NEXT:    [[TMP10:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[MUL3:%.*]] = fmul float [[TMP7]], [[TMP10]]
// CHECK10-NEXT:    [[TMP11:%.*]] = load float*, float** [[D_ADDR]], align 8, !llvm.access.group !2
// CHECK10-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP12]] to i64
// CHECK10-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP11]], i64 [[IDXPROM4]]
// CHECK10-NEXT:    [[TMP13:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP13]]
// CHECK10-NEXT:    [[TMP14:%.*]] = load float*, float** [[A_ADDR]], align 8, !llvm.access.group !2
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP15]] to i64
// CHECK10-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM7]]
// CHECK10-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK10:       omp.body.continue:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK10-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK10-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK10-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK10-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK10-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK10-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 7
// CHECK10-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK10-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 8
// CHECK10-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK10-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP5]] to i64
// CHECK10-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i64 [[IDXPROM]]
// CHECK10-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK10-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK10-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK10-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[TMP8]] to i64
// CHECK10-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP7]], i64 [[IDXPROM1]]
// CHECK10-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK10-NEXT:    [[MUL3:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK10-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK10-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP11]] to i64
// CHECK10-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP10]], i64 [[IDXPROM4]]
// CHECK10-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX5]], align 4
// CHECK10-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP12]]
// CHECK10-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK10-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4
// CHECK10-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP14]] to i64
// CHECK10-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM7]]
// CHECK10-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4
// CHECK10-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK10:       omp.body.continue:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK10-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK10-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK10-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK10-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK10-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[CMP:%.*]] = icmp ule i32 [[TMP1]], [[TMP2]]
// CHECK10-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[MUL:%.*]] = mul i32 [[TMP3]], 127
// CHECK10-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK10-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 8, !llvm.access.group !9
// CHECK10-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP5]] to i64
// CHECK10-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i64 [[IDXPROM]]
// CHECK10-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 8, !llvm.access.group !9
// CHECK10-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[IDXPROM1:%.*]] = zext i32 [[TMP8]] to i64
// CHECK10-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP7]], i64 [[IDXPROM1]]
// CHECK10-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[MUL3:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK10-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 8, !llvm.access.group !9
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[IDXPROM4:%.*]] = zext i32 [[TMP11]] to i64
// CHECK10-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP10]], i64 [[IDXPROM4]]
// CHECK10-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP12]]
// CHECK10-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 8, !llvm.access.group !9
// CHECK10-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[IDXPROM7:%.*]] = zext i32 [[TMP14]] to i64
// CHECK10-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM7]]
// CHECK10-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK10:       omp.body.continue:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    [[ADD9:%.*]] = add i32 [[TMP15]], 1
// CHECK10-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK10-SAME: () #[[ATTR0]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK10-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i8, align 1
// CHECK10-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK10-NEXT:    [[I7:%.*]] = alloca i8, align 1
// CHECK10-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK10-NEXT:    [[TMP0:%.*]] = load i8, i8* [[A]], align 1
// CHECK10-NEXT:    store i8 [[TMP0]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK10-NEXT:    [[TMP1:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK10-NEXT:    [[CONV:%.*]] = sext i8 [[TMP1]] to i32
// CHECK10-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK10-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK10-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK10-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK10-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK10-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK10-NEXT:    store i8 [[TMP3]], i8* [[I4]], align 1
// CHECK10-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK10-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP4]] to i32
// CHECK10-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK10-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK10:       simd.if.then:
// CHECK10-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    [[TMP6:%.*]] = load i8, i8* [[I]], align 1
// CHECK10-NEXT:    store i8 [[TMP6]], i8* [[DOTLINEAR_START]], align 1
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK10-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !12
// CHECK10-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK10-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP9:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !12
// CHECK10-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP9]] to i32
// CHECK10-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK10-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK10-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK10-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK10-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !12
// CHECK10-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK10:       omp.body.continue:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK10-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK10-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    [[TMP12:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK10-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP12]] to i32
// CHECK10-NEXT:    [[TMP13:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK10-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP13]] to i32
// CHECK10-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK10-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK10-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK10-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK10-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK10-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK10-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK10-NEXT:    store i8 [[CONV21]], i8* [[I]], align 1
// CHECK10-NEXT:    br label [[SIMD_IF_END]]
// CHECK10:       simd.if.end:
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK10-SAME: () #[[ATTR0]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[CALL:%.*]] = call signext i32 @_Z9ftemplateIiET_v()
// CHECK10-NEXT:    ret i32 [[CALL]]
//
//
// CHECK10-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK10-SAME: () #[[ATTR0]] comdat {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK10-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !15
// CHECK10-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK10-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK10-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK10-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !15
// CHECK10-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK10:       omp.body.continue:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK10-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK10-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK10-NEXT:    ret i32 0
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK11-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK11-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK11-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK11-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK11-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP1]], i32 16) ]
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 7
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[TMP5:%.*]] = load float*, float** [[B_ADDR]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP5]], i32 [[TMP6]]
// CHECK11-NEXT:    [[TMP7:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[TMP8:%.*]] = load float*, float** [[C_ADDR]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP8]], i32 [[TMP9]]
// CHECK11-NEXT:    [[TMP10:%.*]] = load float, float* [[ARRAYIDX1]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[MUL2:%.*]] = fmul float [[TMP7]], [[TMP10]]
// CHECK11-NEXT:    [[TMP11:%.*]] = load float*, float** [[D_ADDR]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP11]], i32 [[TMP12]]
// CHECK11-NEXT:    [[TMP13:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP13]]
// CHECK11-NEXT:    [[TMP14:%.*]] = load float*, float** [[A_ADDR]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK11-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK11-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK11-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK11-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK11-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK11-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 7
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK11-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i32 [[TMP5]]
// CHECK11-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK11-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP7]], i32 [[TMP8]]
// CHECK11-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX1]], align 4
// CHECK11-NEXT:    [[MUL2:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK11-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK11-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP10]], i32 [[TMP11]]
// CHECK11-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK11-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP12]]
// CHECK11-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4
// CHECK11-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK11-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK11-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK11-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK11-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK11-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[CMP:%.*]] = icmp ule i32 [[TMP1]], [[TMP2]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[MUL:%.*]] = mul i32 [[TMP3]], 127
// CHECK11-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i32 [[TMP5]]
// CHECK11-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP7]], i32 [[TMP8]]
// CHECK11-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX1]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[MUL2:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK11-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP10]], i32 [[TMP11]]
// CHECK11-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP12]]
// CHECK11-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK11-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[ADD6:%.*]] = add i32 [[TMP15]], 1
// CHECK11-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK11-SAME: () #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    [[I7:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK11-NEXT:    [[TMP0:%.*]] = load i8, i8* [[A]], align 1
// CHECK11-NEXT:    store i8 [[TMP0]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK11-NEXT:    [[TMP1:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK11-NEXT:    [[CONV:%.*]] = sext i8 [[TMP1]] to i32
// CHECK11-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK11-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK11-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK11-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK11-NEXT:    store i8 [[TMP3]], i8* [[I4]], align 1
// CHECK11-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK11-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP4]] to i32
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK11-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK11:       simd.if.then:
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i8, i8* [[I]], align 1
// CHECK11-NEXT:    store i8 [[TMP6]], i8* [[DOTLINEAR_START]], align 1
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK11-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP9:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !13
// CHECK11-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP9]] to i32
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK11-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK11-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK11-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !13
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK11-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK11-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP12]] to i32
// CHECK11-NEXT:    [[TMP13:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK11-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP13]] to i32
// CHECK11-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK11-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK11-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK11-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK11-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK11-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK11-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK11-NEXT:    store i8 [[CONV21]], i8* [[I]], align 1
// CHECK11-NEXT:    br label [[SIMD_IF_END]]
// CHECK11:       simd.if.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK11-SAME: () #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[CALL:%.*]] = call i32 @_Z9ftemplateIiET_v()
// CHECK11-NEXT:    ret i32 [[CALL]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK11-SAME: () #[[ATTR0]] comdat {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK11-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK11-NEXT:    ret i32 0
//
//
// CHECK12-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK12-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK12-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK12-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK12-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[TMP1:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK12-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP1]], i32 16) ]
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK12-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 7
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK12-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[TMP5:%.*]] = load float*, float** [[B_ADDR]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP5]], i32 [[TMP6]]
// CHECK12-NEXT:    [[TMP7:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[TMP8:%.*]] = load float*, float** [[C_ADDR]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP8]], i32 [[TMP9]]
// CHECK12-NEXT:    [[TMP10:%.*]] = load float, float* [[ARRAYIDX1]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[MUL2:%.*]] = fmul float [[TMP7]], [[TMP10]]
// CHECK12-NEXT:    [[TMP11:%.*]] = load float*, float** [[D_ADDR]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP11]], i32 [[TMP12]]
// CHECK12-NEXT:    [[TMP13:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP13]]
// CHECK12-NEXT:    [[TMP14:%.*]] = load float*, float** [[A_ADDR]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK12-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK12:       omp.body.continue:
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK12-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK12-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK12-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK12-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK12-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK12-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 7
// CHECK12-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK12-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK12-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 4
// CHECK12-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i32 [[TMP5]]
// CHECK12-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK12-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK12-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK12-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP7]], i32 [[TMP8]]
// CHECK12-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX1]], align 4
// CHECK12-NEXT:    [[MUL2:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK12-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK12-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK12-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP10]], i32 [[TMP11]]
// CHECK12-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK12-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP12]]
// CHECK12-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK12-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4
// CHECK12-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK12-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4
// CHECK12-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK12:       omp.body.continue:
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK12-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK12-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK12-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK12-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK12-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[CMP:%.*]] = icmp ule i32 [[TMP1]], [[TMP2]]
// CHECK12-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[MUL:%.*]] = mul i32 [[TMP3]], 127
// CHECK12-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK12-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i32 [[TMP5]]
// CHECK12-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP7]], i32 [[TMP8]]
// CHECK12-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX1]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[MUL2:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK12-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP10]], i32 [[TMP11]]
// CHECK12-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP12]]
// CHECK12-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK12-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK12:       omp.body.continue:
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    [[ADD6:%.*]] = add i32 [[TMP15]], 1
// CHECK12-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK12-SAME: () #[[ATTR0]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK12-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i8, align 1
// CHECK12-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK12-NEXT:    [[I7:%.*]] = alloca i8, align 1
// CHECK12-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK12-NEXT:    [[TMP0:%.*]] = load i8, i8* [[A]], align 1
// CHECK12-NEXT:    store i8 [[TMP0]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK12-NEXT:    [[TMP1:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK12-NEXT:    [[CONV:%.*]] = sext i8 [[TMP1]] to i32
// CHECK12-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK12-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK12-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK12-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK12-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK12-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK12-NEXT:    store i8 [[TMP3]], i8* [[I4]], align 1
// CHECK12-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK12-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP4]] to i32
// CHECK12-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK12-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK12:       simd.if.then:
// CHECK12-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    [[TMP6:%.*]] = load i8, i8* [[I]], align 1
// CHECK12-NEXT:    store i8 [[TMP6]], i8* [[DOTLINEAR_START]], align 1
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK12-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !13
// CHECK12-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK12-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP9:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !13
// CHECK12-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP9]] to i32
// CHECK12-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK12-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK12-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK12-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK12-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !13
// CHECK12-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK12:       omp.body.continue:
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK12-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK12-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    [[TMP12:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK12-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP12]] to i32
// CHECK12-NEXT:    [[TMP13:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK12-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP13]] to i32
// CHECK12-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK12-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK12-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK12-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK12-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK12-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK12-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK12-NEXT:    store i8 [[CONV21]], i8* [[I]], align 1
// CHECK12-NEXT:    br label [[SIMD_IF_END]]
// CHECK12:       simd.if.end:
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK12-SAME: () #[[ATTR0]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[CALL:%.*]] = call i32 @_Z9ftemplateIiET_v()
// CHECK12-NEXT:    ret i32 [[CALL]]
//
//
// CHECK12-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK12-SAME: () #[[ATTR0]] comdat {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !16
// CHECK12-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK12-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK12-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK12-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !16
// CHECK12-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK12:       omp.body.continue:
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK12-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK12-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK12-NEXT:    ret i32 0
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK13-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK13-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK13-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK13-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[TMP1:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK13-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP1]], i64 16) ]
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 7
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP5:%.*]] = load float*, float** [[B_ADDR]], align 8, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP6]] to i64
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP5]], i64 [[IDXPROM]]
// CHECK13-NEXT:    [[TMP7:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP8:%.*]] = load float*, float** [[C_ADDR]], align 8, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[TMP9]] to i64
// CHECK13-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP8]], i64 [[IDXPROM1]]
// CHECK13-NEXT:    [[TMP10:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[MUL3:%.*]] = fmul float [[TMP7]], [[TMP10]]
// CHECK13-NEXT:    [[TMP11:%.*]] = load float*, float** [[D_ADDR]], align 8, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP12]] to i64
// CHECK13-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP11]], i64 [[IDXPROM4]]
// CHECK13-NEXT:    [[TMP13:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP13]]
// CHECK13-NEXT:    [[TMP14:%.*]] = load float*, float** [[A_ADDR]], align 8, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP15]] to i64
// CHECK13-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM7]]
// CHECK13-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK13-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK13-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK13-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK13-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK13-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 7
// CHECK13-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK13-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK13-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 8, !nontemporal !7
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK13-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP5]] to i64
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i64 [[IDXPROM]]
// CHECK13-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK13-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK13-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[TMP8]] to i64
// CHECK13-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP7]], i64 [[IDXPROM1]]
// CHECK13-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK13-NEXT:    [[MUL3:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK13-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK13-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP11]] to i64
// CHECK13-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP10]], i64 [[IDXPROM4]]
// CHECK13-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX5]], align 4
// CHECK13-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP12]]
// CHECK13-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 8, !nontemporal !7
// CHECK13-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4
// CHECK13-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP14]] to i64
// CHECK13-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM7]]
// CHECK13-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK13-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK13-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK13-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK13-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[CMP:%.*]] = icmp ule i32 [[TMP1]], [[TMP2]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[MUL:%.*]] = mul i32 [[TMP3]], 127
// CHECK13-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 8, !llvm.access.group !10
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP5]] to i64
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i64 [[IDXPROM]]
// CHECK13-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 8, !llvm.access.group !10
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[IDXPROM1:%.*]] = zext i32 [[TMP8]] to i64
// CHECK13-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP7]], i64 [[IDXPROM1]]
// CHECK13-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[MUL3:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK13-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 8, !llvm.access.group !10
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[IDXPROM4:%.*]] = zext i32 [[TMP11]] to i64
// CHECK13-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP10]], i64 [[IDXPROM4]]
// CHECK13-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP12]]
// CHECK13-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 8, !llvm.access.group !10
// CHECK13-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[IDXPROM7:%.*]] = zext i32 [[TMP14]] to i64
// CHECK13-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM7]]
// CHECK13-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[ADD9:%.*]] = add i32 [[TMP15]], 1
// CHECK13-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK13-SAME: () #[[ATTR0]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    [[I7:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK13-NEXT:    [[TMP0:%.*]] = load i8, i8* [[A]], align 1
// CHECK13-NEXT:    store i8 [[TMP0]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK13-NEXT:    [[TMP1:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK13-NEXT:    [[CONV:%.*]] = sext i8 [[TMP1]] to i32
// CHECK13-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK13-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK13-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK13-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK13-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK13-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK13-NEXT:    store i8 [[TMP3]], i8* [[I4]], align 1
// CHECK13-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK13-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP4]] to i32
// CHECK13-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK13-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK13:       simd.if.then:
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[TMP6:%.*]] = load i8, i8* [[I]], align 1
// CHECK13-NEXT:    store i8 [[TMP6]], i8* [[DOTLINEAR_START]], align 1
// CHECK13-NEXT:    [[TMP7:%.*]] = load i8, i8* [[A]], align 1
// CHECK13-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP7]], 0
// CHECK13-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK13:       omp_if.then:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK13-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP10:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !13
// CHECK13-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP10]] to i32
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK13-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK13-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK13-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !7, !llvm.access.group !13
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK13-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK13:       omp_if.else:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK13:       omp.inner.for.cond13:
// CHECK13-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK13-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK13:       omp.inner.for.body15:
// CHECK13-NEXT:    [[TMP15:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK13-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP15]] to i32
// CHECK13-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK13-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK13-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK13-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK13:       omp.body.continue20:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK13:       omp.inner.for.inc21:
// CHECK13-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK13-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK13:       omp.inner.for.end23:
// CHECK13-NEXT:    br label [[OMP_IF_END]]
// CHECK13:       omp_if.end:
// CHECK13-NEXT:    [[TMP18:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK13-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP18]] to i32
// CHECK13-NEXT:    [[TMP19:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK13-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP19]] to i32
// CHECK13-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK13-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK13-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK13-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK13-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK13-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK13-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK13-NEXT:    store i8 [[CONV32]], i8* [[I]], align 1
// CHECK13-NEXT:    br label [[SIMD_IF_END]]
// CHECK13:       simd.if.end:
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK13-SAME: () #[[ATTR0]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[CALL:%.*]] = call signext i32 @_Z9ftemplateIiET_v()
// CHECK13-NEXT:    ret i32 [[CALL]]
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK13-SAME: () #[[ATTR0]] comdat {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK13-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK13-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK13-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK13-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK13-NEXT:    ret i32 0
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK14-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK14-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK14-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK14-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK14-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[TMP1:%.*]] = load float*, float** [[A_ADDR]], align 8
// CHECK14-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP1]], i64 16) ]
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 7
// CHECK14-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK14-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP5:%.*]] = load float*, float** [[B_ADDR]], align 8, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP6]] to i64
// CHECK14-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP5]], i64 [[IDXPROM]]
// CHECK14-NEXT:    [[TMP7:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP8:%.*]] = load float*, float** [[C_ADDR]], align 8, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[TMP9]] to i64
// CHECK14-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP8]], i64 [[IDXPROM1]]
// CHECK14-NEXT:    [[TMP10:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[MUL3:%.*]] = fmul float [[TMP7]], [[TMP10]]
// CHECK14-NEXT:    [[TMP11:%.*]] = load float*, float** [[D_ADDR]], align 8, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP12]] to i64
// CHECK14-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP11]], i64 [[IDXPROM4]]
// CHECK14-NEXT:    [[TMP13:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP13]]
// CHECK14-NEXT:    [[TMP14:%.*]] = load float*, float** [[A_ADDR]], align 8, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP15]] to i64
// CHECK14-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM7]]
// CHECK14-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK14-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK14-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK14-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK14-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK14-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK14-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 7
// CHECK14-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK14-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK14-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 8, !nontemporal !7
// CHECK14-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK14-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP5]] to i64
// CHECK14-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i64 [[IDXPROM]]
// CHECK14-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK14-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 8
// CHECK14-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK14-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[TMP8]] to i64
// CHECK14-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP7]], i64 [[IDXPROM1]]
// CHECK14-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK14-NEXT:    [[MUL3:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK14-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 8
// CHECK14-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK14-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP11]] to i64
// CHECK14-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP10]], i64 [[IDXPROM4]]
// CHECK14-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX5]], align 4
// CHECK14-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP12]]
// CHECK14-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 8, !nontemporal !7
// CHECK14-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4
// CHECK14-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP14]] to i64
// CHECK14-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM7]]
// CHECK14-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK14-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK14-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK14-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK14-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK14-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK14-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK14-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[CMP:%.*]] = icmp ule i32 [[TMP1]], [[TMP2]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[MUL:%.*]] = mul i32 [[TMP3]], 127
// CHECK14-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK14-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 8, !llvm.access.group !10
// CHECK14-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP5]] to i64
// CHECK14-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i64 [[IDXPROM]]
// CHECK14-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 8, !llvm.access.group !10
// CHECK14-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[IDXPROM1:%.*]] = zext i32 [[TMP8]] to i64
// CHECK14-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP7]], i64 [[IDXPROM1]]
// CHECK14-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[MUL3:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK14-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 8, !llvm.access.group !10
// CHECK14-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[IDXPROM4:%.*]] = zext i32 [[TMP11]] to i64
// CHECK14-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP10]], i64 [[IDXPROM4]]
// CHECK14-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[MUL6:%.*]] = fmul float [[MUL3]], [[TMP12]]
// CHECK14-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 8, !llvm.access.group !10
// CHECK14-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[IDXPROM7:%.*]] = zext i32 [[TMP14]] to i64
// CHECK14-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM7]]
// CHECK14-NEXT:    store float [[MUL6]], float* [[ARRAYIDX8]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    [[ADD9:%.*]] = add i32 [[TMP15]], 1
// CHECK14-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK14-SAME: () #[[ATTR0]] {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK14-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK14-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK14-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK14-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i8, align 1
// CHECK14-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK14-NEXT:    [[I7:%.*]] = alloca i8, align 1
// CHECK14-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK14-NEXT:    [[TMP0:%.*]] = load i8, i8* [[A]], align 1
// CHECK14-NEXT:    store i8 [[TMP0]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK14-NEXT:    [[TMP1:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK14-NEXT:    [[CONV:%.*]] = sext i8 [[TMP1]] to i32
// CHECK14-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK14-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK14-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK14-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK14-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK14-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK14-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK14-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK14-NEXT:    store i8 [[TMP3]], i8* [[I4]], align 1
// CHECK14-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK14-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP4]] to i32
// CHECK14-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK14-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK14:       simd.if.then:
// CHECK14-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[TMP6:%.*]] = load i8, i8* [[I]], align 1
// CHECK14-NEXT:    store i8 [[TMP6]], i8* [[DOTLINEAR_START]], align 1
// CHECK14-NEXT:    [[TMP7:%.*]] = load i8, i8* [[A]], align 1
// CHECK14-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP7]], 0
// CHECK14-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK14:       omp_if.then:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK14-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !13
// CHECK14-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK14-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP10:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !13
// CHECK14-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP10]] to i32
// CHECK14-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK14-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK14-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK14-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !7, !llvm.access.group !13
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK14-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK14-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK14:       omp_if.else:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK14:       omp.inner.for.cond13:
// CHECK14-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK14-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK14:       omp.inner.for.body15:
// CHECK14-NEXT:    [[TMP15:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK14-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP15]] to i32
// CHECK14-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK14-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK14-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK14-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK14:       omp.body.continue20:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK14:       omp.inner.for.inc21:
// CHECK14-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK14-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK14:       omp.inner.for.end23:
// CHECK14-NEXT:    br label [[OMP_IF_END]]
// CHECK14:       omp_if.end:
// CHECK14-NEXT:    [[TMP18:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK14-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP18]] to i32
// CHECK14-NEXT:    [[TMP19:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK14-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP19]] to i32
// CHECK14-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK14-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK14-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK14-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK14-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK14-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK14-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK14-NEXT:    store i8 [[CONV32]], i8* [[I]], align 1
// CHECK14-NEXT:    br label [[SIMD_IF_END]]
// CHECK14:       simd.if.end:
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK14-SAME: () #[[ATTR0]] {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[CALL:%.*]] = call signext i32 @_Z9ftemplateIiET_v()
// CHECK14-NEXT:    ret i32 [[CALL]]
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK14-SAME: () #[[ATTR0]] comdat {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK14-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK14-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK14-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK14-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK14-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK14-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK14-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK14-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK14-NEXT:    ret i32 0
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK15-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK15-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK15-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK15-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[TMP1:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK15-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP1]], i32 16) ]
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 7
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP5:%.*]] = load float*, float** [[B_ADDR]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP5]], i32 [[TMP6]]
// CHECK15-NEXT:    [[TMP7:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP8:%.*]] = load float*, float** [[C_ADDR]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP8]], i32 [[TMP9]]
// CHECK15-NEXT:    [[TMP10:%.*]] = load float, float* [[ARRAYIDX1]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[MUL2:%.*]] = fmul float [[TMP7]], [[TMP10]]
// CHECK15-NEXT:    [[TMP11:%.*]] = load float*, float** [[D_ADDR]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP11]], i32 [[TMP12]]
// CHECK15-NEXT:    [[TMP13:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP13]]
// CHECK15-NEXT:    [[TMP14:%.*]] = load float*, float** [[A_ADDR]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK15-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK15-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK15-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK15-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK15-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK15-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 7
// CHECK15-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK15-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK15-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 4, !nontemporal !8
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i32 [[TMP5]]
// CHECK15-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK15-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK15-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP7]], i32 [[TMP8]]
// CHECK15-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX1]], align 4
// CHECK15-NEXT:    [[MUL2:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK15-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK15-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK15-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP10]], i32 [[TMP11]]
// CHECK15-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK15-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP12]]
// CHECK15-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 4, !nontemporal !8
// CHECK15-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4
// CHECK15-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK15-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK15-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK15-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK15-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK15-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[CMP:%.*]] = icmp ule i32 [[TMP1]], [[TMP2]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[MUL:%.*]] = mul i32 [[TMP3]], 127
// CHECK15-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i32 [[TMP5]]
// CHECK15-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP7]], i32 [[TMP8]]
// CHECK15-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX1]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[MUL2:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK15-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP10]], i32 [[TMP11]]
// CHECK15-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP12]]
// CHECK15-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK15-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[ADD6:%.*]] = add i32 [[TMP15]], 1
// CHECK15-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK15-SAME: () #[[ATTR0]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    [[I7:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK15-NEXT:    [[TMP0:%.*]] = load i8, i8* [[A]], align 1
// CHECK15-NEXT:    store i8 [[TMP0]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK15-NEXT:    [[TMP1:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK15-NEXT:    [[CONV:%.*]] = sext i8 [[TMP1]] to i32
// CHECK15-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK15-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK15-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK15-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK15-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK15-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK15-NEXT:    store i8 [[TMP3]], i8* [[I4]], align 1
// CHECK15-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK15-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP4]] to i32
// CHECK15-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK15-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK15:       simd.if.then:
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[TMP6:%.*]] = load i8, i8* [[I]], align 1
// CHECK15-NEXT:    store i8 [[TMP6]], i8* [[DOTLINEAR_START]], align 1
// CHECK15-NEXT:    [[TMP7:%.*]] = load i8, i8* [[A]], align 1
// CHECK15-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP7]], 0
// CHECK15-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK15:       omp_if.then:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK15-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP10:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !14
// CHECK15-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP10]] to i32
// CHECK15-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK15-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK15-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK15-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !8, !llvm.access.group !14
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK15-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK15:       omp_if.else:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK15:       omp.inner.for.cond13:
// CHECK15-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK15-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK15:       omp.inner.for.body15:
// CHECK15-NEXT:    [[TMP15:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK15-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP15]] to i32
// CHECK15-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK15-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK15-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK15-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK15:       omp.body.continue20:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK15:       omp.inner.for.inc21:
// CHECK15-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK15-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK15:       omp.inner.for.end23:
// CHECK15-NEXT:    br label [[OMP_IF_END]]
// CHECK15:       omp_if.end:
// CHECK15-NEXT:    [[TMP18:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK15-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP18]] to i32
// CHECK15-NEXT:    [[TMP19:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK15-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP19]] to i32
// CHECK15-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK15-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK15-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK15-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK15-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK15-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK15-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK15-NEXT:    store i8 [[CONV32]], i8* [[I]], align 1
// CHECK15-NEXT:    br label [[SIMD_IF_END]]
// CHECK15:       simd.if.end:
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK15-SAME: () #[[ATTR0]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[CALL:%.*]] = call i32 @_Z9ftemplateIiET_v()
// CHECK15-NEXT:    ret i32 [[CALL]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK15-SAME: () #[[ATTR0]] comdat {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK15-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK15-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK15-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK15-NEXT:    ret i32 0
//
//
// CHECK16-LABEL: define {{[^@]+}}@_Z23without_schedule_clausePfS_S_S_
// CHECK16-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK16-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK16-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK16-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[TMP1:%.*]] = load float*, float** [[A_ADDR]], align 4
// CHECK16-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP1]], i32 16) ]
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK16:       omp.inner.for.cond:
// CHECK16-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP2]], [[TMP3]]
// CHECK16-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK16:       omp.inner.for.body:
// CHECK16-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 7
// CHECK16-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK16-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP5:%.*]] = load float*, float** [[B_ADDR]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP5]], i32 [[TMP6]]
// CHECK16-NEXT:    [[TMP7:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP8:%.*]] = load float*, float** [[C_ADDR]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP8]], i32 [[TMP9]]
// CHECK16-NEXT:    [[TMP10:%.*]] = load float, float* [[ARRAYIDX1]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[MUL2:%.*]] = fmul float [[TMP7]], [[TMP10]]
// CHECK16-NEXT:    [[TMP11:%.*]] = load float*, float** [[D_ADDR]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP11]], i32 [[TMP12]]
// CHECK16-NEXT:    [[TMP13:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP13]]
// CHECK16-NEXT:    [[TMP14:%.*]] = load float*, float** [[A_ADDR]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK16-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK16:       omp.body.continue:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK16:       omp.inner.for.inc:
// CHECK16-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK16-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK16:       omp.inner.for.end:
// CHECK16-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_Z18static_not_chunkedPfS_S_S_
// CHECK16-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK16-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK16-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK16-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK16:       omp.inner.for.cond:
// CHECK16-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK16-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK16:       omp.inner.for.body:
// CHECK16-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 7
// CHECK16-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK16-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK16-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 4, !nontemporal !8
// CHECK16-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK16-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i32 [[TMP5]]
// CHECK16-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK16-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 4
// CHECK16-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4
// CHECK16-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP7]], i32 [[TMP8]]
// CHECK16-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX1]], align 4
// CHECK16-NEXT:    [[MUL2:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK16-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 4
// CHECK16-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4
// CHECK16-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP10]], i32 [[TMP11]]
// CHECK16-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK16-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP12]]
// CHECK16-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 4, !nontemporal !8
// CHECK16-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4
// CHECK16-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK16-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK16:       omp.body.continue:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK16:       omp.inner.for.inc:
// CHECK16-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK16-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK16:       omp.inner.for.end:
// CHECK16-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_Z14static_chunkedPfS_S_S_
// CHECK16-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK16-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK16-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK16-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK16-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK16:       omp.inner.for.cond:
// CHECK16-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[CMP:%.*]] = icmp ule i32 [[TMP1]], [[TMP2]]
// CHECK16-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK16:       omp.inner.for.body:
// CHECK16-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[MUL:%.*]] = mul i32 [[TMP3]], 127
// CHECK16-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK16-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[TMP4:%.*]] = load float*, float** [[B_ADDR]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP4]], i32 [[TMP5]]
// CHECK16-NEXT:    [[TMP6:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[TMP7:%.*]] = load float*, float** [[C_ADDR]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[TMP8:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[TMP7]], i32 [[TMP8]]
// CHECK16-NEXT:    [[TMP9:%.*]] = load float, float* [[ARRAYIDX1]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[MUL2:%.*]] = fmul float [[TMP6]], [[TMP9]]
// CHECK16-NEXT:    [[TMP10:%.*]] = load float*, float** [[D_ADDR]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP10]], i32 [[TMP11]]
// CHECK16-NEXT:    [[TMP12:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[MUL4:%.*]] = fmul float [[MUL2]], [[TMP12]]
// CHECK16-NEXT:    [[TMP13:%.*]] = load float*, float** [[A_ADDR]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK16-NEXT:    store float [[MUL4]], float* [[ARRAYIDX5]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK16:       omp.body.continue:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK16:       omp.inner.for.inc:
// CHECK16-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    [[ADD6:%.*]] = add i32 [[TMP15]], 1
// CHECK16-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK16:       omp.inner.for.end:
// CHECK16-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_Z12test_precondv
// CHECK16-SAME: () #[[ATTR0]] {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK16-NEXT:    [[I:%.*]] = alloca i8, align 1
// CHECK16-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK16-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK16-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK16-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i8, align 1
// CHECK16-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK16-NEXT:    [[I7:%.*]] = alloca i8, align 1
// CHECK16-NEXT:    store i8 0, i8* [[A]], align 1
// CHECK16-NEXT:    [[TMP0:%.*]] = load i8, i8* [[A]], align 1
// CHECK16-NEXT:    store i8 [[TMP0]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK16-NEXT:    [[TMP1:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK16-NEXT:    [[CONV:%.*]] = sext i8 [[TMP1]] to i32
// CHECK16-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK16-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK16-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK16-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK16-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK16-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK16-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK16-NEXT:    store i8 [[TMP3]], i8* [[I4]], align 1
// CHECK16-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK16-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP4]] to i32
// CHECK16-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK16-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK16:       simd.if.then:
// CHECK16-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[TMP6:%.*]] = load i8, i8* [[I]], align 1
// CHECK16-NEXT:    store i8 [[TMP6]], i8* [[DOTLINEAR_START]], align 1
// CHECK16-NEXT:    [[TMP7:%.*]] = load i8, i8* [[A]], align 1
// CHECK16-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP7]], 0
// CHECK16-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK16:       omp_if.then:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK16:       omp.inner.for.cond:
// CHECK16-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK16-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !14
// CHECK16-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK16-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK16:       omp.inner.for.body:
// CHECK16-NEXT:    [[TMP10:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !14
// CHECK16-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP10]] to i32
// CHECK16-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK16-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK16-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK16-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK16-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !8, !llvm.access.group !14
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK16:       omp.body.continue:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK16:       omp.inner.for.inc:
// CHECK16-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK16-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK16-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK16:       omp.inner.for.end:
// CHECK16-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK16:       omp_if.else:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK16:       omp.inner.for.cond13:
// CHECK16-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK16-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK16:       omp.inner.for.body15:
// CHECK16-NEXT:    [[TMP15:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK16-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP15]] to i32
// CHECK16-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK16-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK16-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK16-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK16:       omp.body.continue20:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK16:       omp.inner.for.inc21:
// CHECK16-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK16-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK16:       omp.inner.for.end23:
// CHECK16-NEXT:    br label [[OMP_IF_END]]
// CHECK16:       omp_if.end:
// CHECK16-NEXT:    [[TMP18:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK16-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP18]] to i32
// CHECK16-NEXT:    [[TMP19:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK16-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP19]] to i32
// CHECK16-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK16-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK16-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK16-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK16-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK16-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK16-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK16-NEXT:    store i8 [[CONV32]], i8* [[I]], align 1
// CHECK16-NEXT:    br label [[SIMD_IF_END]]
// CHECK16:       simd.if.end:
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_Z4fintv
// CHECK16-SAME: () #[[ATTR0]] {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[CALL:%.*]] = call i32 @_Z9ftemplateIiET_v()
// CHECK16-NEXT:    ret i32 [[CALL]]
//
//
// CHECK16-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_v
// CHECK16-SAME: () #[[ATTR0]] comdat {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK16-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK16-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK16:       omp.inner.for.cond:
// CHECK16-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK16-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK16-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK16-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK16:       omp.inner.for.body:
// CHECK16-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK16-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK16-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK16-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK16:       omp.body.continue:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK16:       omp.inner.for.inc:
// CHECK16-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK16-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK16-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK16:       omp.inner.for.end:
// CHECK16-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK16-NEXT:    ret i32 0
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK17-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK17-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK17-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK17-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK17-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK17-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK17-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK17-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK17-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i64 16) ]
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK17-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !9
// CHECK17-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM]]
// CHECK17-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !9
// CHECK17-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP17]] to i64
// CHECK17-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 [[IDXPROM2]]
// CHECK17-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[MUL4:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK17-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !9
// CHECK17-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP20]] to i64
// CHECK17-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP19]], i64 [[IDXPROM5]]
// CHECK17-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX6]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP21]]
// CHECK17-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !9
// CHECK17-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP23]] to i64
// CHECK17-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP22]], i64 [[IDXPROM8]]
// CHECK17-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK17-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK17-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK17-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK17-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK17-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK17-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK17-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK17-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK17-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK17-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK17-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK17-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK17-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK17-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK17-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 8
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK17-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDXPROM]]
// CHECK17-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK17-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 8
// CHECK17-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK17-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP16]] to i64
// CHECK17-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP15]], i64 [[IDXPROM2]]
// CHECK17-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK17-NEXT:    [[MUL4:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK17-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 8
// CHECK17-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK17-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// CHECK17-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP18]], i64 [[IDXPROM5]]
// CHECK17-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX6]], align 4
// CHECK17-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP20]]
// CHECK17-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK17-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK17-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP22]] to i64
// CHECK17-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP21]], i64 [[IDXPROM8]]
// CHECK17-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK17-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK17-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK17-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK17-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK17-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK17-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK17-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK17-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK17-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK17-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK17-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK17:       omp.dispatch.cond:
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK17-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK17:       omp.dispatch.body:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK17-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK17-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !18
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP15]] to i64
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM]]
// CHECK17-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !18
// CHECK17-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[IDXPROM3:%.*]] = zext i32 [[TMP18]] to i64
// CHECK17-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP17]], i64 [[IDXPROM3]]
// CHECK17-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[MUL5:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK17-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !18
// CHECK17-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[IDXPROM6:%.*]] = zext i32 [[TMP21]] to i64
// CHECK17-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP20]], i64 [[IDXPROM6]]
// CHECK17-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX7]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[MUL8:%.*]] = fmul float [[MUL5]], [[TMP22]]
// CHECK17-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !18
// CHECK17-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[IDXPROM9:%.*]] = zext i32 [[TMP24]] to i64
// CHECK17-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP23]], i64 [[IDXPROM9]]
// CHECK17-NEXT:    store float [[MUL8]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[ADD11:%.*]] = add i32 [[TMP25]], 1
// CHECK17-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK17:       omp.dispatch.inc:
// CHECK17-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    [[ADD12:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK17-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    [[ADD13:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK17-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK17:       omp.dispatch.end:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK17-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK17-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK17-SAME: (i64 [[I:%.*]], i64 [[A:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i8*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_ADDR]] to i8*
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK17-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 8
// CHECK17-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK17-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK17-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK17-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK17-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK17-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK17-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK17-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK17-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK17-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK17-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK17-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK17-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK17-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK17:       omp.precond.then:
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK17-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK17-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK17-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK17-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP16:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !21
// CHECK17-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP16]] to i32
// CHECK17-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK17-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK17-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK17-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !21
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK17-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK17-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK17-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    [[TMP23:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK17-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP23]] to i32
// CHECK17-NEXT:    [[TMP24:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK17-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP24]] to i32
// CHECK17-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK17-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK17-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK17-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK17-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK17-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK17-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK17-NEXT:    store i8 [[CONV21]], i8* [[TMP0]], align 1
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK17:       omp.precond.end:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK17-SAME: (i64 [[AA:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK17-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK17-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK17-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK17:       omp.dispatch.cond:
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK17-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK17:       omp.dispatch.body:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK17-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK17-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK17:       omp.dispatch.inc:
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK17-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK17-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK17:       omp.dispatch.end:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK17-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK17-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK18-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK18-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK18-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK18-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK18-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK18-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK18-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK18-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK18-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK18-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK18-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK18-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK18-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK18-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK18-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i64 16) ]
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK18-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK18-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK18-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK18:       cond.true:
// CHECK18-NEXT:    br label [[COND_END:%.*]]
// CHECK18:       cond.false:
// CHECK18-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    br label [[COND_END]]
// CHECK18:       cond.end:
// CHECK18-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK18-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK18:       omp.inner.for.cond:
// CHECK18-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK18-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK18:       omp.inner.for.body:
// CHECK18-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK18-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK18-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !9
// CHECK18-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK18-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM]]
// CHECK18-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !9
// CHECK18-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP17]] to i64
// CHECK18-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 [[IDXPROM2]]
// CHECK18-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[MUL4:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK18-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !9
// CHECK18-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP20]] to i64
// CHECK18-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP19]], i64 [[IDXPROM5]]
// CHECK18-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX6]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP21]]
// CHECK18-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !9
// CHECK18-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP23]] to i64
// CHECK18-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP22]], i64 [[IDXPROM8]]
// CHECK18-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK18:       omp.body.continue:
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK18:       omp.inner.for.inc:
// CHECK18-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK18-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK18:       omp.inner.for.end:
// CHECK18-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK18:       omp.loop.exit:
// CHECK18-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK18-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK18-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK18:       .omp.final.then:
// CHECK18-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK18-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK18:       .omp.final.done:
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK18-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK18-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK18-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK18-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK18-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK18-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK18-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK18-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK18-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK18-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK18-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK18-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK18-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK18-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK18-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK18-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK18:       cond.true:
// CHECK18-NEXT:    br label [[COND_END:%.*]]
// CHECK18:       cond.false:
// CHECK18-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    br label [[COND_END]]
// CHECK18:       cond.end:
// CHECK18-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK18-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK18:       omp.inner.for.cond:
// CHECK18-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK18-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK18:       omp.inner.for.body:
// CHECK18-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK18-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK18-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK18-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 8
// CHECK18-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK18-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK18-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDXPROM]]
// CHECK18-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK18-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 8
// CHECK18-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK18-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP16]] to i64
// CHECK18-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP15]], i64 [[IDXPROM2]]
// CHECK18-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK18-NEXT:    [[MUL4:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK18-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 8
// CHECK18-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK18-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// CHECK18-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP18]], i64 [[IDXPROM5]]
// CHECK18-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX6]], align 4
// CHECK18-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP20]]
// CHECK18-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK18-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK18-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP22]] to i64
// CHECK18-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP21]], i64 [[IDXPROM8]]
// CHECK18-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4
// CHECK18-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK18:       omp.body.continue:
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK18:       omp.inner.for.inc:
// CHECK18-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK18-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK18:       omp.inner.for.end:
// CHECK18-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK18:       omp.loop.exit:
// CHECK18-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK18-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK18-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK18:       .omp.final.then:
// CHECK18-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK18-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK18:       .omp.final.done:
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK18-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK18-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK18-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK18-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK18-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK18-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK18-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK18-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK18-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK18-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK18-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK18-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK18-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK18-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK18-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK18-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK18-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK18:       omp.dispatch.cond:
// CHECK18-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK18-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK18:       cond.true:
// CHECK18-NEXT:    br label [[COND_END:%.*]]
// CHECK18:       cond.false:
// CHECK18-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    br label [[COND_END]]
// CHECK18:       cond.end:
// CHECK18-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK18-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK18-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK18:       omp.dispatch.body:
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK18:       omp.inner.for.cond:
// CHECK18-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK18-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK18:       omp.inner.for.body:
// CHECK18-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK18-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK18-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !18
// CHECK18-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP15]] to i64
// CHECK18-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM]]
// CHECK18-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !18
// CHECK18-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[IDXPROM3:%.*]] = zext i32 [[TMP18]] to i64
// CHECK18-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP17]], i64 [[IDXPROM3]]
// CHECK18-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[MUL5:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK18-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !18
// CHECK18-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[IDXPROM6:%.*]] = zext i32 [[TMP21]] to i64
// CHECK18-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP20]], i64 [[IDXPROM6]]
// CHECK18-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX7]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[MUL8:%.*]] = fmul float [[MUL5]], [[TMP22]]
// CHECK18-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !18
// CHECK18-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[IDXPROM9:%.*]] = zext i32 [[TMP24]] to i64
// CHECK18-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP23]], i64 [[IDXPROM9]]
// CHECK18-NEXT:    store float [[MUL8]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK18:       omp.body.continue:
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK18:       omp.inner.for.inc:
// CHECK18-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    [[ADD11:%.*]] = add i32 [[TMP25]], 1
// CHECK18-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK18:       omp.inner.for.end:
// CHECK18-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK18:       omp.dispatch.inc:
// CHECK18-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    [[ADD12:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK18-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    [[ADD13:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK18-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK18:       omp.dispatch.end:
// CHECK18-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK18-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK18-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK18:       .omp.final.then:
// CHECK18-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK18-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK18:       .omp.final.done:
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK18-SAME: (i64 [[I:%.*]], i64 [[A:%.*]]) #[[ATTR0]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK18-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK18-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK18-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK18-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i8*
// CHECK18-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_ADDR]] to i8*
// CHECK18-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK18-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR0]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 8
// CHECK18-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 8
// CHECK18-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK18-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK18-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK18-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK18-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK18-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 8
// CHECK18-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 8
// CHECK18-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 8
// CHECK18-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK18-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK18-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK18-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK18-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK18-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK18-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK18-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK18-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK18-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK18-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK18-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK18-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK18-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK18-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK18-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK18:       omp.precond.then:
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK18-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK18-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK18-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK18-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK18-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK18:       cond.true:
// CHECK18-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK18-NEXT:    br label [[COND_END:%.*]]
// CHECK18:       cond.false:
// CHECK18-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    br label [[COND_END]]
// CHECK18:       cond.end:
// CHECK18-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK18-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK18:       omp.inner.for.cond:
// CHECK18-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK18-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !21
// CHECK18-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK18-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK18:       omp.inner.for.body:
// CHECK18-NEXT:    [[TMP16:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !21
// CHECK18-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP16]] to i32
// CHECK18-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK18-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK18-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK18-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK18-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !21
// CHECK18-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK18:       omp.body.continue:
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK18:       omp.inner.for.inc:
// CHECK18-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK18-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK18-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK18:       omp.inner.for.end:
// CHECK18-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK18:       omp.loop.exit:
// CHECK18-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK18-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK18-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK18-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK18:       .omp.final.then:
// CHECK18-NEXT:    [[TMP23:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK18-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP23]] to i32
// CHECK18-NEXT:    [[TMP24:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK18-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP24]] to i32
// CHECK18-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK18-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK18-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK18-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK18-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK18-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK18-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK18-NEXT:    store i8 [[CONV21]], i8* [[TMP0]], align 1
// CHECK18-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK18:       .omp.final.done:
// CHECK18-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK18:       omp.precond.end:
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK18-SAME: (i64 [[AA:%.*]]) #[[ATTR0]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK18-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK18-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK18-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK18-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR0]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 8
// CHECK18-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK18-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 8
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK18-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK18-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK18-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK18-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK18:       omp.dispatch.cond:
// CHECK18-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK18-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK18:       cond.true:
// CHECK18-NEXT:    br label [[COND_END:%.*]]
// CHECK18:       cond.false:
// CHECK18-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    br label [[COND_END]]
// CHECK18:       cond.end:
// CHECK18-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK18-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK18-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK18:       omp.dispatch.body:
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK18:       omp.inner.for.cond:
// CHECK18-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK18-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !24
// CHECK18-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK18-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK18:       omp.inner.for.body:
// CHECK18-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK18-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK18-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK18-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !24
// CHECK18-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK18:       omp.body.continue:
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK18:       omp.inner.for.inc:
// CHECK18-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK18-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK18-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK18:       omp.inner.for.end:
// CHECK18-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK18:       omp.dispatch.inc:
// CHECK18-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK18-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK18-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK18:       omp.dispatch.end:
// CHECK18-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK18-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK18-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK18:       .omp.final.then:
// CHECK18-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK18-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK18:       .omp.final.done:
// CHECK18-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK19-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK19-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK19-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK19-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK19-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK19-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK19-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK19-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK19-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i32 16) ]
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK19-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP16]], i32 [[TMP17]]
// CHECK19-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[MUL3:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK19-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP19]], i32 [[TMP20]]
// CHECK19-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP21]]
// CHECK19-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP22]], i32 [[TMP23]]
// CHECK19-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK19-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK19-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK19-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK19-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK19-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK19-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK19-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK19-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK19-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK19-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK19-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK19-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK19-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 4
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i32 [[TMP13]]
// CHECK19-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK19-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 4
// CHECK19-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK19-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP15]], i32 [[TMP16]]
// CHECK19-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK19-NEXT:    [[MUL3:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK19-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 4
// CHECK19-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK19-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP18]], i32 [[TMP19]]
// CHECK19-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX4]], align 4
// CHECK19-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP20]]
// CHECK19-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK19-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK19-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP21]], i32 [[TMP22]]
// CHECK19-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK19-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK19-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK19-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK19-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK19-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK19-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK19-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK19-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK19-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK19-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK19-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK19:       omp.dispatch.cond:
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK19:       omp.dispatch.body:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK19-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK19-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK19-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP17]], i32 [[TMP18]]
// CHECK19-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[MUL4:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK19-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP20]], i32 [[TMP21]]
// CHECK19-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[MUL6:%.*]] = fmul float [[MUL4]], [[TMP22]]
// CHECK19-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP23]], i32 [[TMP24]]
// CHECK19-NEXT:    store float [[MUL6]], float* [[ARRAYIDX7]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[ADD8:%.*]] = add i32 [[TMP25]], 1
// CHECK19-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK19:       omp.dispatch.inc:
// CHECK19-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    [[ADD9:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK19-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    [[ADD10:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK19-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK19:       omp.dispatch.end:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK19-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK19-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK19-SAME: (i32 [[I:%.*]], i32 [[A:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_ADDR]] to i8*
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_ADDR]] to i8*
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK19-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 4
// CHECK19-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK19-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK19-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK19-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK19-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK19-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK19-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK19-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK19-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK19-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK19-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK19-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK19-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK19-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK19:       omp.precond.then:
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK19-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK19-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK19-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK19-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP16:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !22
// CHECK19-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP16]] to i32
// CHECK19-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK19-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK19-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK19-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !22
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK19-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK19-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK19-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    [[TMP23:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK19-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP23]] to i32
// CHECK19-NEXT:    [[TMP24:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK19-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP24]] to i32
// CHECK19-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK19-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK19-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK19-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK19-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK19-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK19-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK19-NEXT:    store i8 [[CONV21]], i8* [[TMP0]], align 1
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK19:       omp.precond.end:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK19-SAME: (i32 [[AA:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK19-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK19-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK19-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK19:       omp.dispatch.cond:
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK19:       omp.dispatch.body:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK19-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK19-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP26:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK19:       omp.dispatch.inc:
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK19-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK19-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK19:       omp.dispatch.end:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK19-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK19-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK20-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK20-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK20-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK20-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK20-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK20-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK20-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK20-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK20-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK20-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK20-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK20-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK20-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK20-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK20-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i32 16) ]
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK20-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK20-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK20-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK20:       cond.true:
// CHECK20-NEXT:    br label [[COND_END:%.*]]
// CHECK20:       cond.false:
// CHECK20-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    br label [[COND_END]]
// CHECK20:       cond.end:
// CHECK20-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK20-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK20:       omp.inner.for.cond:
// CHECK20-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK20-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK20:       omp.inner.for.body:
// CHECK20-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK20-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK20-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK20-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP16]], i32 [[TMP17]]
// CHECK20-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[MUL3:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK20-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP19]], i32 [[TMP20]]
// CHECK20-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP21]]
// CHECK20-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP22]], i32 [[TMP23]]
// CHECK20-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK20:       omp.body.continue:
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK20:       omp.inner.for.inc:
// CHECK20-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK20-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK20:       omp.inner.for.end:
// CHECK20-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK20:       omp.loop.exit:
// CHECK20-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK20-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK20-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK20:       .omp.final.then:
// CHECK20-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK20-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK20:       .omp.final.done:
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK20-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK20-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK20-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK20-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK20-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK20-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK20-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK20-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK20-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK20-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK20-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK20-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK20-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK20-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK20-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK20-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK20:       cond.true:
// CHECK20-NEXT:    br label [[COND_END:%.*]]
// CHECK20:       cond.false:
// CHECK20-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    br label [[COND_END]]
// CHECK20:       cond.end:
// CHECK20-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK20-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK20:       omp.inner.for.cond:
// CHECK20-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK20-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK20:       omp.inner.for.body:
// CHECK20-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK20-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK20-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK20-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 4
// CHECK20-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK20-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i32 [[TMP13]]
// CHECK20-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK20-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 4
// CHECK20-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK20-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP15]], i32 [[TMP16]]
// CHECK20-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK20-NEXT:    [[MUL3:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK20-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 4
// CHECK20-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK20-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP18]], i32 [[TMP19]]
// CHECK20-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX4]], align 4
// CHECK20-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP20]]
// CHECK20-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK20-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK20-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP21]], i32 [[TMP22]]
// CHECK20-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4
// CHECK20-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK20:       omp.body.continue:
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK20:       omp.inner.for.inc:
// CHECK20-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK20-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK20:       omp.inner.for.end:
// CHECK20-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK20:       omp.loop.exit:
// CHECK20-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK20-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK20-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK20:       .omp.final.then:
// CHECK20-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK20-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK20:       .omp.final.done:
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK20-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK20-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK20-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK20-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK20-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK20-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK20-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK20-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK20-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK20-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK20-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK20-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK20-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK20-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK20-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK20-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK20-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK20:       omp.dispatch.cond:
// CHECK20-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK20-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK20:       cond.true:
// CHECK20-NEXT:    br label [[COND_END:%.*]]
// CHECK20:       cond.false:
// CHECK20-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    br label [[COND_END]]
// CHECK20:       cond.end:
// CHECK20-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK20-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK20-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK20:       omp.dispatch.body:
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK20:       omp.inner.for.cond:
// CHECK20-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK20-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK20:       omp.inner.for.body:
// CHECK20-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK20-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK20-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK20-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP17]], i32 [[TMP18]]
// CHECK20-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[MUL4:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK20-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP20]], i32 [[TMP21]]
// CHECK20-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[MUL6:%.*]] = fmul float [[MUL4]], [[TMP22]]
// CHECK20-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP23]], i32 [[TMP24]]
// CHECK20-NEXT:    store float [[MUL6]], float* [[ARRAYIDX7]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK20:       omp.body.continue:
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK20:       omp.inner.for.inc:
// CHECK20-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    [[ADD8:%.*]] = add i32 [[TMP25]], 1
// CHECK20-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK20:       omp.inner.for.end:
// CHECK20-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK20:       omp.dispatch.inc:
// CHECK20-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    [[ADD9:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK20-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    [[ADD10:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK20-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK20:       omp.dispatch.end:
// CHECK20-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK20-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK20-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK20:       .omp.final.then:
// CHECK20-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK20-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK20:       .omp.final.done:
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK20-SAME: (i32 [[I:%.*]], i32 [[A:%.*]]) #[[ATTR0]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK20-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK20-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_ADDR]] to i8*
// CHECK20-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_ADDR]] to i8*
// CHECK20-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK20-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR0]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 4
// CHECK20-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 4
// CHECK20-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK20-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK20-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK20-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK20-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK20-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 4
// CHECK20-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 4
// CHECK20-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 4
// CHECK20-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK20-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK20-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK20-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK20-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK20-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK20-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK20-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK20-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK20-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK20-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK20-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK20-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK20-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK20-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK20-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK20:       omp.precond.then:
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK20-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK20-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK20-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK20-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK20-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK20:       cond.true:
// CHECK20-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK20-NEXT:    br label [[COND_END:%.*]]
// CHECK20:       cond.false:
// CHECK20-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    br label [[COND_END]]
// CHECK20:       cond.end:
// CHECK20-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK20-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK20:       omp.inner.for.cond:
// CHECK20-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK20-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK20-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK20-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK20:       omp.inner.for.body:
// CHECK20-NEXT:    [[TMP16:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !22
// CHECK20-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP16]] to i32
// CHECK20-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK20-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK20-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK20-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK20-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !llvm.access.group !22
// CHECK20-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK20:       omp.body.continue:
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK20:       omp.inner.for.inc:
// CHECK20-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK20-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK20-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK20:       omp.inner.for.end:
// CHECK20-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK20:       omp.loop.exit:
// CHECK20-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK20-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK20-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK20-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK20:       .omp.final.then:
// CHECK20-NEXT:    [[TMP23:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK20-NEXT:    [[CONV13:%.*]] = sext i8 [[TMP23]] to i32
// CHECK20-NEXT:    [[TMP24:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK20-NEXT:    [[CONV14:%.*]] = sext i8 [[TMP24]] to i32
// CHECK20-NEXT:    [[SUB15:%.*]] = sub i32 10, [[CONV14]]
// CHECK20-NEXT:    [[SUB16:%.*]] = sub i32 [[SUB15]], 1
// CHECK20-NEXT:    [[ADD17:%.*]] = add i32 [[SUB16]], 1
// CHECK20-NEXT:    [[DIV18:%.*]] = udiv i32 [[ADD17]], 1
// CHECK20-NEXT:    [[MUL19:%.*]] = mul nsw i32 [[DIV18]], 1
// CHECK20-NEXT:    [[ADD20:%.*]] = add nsw i32 [[CONV13]], [[MUL19]]
// CHECK20-NEXT:    [[CONV21:%.*]] = trunc i32 [[ADD20]] to i8
// CHECK20-NEXT:    store i8 [[CONV21]], i8* [[TMP0]], align 1
// CHECK20-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK20:       .omp.final.done:
// CHECK20-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK20:       omp.precond.end:
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK20-SAME: (i32 [[AA:%.*]]) #[[ATTR0]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK20-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK20-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK20-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR0]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 4
// CHECK20-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK20-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK20-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK20-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK20-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK20-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK20:       omp.dispatch.cond:
// CHECK20-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK20-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK20:       cond.true:
// CHECK20-NEXT:    br label [[COND_END:%.*]]
// CHECK20:       cond.false:
// CHECK20-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    br label [[COND_END]]
// CHECK20:       cond.end:
// CHECK20-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK20-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK20-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK20:       omp.dispatch.body:
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK20:       omp.inner.for.cond:
// CHECK20-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK20-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !25
// CHECK20-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK20-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK20:       omp.inner.for.body:
// CHECK20-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK20-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK20-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK20-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !25
// CHECK20-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK20:       omp.body.continue:
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK20:       omp.inner.for.inc:
// CHECK20-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK20-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK20-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP26:![0-9]+]]
// CHECK20:       omp.inner.for.end:
// CHECK20-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK20:       omp.dispatch.inc:
// CHECK20-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK20-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK20-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK20:       omp.dispatch.end:
// CHECK20-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK20-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK20-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK20:       .omp.final.then:
// CHECK20-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK20-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK20:       .omp.final.done:
// CHECK20-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK21-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK21-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK21-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK21-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK21-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK21-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK21-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK21-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK21-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK21-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i64 16) ]
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK21-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !9
// CHECK21-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM]]
// CHECK21-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !9
// CHECK21-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP17]] to i64
// CHECK21-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 [[IDXPROM2]]
// CHECK21-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[MUL4:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK21-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !9
// CHECK21-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP20]] to i64
// CHECK21-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP19]], i64 [[IDXPROM5]]
// CHECK21-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX6]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP21]]
// CHECK21-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !9
// CHECK21-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP23]] to i64
// CHECK21-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP22]], i64 [[IDXPROM8]]
// CHECK21-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK21-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK21-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK21-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK21-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK21-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK21-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK21-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK21-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK21-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK21-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK21-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK21-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK21-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK21-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK21-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 8, !nontemporal !16
// CHECK21-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK21-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDXPROM]]
// CHECK21-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK21-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 8
// CHECK21-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK21-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP16]] to i64
// CHECK21-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP15]], i64 [[IDXPROM2]]
// CHECK21-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK21-NEXT:    [[MUL4:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK21-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 8
// CHECK21-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK21-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// CHECK21-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP18]], i64 [[IDXPROM5]]
// CHECK21-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX6]], align 4
// CHECK21-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP20]]
// CHECK21-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 8, !nontemporal !16
// CHECK21-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK21-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP22]] to i64
// CHECK21-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP21]], i64 [[IDXPROM8]]
// CHECK21-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK21-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK21-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK21-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK21-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK21-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK21-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK21-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK21-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK21-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK21-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK21-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK21:       omp.dispatch.cond:
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK21-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK21:       omp.dispatch.body:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK21-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK21-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !19
// CHECK21-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP15]] to i64
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM]]
// CHECK21-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !19
// CHECK21-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[IDXPROM3:%.*]] = zext i32 [[TMP18]] to i64
// CHECK21-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP17]], i64 [[IDXPROM3]]
// CHECK21-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[MUL5:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK21-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !19
// CHECK21-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[IDXPROM6:%.*]] = zext i32 [[TMP21]] to i64
// CHECK21-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP20]], i64 [[IDXPROM6]]
// CHECK21-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX7]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[MUL8:%.*]] = fmul float [[MUL5]], [[TMP22]]
// CHECK21-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !19
// CHECK21-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[IDXPROM9:%.*]] = zext i32 [[TMP24]] to i64
// CHECK21-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP23]], i64 [[IDXPROM9]]
// CHECK21-NEXT:    store float [[MUL8]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    [[ADD11:%.*]] = add i32 [[TMP25]], 1
// CHECK21-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK21:       omp.dispatch.inc:
// CHECK21-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    [[ADD12:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK21-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    [[ADD13:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK21-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK21:       omp.dispatch.end:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK21-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK21-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK21-SAME: (i64 [[I:%.*]], i64 [[A:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i8*
// CHECK21-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_ADDR]] to i8*
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK21-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 8
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 8
// CHECK21-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK21-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK21-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK21-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK21-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK21-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK21-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK21-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK21-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK21-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK21-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK21-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK21-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK21-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK21-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK21:       omp.precond.then:
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK21-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK21-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK21-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP14:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK21-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP14]], 0
// CHECK21-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK21:       omp_if.then:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK21-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK21-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK21-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !22
// CHECK21-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP17]] to i32
// CHECK21-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK21-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK21-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK21-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !16, !llvm.access.group !22
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK21-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK21-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK21:       omp_if.else:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK21:       omp.inner.for.cond13:
// CHECK21-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK21-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK21:       omp.inner.for.body15:
// CHECK21-NEXT:    [[TMP22:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK21-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP22]] to i32
// CHECK21-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP23]], 1
// CHECK21-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK21-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK21-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK21:       omp.body.continue20:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK21:       omp.inner.for.inc21:
// CHECK21-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK21-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK21:       omp.inner.for.end23:
// CHECK21-NEXT:    br label [[OMP_IF_END]]
// CHECK21:       omp_if.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK21-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK21-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    [[TMP29:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK21-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP29]] to i32
// CHECK21-NEXT:    [[TMP30:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK21-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP30]] to i32
// CHECK21-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK21-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK21-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK21-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK21-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK21-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK21-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK21-NEXT:    store i8 [[CONV32]], i8* [[TMP0]], align 1
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK21:       omp.precond.end:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK21-SAME: (i64 [[AA:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK21-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 8
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK21-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK21-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK21-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK21:       omp.dispatch.cond:
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK21-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK21:       omp.dispatch.body:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK21-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK21-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK21:       omp.dispatch.inc:
// CHECK21-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK21-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK21-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK21:       omp.dispatch.end:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK21-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK21-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK22-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK22-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK22-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK22-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK22-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK22-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK22-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK22-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK22-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK22-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK22-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK22-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK22-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK22-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK22-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 8
// CHECK22-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i64 16) ]
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK22-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK22-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK22-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK22:       cond.true:
// CHECK22-NEXT:    br label [[COND_END:%.*]]
// CHECK22:       cond.false:
// CHECK22-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    br label [[COND_END]]
// CHECK22:       cond.end:
// CHECK22-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK22-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK22:       omp.inner.for.cond:
// CHECK22-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK22-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK22:       omp.inner.for.body:
// CHECK22-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK22-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK22-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !9
// CHECK22-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK22-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i64 [[IDXPROM]]
// CHECK22-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !9
// CHECK22-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP17]] to i64
// CHECK22-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP16]], i64 [[IDXPROM2]]
// CHECK22-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[MUL4:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK22-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !9
// CHECK22-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP20]] to i64
// CHECK22-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP19]], i64 [[IDXPROM5]]
// CHECK22-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX6]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP21]]
// CHECK22-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !9
// CHECK22-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP23]] to i64
// CHECK22-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP22]], i64 [[IDXPROM8]]
// CHECK22-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK22:       omp.body.continue:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK22:       omp.inner.for.inc:
// CHECK22-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK22-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK22:       omp.inner.for.end:
// CHECK22-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK22:       omp.loop.exit:
// CHECK22-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK22-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK22-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK22:       .omp.final.then:
// CHECK22-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK22-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK22:       .omp.final.done:
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK22-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK22-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK22-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK22-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK22-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK22-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK22-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK22-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK22-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK22-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK22-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK22-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK22-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK22-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK22-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK22-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK22-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK22:       cond.true:
// CHECK22-NEXT:    br label [[COND_END:%.*]]
// CHECK22:       cond.false:
// CHECK22-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    br label [[COND_END]]
// CHECK22:       cond.end:
// CHECK22-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK22-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK22:       omp.inner.for.cond:
// CHECK22-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK22-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK22:       omp.inner.for.body:
// CHECK22-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK22-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK22-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK22-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 8, !nontemporal !16
// CHECK22-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK22-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK22-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i64 [[IDXPROM]]
// CHECK22-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK22-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 8
// CHECK22-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK22-NEXT:    [[IDXPROM2:%.*]] = sext i32 [[TMP16]] to i64
// CHECK22-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP15]], i64 [[IDXPROM2]]
// CHECK22-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX3]], align 4
// CHECK22-NEXT:    [[MUL4:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK22-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 8
// CHECK22-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK22-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// CHECK22-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP18]], i64 [[IDXPROM5]]
// CHECK22-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX6]], align 4
// CHECK22-NEXT:    [[MUL7:%.*]] = fmul float [[MUL4]], [[TMP20]]
// CHECK22-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 8, !nontemporal !16
// CHECK22-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK22-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP22]] to i64
// CHECK22-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP21]], i64 [[IDXPROM8]]
// CHECK22-NEXT:    store float [[MUL7]], float* [[ARRAYIDX9]], align 4
// CHECK22-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK22:       omp.body.continue:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK22:       omp.inner.for.inc:
// CHECK22-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK22-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK22:       omp.inner.for.end:
// CHECK22-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK22:       omp.loop.exit:
// CHECK22-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK22-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK22-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK22:       .omp.final.then:
// CHECK22-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK22-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK22:       .omp.final.done:
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK22-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 8
// CHECK22-NEXT:    store float* [[A]], float** [[A_ADDR]], align 8
// CHECK22-NEXT:    store float* [[B]], float** [[B_ADDR]], align 8
// CHECK22-NEXT:    store float* [[C]], float** [[C_ADDR]], align 8
// CHECK22-NEXT:    store float* [[D]], float** [[D_ADDR]], align 8
// CHECK22-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK22-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 8 dereferenceable(8) [[A:%.*]], float** nonnull align 8 dereferenceable(8) [[B:%.*]], float** nonnull align 8 dereferenceable(8) [[C:%.*]], float** nonnull align 8 dereferenceable(8) [[D:%.*]]) #[[ATTR0]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 8
// CHECK22-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK22-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 8
// CHECK22-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 8
// CHECK22-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 8
// CHECK22-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 8
// CHECK22-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 8
// CHECK22-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 8
// CHECK22-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 8
// CHECK22-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 8
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK22-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK22-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK22:       omp.dispatch.cond:
// CHECK22-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK22-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK22:       cond.true:
// CHECK22-NEXT:    br label [[COND_END:%.*]]
// CHECK22:       cond.false:
// CHECK22-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    br label [[COND_END]]
// CHECK22:       cond.end:
// CHECK22-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK22-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK22-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK22:       omp.dispatch.body:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK22:       omp.inner.for.cond:
// CHECK22-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK22-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK22:       omp.inner.for.body:
// CHECK22-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK22-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK22-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 8, !llvm.access.group !19
// CHECK22-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[IDXPROM:%.*]] = zext i32 [[TMP15]] to i64
// CHECK22-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i64 [[IDXPROM]]
// CHECK22-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 8, !llvm.access.group !19
// CHECK22-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[IDXPROM3:%.*]] = zext i32 [[TMP18]] to i64
// CHECK22-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP17]], i64 [[IDXPROM3]]
// CHECK22-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[MUL5:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK22-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 8, !llvm.access.group !19
// CHECK22-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[IDXPROM6:%.*]] = zext i32 [[TMP21]] to i64
// CHECK22-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP20]], i64 [[IDXPROM6]]
// CHECK22-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX7]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[MUL8:%.*]] = fmul float [[MUL5]], [[TMP22]]
// CHECK22-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 8, !llvm.access.group !19
// CHECK22-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[IDXPROM9:%.*]] = zext i32 [[TMP24]] to i64
// CHECK22-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP23]], i64 [[IDXPROM9]]
// CHECK22-NEXT:    store float [[MUL8]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK22:       omp.body.continue:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK22:       omp.inner.for.inc:
// CHECK22-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    [[ADD11:%.*]] = add i32 [[TMP25]], 1
// CHECK22-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK22:       omp.inner.for.end:
// CHECK22-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK22:       omp.dispatch.inc:
// CHECK22-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    [[ADD12:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK22-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    [[ADD13:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK22-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK22:       omp.dispatch.end:
// CHECK22-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK22-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK22-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK22:       .omp.final.then:
// CHECK22-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK22-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK22:       .omp.final.done:
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK22-SAME: (i64 [[I:%.*]], i64 [[A:%.*]]) #[[ATTR0]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK22-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK22-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK22-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK22-NEXT:    [[CONV:%.*]] = bitcast i64* [[I_ADDR]] to i8*
// CHECK22-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_ADDR]] to i8*
// CHECK22-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK22-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR0]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 8
// CHECK22-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 8
// CHECK22-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK22-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK22-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK22-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK22-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK22-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 8
// CHECK22-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 8
// CHECK22-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 8
// CHECK22-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 8
// CHECK22-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK22-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK22-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK22-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK22-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK22-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK22-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK22-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK22-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK22-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK22-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK22-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK22-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK22-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK22-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK22-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK22:       omp.precond.then:
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK22-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK22-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK22-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK22-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK22-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK22:       cond.true:
// CHECK22-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK22-NEXT:    br label [[COND_END:%.*]]
// CHECK22:       cond.false:
// CHECK22-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    br label [[COND_END]]
// CHECK22:       cond.end:
// CHECK22-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK22-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP14:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK22-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP14]], 0
// CHECK22-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK22:       omp_if.then:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK22:       omp.inner.for.cond:
// CHECK22-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK22-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK22-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK22-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK22:       omp.inner.for.body:
// CHECK22-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !22
// CHECK22-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP17]] to i32
// CHECK22-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK22-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK22-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK22-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK22-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !16, !llvm.access.group !22
// CHECK22-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK22:       omp.body.continue:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK22:       omp.inner.for.inc:
// CHECK22-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK22-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK22-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK22:       omp.inner.for.end:
// CHECK22-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK22:       omp_if.else:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK22:       omp.inner.for.cond13:
// CHECK22-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK22-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK22:       omp.inner.for.body15:
// CHECK22-NEXT:    [[TMP22:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK22-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP22]] to i32
// CHECK22-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP23]], 1
// CHECK22-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK22-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK22-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK22-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK22:       omp.body.continue20:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK22:       omp.inner.for.inc21:
// CHECK22-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK22-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK22:       omp.inner.for.end23:
// CHECK22-NEXT:    br label [[OMP_IF_END]]
// CHECK22:       omp_if.end:
// CHECK22-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK22:       omp.loop.exit:
// CHECK22-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK22-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK22-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK22-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK22:       .omp.final.then:
// CHECK22-NEXT:    [[TMP29:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK22-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP29]] to i32
// CHECK22-NEXT:    [[TMP30:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK22-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP30]] to i32
// CHECK22-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK22-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK22-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK22-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK22-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK22-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK22-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK22-NEXT:    store i8 [[CONV32]], i8* [[TMP0]], align 1
// CHECK22-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK22:       .omp.final.done:
// CHECK22-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK22:       omp.precond.end:
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK22-SAME: (i64 [[AA:%.*]]) #[[ATTR0]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK22-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK22-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK22-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK22-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR0]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 8
// CHECK22-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK22-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 8
// CHECK22-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 8
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK22-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK22-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK22-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK22-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK22:       omp.dispatch.cond:
// CHECK22-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK22-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK22:       cond.true:
// CHECK22-NEXT:    br label [[COND_END:%.*]]
// CHECK22:       cond.false:
// CHECK22-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    br label [[COND_END]]
// CHECK22:       cond.end:
// CHECK22-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK22-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK22-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK22:       omp.dispatch.body:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK22:       omp.inner.for.cond:
// CHECK22-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK22-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !27
// CHECK22-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK22-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK22:       omp.inner.for.body:
// CHECK22-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK22-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK22-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK22-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !27
// CHECK22-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK22:       omp.body.continue:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK22:       omp.inner.for.inc:
// CHECK22-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK22-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK22-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
// CHECK22:       omp.inner.for.end:
// CHECK22-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK22:       omp.dispatch.inc:
// CHECK22-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK22-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK22-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK22:       omp.dispatch.end:
// CHECK22-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK22-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK22-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK22:       .omp.final.then:
// CHECK22-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK22-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK22:       .omp.final.done:
// CHECK22-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK23-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK23-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK23-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK23-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK23-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK23-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK23-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK23-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK23-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i32 16) ]
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK23-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[TMP14:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP13]], i32 [[TMP14]]
// CHECK23-NEXT:    [[TMP15:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[TMP16:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP16]], i32 [[TMP17]]
// CHECK23-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX2]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[MUL3:%.*]] = fmul float [[TMP15]], [[TMP18]]
// CHECK23-NEXT:    [[TMP19:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[TMP20:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP19]], i32 [[TMP20]]
// CHECK23-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX4]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP21]]
// CHECK23-NEXT:    [[TMP22:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP22]], i32 [[TMP23]]
// CHECK23-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK23-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK23-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK23-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 32000001, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18static_not_chunkedPfS_S_S__l86
// CHECK23-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK23-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK23-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK23-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK23-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK23-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK23-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK23-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 4571423
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK23-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 7
// CHECK23-NEXT:    [[SUB:%.*]] = sub nsw i32 32000000, [[MUL]]
// CHECK23-NEXT:    store i32 [[SUB]], i32* [[I]], align 4
// CHECK23-NEXT:    [[TMP12:%.*]] = load float*, float** [[TMP1]], align 4, !nontemporal !17
// CHECK23-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP12]], i32 [[TMP13]]
// CHECK23-NEXT:    [[TMP14:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK23-NEXT:    [[TMP15:%.*]] = load float*, float** [[TMP2]], align 4
// CHECK23-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I]], align 4
// CHECK23-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, float* [[TMP15]], i32 [[TMP16]]
// CHECK23-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX2]], align 4
// CHECK23-NEXT:    [[MUL3:%.*]] = fmul float [[TMP14]], [[TMP17]]
// CHECK23-NEXT:    [[TMP18:%.*]] = load float*, float** [[TMP3]], align 4
// CHECK23-NEXT:    [[TMP19:%.*]] = load i32, i32* [[I]], align 4
// CHECK23-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, float* [[TMP18]], i32 [[TMP19]]
// CHECK23-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX4]], align 4
// CHECK23-NEXT:    [[MUL5:%.*]] = fmul float [[MUL3]], [[TMP20]]
// CHECK23-NEXT:    [[TMP21:%.*]] = load float*, float** [[TMP0]], align 4, !nontemporal !17
// CHECK23-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I]], align 4
// CHECK23-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, float* [[TMP21]], i32 [[TMP22]]
// CHECK23-NEXT:    store float [[MUL5]], float* [[ARRAYIDX6]], align 4
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP18:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK23-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK23-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 32, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z14static_chunkedPfS_S_S__l103
// CHECK23-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK23-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK23-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK23-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK23-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK23-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK23-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK23-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 16908288, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 5)
// CHECK23-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK23:       omp.dispatch.cond:
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[TMP6]], 16908288
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 16908288, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[TMP9]], [[TMP10]]
// CHECK23-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK23:       omp.dispatch.body:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[CMP2:%.*]] = icmp ule i32 [[TMP11]], [[TMP12]]
// CHECK23-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[MUL:%.*]] = mul i32 [[TMP13]], 127
// CHECK23-NEXT:    [[ADD:%.*]] = add i32 131071, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[TMP14:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[TMP14]], i32 [[TMP15]]
// CHECK23-NEXT:    [[TMP16:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[TMP17:%.*]] = load float*, float** [[TMP2]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, float* [[TMP17]], i32 [[TMP18]]
// CHECK23-NEXT:    [[TMP19:%.*]] = load float, float* [[ARRAYIDX3]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[MUL4:%.*]] = fmul float [[TMP16]], [[TMP19]]
// CHECK23-NEXT:    [[TMP20:%.*]] = load float*, float** [[TMP3]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, float* [[TMP20]], i32 [[TMP21]]
// CHECK23-NEXT:    [[TMP22:%.*]] = load float, float* [[ARRAYIDX5]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[MUL6:%.*]] = fmul float [[MUL4]], [[TMP22]]
// CHECK23-NEXT:    [[TMP23:%.*]] = load float*, float** [[TMP0]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, float* [[TMP23]], i32 [[TMP24]]
// CHECK23-NEXT:    store float [[MUL6]], float* [[ARRAYIDX7]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    [[ADD8:%.*]] = add i32 [[TMP25]], 1
// CHECK23-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP21:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK23:       omp.dispatch.inc:
// CHECK23-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    [[ADD9:%.*]] = add i32 [[TMP26]], [[TMP27]]
// CHECK23-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    [[ADD10:%.*]] = add i32 [[TMP28]], [[TMP29]]
// CHECK23-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK23:       omp.dispatch.end:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK23-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK23-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 -2147483522, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z12test_precondv_l115
// CHECK23-SAME: (i32 [[I:%.*]], i32 [[A:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[I_ADDR]] to i8*
// CHECK23-NEXT:    [[CONV1:%.*]] = bitcast i32* [[A_ADDR]] to i8*
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i8*, i8*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i8* [[CONV]], i8* [[CONV1]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK23-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i8* nonnull align 1 dereferenceable(1) [[I:%.*]], i8* nonnull align 1 dereferenceable(1) [[A:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[I_ADDR:%.*]] = alloca i8*, align 4
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i8*, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I4:%.*]] = alloca i8, align 1
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I6:%.*]] = alloca i8, align 1
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store i8* [[I]], i8** [[I_ADDR]], align 4
// CHECK23-NEXT:    store i8* [[A]], i8** [[A_ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load i8*, i8** [[I_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i8*, i8** [[A_ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK23-NEXT:    store i8 [[TMP2]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK23-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK23-NEXT:    [[CONV:%.*]] = sext i8 [[TMP3]] to i32
// CHECK23-NEXT:    [[SUB:%.*]] = sub i32 10, [[CONV]]
// CHECK23-NEXT:    [[SUB2:%.*]] = sub i32 [[SUB]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add i32 [[SUB2]], 1
// CHECK23-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK23-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK23-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK23-NEXT:    store i8 [[TMP4]], i8* [[I4]], align 1
// CHECK23-NEXT:    [[TMP5:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK23-NEXT:    [[CONV5:%.*]] = sext i8 [[TMP5]] to i32
// CHECK23-NEXT:    [[CMP:%.*]] = icmp slt i32 [[CONV5]], 10
// CHECK23-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK23:       omp.precond.then:
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK23-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK23-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK23-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP14:%.*]] = load i8, i8* [[TMP1]], align 1
// CHECK23-NEXT:    [[TOBOOL:%.*]] = icmp ne i8 [[TMP14]], 0
// CHECK23-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK23:       omp_if.then:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK23-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !23
// CHECK23-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK23-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP17:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1, !llvm.access.group !23
// CHECK23-NEXT:    [[CONV9:%.*]] = sext i8 [[TMP17]] to i32
// CHECK23-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK23-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV9]], [[MUL]]
// CHECK23-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i8
// CHECK23-NEXT:    store i8 [[CONV11]], i8* [[I6]], align 1, !nontemporal !17, !llvm.access.group !23
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK23-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK23-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP24:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK23:       omp_if.else:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND13:%.*]]
// CHECK23:       omp.inner.for.cond13:
// CHECK23-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP14:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK23-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY15:%.*]], label [[OMP_INNER_FOR_END23:%.*]]
// CHECK23:       omp.inner.for.body15:
// CHECK23-NEXT:    [[TMP22:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK23-NEXT:    [[CONV16:%.*]] = sext i8 [[TMP22]] to i32
// CHECK23-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[TMP23]], 1
// CHECK23-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV16]], [[MUL17]]
// CHECK23-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK23-NEXT:    store i8 [[CONV19]], i8* [[I6]], align 1
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE20:%.*]]
// CHECK23:       omp.body.continue20:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC21:%.*]]
// CHECK23:       omp.inner.for.inc21:
// CHECK23-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[ADD22:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK23-NEXT:    store i32 [[ADD22]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND13]], !llvm.loop [[LOOP26:![0-9]+]]
// CHECK23:       omp.inner.for.end23:
// CHECK23-NEXT:    br label [[OMP_IF_END]]
// CHECK23:       omp_if.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK23-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK23-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    [[TMP29:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK23-NEXT:    [[CONV24:%.*]] = sext i8 [[TMP29]] to i32
// CHECK23-NEXT:    [[TMP30:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK23-NEXT:    [[CONV25:%.*]] = sext i8 [[TMP30]] to i32
// CHECK23-NEXT:    [[SUB26:%.*]] = sub i32 10, [[CONV25]]
// CHECK23-NEXT:    [[SUB27:%.*]] = sub i32 [[SUB26]], 1
// CHECK23-NEXT:    [[ADD28:%.*]] = add i32 [[SUB27]], 1
// CHECK23-NEXT:    [[DIV29:%.*]] = udiv i32 [[ADD28]], 1
// CHECK23-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[DIV29]], 1
// CHECK23-NEXT:    [[ADD31:%.*]] = add nsw i32 [[CONV24]], [[MUL30]]
// CHECK23-NEXT:    [[CONV32:%.*]] = trunc i32 [[ADD31]] to i8
// CHECK23-NEXT:    store i8 [[CONV32]], i8* [[TMP0]], align 1
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK23:       omp.precond.end:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_v_l135
// CHECK23-SAME: (i32 [[AA:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i16*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i16* [[CONV]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK23-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i16* nonnull align 2 dereferenceable(2) [[AA:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i16*, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store i16* [[AA]], i16** [[AA_ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load i16*, i16** [[AA_ADDR]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 99, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i16, i16* [[TMP0]], align 2
// CHECK23-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[CONV]])
// CHECK23-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK23:       omp.dispatch.cond:
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 99
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 99, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK23-NEXT:    br i1 [[CMP1]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK23:       omp.dispatch.body:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK23-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK23-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP29:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK23:       omp.dispatch.inc:
// CHECK23-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP13]], [[TMP14]]
// CHECK23-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP15]], [[TMP16]]
// CHECK23-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK23:       omp.dispatch.end:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK23-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK23-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 100, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK24-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z23without_schedule_clausePfS_S_S__l70
// CHECK24-SAME: (float* [[A:%.*]], float* [[B:%.*]], float* [[C:%.*]], float* [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK24-NEXT:  entry:
// CHECK24-NEXT:    [[A_ADDR:%.*]] = alloca float*, align 4
// CHECK24-NEXT:    [[B_ADDR:%.*]] = alloca float*, align 4
// CHECK24-NEXT:    [[C_ADDR:%.*]] = alloca float*, align 4
// CHECK24-NEXT:    [[D_ADDR:%.*]] = alloca float*, align 4
// CHECK24-NEXT:    store float* [[A]], float** [[A_ADDR]], align 4
// CHECK24-NEXT:    store float* [[B]], float** [[B_ADDR]], align 4
// CHECK24-NEXT:    store float* [[C]], float** [[C_ADDR]], align 4
// CHECK24-NEXT:    store float* [[D]], float** [[D_ADDR]], align 4
// CHECK24-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, float**, float**, float**, float**)* @.omp_outlined. to void (i32*, i32*, ...)*), float** [[A_ADDR]], float** [[B_ADDR]], float** [[C_ADDR]], float** [[D_ADDR]])
// CHECK24-NEXT:    ret void
//
//
// CHECK24-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK24-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], float** nonnull align 4 dereferenceable(4) [[A:%.*]], float** nonnull align 4 dereferenceable(4) [[B:%.*]], float** nonnull align 4 dereferenceable(4) [[C:%.*]], float** nonnull align 4 dereferenceable(4) [[D:%.*]]) #[[ATTR0]] {
// CHECK24-NEXT:  entry:
// CHECK24-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK24-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK24-NEXT:    [[A_ADDR:%.*]] = alloca float**, align 4
// CHECK24-NEXT:    [[B_ADDR:%.*]] = alloca float**, align 4
// CHECK24-NEXT:    [[C_ADDR:%.*]] = alloca float**, align 4
// CHECK24-NEXT:    [[D_ADDR:%.*]] = alloca float**, align 4
// CHECK24-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK24-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK24-NEXT:    store float** [[A]], float*** [[A_ADDR]], align 4
// CHECK24-NEXT:    store float** [[B]], float*** [[B_ADDR]], align 4
// CHECK24-NEXT:    store float** [[C]], float*** [[C_ADDR]], align 4
// CHECK24-NEXT:    store float** [[D]], float*** [[D_ADDR]], align 4
// CHECK24-NEXT:    [[TMP0:%.*]] = load float**, float*** [[A_ADDR]], align 4
// CHECK24-NEXT:    [[TMP1:%.*]] = load float**, float*** [[B_ADDR]], align 4
// CHECK24-NEXT:    [[TMP2:%.*]] = load float**, float*** [[C_ADDR]], align 4
// CHECK24-NEXT:    [[TMP3:%.*]] = load float**, float*** [[D_ADDR]], align 4
// CHECK24-NEXT:    [[TMP4:%.*]] = load float*, float** [[TMP0]], align 4
// CHECK24-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[TMP4]], i32 16) ]
// CHECK24-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK24-NEXT:    store i32 4571423, i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK24-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK24-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK24-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK24-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP6]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK24-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 4571423
// CHECK24-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK24:       cond.true:
// CHECK24-NEXT:    br label [[COND_END:%.*]]
// CHECK24:       cond.false:
// CHECK24-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    br label [[COND_END]]
// CHECK24:       cond.end:
// CHECK24-NEXT:    [[COND:%.*]] = phi i32 [ 4571423, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK24-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK24-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK24:       omp.inner.for.cond:
// CHECK24-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK24-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK24-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK24-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK24:       omp.inner.for.body:
// CHECK24-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK24-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 7
// CHECK24-NEXT:    [[ADD:%.*]] = add nsw i32 33, [[MUL]]
// CHECK24-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK24-NEXT:    [[TMP13:%.*]] = load float*, float** [[TMP1]], align 4, !llvm.access.group !10
// CHECK24-NEXT:    [[TMP14:%.*]]