// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -show-encoding %s | FileCheck --check-prefix=GFX11 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -show-encoding %s 2>&1 | FileCheck --check-prefixes=GFX11-ERR --implicit-check-not=error: %s

buffer_gl0_inv
// GFX11: encoding: [0x00,0x00,0xac,0xe0,0x00,0x00,0x00,0x00]

buffer_gl1_inv
// GFX11: encoding: [0x00,0x00,0xb0,0xe0,0x00,0x00,0x00,0x00]

buffer_load_b32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0xff,0x02,0x03]

buffer_load_b32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x03,0x03]

buffer_load_b32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x18,0x03]

buffer_load_b32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x65]

buffer_load_b32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_b32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x80]

buffer_load_b32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_b32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_b32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_b32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x82,0x03]

buffer_load_b32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x42,0x03]

buffer_load_b32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b32 v5, off, s[8:11], s3 offset:4095 lds
// GFX11-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_b64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x03,0x03]

buffer_load_b64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x18,0x03]

buffer_load_b64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x65]

buffer_load_b64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_b64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x80]

buffer_load_b64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_b64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_b64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_b64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x82,0x03]

buffer_load_b64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x42,0x03]

buffer_load_b64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b96 v[253:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_b96 v[5:7], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x03,0x03]

buffer_load_b96 v[5:7], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x18,0x03]

buffer_load_b96 v[5:7], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x65]

buffer_load_b96 v[5:7], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_b96 v[5:7], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x80]

buffer_load_b96 v[5:7], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_b96 v[5:7], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_b96 v[5:7], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_b96 v[5:7], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x82,0x03]

buffer_load_b96 v[5:7], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x42,0x03]

buffer_load_b96 v[5:7], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b96 v[5:7], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b128 v[252:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_b128 v[5:8], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_b128 v[5:8], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_b128 v[5:8], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_b128 v[5:8], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_b128 v[5:8], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_b128 v[5:8], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_b128 v[5:8], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_b128 v[5:8], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_b128 v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_b128 v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_b128 v[5:8], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_b128 v[5:8], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_b16 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0xff,0x02,0x03]

buffer_load_d16_b16 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_b16 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_b16 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_b16 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_b16 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_b16 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_b16 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_b16 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_b16 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_b16 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_b16 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_b16 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_x v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0xff,0x02,0x03]

buffer_load_d16_format_x v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_format_x v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_format_x v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_format_x v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_format_x v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_format_x v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_format_x v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_format_x v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_format_x v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_format_x v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_format_x v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_x v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xy v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0xff,0x02,0x03]

buffer_load_d16_format_xy v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_format_xy v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_format_xy v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_format_xy v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_format_xy v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_format_xy v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_format_xy v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_format_xy v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_format_xy v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_format_xy v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_format_xy v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xy v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyz v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_format_xyz v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_format_xyz v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyz v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyzw v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_format_xyzw v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_format_xyzw v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_format_xyzw v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_b16 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_d16_hi_b16 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_hi_b16 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_hi_b16 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_hi_b16 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_hi_b16 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_hi_b16 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_hi_b16 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_hi_b16 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_hi_b16 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_hi_b16 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_b16 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_format_x v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0xff,0x02,0x03]

buffer_load_d16_hi_format_x v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_hi_format_x v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_hi_format_x v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_hi_format_x v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_hi_format_x v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_hi_format_x v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_hi_format_x v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_hi_format_x v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_hi_format_x v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_hi_format_x v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_format_x v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_i8 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0xff,0x02,0x03]

buffer_load_d16_hi_i8 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_hi_i8 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_hi_i8 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_hi_i8 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_hi_i8 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_hi_i8 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_hi_i8 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_hi_i8 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_hi_i8 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_hi_i8 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_i8 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_u8 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0xff,0x02,0x03]

buffer_load_d16_hi_u8 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_hi_u8 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_hi_u8 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_hi_u8 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_hi_u8 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_hi_u8 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_hi_u8 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_hi_u8 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_hi_u8 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_hi_u8 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_hi_u8 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_i8 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_d16_i8 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_i8 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_i8 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_i8 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_i8 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_i8 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_i8 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_i8 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_i8 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_i8 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_i8 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_i8 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_u8 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0xff,0x02,0x03]

buffer_load_d16_u8 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x03,0x03]

buffer_load_d16_u8 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x18,0x03]

buffer_load_d16_u8 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0x65]

buffer_load_d16_u8 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_d16_u8 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0x80]

buffer_load_d16_u8 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_d16_u8 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_d16_u8 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_d16_u8 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x82,0x03]

buffer_load_d16_u8 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x42,0x03]

buffer_load_d16_u8 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_d16_u8 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0xff,0x02,0x03]

buffer_load_format_x v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_x v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_x v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_x v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_format_x v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_x v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_x v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_x v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_x v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x82,0x03]

buffer_load_format_x v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_x v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xy v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xy v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_format_xy v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xy v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xy v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xy v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x82,0x03]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:7], off, s[8:11], s3 offset:4095 glc slc dlc tfe
// GFX11: encoding: [0xff,0x7f,0x04,0xe0,0x00,0x05,0x22,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[253:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyz v[5:7], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xyz v[5:7], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_format_xyz v[5:7], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyz v[5:7], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyz v[5:7], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyz v[5:7], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x82,0x03]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[252:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyzw v[5:8], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xyzw v[5:8], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyzw v[5:8], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyzw v[5:8], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i8 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i8 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0xff,0x02,0x03]

buffer_load_i8 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x03,0x03]

buffer_load_i8 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x18,0x03]

buffer_load_i8 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x65]

buffer_load_i8 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_i8 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x80]

buffer_load_i8 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_i8 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_i8 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_i8 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x82,0x03]

buffer_load_i8 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x42,0x03]

buffer_load_i8 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i8 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i8 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i8 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i8 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i8 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i8 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i16 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i16 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_i16 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_i16 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_i16 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_i16 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_i16 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_i16 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_i16 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_i16 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_i16 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_i16 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_i16 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i16 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i16 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i16 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i16 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i16 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_i16 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u8 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u8 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0xff,0x02,0x03]

buffer_load_u8 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x03,0x03]

buffer_load_u8 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x18,0x03]

buffer_load_u8 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x65]

buffer_load_u8 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_u8 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x80]

buffer_load_u8 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_u8 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_u8 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_u8 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x82,0x03]

buffer_load_u8 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x42,0x03]

buffer_load_u8 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u8 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u8 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u8 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u8 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u8 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u8 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u16 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u16 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0xff,0x02,0x03]

buffer_load_u16 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x03,0x03]

buffer_load_u16 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x18,0x03]

buffer_load_u16 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x65]

buffer_load_u16 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_u16 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x80]

buffer_load_u16 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_u16 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_u16 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_u16 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x82,0x03]

buffer_load_u16 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x42,0x03]

buffer_load_u16 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u16 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u16 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u16 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u16 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u16 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_u16 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_lds_b32 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_b32 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_b32 off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x03,0x03]

buffer_load_lds_b32 off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x18,0x03]

buffer_load_lds_b32 off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x02,0x65]

buffer_load_lds_b32 off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x02,0x7d]

buffer_load_lds_b32 off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x02,0x80]

buffer_load_lds_b32 off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x02,0xc1]

buffer_load_lds_b32 off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x02,0xf0]

buffer_load_lds_b32 off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x02,0xf7]

buffer_load_lds_b32 v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x82,0x03]

buffer_load_lds_b32 v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x00,0x42,0x03]

buffer_load_lds_b32 off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xc4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_b32 off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xc4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_b32 off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xc4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_b32 off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xc4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_b32 off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xc4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_b32 off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xc4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_b32 off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xc4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_b32 off, s[8:11], s3 lds
// GFX11-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_lds_format_x off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_format_x off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_format_x off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x03,0x03]

buffer_load_lds_format_x off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x18,0x03]

buffer_load_lds_format_x off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x02,0x65]

buffer_load_lds_format_x off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x02,0x7d]

buffer_load_lds_format_x off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x02,0x80]

buffer_load_lds_format_x off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x02,0xc1]

buffer_load_lds_format_x off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x02,0xf0]

buffer_load_lds_format_x off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x02,0xf7]

buffer_load_lds_format_x v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x82,0x03]

buffer_load_lds_format_x v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x00,0x42,0x03]

buffer_load_lds_format_x off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xc8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_format_x off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xc8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_format_x off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xc8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_format_x off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xc8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_format_x off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xc8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_format_x off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xc8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_format_x off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xc8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i8 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i8 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i8 off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x03,0x03]

buffer_load_lds_i8 off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x18,0x03]

buffer_load_lds_i8 off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x02,0x65]

buffer_load_lds_i8 off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x02,0x7d]

buffer_load_lds_i8 off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x02,0x80]

buffer_load_lds_i8 off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x02,0xc1]

buffer_load_lds_i8 off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x02,0xf0]

buffer_load_lds_i8 off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x02,0xf7]

buffer_load_lds_i8 v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x82,0x03]

buffer_load_lds_i8 v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xb8,0xe0,0x00,0x00,0x42,0x03]

buffer_load_lds_i8 off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xb8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i8 off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xb8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i8 off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xb8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i8 off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xb8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i8 off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xb8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i8 off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xb8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i8 off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xb8,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i16 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i16 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i16 off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x03,0x03]

buffer_load_lds_i16 off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x18,0x03]

buffer_load_lds_i16 off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x02,0x65]

buffer_load_lds_i16 off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x02,0x7d]

buffer_load_lds_i16 off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x02,0x80]

buffer_load_lds_i16 off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x02,0xc1]

buffer_load_lds_i16 off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x02,0xf0]

buffer_load_lds_i16 off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x02,0xf7]

buffer_load_lds_i16 v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x82,0x03]

buffer_load_lds_i16 v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x00,0x42,0x03]

buffer_load_lds_i16 off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xc0,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i16 off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xc0,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i16 off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xc0,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i16 off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xc0,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i16 off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xc0,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i16 off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xc0,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_i16 off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xc0,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u8 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u8 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u8 off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x03,0x03]

buffer_load_lds_u8 off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x18,0x03]

buffer_load_lds_u8 off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x02,0x65]

buffer_load_lds_u8 off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x02,0x7d]

buffer_load_lds_u8 off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x02,0x80]

buffer_load_lds_u8 off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x02,0xc1]

buffer_load_lds_u8 off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x02,0xf0]

buffer_load_lds_u8 off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x02,0xf7]

buffer_load_lds_u8 v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x82,0x03]

buffer_load_lds_u8 v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xb4,0xe0,0x00,0x00,0x42,0x03]

buffer_load_lds_u8 off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xb4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u8 off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xb4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u8 off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xb4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u8 off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xb4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u8 off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xb4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u8 off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xb4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u8 off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xb4,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u16 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u16 off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u16 off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x03,0x03]

buffer_load_lds_u16 off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x18,0x03]

buffer_load_lds_u16 off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x02,0x65]

buffer_load_lds_u16 off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x02,0x7d]

buffer_load_lds_u16 off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x02,0x80]

buffer_load_lds_u16 off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x02,0xc1]

buffer_load_lds_u16 off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x02,0xf0]

buffer_load_lds_u16 off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x02,0xf7]

buffer_load_lds_u16 v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x82,0x03]

buffer_load_lds_u16 v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xbc,0xe0,0x00,0x00,0x42,0x03]

buffer_load_lds_u16 off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xbc,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u16 off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xbc,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u16 off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xbc,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u16 off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xbc,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u16 off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xbc,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u16 off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xbc,0xe0,0x00,0x00,0x02,0x03]

buffer_load_lds_u16 off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xbc,0xe0,0x00,0x00,0x02,0x03]

buffer_store_b8 v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b8 v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0xff,0x03,0x04]

buffer_store_b8 v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x04,0x04]

buffer_store_b8 v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x18,0x04]

buffer_store_b8 v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x65]

buffer_store_b8 v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_b8 v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x80]

buffer_store_b8 v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_b8 v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_b8 v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_b8 v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x83,0x04]

buffer_store_b8 v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x43,0x04]

buffer_store_b8 v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b8 v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b8 v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b8 v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b8 v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b8 v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b8 v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b16 v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b16 v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0xff,0x03,0x04]

buffer_store_b16 v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x04,0x04]

buffer_store_b16 v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x18,0x04]

buffer_store_b16 v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0x65]

buffer_store_b16 v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_b16 v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0x80]

buffer_store_b16 v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_b16 v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_b16 v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_b16 v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x83,0x04]

buffer_store_b16 v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x43,0x04]

buffer_store_b16 v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b16 v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b16 v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b16 v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b16 v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b16 v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b16 v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b32 v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b32 v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0xff,0x03,0x04]

buffer_store_b32 v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x04,0x04]

buffer_store_b32 v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x18,0x04]

buffer_store_b32 v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x65]

buffer_store_b32 v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_b32 v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x80]

buffer_store_b32 v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_b32 v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_b32 v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_b32 v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x83,0x04]

buffer_store_b32 v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x43,0x04]

buffer_store_b32 v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b32 v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b32 v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b32 v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b32 v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b32 v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b32 v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b64 v[254:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_b64 v[1:2], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_b64 v[1:2], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_b64 v[1:2], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_b64 v[1:2], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_b64 v[1:2], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_b64 v[1:2], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_b64 v[1:2], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_b64 v[1:2], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_b64 v[1:2], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x83,0x04]

buffer_store_b64 v[1:2], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_b64 v[1:2], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b64 v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b96 v[253:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_b96 v[1:3], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x04,0x04]

buffer_store_b96 v[1:3], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x18,0x04]

buffer_store_b96 v[1:3], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x65]

buffer_store_b96 v[1:3], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_b96 v[1:3], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x80]

buffer_store_b96 v[1:3], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_b96 v[1:3], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_b96 v[1:3], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_b96 v[1:3], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x83,0x04]

buffer_store_b96 v[1:3], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x43,0x04]

buffer_store_b96 v[1:3], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b96 v[1:3], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b128 v[252:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_b128 v[1:4], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x04,0x04]

buffer_store_b128 v[1:4], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x18,0x04]

buffer_store_b128 v[1:4], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x65]

buffer_store_b128 v[1:4], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_b128 v[1:4], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x80]

buffer_store_b128 v[1:4], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_b128 v[1:4], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_b128 v[1:4], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_b128 v[1:4], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x83,0x04]

buffer_store_b128 v[1:4], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x43,0x04]

buffer_store_b128 v[1:4], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_b128 v[1:4], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_x v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0xff,0x03,0x04]

buffer_store_d16_format_x v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x04,0x04]

buffer_store_d16_format_x v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x18,0x04]

buffer_store_d16_format_x v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x65]

buffer_store_d16_format_x v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_d16_format_x v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x80]

buffer_store_d16_format_x v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_d16_format_x v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_d16_format_x v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_d16_format_x v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x83,0x04]

buffer_store_d16_format_x v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x43,0x04]

buffer_store_d16_format_x v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_x v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xy v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0xff,0x03,0x04]

buffer_store_d16_format_xy v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x04,0x04]

buffer_store_d16_format_xy v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x18,0x04]

buffer_store_d16_format_xy v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x65]

buffer_store_d16_format_xy v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_d16_format_xy v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x80]

buffer_store_d16_format_xy v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_d16_format_xy v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_d16_format_xy v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_d16_format_xy v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x83,0x04]

buffer_store_d16_format_xy v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x43,0x04]

buffer_store_d16_format_xy v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xy v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyz v[254:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x04,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x18,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x65]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x80]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_d16_format_xyz v[1:2], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x83,0x04]

buffer_store_d16_format_xyz v[1:2], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x43,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyz v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyzw v[254:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_d16_format_xyzw v[1:2], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x83,0x04]

buffer_store_d16_format_xyzw v[1:2], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_format_xyzw v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b8 v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0xff,0x03,0x04]

buffer_store_d16_hi_b8 v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x04,0x04]

buffer_store_d16_hi_b8 v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x18,0x04]

buffer_store_d16_hi_b8 v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0x65]

buffer_store_d16_hi_b8 v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_d16_hi_b8 v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0x80]

buffer_store_d16_hi_b8 v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_d16_hi_b8 v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_d16_hi_b8 v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_d16_hi_b8 v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x83,0x04]

buffer_store_d16_hi_b8 v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x43,0x04]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b8 v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b16 v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0xff,0x03,0x04]

buffer_store_d16_hi_b16 v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x04,0x04]

buffer_store_d16_hi_b16 v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x18,0x04]

buffer_store_d16_hi_b16 v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0x65]

buffer_store_d16_hi_b16 v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_d16_hi_b16 v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0x80]

buffer_store_d16_hi_b16 v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_d16_hi_b16 v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_d16_hi_b16 v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_d16_hi_b16 v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x83,0x04]

buffer_store_d16_hi_b16 v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x43,0x04]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_b16 v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_format_x v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0xff,0x03,0x04]

buffer_store_d16_hi_format_x v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_d16_hi_format_x v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_d16_hi_format_x v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_d16_hi_format_x v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_d16_hi_format_x v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_d16_hi_format_x v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_d16_hi_format_x v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_d16_hi_format_x v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_d16_hi_format_x v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x83,0x04]

buffer_store_d16_hi_format_x v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_d16_hi_format_x v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0xff,0x03,0x04]

buffer_store_format_x v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_x v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_x v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_x v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_format_x v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_x v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_x v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_x v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_x v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x83,0x04]

buffer_store_format_x v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_x v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[254:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xy v[1:2], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xy v[1:2], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_format_xy v[1:2], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xy v[1:2], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xy v[1:2], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xy v[1:2], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x83,0x04]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[253:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyz v[1:3], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xyz v[1:3], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_format_xyz v[1:3], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyz v[1:3], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyz v[1:3], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyz v[1:3], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x83,0x04]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[252:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyzw v[1:4], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xyzw v[1:4], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyzw v[1:4], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyzw v[1:4], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x83,0x04]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_f32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_add_f32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_add_f32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_add_f32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_add_f32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_add_f32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_add_f32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_add_f32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_add_f32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_add_f32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_add_f32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_add_f32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_f32 v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add_u32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_add_u32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_add_u32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_add_u32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_add_u32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_add_u32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_add_u32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_add_u32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_add_u32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_add_u32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_add_u32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_add_u32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add_u32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_u64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_add_u64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_add_u64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_add_u64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_add_u64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_add_u64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_add_u64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_add_u64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_add_u64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_add_u64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_u64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and_b32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_and_b32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_and_b32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_and_b32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_and_b32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_and_b32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_and_b32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_and_b32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_and_b32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_and_b32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_and_b32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_and_b32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and_b32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_b64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_and_b64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_and_b64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_and_b64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_and_b64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_and_b64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_and_b64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_and_b64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_and_b64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_and_b64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_b64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b32 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0xfe,0x02,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_cmpswap_b32 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_cmpswap_b32 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b32 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b64 v[252:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0xfc,0x02,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_cmpswap_b64 v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_cmpswap_b64 v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_b64 v[5:8], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_f32 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_cmpswap_f32 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_cmpswap_f32 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_f32 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:4095
// GFX11-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: instruction must use glc

buffer_atomic_csub_u32 v255, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_csub_u32 v5, off, s[12:15], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_csub_u32 v5, off, s[96:99], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_csub_u32 v5, off, s[8:11], s101 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_csub_u32 v5, off, s[8:11], m0 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_csub_u32 v5, off, s[8:11], 0 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_csub_u32 v5, off, s[8:11], -1 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_csub_u32 v5, off, s[8:11], 0.5 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_csub_u32 v5, off, s[8:11], -4.0 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_csub_u32 v5, v0, s[8:11], s3 idxen offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_csub_u32 v5, v0, s[8:11], s3 offen offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 glc
// GFX11: encoding: [0x00,0x40,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:0 glc
// GFX11: encoding: [0x00,0x40,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:7 glc
// GFX11: encoding: [0x07,0x40,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:4095 glc dlc
// GFX11: encoding: [0xff,0x6f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub_u32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_dec_u32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_dec_u32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_dec_u32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_dec_u32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_dec_u32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_dec_u32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_dec_u32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_dec_u32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_dec_u32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_dec_u32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_dec_u32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_dec_u64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_dec_u64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_u64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_inc_u32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_inc_u32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_inc_u32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_inc_u32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_inc_u32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_inc_u32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_inc_u32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_inc_u32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_inc_u32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_inc_u32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_inc_u32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_inc_u64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_inc_u64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_u64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_f32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_max_f32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_max_f32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_max_f32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_max_f32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_max_f32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_max_f32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_max_f32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_max_f32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_max_f32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_max_f32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_max_f32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_f32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_i32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_max_i32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_max_i32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_max_i32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_max_i32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_max_i32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_max_i32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_max_i32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_max_i32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_max_i32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_max_i32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_max_i32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_i32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_i64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_max_i64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_max_i64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_max_i64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_max_i64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_max_i64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_max_i64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_max_i64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_max_i64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_max_i64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_i64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_u32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_max_u32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_max_u32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_max_u32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_max_u32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_max_u32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_max_u32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_max_u32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_max_u32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_max_u32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_max_u32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_max_u32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_u32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_u64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_max_u64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_max_u64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_max_u64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_max_u64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_max_u64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_max_u64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_max_u64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_max_u64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_max_u64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_max_u64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_f32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_min_f32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_min_f32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_min_f32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_min_f32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_min_f32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_min_f32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_min_f32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_min_f32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_min_f32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_min_f32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_min_f32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_f32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_i32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_min_i32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_min_i32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_min_i32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_min_i32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_min_i32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_min_i32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_min_i32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_min_i32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_min_i32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_min_i32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_min_i32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_i32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_i64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_min_i64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_min_i64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_min_i64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_min_i64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_min_i64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_min_i64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_min_i64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_min_i64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_min_i64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_i64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_u32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_min_u32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_min_u32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_min_u32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_min_u32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_min_u32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_min_u32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_min_u32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_min_u32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_min_u32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_min_u32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_min_u32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_u32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_u64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_min_u64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_min_u64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_min_u64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_min_u64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_min_u64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_min_u64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_min_u64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_min_u64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_min_u64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_min_u64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or_b32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_or_b32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_or_b32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_or_b32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_or_b32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_or_b32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_or_b32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_or_b32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_or_b32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_or_b32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_or_b32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_or_b32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or_b32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_b64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_or_b64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_or_b64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_or_b64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_or_b64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_or_b64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_or_b64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_or_b64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_or_b64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_or_b64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_b64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_sub_u32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_sub_u32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_sub_u32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_sub_u32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_sub_u32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_sub_u32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_sub_u32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_sub_u32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_sub_u32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_sub_u32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_sub_u32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_sub_u64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_sub_u64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_u64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_swap_b32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_swap_b32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_swap_b32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_swap_b32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_swap_b32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_swap_b32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_swap_b32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_swap_b32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_swap_b32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_swap_b32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_swap_b32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_swap_b64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_swap_b64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_b64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b32 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_xor_b32 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_xor_b32 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_xor_b32 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_xor_b32 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_xor_b32 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_xor_b32 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_xor_b32 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_xor_b32 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_xor_b32 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_xor_b32 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_xor_b32 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b32 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b64 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_xor_b64 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_xor_b64 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_b64 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x2c,0xe1,0x00,0x05,0x02,0x03]
