/*
 $License:
   Copyright 2011 InvenSense, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
  $
 */

/* WARNING: autogenerated code, do not modify */
/**
 * @defgroup DMPDEFAULT 
 * @brief  
 *
 * @{
 * @file     inv_setup_dmpMantis.c
 * @brief    
 *
 *
 */

#include "mltypes.h"
#include "dmpDefault.h"
#include "dmpKey.h"
#include "dmpmap.h"
#include "mldl.h"

#define CFG_25  1786
#define CFG_24  1782
#define CFG_26  1790
#define CFG_21  1899
#define CFG_20  1728
#define CFG_23  1911
#define CFG_TAP4  1905
#define CFG_TAP5  1906
#define CFG_TAP6  1907
#define CFG_1  1865
#define CFG_TAP0  1899
#define CFG_TAP1  1901
#define CFG_TAP2  1902
#define CFG_TAP_SAVE_ACCB  1770
#define CFG_ORIENT_IRQ_1  1798
#define CFG_ORIENT_IRQ_2  1821
#define CFG_ORIENT_IRQ_3  1826
#define FCFG_MAG_VAL  774
#define CFG_TAP_QUANTIZE  1730
#define FCFG_3  936
#define FCFG_1  891
#define CFG_ACCEL_FILTER  1076
#define FCFG_2  895
#define CFG_3D  1629
#define FCFG_7  902
#define CFG_3C  1627
#define FCFG_5  1030
#define FCFG_4  880
#define CFG_3B  1625
#define CFG_TAP_JERK  1722
#define FCFG_6  954
#define CFG_12  1894
#define CFG_TAP7  1908
#define CFG_14  1871
#define CFG_15  1876
#define CFG_16  1912
#define CFG_TAP_CLEAR_STICKY  1914
#define CFG_6  1920
#define CFG_7  1014
#define CFG_4  1634
#define CFG_5  1831
#define CFG_3  1623
#define CFG_GYRO_SOURCE  1859
#define CFG_TAP3  1903
#define CFG_EXTERNAL  1884
#define CFG_8  1854
#define CFG_9  1860
#define CFG_ORIENT_2  1816
#define CFG_ORIENT_1  1796
#define CFG_MOTION_BIAS  1023
#define FCFG_MAG_MOV  791
#define TEMPLABEL  1491
#define FCFG_ACCEL_INIT  847


#define D_0_22  (22+512)
#define D_0_24  (24+512)

#define D_0_36  (36)
#define D_0_52  (52)
#define D_0_96  (96)
#define D_0_104 (104)
#define D_0_108 (108)
#define D_0_163 (163)
#define D_0_188 (188)
#define D_0_192 (192)
#define D_0_224 (224)
#define D_0_228 (228)
#define D_0_232 (232)
#define D_0_236 (236)

#define D_1_2 (256 + 2)
#define D_1_4 (256 + 4)
#define D_1_8 (256 + 8)
#define D_1_10 (256 + 10)
#define D_1_24 (256 + 24)
#define D_1_28 (256 + 28)
#define D_1_92 (256 + 92)
#define D_1_96 (256 + 96)
#define D_1_98 (256 + 98)
#define D_1_106 (256 + 106)
#define D_1_108 (256 + 108)
#define D_1_112 (256 + 112)
#define D_1_128 (256 + 144)
#define D_1_152 (256 + 12)
#define D_1_168 (256 + 168)
#define D_1_175 (256 + 175)
#define D_1_178 (256 + 178)
#define D_1_236 (256 + 236)
#define D_1_244 (256 + 244)
#define D_2_12  (512+12)
#define D_2_96  (512+96)
#define D_2_108 (512+108)
#define D_2_244 (512+244)
#define D_2_248 (512+248)
#define D_2_252 (512+252)

#define CPASS_BIAS_X (35*16+4)
#define CPASS_BIAS_Y (35*16+8)
#define CPASS_BIAS_Z (35*16+12)
#define CPASS_MTX_00 (36*16)
#define CPASS_MTX_01 (36*16+4)
#define CPASS_MTX_02 (36*16+8)
#define CPASS_MTX_10 (36*16+12)
#define CPASS_MTX_11 (37*16)
#define CPASS_MTX_12 (37*16+4)
#define CPASS_MTX_20 (37*16+8)
#define CPASS_MTX_21 (37*16+12)
#define CPASS_MTX_22 (43*16+12)
#define D_ACT0    (40*16)
#define D_ACSX   (40*16+4)
#define D_ACSY   (40*16+8)
#define D_ACSZ   (40*16+12)

static const tKeyLabel dmpTConfig[] = {
    {KEY_CFG_25, CFG_25},
    {KEY_CFG_24, CFG_24},
    {KEY_CFG_26, CFG_26},
    {KEY_CFG_21, CFG_21},
    {KEY_CFG_20, CFG_20},
    {KEY_CFG_23, CFG_23},
    {KEY_CFG_TAP4, CFG_TAP4},
    {KEY_CFG_TAP5, CFG_TAP5},
    {KEY_CFG_TAP6, CFG_TAP6},
    {KEY_CFG_1, CFG_1},
    {KEY_CFG_TAP0, CFG_TAP0},
    {KEY_CFG_TAP1, CFG_TAP1},
    {KEY_CFG_TAP2, CFG_TAP2},
    {KEY_CFG_TAP_SAVE_ACCB, CFG_TAP_SAVE_ACCB},
    {KEY_CFG_ORIENT_IRQ_1, CFG_ORIENT_IRQ_1},
    {KEY_CFG_ORIENT_IRQ_2, CFG_ORIENT_IRQ_2},
    {KEY_CFG_ORIENT_IRQ_3, CFG_ORIENT_IRQ_3},
    {KEY_FCFG_MAG_VAL, FCFG_MAG_VAL},
    {KEY_CFG_TAP_QUANTIZE, CFG_TAP_QUANTIZE},
    {KEY_FCFG_3, FCFG_3},
    {KEY_FCFG_1, FCFG_1},
//    {KEY_CFG_ACCEL_FILTER, CFG_ACCEL_FILTER},
    {KEY_FCFG_2, FCFG_2},
    {KEY_CFG_3D, CFG_3D},
    {KEY_FCFG_7, FCFG_7},
    {KEY_CFG_3C, CFG_3C},
    {KEY_FCFG_5, FCFG_5},
    {KEY_FCFG_4, FCFG_4},
    {KEY_CFG_3B, CFG_3B},
    {KEY_CFG_TAP_JERK, CFG_TAP_JERK},
    {KEY_FCFG_6, FCFG_6},
    {KEY_CFG_12, CFG_12},
    {KEY_CFG_TAP7, CFG_TAP7},
    {KEY_CFG_14, CFG_14},
    {KEY_CFG_15, CFG_15},
    {KEY_CFG_16, CFG_16},
    {KEY_CFG_TAP_CLEAR_STICKY, CFG_TAP_CLEAR_STICKY},
    {KEY_CFG_6, CFG_6},
    {KEY_CFG_7, CFG_7},
    {KEY_CFG_4, CFG_4},
    {KEY_CFG_5, CFG_5},
    {KEY_CFG_3, CFG_3},
    {KEY_CFG_GYRO_SOURCE, CFG_GYRO_SOURCE},
    {KEY_CFG_TAP3, CFG_TAP3},
    {KEY_CFG_EXTERNAL, CFG_EXTERNAL},
    {KEY_CFG_8, CFG_8},
    {KEY_CFG_9, CFG_9},
    {KEY_CFG_ORIENT_2, CFG_ORIENT_2},
    {KEY_CFG_ORIENT_1, CFG_ORIENT_1},
    {KEY_CFG_MOTION_BIAS, CFG_MOTION_BIAS},
    {KEY_FCFG_MAG_MOV, FCFG_MAG_MOV},
//    {KEY_TEMPLABEL, TEMPLABEL},
    {KEY_FCFG_ACCEL_INIT, FCFG_ACCEL_INIT},
    {KEY_D_0_22, D_0_22},
    {KEY_D_0_24, D_0_24},
    {KEY_D_0_36, D_0_36},
    {KEY_D_0_52, D_0_52},
    {KEY_D_0_96, D_0_96},
    {KEY_D_0_104, D_0_104},
    {KEY_D_0_108, D_0_108},
    {KEY_D_0_163, D_0_163},
    {KEY_D_0_188, D_0_188},
    {KEY_D_0_192, D_0_192},
    {KEY_D_0_224, D_0_224},
    {KEY_D_0_228, D_0_228},
    {KEY_D_0_232, D_0_232},
    {KEY_D_0_236, D_0_236},

    {KEY_DMP_PREVPTAT, DMP_PREVPTAT},
    {KEY_D_1_2, D_1_2},
    {KEY_D_1_4, D_1_4},
    {KEY_D_1_8, D_1_8},
    {KEY_D_1_10, D_1_10},
    {KEY_D_1_24, D_1_24},
    {KEY_D_1_28, D_1_28},
    {KEY_D_1_92, D_1_92},
    {KEY_D_1_96, D_1_96},
    {KEY_D_1_98, D_1_98},
    {KEY_D_1_106, D_1_106},
    {KEY_D_1_108, D_1_108},
    {KEY_D_1_112, D_1_112},
    {KEY_D_1_128, D_1_128},
    {KEY_D_1_152, D_1_152},
    {KEY_D_1_168, D_1_168},
    {KEY_D_1_175, D_1_175},
    {KEY_D_1_178, D_1_178},
    {KEY_D_1_236, D_1_236},
    {KEY_D_1_244, D_1_244},

    {KEY_D_2_12,  D_2_12},
    {KEY_D_2_96,  D_2_96},
    {KEY_D_2_108, D_2_108},
    {KEY_D_2_244, D_2_244},
    {KEY_D_2_248, D_2_248},
    {KEY_D_2_252, D_2_252},

    {KEY_DMP_TAPW_MIN, DMP_TAPW_MIN},
    {KEY_DMP_TAP_THR_X, DMP_TAP_THX},
    {KEY_DMP_TAP_THR_Y, DMP_TAP_THY},
    {KEY_DMP_TAP_THR_Z, DMP_TAP_THZ},
    {KEY_DMP_SH_TH_Y, DMP_SH_TH_Y},
    {KEY_DMP_SH_TH_X, DMP_SH_TH_X},
    {KEY_DMP_SH_TH_Z, DMP_SH_TH_Z},
    {KEY_DMP_ORIENT, DMP_ORIENT},

    {KEY_CPASS_BIAS_X, CPASS_BIAS_X},
    {KEY_CPASS_BIAS_Y, CPASS_BIAS_Y},
    {KEY_CPASS_BIAS_Z, CPASS_BIAS_Z},
    {KEY_CPASS_MTX_00, CPASS_MTX_00},
    {KEY_CPASS_MTX_01, CPASS_MTX_01},
    {KEY_CPASS_MTX_02, CPASS_MTX_02},
    {KEY_CPASS_MTX_10, CPASS_MTX_10},
    {KEY_CPASS_MTX_11, CPASS_MTX_11},
    {KEY_CPASS_MTX_12, CPASS_MTX_12},
    {KEY_CPASS_MTX_20, CPASS_MTX_20},
    {KEY_CPASS_MTX_21, CPASS_MTX_21},
    {KEY_CPASS_MTX_22, CPASS_MTX_22},
    {KEY_D_ACT0, D_ACT0},
    {KEY_D_ACSX, D_ACSX},
    {KEY_D_ACSY, D_ACSY},
    {KEY_D_ACSZ, D_ACSZ}
};
#define NUM_LOCAL_KEYS (sizeof(dmpTConfig)/sizeof(dmpTConfig[0]))

#define DMP_CODE_SIZE 1923

static const unsigned char dmpMemory[DMP_CODE_SIZE] = {
    0xfb, 0x00, 0x00, 0x3e, 0x00, 0x0b, 0x00, 0x36, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 
    0x00, 0x65, 0x00, 0x54, 0xff, 0xef, 0x00, 0x00, 0xfa, 0x80, 0x00, 0x0b, 0x12, 0x82, 0x00, 0x01, 
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x28, 0x00, 0x00, 0xff, 0xff, 0x45, 0x81, 0xff, 0xff, 0xfa, 0x72, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x03, 0xe8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x7f, 0xff, 0xff, 0xfe, 0x80, 0x01, 
    0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x3e, 0x03, 0x30, 0x40, 0x00, 0x00, 0x00, 0x02, 0xca, 0xe3, 0x09, 0x3e, 0x80, 0x00, 0x00, 
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 
    0x41, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x2a, 0x00, 0x00, 0x16, 0x55, 0x00, 0x00, 0x21, 0x82, 
    0xfd, 0x87, 0x26, 0x50, 0xfd, 0x80, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x05, 0x80, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x6f, 0x00, 0x02, 0x65, 0x32, 0x00, 0x00, 0x5e, 0xc0, 
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xfb, 0x8c, 0x6f, 0x5d, 0xfd, 0x5d, 0x08, 0xd9, 0x00, 0x7c, 0x73, 0x3b, 0x00, 0x6c, 0x12, 0xcc, 
    0x32, 0x00, 0x13, 0x9d, 0x32, 0x00, 0xd0, 0xd6, 0x32, 0x00, 0x08, 0x00, 0x40, 0x00, 0x01, 0xf4, 
    0xff, 0xe6, 0x80, 0x79, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xd6, 0x00, 0x00, 0x27, 0x10, 
    0xfb, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xfa, 0x36, 0xff, 0xbc, 0x30, 0x8e, 0x00, 0x05, 0xfb, 0xf0, 0xff, 0xd9, 0x5b, 0xc8, 
    0xff, 0xd0, 0x9a, 0xbe, 0x00, 0x00, 0x10, 0xa9, 0xff, 0xf4, 0x1e, 0xb2, 0x00, 0xce, 0xbb, 0xf7, 
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x02, 0x02, 0x00, 0x00, 0x0c, 
    0xff, 0xc2, 0x80, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0xcf, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x14, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0x3f, 0x68, 0xb6, 0x79, 0x35, 0x28, 0xbc, 0xc6, 0x7e, 0xd1, 0x6c, 
    0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0x6a, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x30, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x25, 0x4d, 0x00, 0x2f, 0x70, 0x6d, 0x00, 0x00, 0x05, 0xae, 0x00, 0x0c, 0x02, 0xd0, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x00, 0x54, 0xff, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x01, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x01, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0xff, 0xef, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 
    0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

    0xd8, 0xdc, 0xba, 0xa2, 0xf1, 0xde, 0xb2, 0xb8, 0xb4, 0xa8, 0x81, 0x91, 0xf7, 0x4a, 0x90, 0x7f, 
    0x91, 0x6a, 0xf3, 0xf9, 0xdb, 0xa8, 0xf9, 0xb0, 0xba, 0xa0, 0x80, 0xf2, 0xce, 0x81, 0xf3, 0xc2, 
    0xf1, 0xc1, 0xf2, 0xc3, 0xf3, 0xcc, 0xa2, 0xb2, 0x80, 0xf1, 0xc6, 0xd8, 0x80, 0xba, 0xa7, 0xdf, 
    0xdf, 0xdf, 0xf2, 0xa7, 0xc3, 0xcb, 0xc5, 0xb6, 0xf0, 0x87, 0xa2, 0x94, 0x24, 0x48, 0x70, 0x3c, 
    0x95, 0x40, 0x68, 0x34, 0x58, 0x9b, 0x78, 0xa2, 0xf1, 0x83, 0x92, 0x2d, 0x55, 0x7d, 0xd8, 0xb1, 
    0xb4, 0xb8, 0xa1, 0xd0, 0x91, 0x80, 0xf2, 0x70, 0xf3, 0x70, 0xf2, 0x7c, 0x80, 0xa8, 0xf1, 0x01, 
    0xb0, 0x98, 0x87, 0xd9, 0x43, 0xd8, 0x86, 0xc9, 0x88, 0xba, 0xa1, 0xf2, 0x0e, 0xb8, 0x97, 0x80, 
    0xf1, 0xa9, 0xdf, 0xdf, 0xdf, 0xaa, 0xdf, 0xdf, 0xdf, 0xf2, 0xaa, 0xc5, 0xcd, 0xc7, 0xa9, 0xc1, 
    0xc9, 0xc3, 0x97, 0xf1, 0xa9, 0x89, 0x26, 0x46, 0x66, 0xb0, 0xb4, 0xba, 0x80, 0xac, 0xde, 0xf2, 
    0xca, 0xf1, 0xb2, 0x8c, 0x02, 0xa9, 0xb6, 0x98, 0x00, 0x89, 0x0e, 0x16, 0x1e, 0xb8, 0xa9, 0xb4, 
    0x99, 0x2c, 0x54, 0x7c, 0xb0, 0x8a, 0xa8, 0x96, 0x36, 0x56, 0x76, 0xf1, 0xb9, 0xaf, 0xb4, 0xb0, 
    0x83, 0xc0, 0xb8, 0xa8, 0x97, 0x11, 0xb1, 0x8f, 0x98, 0xb9, 0xaf, 0xf0, 0x24, 0x08, 0x44, 0x10, 
    0x64, 0x18, 0xf1, 0xa3, 0x29, 0x55, 0x7d, 0xaf, 0x83, 0xb5, 0x93, 0xaf, 0xf0, 0x00, 0x28, 0x50, 
    0xf1, 0xa3, 0x86, 0x9f, 0x61, 0xa6, 0xda, 0xde, 0xdf, 0xd9, 0xfa, 0xa3, 0x86, 0x96, 0xdb, 0x31, 
    0xa6, 0xd9, 0xf8, 0xdf, 0xba, 0xa6, 0x8f, 0xc2, 0xc5, 0xc7, 0xb2, 0x8c, 0xc1, 0xb8, 0xa2, 0xdf, 
    0xdf, 0xdf, 0xa3, 0xdf, 0xdf, 0xdf, 0xd8, 0xd8, 0xf1, 0xb8, 0xa8, 0xb2, 0x86, 0xb4, 0x98, 0x0d, 
    0x35, 0x5d, 0xb8, 0xaa, 0x98, 0xb0, 0x87, 0x2d, 0x35, 0x3d, 0xb2, 0xb6, 0xba, 0xaf, 0x8c, 0x96, 
    0x19, 0x8f, 0x9f, 0xa7, 0x0e, 0x16, 0x1e, 0xb4, 0x9a, 0xb8, 0xaa, 0x87, 0x2c, 0x54, 0x7c, 0xb9, 
    0xa3, 0xde, 0xdf, 0xdf, 0xa3, 0xb1, 0x80, 0xf2, 0xc4, 0xcd, 0xc9, 0xf1, 0xb8, 0xa9, 0xb4, 0x99, 
    0x83, 0x0d, 0x35, 0x5d, 0x89, 0xb9, 0xa3, 0x2d, 0x55, 0x7d, 0xb5, 0x93, 0xa3, 0x0e, 0x16, 0x1e, 
    0xa9, 0x2c, 0x54, 0x7c, 0xb8, 0xb4, 0xb0, 0xf1, 0x97, 0x83, 0xa8, 0x11, 0x84, 0xa5, 0x09, 0x98, 
    0xa3, 0x83, 0xf0, 0xda, 0x24, 0x08, 0x44, 0x10, 0x64, 0x18, 0xd8, 0xf1, 0xa5, 0x29, 0x55, 0x7d, 
    0xa5, 0x85, 0x95, 0x02, 0x1a, 0x2e, 0x3a, 0x56, 0x5a, 0x40, 0x48, 0xf9, 0xf3, 0xa3, 0xd9, 0xf8, 
    0xf0, 0x98, 0x83, 0x24, 0x08, 0x44, 0x10, 0x64, 0x18, 0x97, 0x82, 0xa8, 0xf1, 0x11, 0xf0, 0x98, 
    0xa2, 0x24, 0x08, 0x44, 0x10, 0x64, 0x18, 0xda, 0xf3, 0xde, 0xd8, 0x83, 0xa5, 0x94, 0x01, 0xd9, 
    0xa3, 0x02, 0xf1, 0xa2, 0xc3, 0xc5, 0xc7, 0xd8, 0xf1, 0x84, 0x92, 0xa2, 0x4d, 0xda, 0x2a, 0xd8, 
    0x48, 0x69, 0xd9, 0x2a, 0xd8, 0x68, 0x55, 0xda, 0x32, 0xd8, 0x50, 0x71, 0xd9, 0x32, 0xd8, 0x70, 
    0x5d, 0xda, 0x3a, 0xd8, 0x58, 0x79, 0xd9, 0x3a, 0xd8, 0x78, 0x93, 0xa3, 0x4d, 0xda, 0x2a, 0xd8, 
    0x48, 0x69, 0xd9, 0x2a, 0xd8, 0x68, 0x55, 0xda, 0x32, 0xd8, 0x50, 0x71, 0xd9, 0x32, 0xd8, 0x70, 
    0x5d, 0xda, 0x3a, 0xd8, 0x58, 0x79, 0xd9, 0x3a, 0xd8, 0x78, 0xa8, 0x8a, 0x9a, 0xf0, 0x28, 0x50, 
    0x78, 0x9e, 0xf3, 0x88, 0x18, 0xf1, 0x9f, 0x1d, 0x98, 0xa8, 0xd9, 0x08, 0xd8, 0xc8, 0x9f, 0x12, 
    0x9e, 0xf3, 0x15, 0xa8, 0xda, 0x12, 0x10, 0xd8, 0xf1, 0xaf, 0xc8, 0x97, 0x87, 0x34, 0xb5, 0xb9, 
    0x94, 0xa4, 0x21, 0xf3, 0xd9, 0x22, 0xd8, 0xf2, 0x2d, 0xf3, 0xd9, 0x2a, 0xd8, 0xf2, 0x35, 0xf3, 
    0xd9, 0x32, 0xd8, 0x81, 0xa4, 0x60, 0x60, 0x61, 0xd9, 0x61, 0xd8, 0x6c, 0x68, 0x69, 0xd9, 0x69, 
    0xd8, 0x74, 0x70, 0x71, 0xd9, 0x71, 0xd8, 0xb1, 0xa3, 0x84, 0x19, 0x3d, 0x5d, 0xa3, 0x83, 0x1a, 
    0x3e, 0x5e, 0x93, 0x10, 0x30, 0x81, 0x10, 0x11, 0xb8, 0xb0, 0xaf, 0x8f, 0x94, 0xf2, 0xda, 0x3e, 
    0xd8, 0xb4, 0x9a, 0xa8, 0x87, 0x29, 0xda, 0xf8, 0xd8, 0x87, 0x9a, 0x35, 0xda, 0xf8, 0xd8, 0x87, 
    0x9a, 0x3d, 0xda, 0xf8, 0xd8, 0xb1, 0xb9, 0xa4, 0x98, 0x85, 0x02, 0x2e, 0x56, 0xa5, 0x81, 0x00, 
    0x0c, 0x14, 0xa3, 0x97, 0xb0, 0x8a, 0xf1, 0x2d, 0xd9, 0x28, 0xd8, 0x4d, 0xd9, 0x48, 0xd8, 0x6d, 
    0xd9, 0x68, 0xd8, 0xb1, 0x84, 0x0d, 0xda, 0x0e, 0xd8, 0xa3, 0x29, 0x83, 0xda, 0x2c, 0x0e, 0xd8, 
    0xa3, 0x84, 0x49, 0x83, 0xda, 0x2c, 0x4c, 0x0e, 0xd8, 0xb8, 0xb0, 0xa8, 0x8a, 0x9a, 0xf5, 0x20, 
    0xaa, 0xda, 0xdf, 0xd8, 0xa8, 0x40, 0xaa, 0xd0, 0xda, 0xde, 0xd8, 0xa8, 0x60, 0xaa, 0xda, 0xd0, 
    0xdf, 0xd8, 0xf1, 0x97, 0x86, 0xa8, 0x31, 0x9b, 0x06, 0x99, 0x07, 0xab, 0x97, 0x28, 0x88, 0x9b, 
    0xf0, 0x0c, 0x20, 0x14, 0x40, 0xb8, 0xb0, 0xb4, 0xa8, 0x8c, 0x9c, 0xf0, 0x04, 0x28, 0x51, 0x79, 
    0x1d, 0x30, 0x14, 0x38, 0xb2, 0x82, 0xab, 0xd0, 0x98, 0x2c, 0x50, 0x50, 0x78, 0x78, 0x9b, 0xf1, 
    0x1a, 0xb0, 0xf0, 0x8a, 0x9c, 0xa8, 0x29, 0x51, 0x79, 0x8b, 0x29, 0x51, 0x79, 0x8a, 0x24, 0x70, 
    0x59, 0x8b, 0x20, 0x58, 0x71, 0x8a, 0x44, 0x69, 0x38, 0x8b, 0x39, 0x40, 0x68, 0x8a, 0x64, 0x48, 
    0x31, 0x8b, 0x30, 0x49, 0x60, 0xa5, 0x88, 0x20, 0x09, 0x71, 0x58, 0x44, 0x68, 0x11, 0x39, 0x64, 
    0x49, 0x30, 0x19, 0xf1, 0xac, 0x00, 0x2c, 0x54, 0x7c, 0xf0, 0x8c, 0xa8, 0x04, 0x28, 0x50, 0x78, 
    0xf1, 0x88, 0x97, 0x26, 0xa8, 0x59, 0x98, 0xac, 0x8c, 0x02, 0x26, 0x46, 0x66, 0xf0, 0x89, 0x9c, 
    0xa8, 0x29, 0x51, 0x79, 0x24, 0x70, 0x59, 0x44, 0x69, 0x38, 0x64, 0x48, 0x31, 0xa9, 0x88, 0x09, 
    0x20, 0x59, 0x70, 0xab, 0x11, 0x38, 0x40, 0x69, 0xa8, 0x19, 0x31, 0x48, 0x60, 0x8c, 0xa8, 0x3c, 
    0x41, 0x5c, 0x20, 0x7c, 0x00, 0xf1, 0x87, 0x98, 0x19, 0x86, 0xa8, 0x6e, 0x76, 0x7e, 0xa9, 0x99, 
    0x88, 0x2d, 0x55, 0x7d, 0x9e, 0xb9, 0xa3, 0x8a, 0x22, 0x8a, 0x6e, 0x8a, 0x56, 0x8a, 0x5e, 0x9f, 
    0xb1, 0x83, 0x06, 0x26, 0x46, 0x66, 0x0e, 0x2e, 0x4e, 0x6e, 0x9d, 0xb8, 0xad, 0x00, 0x2c, 0x54, 
    0x7c, 0xf2, 0xb1, 0x8c, 0xb4, 0x99, 0xb9, 0xa3, 0x2d, 0x55, 0x7d, 0x81, 0x91, 0xac, 0x38, 0xad, 
    0x3a, 0xb5, 0x83, 0x91, 0xac, 0x2d, 0xd9, 0x28, 0xd8, 0x4d, 0xd9, 0x48, 0xd8, 0x6d, 0xd9, 0x68, 
    0xd8, 0x8c, 0x9d, 0xae, 0x29, 0xd9, 0x04, 0xae, 0xd8, 0x51, 0xd9, 0x04, 0xae, 0xd8, 0x79, 0xd9, 
    0x04, 0xd8, 0x81, 0xf3, 0x9d, 0xad, 0x00, 0x8d, 0xae, 0x19, 0x81, 0xad, 0xd9, 0x01, 0xd8, 0xf2, 
    0xae, 0xda, 0x26, 0xd8, 0x8e, 0x91, 0x29, 0x83, 0xa7, 0xd9, 0xad, 0xad, 0xad, 0xad, 0xf3, 0x2a, 
    0xd8, 0xd8, 0xf1, 0xb0, 0xac, 0x89, 0x91, 0x3e, 0x5e, 0x76, 0xf3, 0xac, 0x2e, 0x2e, 0xf1, 0xb1, 
    0x8c, 0x5a, 0x9c, 0xac, 0x2c, 0x28, 0x28, 0x28, 0x9c, 0xac, 0x30, 0x18, 0xa8, 0x98, 0x81, 0x28, 
    0x34, 0x3c, 0x97, 0x24, 0xa7, 0x28, 0x34, 0x3c, 0x9c, 0x24, 0xf2, 0xb0, 0x89, 0xac, 0x91, 0x2c, 
    0x4c, 0x6c, 0x8a, 0x9b, 0x2d, 0xd9, 0xd8, 0xd8, 0x51, 0xd9, 0xd8, 0xd8, 0x79, 0xd9, 0xd8, 0xd8, 
    0xf1, 0x9e, 0x88, 0xa3, 0x31, 0xda, 0xd8, 0xd8, 0x91, 0x2d, 0xd9, 0x28, 0xd8, 0x4d, 0xd9, 0x48, 
    0xd8, 0x6d, 0xd9, 0x68, 0xd8, 0xb1, 0x83, 0x93, 0x35, 0x3d, 0x80, 0x25, 0xda, 0xd8, 0xd8, 0x85, 
    0x69, 0xda, 0xd8, 0xd8, 0xb4, 0x93, 0x81, 0xa3, 0x28, 0x34, 0x3c, 0xf3, 0xab, 0x8b, 0xf8, 0xa3, 
    0x91, 0xb6, 0x09, 0xb4, 0xd9, 0xab, 0xde, 0xfa, 0xb0, 0x87, 0x9c, 0xb9, 0xa3, 0xdd, 0xf1, 0xa3, 
    0xa3, 0xa3, 0xa3, 0x95, 0xf1, 0xa3, 0xa3, 0xa3, 0x9d, 0xf1, 0xa3, 0xa3, 0xa3, 0xa3, 0xf2, 0xa3, 
    0xb4, 0x90, 0x80, 0xf2, 0xa3, 0xa3, 0xa3, 0xa3, 0xa3, 0xa3, 0xa3, 0xb2, 0xa3, 0xa3, 0xa3, 0xa3, 
    0xa3, 0xa3, 0xb0, 0x87, 0xb5, 0x99, 0xf1, 0xa3, 0xa3, 0xa3, 0x98, 0xf1, 0xa3, 0xa3, 0xa3, 0xa3, 
    0x97, 0xa3, 0xa3, 0xa3, 0xa3, 0xf3, 0x9b, 0xa3, 0xa3, 0xdc, 0xb9, 0xa7, 0xf1, 0x26, 0x26, 0x26, 
    0xd8, 0xd8, 0xff
};

static unsigned short sStartAddress = 0x0300;


static tKeyLabel keys[NUM_KEYS];

static unsigned short inv_setup_dmpGetAddress( unsigned short key )
{
    static int isSorted = 0;
    if ( !isSorted ) {
        int kk;
        for (kk=0; kk<NUM_KEYS; ++kk) {
            keys[ kk ].addr = 0xffff;
            keys[ kk ].key = kk;
        }
        for (kk=0; kk<NUM_LOCAL_KEYS; ++kk) {
            keys[ dmpTConfig[kk].key ].addr = dmpTConfig[kk].addr;
        }
        isSorted = 1;
    }
    if ( key >= NUM_KEYS )
        return 0xffff;
    return keys[ key ].addr;
}

/**
 *  @brief
 *  @return INV_SUCCESS or a non-zero error code.
 */
inv_error_t inv_setup_dmp(void)

{
    inv_error_t result;

    inv_set_get_address(inv_setup_dmpGetAddress);
    result = inv_clock_source(MPU_CLK_SEL_PLLGYROZ);
    if (result) {
        LOG_RESULT_LOCATION(result);
        return result;
    }
    result = inv_dl_cfg_sampling(MPU_FILTER_42HZ, 4);
    if (result) {
        LOG_RESULT_LOCATION(result);
        return result;
    }
    result = inv_set_full_scale(2000.f);  
    if (result) {
        LOG_RESULT_LOCATION(result);
        return result;
    }
    result = inv_load_dmp(dmpMemory, DMP_CODE_SIZE, sStartAddress);
    if (result) {
        LOG_RESULT_LOCATION(result);
        return result;
    }
    result = inv_set_external_sync(MPU_EXT_SYNC_TEMP);
    if (result) {
        LOG_RESULT_LOCATION(result);
        return result;
    }

    return result;
}
/**
 *@}
 */
