/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pileup;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.gatk.utils.pileup.PileupElement;
import org.broadinstitute.gatk.utils.pileup.PileupElementTracker;

class UnifiedPileupElementTracker<PE extends PileupElement>
extends PileupElementTracker<PE> {
    private final List<PE> pileup;

    @Override
    public UnifiedPileupElementTracker<PE> copy() {
        UnifiedPileupElementTracker<PileupElement> result = new UnifiedPileupElementTracker<PileupElement>();
        for (PileupElement element : this.pileup) {
            result.add(element);
        }
        return result;
    }

    public UnifiedPileupElementTracker() {
        this.pileup = new LinkedList<PE>();
    }

    public UnifiedPileupElementTracker(List<PE> pileup) {
        this.pileup = pileup;
    }

    public void add(PE element) {
        this.pileup.add(element);
    }

    public PE get(int index) {
        return (PE)((PileupElement)this.pileup.get(index));
    }

    @Override
    public int size() {
        return this.pileup.size();
    }

    @Override
    public Iterator<PE> iterator() {
        return this.pileup.iterator();
    }

    @Override
    public Iterable<PE> unorderedIterable() {
        return this;
    }
}

